/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.other.bean.OtherBidDetailEntity;
import com.ejianc.business.tender.other.bean.OtherBidEntity;
import com.ejianc.business.tender.other.bean.OtherBidSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSellEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherNoticeEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherWinnoticeEntity;
import com.ejianc.business.tender.other.mapper.OtherBidMapper;
import com.ejianc.business.tender.other.service.IOtherBidDetailService;
import com.ejianc.business.tender.other.service.IOtherBidService;
import com.ejianc.business.tender.other.service.IOtherBidSupplierService;
import com.ejianc.business.tender.other.service.IOtherDocumentSellService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherDocumentSupplierService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherNoticeService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.service.IOtherPicketageSupplierService;
import com.ejianc.business.tender.other.service.IOtherWinnoticeService;
import com.ejianc.business.tender.other.vo.OtherBidDetailVO;
import com.ejianc.business.tender.other.vo.OtherBidSupplierVO;
import com.ejianc.business.tender.other.vo.OtherBidVO;
import com.ejianc.business.tender.other.vo.OtherDocumentSellVO;
import com.ejianc.business.tender.other.vo.OtherPicketageSupplierVO;
import com.ejianc.business.tender.other.vo.OtherPicketageVO;
import com.ejianc.business.tender.other.vo.OtherWinbidDetailVO;
import com.ejianc.business.tender.other.vo.OtherWinbidVO;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.tenant.api.IidmWebEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.IEjcCloudDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="otherBidService")
public class OtherBidServiceImpl
extends BaseServiceImpl<OtherBidMapper, OtherBidEntity>
implements IOtherBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherNoticeService otherNoticeService;
    @Autowired
    private IOtherWinnoticeService otherWinnoticeService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherBidDetailService otherBidDetailService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherBidSupplierService otherBidSupplierService;
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IOtherPicketageSupplierService otherPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IEjcCloudDataPushService systemDataPushService;
    @Autowired
    private IidmWebEnterpriseApi idmWebEnterpriseApi;
    @Autowired
    private ISupplierApi supplierApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";

    @Override
    public OtherBidVO saveBid(Long picketageId) {
        OtherBidEntity entity = new OtherBidEntity();
        entity.setPicketageId(picketageId);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OtherPicketageEntity otherPicketageEntity = (OtherPicketageEntity)((Object)this.otherPicketageService.selectById(picketageId));
        OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherPicketageEntity.getInviteId()));
        entity.setInviteId(otherPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate((Object)entity, false);
        OtherBidVO vo = (OtherBidVO)BeanMapper.map((Object)((Object)entity), OtherBidVO.class);
        otherPicketageEntity.setBidId(entity.getId());
        this.otherPicketageService.updateById((Object)otherPicketageEntity);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId, (Object)otherPicketageEntity.getDocumentId());
        lambdaSell.eq(OtherDocumentSellEntity::getTenderFlag, (Object)1);
        List sellList = this.otherDocumentSellService.list((Wrapper)lambdaSell);
        List otherDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, OtherDocumentSellVO.class);
        Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOS.stream().collect(Collectors.groupingBy(OtherDocumentSellVO::getSupplierId));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId, (Object)otherPicketageEntity.getDocumentId());
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.otherDocumentSupplierService.list((Wrapper)lambdaSupplier);
        Map supplieotherityMap = supplierList.stream().collect(Collectors.toMap(OtherDocumentSupplierEntity::getSupplierId, Function.identity()));
        ArrayList supplierVOList = new ArrayList();
        ArrayList otherBidDetailEntityList = new ArrayList();
        sellMap.forEach((key, value) -> {
            OtherBidSupplierVO otherBidSupplierVO = new OtherBidSupplierVO();
            otherBidSupplierVO.setSupplierId(key);
            otherBidSupplierVO.setSupplierName(((OtherDocumentSellVO)value.stream().findFirst().get()).getSupplierName());
            OtherDocumentSupplierEntity otherDocumentSupplierEntity = (OtherDocumentSupplierEntity)((Object)((Object)supplieotherityMap.get(key)));
            otherBidSupplierVO.setLinkName(otherDocumentSupplierEntity.getLinkName());
            otherBidSupplierVO.setSupplierMobile(otherDocumentSupplierEntity.getLinkMobile());
            otherBidSupplierVO.setId(Long.valueOf(IdWorker.getId()));
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;
            for (OtherDocumentSellVO otherDocumentSellVO : value) {
                tenderMoneyTax = tenderMoneyTax.add(otherDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : otherDocumentSellVO.getTenderMoneyTax());
                tenderMoney = tenderMoney.add(otherDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : otherDocumentSellVO.getTenderMoney());
                OtherBidDetailEntity otherBidDetailEntity = (OtherBidDetailEntity)((Object)((Object)BeanMapper.map((Object)otherDocumentSellVO, OtherBidDetailEntity.class)));
                otherBidDetailEntity.setMoney(otherDocumentSellVO.getTenderMoney());
                otherBidDetailEntity.setMoneyTax(otherDocumentSellVO.getTenderMoneyTax());
                otherBidDetailEntity.setId(null);
                otherBidDetailEntity.setBidSupplierId(otherBidSupplierVO.getId());
                otherBidDetailEntity.setBidId(entity.getId());
                otherBidDetailEntityList.add(otherBidDetailEntity);
            }
            otherBidSupplierVO.setMoneyTax(tenderMoneyTax);
            otherBidSupplierVO.setMoney(tenderMoney);
            otherBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(otherBidSupplierVO);
        });
        List otherBidSupplieotherities = BeanMapper.mapList(supplierVOList, OtherBidSupplierEntity.class);
        this.otherBidSupplierService.saveBatch(otherBidSupplieotherities);
        this.otherBidDetailService.saveBatch(otherBidDetailEntityList);
        String tenderUnitNum = new String();
        List<OtherBidDetailEntity> bidDetailEntityList = ((OtherBidMapper)this.baseMapper).selectBidSupplier(entity.getId());
        for (OtherBidDetailEntity otherBidDetailEntity : bidDetailEntityList) {
            OtherBidSupplierEntity supplieotherity = (OtherBidSupplierEntity)((Object)this.otherBidSupplierService.selectById(otherBidDetailEntity.getBidSupplierId()));
            BigDecimal sumNum = otherBidDetailEntity.getTenderNum().setScale(4, 4);
            String name = supplieotherity.getSupplierName() + "(" + sumNum + "),";
            tenderUnitNum = tenderUnitNum + name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        this.otherInviteService.saveOrUpdate((Object)inviteEntity);
        OtherBidVO otherBidVO = (OtherBidVO)BeanMapper.map((Object)((Object)entity), OtherBidVO.class);
        return otherBidVO;
    }

    @Override
    public OtherBidVO queryDetail(Long bidId) {
        OtherBidEntity otherBidEntity = (OtherBidEntity)((Object)super.selectById((Serializable)bidId));
        OtherBidVO otherBidVO = (OtherBidVO)BeanMapper.map((Object)((Object)otherBidEntity), OtherBidVO.class);
        List otherBidDetailList = otherBidVO.getOtherBidDetailList();
        Map<Long, List<OtherBidDetailVO>> detailMap = otherBidDetailList.stream().collect(Collectors.groupingBy(OtherBidDetailVO::getBidSupplierId));
        List otherBidSupplierList = otherBidVO.getOtherBidSupplierList();
        for (OtherBidSupplierVO otherBidSupplierVO : otherBidSupplierList) {
            otherBidSupplierVO.setOtherBidDetailList(detailMap.get(otherBidSupplierVO.getId()));
        }
        otherBidVO.setOtherBidSupplierList(otherBidSupplierList);
        return otherBidVO;
    }

    @Override
    @Transactional
    public OtherBidVO publishBid(OtherBidVO saveorUpdateVO) {
        OtherBidEntity entity = (OtherBidEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        OtherBidVO vo = (OtherBidVO)BeanMapper.map((Object)((Object)entity), OtherBidVO.class);
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(entity.getInviteId()));
        OtherWinbidVO winbidVO = new OtherWinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(otherInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType() == null || winbidVO.getPurchaseType() == 1) {
            winbidVO.setSourceProjectId(null);
        } else {
            winbidVO.setSourceProjectId(Long.toString(otherInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(otherInviteEntity.getProjectName());
        winbidVO.setProjectCode(otherInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(otherInviteEntity.getOrgId()));
        winbidVO.setOrgName(otherInviteEntity.getOrgName());
        winbidVO.setUnitName(otherInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(otherInviteEntity.getUnitId()));
        winbidVO.setType("OTHER");
        winbidVO.setTenderName(otherInviteEntity.getTenderName());
        winbidVO.setTenderType(otherInviteEntity.getTenderType());
        winbidVO.setSystemId(((EnterpriseVO)this.idmWebEnterpriseApi.getEnterpriseByTenantId(InvocationInfoProxy.getTenantid()).getData()).getId().toString());
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(OtherDocumentEntity::getInviteId, (Object)entity.getInviteId());
        OtherDocumentEntity otherDocumentEntity = (OtherDocumentEntity)((Object)this.otherDocumentService.getOne((Wrapper)lambdaDoc));
        winbidVO.setNoticeBidTime(otherDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());
        if (otherInviteEntity.getTenderType() == 2 || otherInviteEntity.getTenderType() == 3 || otherInviteEntity.getTenderType() == 4 || otherInviteEntity.getTenderType() == 5) {
            winbidVO.setSourceEmployeeId(Long.toString(otherDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(otherDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(otherDocumentEntity.getPurchaseType());
        } else {
            LambdaQueryWrapper lambdaNotice = Wrappers.lambdaQuery();
            lambdaNotice.eq(OtherNoticeEntity::getInviteId, (Object)entity.getInviteId());
            OtherNoticeEntity noticeEntity = (OtherNoticeEntity)((Object)this.otherNoticeService.getOne((Wrapper)lambdaNotice));
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }
        OtherBidVO otherBidVO = this.queryDetail(entity.getId());
        List otherBidSupplierList = otherBidVO.getOtherBidSupplierList();
        ArrayList<OtherWinbidVO> winbidVOList = new ArrayList<OtherWinbidVO>();
        for (OtherBidSupplierVO otherBidSupplierVO : otherBidSupplierList) {
            OtherWinbidVO winbidVONew = (OtherWinbidVO)BeanMapper.map((Object)winbidVO, OtherWinbidVO.class);
            SupplierVO supplierVO = (SupplierVO)this.supplierApi.queryById(otherBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(otherBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(otherBidSupplierVO.getMoney());
            winbidVONew.setContent(otherBidVO.getBidContent());
            winbidVONew.setWinbidType(Integer.valueOf(0));
            List otherBidDetailList = otherBidSupplierVO.getOtherBidDetailList();
            ArrayList<OtherWinbidDetailVO> otherWinbidDetailVOList = new ArrayList<OtherWinbidDetailVO>();
            for (OtherBidDetailVO otherBidDetailVO : otherBidDetailList) {
                OtherWinbidDetailVO otherWinbidDetailVO = new OtherWinbidDetailVO();
                otherWinbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                otherWinbidDetailVO.setMaterialName(otherBidDetailVO.getMaterialName());
                otherWinbidDetailVO.setMaterialCode(otherBidDetailVO.getMaterialCode());
                otherWinbidDetailVO.setUnit(otherBidDetailVO.getUnit());
                otherWinbidDetailVO.setSpec(otherBidDetailVO.getSpec());
                otherWinbidDetailVO.setBrand(otherBidDetailVO.getMaterialBrand());
                otherWinbidDetailVO.setSupplierBrand(otherBidDetailVO.getBrand());
                otherWinbidDetailVO.setPrice(otherBidDetailVO.getPrice());
                otherWinbidDetailVO.setPriceTax(otherBidDetailVO.getPriceTax());
                otherWinbidDetailVO.setMoney(otherBidDetailVO.getMoney());
                otherWinbidDetailVO.setMoneyTax(otherBidDetailVO.getMoneyTax());
                otherWinbidDetailVO.setTax(otherBidDetailVO.getSellTax());
                otherWinbidDetailVO.setCalculateType(otherBidDetailVO.getCalculateType());
                otherWinbidDetailVO.setMemo(otherBidDetailVO.getMaterialMemo());
                otherWinbidDetailVO.setSupplierMemo(otherBidDetailVO.getMemo());
                otherWinbidDetailVO.setMoney(otherBidDetailVO.getMoney());
                otherWinbidDetailVO.setRate(otherBidDetailVO.getRate());
                otherWinbidDetailVO.setTenderNum(otherBidDetailVO.getTenderNum());
                otherWinbidDetailVO.setNum(otherBidDetailVO.getNum());
                otherWinbidDetailVOList.add(otherWinbidDetailVO);
            }
            winbidVONew.setOtherWinbidDetailList(otherWinbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        this.logger.info("\u63a8\u9001\u4f9b\u65b9\u4e2d\u6807\u4fe1\u606f:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winbidSavesUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u540c\u6b65\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(vo.getId());
    }

    @Override
    public OtherBidVO queryDbDetail(Long picketage) {
        return null;
    }

    @Override
    public OtherBidVO nextPaper(Long winnoticeId) {
        OtherBidEntity entity = new OtherBidEntity();
        OtherWinnoticeEntity otherWinnoticeEntity = (OtherWinnoticeEntity)((Object)this.otherWinnoticeService.selectById(winnoticeId));
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherWinnoticeEntity.getInviteId()));
        entity.setInviteId(otherWinnoticeEntity.getInviteId());
        entity.setBidName(otherInviteEntity.getTenderName());
        entity.setPurchaseType(otherInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate((Object)entity, false);
        otherWinnoticeEntity.setNextFlag(1);
        this.otherWinnoticeService.updateById((Object)otherWinnoticeEntity);
        otherInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.otherInviteService.updateById((Object)otherInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(5);
        processEntity.setFrontendUrl("other/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        OtherBidVO otherBidVO = (OtherBidVO)BeanMapper.map((Object)((Object)entity), OtherBidVO.class);
        return otherBidVO;
    }

    @Override
    public List<OtherPicketageSupplierVO> querySupplierList(Long picketageId) {
        OtherBidEntity otherBidEntity = (OtherBidEntity)((Object)super.selectById((Serializable)picketageId));
        OtherWinnoticeEntity otherWinnoticeEntity = (OtherWinnoticeEntity)((Object)this.otherWinnoticeService.selectById(otherBidEntity.getWinnoticeId()));
        LambdaQueryWrapper lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(OtherPicketageSupplierEntity::getPicketageId, (Object)otherWinnoticeEntity.getPicketageId());
        List listSupplier = this.otherPicketageSupplierService.list((Wrapper)lambdaSupplierList);
        List otherPicketageSupplierVOS = BeanMapper.mapList((Iterable)listSupplier, OtherPicketageSupplierVO.class);
        return otherPicketageSupplierVOS;
    }

    @Override
    @Transactional
    public OtherPicketageVO insertProcess(Long picketageId) {
        OtherPicketageEntity otherPicketageEntity = (OtherPicketageEntity)((Object)this.otherPicketageService.selectById(picketageId));
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherPicketageEntity.getInviteId()));
        otherInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.otherInviteService.updateById((Object)otherInviteEntity);
        otherPicketageEntity.setBidStatus(1);
        this.otherPicketageService.updateById((Object)otherPicketageEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(otherPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(otherInviteEntity.getId());
        processEntity.setType(5);
        processEntity.setFrontendUrl("other/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        OtherPicketageVO otherPicketageVO = (OtherPicketageVO)BeanMapper.map((Object)((Object)otherPicketageEntity), OtherPicketageVO.class);
        return otherPicketageVO;
    }

    @Override
    public List<OtherPicketageSupplierVO> querySupplierDetail(Long id) {
        OtherBidEntity otherBidEntity = (OtherBidEntity)((Object)super.selectById((Serializable)id));
        return this.otherPicketageService.querySupplierList(otherBidEntity.getPicketageId());
    }
}

