package com.ejianc.business.tender.abolish.service.impl;

import com.ejianc.business.tender.abolish.bean.WasteEntity;
import com.ejianc.business.tender.abolish.service.IWasteService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("waste")
public class WasteBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWasteService wasteService;
    /** 评标 */
    @Autowired
    private IExpertEvaluatingService evaluatingService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        // 释放采购计划，有审批流时发送废标通知给供应商，供应商状态为已淘汰
//		wasteService.updateGysByWaste(billId);
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        // 直审情况下，走此方法，不走提交后方法，需要在此处做判断，发布内部消息
        // 20211214 修改为审批通过后修改供应商状态，并发送内部消息
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE
                .getBillStateCode().equals(state)) {
            wasteService.updateGysByWaste(billId);//修改状态
            // 获取废标信息
            WasteEntity wasteEntity = wasteService.getById(billId);
            evaluatingService.stateCheckout(wasteEntity.getTenderId());//评标校验
            // 发送消息
            wasteService.sendMsgByWaste(wasteEntity.getType(), wasteEntity.getTenderId());
            // 废标生效
            wasteService.updateExpertEvaluatingByWaste(wasteEntity.getTenderId());
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.error("该功能不支持！");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
