package com.ejianc.business.tender.expert.service.impl;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.expert.bean.*;
import com.ejianc.business.tender.expert.mapper.ExpertEvaluatingMapper;
import com.ejianc.business.tender.expert.service.*;
import com.ejianc.business.tender.expert.vo.*;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherTalkMapper;
import com.ejianc.business.tender.other.service.IOtherDocumentSchemeService;
import com.ejianc.business.tender.other.service.IOtherDocumentSellService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料专家评标主表
 *
 * @author generator
 */
@Service("expertEvaluatingService")
public class ExpertEvaluatingServiceImpl extends BaseServiceImpl<ExpertEvaluatingMapper, ExpertEvaluatingEntity> implements IExpertEvaluatingService {
    @Autowired
    private IExpertRecordService expertRecordService;
    @Autowired
    private IExpertRecordScoreService expertRecordScoreService;
    @Autowired
    private IExpertEvaluatingDetailService IExpertEvaluatingDetailService;
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "EXPERT_EVALUATION";//此处需要根据实际修改
    @Autowired
    private IExpertEvaluatingService service;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private ITemplateDetailService templateDetailService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private OtherTalkMapper otherTalkMapper;
    @Autowired
    private IExpertService expertService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;
    @Autowired
    private IEvaluationDetailService evaluationDetailService;
    @Autowired
    private IExpertRecordService recordService;
    @Autowired
    private IExpertEvaluatingDetailService detailService;


    @Override
    public List<ExpertEvaluatingVO> queryPendingList(Page<ExpertEvaluatingVO> page, String searchText, Integer evaluationState, Integer evaluationState1, String employeeId) {
        return baseMapper.queryPendingList(page, searchText, evaluationState, evaluationState1, employeeId);
    }

    @Override
    public Boolean updateState(Integer evaluationState, Long id, Long employeeId, DateTime evaluationTime) {
        return baseMapper.updateState(evaluationState, id, employeeId, evaluationTime);
    }

    //查询供应商方案接口
    @Override
    public List<ExpertEvaluatingDetailScoreVO> queryScoreDetail(Long inviteId, Long evaluationId) {
        ExpertEvaluatingEntity expertEvaluating = service.selectById(evaluationId);
        if (null == expertEvaluating) {
            return null;
        }
        int size = expertEvaluating.getStuffEvaluationDetailEntities().size();
        List<ExpertEvaluatingDetailScoreVO> listVO = new ArrayList<>();
        //评分记录主表
        LambdaQueryWrapper<ExpertRecordEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertRecordEntity::getInviteId, inviteId);
        lambda.in(ExpertRecordEntity::getEvaluationId, evaluationId);
        lambda.eq(ExpertRecordEntity::getFlag, 1);
        List<ExpertRecordEntity> list = expertRecordService.list(lambda);
        if (CollectionUtils.isNotEmpty(list)) {
            BigDecimal bigDecimal = new BigDecimal(0);
            list.forEach(v -> {
                ExpertEvaluatingDetailScoreVO reslutVO = BeanMapper.map(v, ExpertEvaluatingDetailScoreVO.class);
                if (v.getSumScore() == null) {//总分判空
                    v.setSumScore(bigDecimal);
                }
                reslutVO.setAvgScore(v.getSumScore());
                reslutVO.setGrossScore(v.getSumScore());
                if (v.getMoneyTax() == null) {//总额判空
                    v.setMoneyTax(bigDecimal);
                }
                if (v.getMoney() == null) {
                    v.setMoneyTax(bigDecimal);
                }
                reslutVO.setSchemeNameMoney(v.getSchemeName() + "(含税:" + v.getMoneyTax().setScale(2, BigDecimal.ROUND_HALF_UP) + "元;无税:" + v.getMoney().setScale(2, BigDecimal.ROUND_HALF_UP) + "元)");
                //当只有一个方案被一个专家评分后不会进入下面去重，所以需要在这里处理
                reslutVO.setExpertNum(1 + "/" + size);
                if (reslutVO.getPassFlag() == null) {
                    reslutVO.setPassFlag(1);
                }
                switch (reslutVO.getPassFlag()) {
                    case 1:
                        reslutVO.setPassNum(1 + "/" + 1);
                        break;
                    case 2:
                        reslutVO.setPassNum(0 + "/" + 1);
                        break;
                }
                if (reslutVO.getCollectPassFlag() == null) {
                    reslutVO.setCollectPassFlag(1);
                }
                listVO.add(reslutVO);
            });
//                上面查询的是一个专家对一个方案的总分，这里将其去重得到每个方案的总分和平均分
            for (int i = 0; i < listVO.size() - 1; i++) {
                int avg = 1;
                int pass = 0;
                if (listVO.get(i).getPassFlag().equals(1)) {//主方案是否通过
                    pass += 1;
                }
                for (int j = listVO.size() - 1; j > i; j--) {
                    //相同条件，相同供应商的相同方案
                    if (listVO.get(j).getSupplierId().equals(listVO.get(i).getSupplierId()) && listVO.get(j).getDocumentSchemeId().equals(listVO.get(i).getDocumentSchemeId())) {
                        //此方案被评标的专家个数
                        ++avg;
                        listVO.get(i).setGrossScore(listVO.get(i).getGrossScore().add(listVO.get(j).getGrossScore()));
                        listVO.get(i).setAvgScore(new BigDecimal(listVO.get(i).getGrossScore().doubleValue() / avg));
                        listVO.get(i).setExpertNum(avg + "/" + size);
                        //此方案是否通过计算
                        if (listVO.get(j).getPassFlag().equals(1)) {//重复是否通过
                            pass++;
                        }
                        listVO.get(i).setPassNum(pass + "/" + avg);
                        //删除重复的，留下最终的方案评分
                        listVO.remove(j);
                    }
                }
            }
            if (expertEvaluating.getDistinctionFlag().equals(0)) {//是否区分商务/技术
                return service.getAvgScore(listVO);
            }
            else {
                return listVO;
            }
        }
        return listVO;
    }

    //专家失效接口
    @Override
    public void stateCheckout(Long inviteId) {
        LambdaQueryWrapper<ExpertEvaluatingEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertEvaluatingEntity::getInviteId, inviteId);
        List<ExpertEvaluatingEntity> list = service.list(lambda);
        if (CollectionUtils.isNotEmpty(list)) {
            LambdaQueryWrapper<ExpertEvaluatingDetailEntity> lambda2 = Wrappers.lambdaQuery();
            lambda2.eq(ExpertEvaluatingDetailEntity::getEvaluationId, list.get(0).getId());
            lambda2.in(ExpertEvaluatingDetailEntity::getEvaluationState, 0, 3);
            List<ExpertEvaluatingDetailEntity> list1 = IExpertEvaluatingDetailService.list(lambda2);
            list1.forEach(v -> {
                v.setEvaluationState(2);
            });
            if (CollectionUtils.isNotEmpty(list1)) {
                IExpertEvaluatingDetailService.saveOrUpdateBatch(list1);
            }
        }
    }

    //查询专家评分详情接口
    @Override
    public Map<String, Object> queryExpertDetail(ExpertEvaluatingDetailScoreVO vo) {
        Map<String, Object> detailMap = new HashMap<>();
        ////查询评标记录
        LambdaQueryWrapper<ExpertRecordEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertRecordEntity::getInviteId, vo.getInviteId());
        lambda.eq(ExpertRecordEntity::getEvaluationId, vo.getEvaluationId());
        lambda.eq(ExpertRecordEntity::getSupplierId, vo.getSupplierId());
        lambda.eq(ExpertRecordEntity::getDocumentSchemeId, vo.getDocumentSchemeId());
        lambda.eq(ExpertRecordEntity::getFlag, 1);
        List<ExpertRecordEntity> recordEntityList = expertRecordService.list(lambda);
        List<ExpertRecordVO> recordVOList = BeanMapper.mapList(recordEntityList, ExpertRecordVO.class);
        //是否区分商务/技术
        ExpertEvaluatingEntity expertEvaluating = service.selectById(vo.getEvaluationId());
        Integer distinctionFlag = expertEvaluating.getDistinctionFlag();
        //获取商务、技术
        List<ExpertRecordVO> recordVOList2 = new ArrayList<>();//商务
        List<ExpertRecordVO> recordVOList3 = new ArrayList<>();//技术
        if (CollectionUtils.isNotEmpty(recordVOList) && distinctionFlag.equals(0)) {
            for (ExpertRecordVO recordVO : recordVOList) {
                LambdaQueryWrapper<ExpertEntity> lambda2 = Wrappers.lambdaQuery();
                lambda2.eq(ExpertEntity::getExpertId, recordVO.getEmployeeId());
                List<ExpertEntity> list = expertService.list(lambda2);
                if (CollectionUtils.isNotEmpty(list)) {
                    switch (list.get(0).getType()) {
                        case 0:
                            recordVOList2.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                            break;
                        case 1:
                            recordVOList3.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                            break;
                        case 2:
                            recordVOList2.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                            recordVOList3.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                            break;
                    }
                }
            }
        }
        else {//不区分商务技术，专家都有分数
            recordVOList2.addAll(BeanMapper.mapList(recordVOList, ExpertRecordVO.class));
            recordVOList3.addAll(BeanMapper.mapList(recordVOList, ExpertRecordVO.class));
        }
        //商务得分值
        recordVOList2 = service.getRecordVO(recordVOList2, 0);
        //技术得分值
        recordVOList3 = service.getRecordVO(recordVOList3, 1);
        //商务表头
        List<TemplateDetailVO> businessHead = service.getHead(vo.getTemplateId(), 0);
        //商务表头
        List<TemplateDetailVO> technologyHead = service.getHead(vo.getTemplateId(), 1);
        detailMap.put("businessHead", businessHead);
        detailMap.put("businessDatail", recordVOList2);
        detailMap.put("technologyHead", technologyHead);
        detailMap.put("technologyDateil", recordVOList3);
        return detailMap;
    }

    //供应商方案平均分处理
    @Override
    public List<ExpertEvaluatingDetailScoreVO> getAvgScore(List<ExpertEvaluatingDetailScoreVO> list) {
        for (ExpertEvaluatingDetailScoreVO expertEvaluatingDetailScoreVO : list) {
            LambdaQueryWrapper<ExpertRecordEntity> lambda = Wrappers.lambdaQuery();
            lambda.eq(ExpertRecordEntity::getInviteId, expertEvaluatingDetailScoreVO.getInviteId());
            lambda.eq(ExpertRecordEntity::getEvaluationId, expertEvaluatingDetailScoreVO.getEvaluationId());
            lambda.eq(ExpertRecordEntity::getSupplierId, expertEvaluatingDetailScoreVO.getSupplierId());
            lambda.eq(ExpertRecordEntity::getDocumentSchemeId, expertEvaluatingDetailScoreVO.getDocumentSchemeId());
            lambda.eq(ExpertRecordEntity::getFlag, 1);
            List<ExpertRecordEntity> recordEntityList = expertRecordService.list(lambda);
            List<ExpertRecordVO> recordVOList = BeanMapper.mapList(recordEntityList, ExpertRecordVO.class);
            //是否区分商务/技术
            ExpertEvaluatingEntity expertEvaluating = service.selectById(expertEvaluatingDetailScoreVO.getEvaluationId());
            Integer distinctionFlag = expertEvaluating.getDistinctionFlag();
            //获取商务、技术
            List<ExpertRecordVO> recordVOList2 = new ArrayList<>();//商务
            List<ExpertRecordVO> recordVOList3 = new ArrayList<>();//技术
            if (CollectionUtils.isNotEmpty(recordVOList) && distinctionFlag.equals(0)) {
                for (ExpertRecordVO recordVO : recordVOList) {
                    LambdaQueryWrapper<ExpertEntity> lambda2 = Wrappers.lambdaQuery();
                    lambda2.eq(ExpertEntity::getExpertId, recordVO.getEmployeeId());
                    List<ExpertEntity> expertList = expertService.list(lambda2);
                    if (CollectionUtils.isNotEmpty(expertList)) {
                        switch (expertList.get(0).getType()) {
                            case 0:
                                recordVOList2.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                                break;
                            case 1:
                                recordVOList3.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                                break;
                            case 2:
                                recordVOList2.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                                recordVOList3.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                                break;
                        }
                    }
                }
            }

            //商务
            BigDecimal bussScore = service.getScore(recordVOList2, 0);
            //技术
            BigDecimal techScore = service.getScore(recordVOList3, 1);
            if (CollectionUtils.isNotEmpty(recordVOList2) && CollectionUtils.isNotEmpty(recordVOList3)) {
                expertEvaluatingDetailScoreVO.setAvgScore(bussScore.divide(new BigDecimal(recordVOList2.size()), 8, BigDecimal.ROUND_HALF_UP).add(techScore.divide(new BigDecimal(recordVOList3.size()), 8, BigDecimal.ROUND_HALF_UP)));
            }
            else if (CollectionUtils.isNotEmpty(recordVOList2)) {
                expertEvaluatingDetailScoreVO.setAvgScore(bussScore.divide(new BigDecimal(recordVOList2.size()), 8, BigDecimal.ROUND_HALF_UP));
            }
            else if (CollectionUtils.isNotEmpty(recordVOList3)) {
                expertEvaluatingDetailScoreVO.setAvgScore(techScore.divide(new BigDecimal(recordVOList3.size()), 8, BigDecimal.ROUND_HALF_UP));
            }
        }
        return list;
    }

    //获去总分数
    @Override
    public BigDecimal getScore(List<ExpertRecordVO> recordVOList, Integer type) {
        BigDecimal score = new BigDecimal(0);
        for (ExpertRecordVO recordVO : recordVOList) {
            //查询出 商务/技术 模板父级
            LambdaQueryWrapper<TemplateDetailEntity> templateDetailLambda = Wrappers.lambdaQuery();
            templateDetailLambda.eq(TemplateDetailEntity::getTemplateId, recordVO.getTemplateId());
            //商务//技术 筛选条件
            templateDetailLambda.eq(TemplateDetailEntity::getScoringType, type);
            templateDetailLambda.isNull(TemplateDetailEntity::getParentId);
            List<TemplateDetailEntity> templateDetailEntityList = templateDetailService.list(templateDetailLambda);
            if (CollectionUtils.isNotEmpty(templateDetailEntityList)) {
                List<Long> parentIds = templateDetailEntityList.stream().map(TemplateDetailEntity::getId).collect(Collectors.toList());
                //查询 商务/技术 得分父级
                LambdaQueryWrapper<ExpertRecordScoreEntity> expertRecordScoreLambda = Wrappers.lambdaQuery();
                expertRecordScoreLambda.eq(ExpertRecordScoreEntity::getRecordId, recordVO.getId());
                expertRecordScoreLambda.isNotNull(ExpertRecordScoreEntity::getScoringTemplateDetailId);
                expertRecordScoreLambda.in(ExpertRecordScoreEntity::getScoringTemplateDetailParentId, parentIds);
                List<ExpertRecordScoreEntity> expertRecordScoreEntityList = expertRecordScoreService.list(expertRecordScoreLambda);
                List<ExpertRecordScoreVO> expertRecordScoreVOList = BeanMapper.mapList(expertRecordScoreEntityList, ExpertRecordScoreVO.class);
                if (CollectionUtils.isNotEmpty(expertRecordScoreVOList)) {
                    for (ExpertRecordScoreVO expertRecordScoreVO : expertRecordScoreVOList) {
                        //查询得分子级
                        LambdaQueryWrapper<ExpertRecordScoreEntity> expertRecordScoreLambda2 = Wrappers.lambdaQuery();
                        expertRecordScoreLambda2.eq(ExpertRecordScoreEntity::getRecordId, recordVO.getId());
                        expertRecordScoreLambda2.eq(ExpertRecordScoreEntity::getScoringTemplateDetailParentId, expertRecordScoreVO.getScoringTemplateDetailParentId());
                        expertRecordScoreLambda2.isNull(ExpertRecordScoreEntity::getScoringTemplateDetailId);
                        List<ExpertRecordScoreEntity> expertRecordScoreEntityList2 = expertRecordScoreService.list(expertRecordScoreLambda2);
                        List<ExpertRecordScoreVO> expertRecordScoreVOList2 = BeanMapper.mapList(expertRecordScoreEntityList2, ExpertRecordScoreVO.class);
                        for (ExpertRecordScoreVO expertRecordScoreVO2 : expertRecordScoreVOList2) {
                            if (expertRecordScoreVO2.getScore() != null) {
                                score = score.add(expertRecordScoreVO2.getScore().multiply(expertRecordScoreVO.getWeight().divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP)));
                            }
                        }
                    }
                }
            }
        }
        return score;
    }

    //评标汇总接口
    @Override
    public void collect(CollectVO collectVO) {
        String id = collectVO.getEvaluationId();
        String gatherReason = collectVO.getGatherReason();
        List<ExpertEvaluatingDetailScoreVO> scoreResultList = collectVO.getScoreResultList();
        ExpertEvaluatingEntity evaluatingEntity = service.selectById(id);
        evaluatingEntity.setGatherStatus(1);
        evaluatingEntity.setGatherReason(gatherReason);
        //推荐的供应商数据
        List<ExpertEvaluatingDetailScoreVO> detailScoreList = scoreResultList.stream().filter(t -> t.getReferFlag() != null && t.getReferFlag() == 1).collect(Collectors.toList());
        //通过的供应商数据
        List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2 = scoreResultList.stream().filter(t -> t.getCollectPassFlag() != null && t.getCollectPassFlag() == 1).collect(Collectors.toList());
        //未通过供应商数据
        List<ExpertEvaluatingDetailScoreVO> detailScoreVOList = scoreResultList.stream().filter(t -> t.getCollectPassFlag() != null && t.getCollectPassFlag() == 2).collect(Collectors.toList());
        List<ExpertEvaluatingDetailEntity> detailList = detailService.list(new QueryWrapper<ExpertEvaluatingDetailEntity>().eq("evaluation_id", id));
        for (ExpertEvaluatingDetailEntity detailEntity : detailList) {
            if (detailEntity.getEvaluationState() == 0 || detailEntity.getEvaluationState() == 3) {
                detailEntity.setEvaluationState(2);
            }
            if (detailEntity.getEvaluationState() == 1) {
                List<ExpertEntity> expertList = expertService.list(new QueryWrapper<ExpertEntity>().eq("expert_id", detailEntity.getExpertId()));
                EvaluationDetailEntity evaluationDetailEntity = new EvaluationDetailEntity();
                evaluationDetailEntity.setEvaluationName(evaluatingEntity.getEvaluationName());
                evaluationDetailEntity.setInvitingUnit(evaluatingEntity.getProjectName() == null ? evaluatingEntity.getOrgName() : evaluatingEntity.getProjectName());
                evaluationDetailEntity.setLinkman(evaluatingEntity.getEmployeeName());
                evaluationDetailEntity.setPhone(evaluatingEntity.getEmployeeMobile());
                evaluationDetailEntity.setEvaluateDate(detailEntity.getEvaluationTime());
                evaluationDetailEntity.setExpertId(expertList.get(0).getId());
                evaluationDetailService.saveOrUpdate(evaluationDetailEntity);
            }
            detailService.saveOrUpdate(detailEntity);
        }
        service.saveOrUpdate(evaluatingEntity);
        //TODO 招标修改
        if (evaluatingEntity.getInviteType() == 5) {
            dealOtherData(detailScoreList, detailScoreVOList2, detailScoreVOList);

            //评标汇总结束后 修改招标状态 为专家评标结束
            OtherInviteEntity otherInviteEntity = otherInviteService.selectById(evaluatingEntity.getInviteId());
            otherInviteEntity.setTenderState(TenderStateEnum.专家评标结束.getCode());
            otherInviteService.saveOrUpdate(otherInviteEntity);
        }
    }

    public void dealOtherData(List<ExpertEvaluatingDetailScoreVO> detailScoreList, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList) {
        //回写推荐sell表
        OtherDocumentEntity documentEntity = otherDocumentService.list(new QueryWrapper<OtherDocumentEntity>().eq("invite_id", detailScoreList.get(0).getInviteId())).get(0);
        List<OtherDocumentSellEntity> sellEntityList = otherDocumentSellService.list(new QueryWrapper<OtherDocumentSellEntity>()
                .eq("document_id", documentEntity.getId())
                .eq("scheme_id", detailScoreList.get(0).getDocumentSchemeId())
                .eq("supplier_id", detailScoreList.get(0).getSupplierId())
                .orderByDesc("talk_num"));
        List<OtherDocumentSellEntity> sellEntityList1 = sellEntityList.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
        for (OtherDocumentSellEntity sellEntity : sellEntityList1) {
            sellEntity.setReferFlag(1);
            otherDocumentSellService.saveOrUpdate(sellEntity);
        }
        //回写评分表
        for (ExpertEvaluatingDetailScoreVO detailScoreVO : detailScoreList) {
            List<ExpertRecordEntity> recordEntityList = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", detailScoreVO.getDocumentSchemeId())
                    .eq("supplier_id", detailScoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList) {
                recordEntity.setReferFlag(1);
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //未通过方案
        for (ExpertEvaluatingDetailScoreVO scoreVO : detailScoreVOList) {
            //回写sell表
            List<OtherDocumentSellEntity> sellEntity1List = otherDocumentSellService.list(new QueryWrapper<OtherDocumentSellEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<OtherDocumentSellEntity> sellEntityList2 = sellEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (OtherDocumentSellEntity sellEntity1 : sellEntityList2) {
                sellEntity1.setPassFlag(2);
                otherDocumentSellService.saveOrUpdate(sellEntity1);
            }
            //回写方案表
            List<OtherDocumentSchemeEntity> schemeEntity1List = otherDocumentSchemeService.list(new QueryWrapper<OtherDocumentSchemeEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<OtherDocumentSchemeEntity> schemeEntityList2 = schemeEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (OtherDocumentSchemeEntity schemeEntity2 : schemeEntityList2) {
                schemeEntity2.setPassFlag(2);
                otherDocumentSchemeService.saveOrUpdate(schemeEntity2);
            }
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(2);
                recordEntity.setCollectMemo(scoreVO.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //回写通过记录的汇总备注
        for (ExpertEvaluatingDetailScoreVO scoreVO2 : detailScoreVOList2) {
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO2.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO2.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(1);
                recordEntity.setCollectMemo(scoreVO2.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
    }

    @Override
    public List<ExpertEvaluatingVO> queryGatherList(Page<ExpertEvaluatingVO> page, String searchText, Integer gatherStatus, Long employeeId) {
        return baseMapper.queryGatherList(page, searchText, gatherStatus, employeeId);
    }

    //获取评分详情表头
    @Override
    public List<TemplateDetailVO> getHead(Long templateId, Integer type) {
        List<TemplateDetailVO> templateDetailVOS = new ArrayList<>();
        LambdaQueryWrapper<TemplateDetailEntity> templateDetailLambda = Wrappers.lambdaQuery();
        templateDetailLambda.eq(TemplateDetailEntity::getTemplateId, templateId);
        templateDetailLambda.eq(TemplateDetailEntity::getScoringType, type);
        List<TemplateDetailEntity> list = templateDetailService.list(templateDetailLambda);
        if (CollectionUtils.isNotEmpty(list)) {
            templateDetailVOS = TreeNodeBUtil.buildTree(BeanMapper.mapList(list, TemplateDetailVO.class));
        }
        return templateDetailVOS;
    }


    //获取评分详情内容
    //type---商务/技术（0-1）
    //recordVOList  集合
    @Override
    public List<ExpertRecordVO> getRecordVO(List<ExpertRecordVO> recordVOList, Integer type) {
        //商务/技术 得分值
        if (CollectionUtils.isNotEmpty(recordVOList)) {
            //查询出 商务/技术 模板父级
            LambdaQueryWrapper<TemplateDetailEntity> templateDetailLambda = Wrappers.lambdaQuery();
            templateDetailLambda.eq(TemplateDetailEntity::getTemplateId, recordVOList.get(0).getTemplateId());
            //商务//技术 筛选条件
            templateDetailLambda.eq(TemplateDetailEntity::getScoringType, type);
            templateDetailLambda.isNull(TemplateDetailEntity::getParentId);
            List<TemplateDetailEntity> templateDetailEntityList = templateDetailService.list(templateDetailLambda);
            if (CollectionUtils.isNotEmpty(templateDetailEntityList)) {
                List<Long> parentIds = templateDetailEntityList.stream().map(TemplateDetailEntity::getId).collect(Collectors.toList());
                for (ExpertRecordVO recordVO : recordVOList) {
                    BigDecimal score = new BigDecimal(0);
                    LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
                    expertLambda.eq(ExpertEntity::getExpertId, recordVO.getEmployeeId());
                    List<ExpertEntity> list = expertService.list(expertLambda);
                    if (CollectionUtils.isNotEmpty(list)) {
                        switch (list.get(0).getType()) {
                            case 0:
                                recordVO.setSupplierName("商务专家");
                                break;
                            case 1:
                                recordVO.setSupplierName("技术专家");
                                break;
                            case 2:
                                recordVO.setSupplierName("商务技术专家");
                                break;
                        }
                    }
                    //查询 商务/技术 得分父级
                    LambdaQueryWrapper<ExpertRecordScoreEntity> expertRecordScoreLambda = Wrappers.lambdaQuery();
                    expertRecordScoreLambda.eq(ExpertRecordScoreEntity::getRecordId, recordVO.getId());
                    expertRecordScoreLambda.isNotNull(ExpertRecordScoreEntity::getScoringTemplateDetailId);
                    expertRecordScoreLambda.in(ExpertRecordScoreEntity::getScoringTemplateDetailParentId, parentIds);
                    List<ExpertRecordScoreEntity> expertRecordScoreEntityList = expertRecordScoreService.list(expertRecordScoreLambda);
                    List<ExpertRecordScoreVO> expertRecordScoreVOList = BeanMapper.mapList(expertRecordScoreEntityList, ExpertRecordScoreVO.class);
                    if (CollectionUtils.isNotEmpty(expertRecordScoreVOList)) {
                        for (ExpertRecordScoreVO expertRecordScoreVO : expertRecordScoreVOList) {
                            //查询得分子级
                            LambdaQueryWrapper<ExpertRecordScoreEntity> expertRecordScoreLambda2 = Wrappers.lambdaQuery();
                            expertRecordScoreLambda2.eq(ExpertRecordScoreEntity::getRecordId, recordVO.getId());
                            expertRecordScoreLambda2.eq(ExpertRecordScoreEntity::getScoringTemplateDetailParentId, expertRecordScoreVO.getScoringTemplateDetailParentId());
                            expertRecordScoreLambda2.isNull(ExpertRecordScoreEntity::getScoringTemplateDetailId);
                            List<ExpertRecordScoreEntity> expertRecordScoreEntityList2 = expertRecordScoreService.list(expertRecordScoreLambda2);
                            List<ExpertRecordScoreVO> expertRecordScoreVOList2 = BeanMapper.mapList(expertRecordScoreEntityList2, ExpertRecordScoreVO.class);
                            for (ExpertRecordScoreVO expertRecordScoreVO2 : expertRecordScoreVOList2) {
                                if (expertRecordScoreVO2.getScore() == null) {
                                    expertRecordScoreVO2.setScore(new BigDecimal(0));
                                }
                                if (expertRecordScoreVO2.getScore() != null) {
                                    score = score.add(expertRecordScoreVO2.getScore().multiply(expertRecordScoreVO.getWeight().divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP)));
                                }
                            }
                            //父子级链接
                            expertRecordScoreVO.setExpertRecordScoreVOList(expertRecordScoreVOList2);
                        }
                        //得分
                        recordVO.setStuffRecordScoreVos(expertRecordScoreVOList);
                    }
                    recordVO.setSumScore(score);
                    recordVO.setSchemeNameMoney(recordVO.getSchemeName() + "含税:(" + recordVO.getMoneyTax().setScale(2, BigDecimal.ROUND_HALF_UP) + "元;无税:" + recordVO.getMoney().setScale(2, BigDecimal.ROUND_HALF_UP) + "元)");
                }
            }
            else {
                return new ArrayList<ExpertRecordVO>();//查不到模板子表，证明改模板是单一的
            }
        }
        return recordVOList;
    }

    //下一步接口
    @Override
    public ExpertEvaluatingVO saveEvaluation(Long documentId) {
        ExpertEvaluatingVO vo = new ExpertEvaluatingVO();
        LambdaQueryWrapper<ProcessEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ProcessEntity::getBillId, documentId);
        List<ProcessEntity> list = processService.list(lambda);
        switch (list.get(0).getType()) {
            case 5:
                vo = service.otherNext(documentId);
                break;
        }
        return vo;
    }


    //其他下一步
    @Override
    public ExpertEvaluatingVO otherNext(Long documentId) {
        ExpertEvaluatingEntity entity = new ExpertEvaluatingEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询文件主表信息
        OtherDocumentEntity otherDocumentEntity = otherDocumentService.selectById(documentId);
//查询招标立项
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherDocumentEntity.getInviteId());
        //更新下一步状态
        otherDocumentEntity.setNextFlag(0);
        otherDocumentService.updateById(otherDocumentEntity);

        LambdaQueryWrapper<OtherTalkEntity> lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(OtherTalkEntity::getBillId, documentId);
        OtherTalkEntity otherTalkEntity = otherTalkMapper.selectOne(lambdaTalk);
        if (null != otherTalkEntity) {
            otherTalkEntity.setNextFlag(0);
            otherTalkMapper.updateById(otherTalkEntity);
        }
        //复制主表信息
        entity.setProjectId(otherDocumentEntity.getProjectId());
        entity.setProjectName(otherDocumentEntity.getProjectName());
        entity.setPurchaseType(otherDocumentEntity.getPurchaseType());
        entity.setOrgId(otherDocumentEntity.getOrgId());
        entity.setOrgName(otherDocumentEntity.getOrgName());
        entity.setParentOrgId(otherDocumentEntity.getParentOrgId());
        entity.setParentOrgName(otherDocumentEntity.getParentOrgName());
        entity.setProjectCode(otherDocumentEntity.getProjectCode());
        entity.setEvaluationName(otherDocumentEntity.getDocumentName());
        entity.setEmployeeId(otherDocumentEntity.getEmployeeId());
        entity.setEmployeeName(otherDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        entity.setInviteId(otherDocumentEntity.getInviteId());
        entity.setDocumentId(otherDocumentEntity.getId());
        entity.setPurchaseType(otherDocumentEntity.getPurchaseType());
        entity.setUnitId(otherInviteEntity.getUnitId());
        entity.setUnitName(otherInviteEntity.getUnitName());
        entity.setGatherStatus(0);
        entity.setInviteType(5);//招标类型
        entity.setDistinctionFlag(1);
        entity.setFlagNew(1);
        entity.setChangeVersion(1);
        //复制子表
        if (CollectionUtils.isNotEmpty(otherDocumentEntity.getExpertVOList())) {
            List<ExpertEvaluatingDetailEntity> detailEntities = BeanMapper.mapList(otherDocumentEntity.getExpertVOList(), ExpertEvaluatingDetailEntity.class);
            for (ExpertEvaluatingDetailEntity evaluationDetailEntity : detailEntities) {
                evaluationDetailEntity.setId(null);
                evaluationDetailEntity.setEvaluationState(0);
                evaluationDetailEntity.setLeader(1);
            }
            entity.setStuffEvaluationDetailEntities(detailEntities);
        }
        service.saveOrUpdate(entity, false);
        //回写招标阶段
//        Integer tenderStage = 4;
//        otherInviteService.updateTenderStage(String.valueOf(otherDocumentEntity.getInviteId()), tenderStage);
//        回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("专家评标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(5);
        processEntity.setFrontendUrl("stuff/evaluationCard");
        processService.saveOrUpdate(processEntity);

        //招标文件下一步 专家评标 改招标状态 为专家评标中
        otherInviteEntity.setTenderState(TenderStateEnum.专家评标中.getCode());
        otherInviteEntity.setTenderStage(TenderStageEnum.EXPERT_STATE.getTenderTypeCode());
        otherInviteEntity.setStopTime(null);
        otherInviteService.saveOrUpdate(otherInviteEntity);

        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        return vo;
    }
    /* 评标进度报表*/
    @Override
    public List<ProgressSheetVO> queryProgressSheet(QueryWrapper queryWrapper,Page<ProgressSheetVO> page) {
        return baseMapper.queryProgressSheet(queryWrapper,page);
    }
}
