package com.ejianc.business.tender.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherTalkEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherDocumentSupplierService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentRecordVO;
import com.ejianc.business.tender.other.vo.OtherDocumentSellVO;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierSellVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 招标文件主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherDocument")
@Api(value = "招标文件主表", tags = {"招标文件主表"})
public class OtherDocumentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改
    @Autowired
    private IOtherDocumentService service;
    @Autowired
    private IOtherTalkService talkService;
    @Autowired
    private IOtherDocumentSupplierService documentSupplierService;



    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherDocumentVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody OtherDocumentVO saveorUpdateVO) {
        OtherDocumentVO otherDocumentVO = service.saveOrUpdates(saveorUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",otherDocumentVO);
    }
    @ApiOperation("供方推送报价信息接口")
    @RequestMapping(value = "/supplierPushSell", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> supplierPushSell(HttpServletRequest request,  @RequestParam(value = "file",required = false) MultipartFile file){
        Boolean b = service.supplierPushSell(request,file);
        return CommonResponse.success("推送报价信息成功！",b);
    }


    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentVO> publishDocument(@RequestParam Long id) throws Exception {
    	return CommonResponse.success("发布成功！",service.publishDocument(id));
    }
    @ApiOperation("答疑附件上传同步供方新增接口")
    @RequestMapping(value = "/uploadById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> uploadById(@RequestParam Long attachId,@RequestParam Long inviteId) throws Exception {
    	return CommonResponse.success("同步成功！",service.uploadById(attachId,inviteId));
    }
    @ApiOperation("答疑附件删除同步供方接口")
    @RequestMapping(value = "/deleteFileById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteFileById(@RequestBody OtherDocumentVO otherDocumentVO) throws Exception {
    	return CommonResponse.success("删除成功！",service.deleteFileById(otherDocumentVO.getSourceId(),otherDocumentVO.getFileNames()));
    }
    @ApiOperation("竞争性谈判等发布接口")
    @RequestMapping(value = "/publishManyDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentVO> publish4Document(@RequestParam Long id) throws InvocationTargetException, IllegalAccessException {
        return CommonResponse.success("发布成功！",service.publishManyDocument(id));
    }
    @ApiOperation("根据供应商主键和方案主键查询详情接口")
    @RequestMapping(value = "/getSchemeDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<OtherDocumentSellVO>> getSchemeDetail(@RequestBody OtherDocumentSellVO otherDocumentSellVO) {
        List<OtherDocumentSellVO> list = service.getSchemeDetail(otherDocumentSellVO);
    	return CommonResponse.success("查询成功！",list);
    }
    @ApiOperation("开标接口")
    @RequestMapping(value = "/bidDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentVO> bidDocument(@RequestParam Long id) {
        OtherDocumentVO s = service.bidDocument(id);
    	return CommonResponse.success("开标成功！",s);
    }
    @ApiOperation("延长截止时间接口")
    @RequestMapping(value = "/extendDocument", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherDocumentVO> extendDocument(@RequestBody OtherDocumentRecordVO otherDocumentRecordVO) {
    	return CommonResponse.success("延长截止时间！",service.extendDocument(otherDocumentRecordVO));
    }
    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/delSupplier", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse delSupplier(@RequestParam Long id) {
        return service.delSupplier(id);
    }
    @ApiOperation("查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentSupplierSellVO> getSupplierSchemeDetail(Long supplierDetailId,Long documentId) {
        OtherDocumentSupplierSellVO otherDocumentSupplierSellVO = service.getSupplierSchemeDetail(supplierDetailId,documentId);
    	return CommonResponse.success("开标成功！",otherDocumentSupplierSellVO);
    }
    @ApiOperation("定标中查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetailDb", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentSupplierSellVO> getSupplierSchemeDetailDb(Long schemeId,Long documentId) {
        OtherDocumentSupplierSellVO otherDocumentSupplierSellVO = service.getSupplierSchemeDetailDb(schemeId,documentId);
    	return CommonResponse.success("开标成功！",otherDocumentSupplierSellVO);
    }
    @ApiOperation("洽商谈判查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetailTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentSupplierSellVO> getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        OtherDocumentSupplierSellVO otherDocumentSupplierSellVO = service.getSupplierSchemeDetailTalk(supplierDetailId,talkId);
    	return CommonResponse.success("开标成功！",otherDocumentSupplierSellVO);
    }
    @ApiOperation("洽商谈判供应商方案详情接口(多轮显示)")
    @RequestMapping(value = "/getSupplierSchemeTalkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentSupplierSellVO> getSupplierSchemeTalkDetail(Long supplierDetailId,Long talkId) {
        OtherDocumentSupplierSellVO otherDocumentSupplierSellVO = service.getSupplierSchemeTalkDetail(supplierDetailId,talkId);
    	return CommonResponse.success("开标成功！",otherDocumentSupplierSellVO);
    }
    @ApiOperation("招标公告下一步接口")
    @RequestMapping(value = "/saveDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentVO> saveDocument(@RequestParam Long noticeId) {
        OtherDocumentVO otherDocumentVO = service.saveDocument(noticeId);
    	return CommonResponse.success("保存或修改单据成功！",otherDocumentVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentVO> queryDetail(@RequestParam Long id) {
        OtherDocumentVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherDocumentVO> vos) {
        service.removeByIds(vos.stream().map(OtherDocumentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OtherDocumentVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OtherDocumentEntity> page = service.queryPage(param,false);
        IPage<OtherDocumentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherDocumentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OtherDocumentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OtherDocument-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOtherDocumentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherDocumentVO>> refOtherDocumentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OtherDocumentEntity> page = service.queryPage(param,false);
        IPage<OtherDocumentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherDocumentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("竞争性谈判等下一步接口")
    @RequestMapping(value = "/saveManyDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentVO> saveManyDocument(@RequestParam Long id) {
        OtherDocumentEntity otherDocumentEntity = new OtherDocumentEntity();
        if(otherDocumentEntity.getId() == null || otherDocumentEntity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                otherDocumentEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        OtherDocumentVO vo = service.saveManyDocument(id);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("查询供应商主键ID")
    @RequestMapping(value = "/querySupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentSupplierEntity> querySupplierId(@RequestParam Long supplierId, @RequestParam Long talkId) {
        OtherTalkEntity otherTalkEntity = talkService.selectById(talkId);
        List<OtherDocumentSupplierEntity> list = documentSupplierService.list(new QueryWrapper<OtherDocumentSupplierEntity>().eq("supplier_id", supplierId).eq("document_id", otherTalkEntity.getBillId()));
        return CommonResponse.success("保存或修改单据成功！",list.get(0));
    }
}
