package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherTalkMapper;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.other.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.api.IidmWebEnterpriseApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.IEjcCloudDataPushService;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
@Service("otherTalkService")
public class OtherTalkServiceImpl extends BaseServiceImpl<OtherTalkMapper, OtherTalkEntity> implements IOtherTalkService {
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IOtherTalkDetailService otherTalkDetailService;
    @Autowired
    private IOtherTalkRecordService otherTalkRecordService;
    @Autowired
    private IOtherTalkRecordDetailService otherTalkRecordDetailService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;
    @Autowired
    private IEjcCloudDataPushService systemDataPushService;
    @Autowired
    private IidmWebEnterpriseApi idmWebEnterpriseApi;
    @Autowired
    private IProcessService processService;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000006";
    @Autowired
    private IAttachmentApi attachmentApi;

    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());


    @Transactional
    @Override
    public OtherTalkVO publishTalk(Long id) {
        //更新发布状态
        OtherTalkEntity otherTalkEntity = super.selectById(id);
        otherTalkEntity.setPublishFlag(0);
        super.updateById(otherTalkEntity);
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherTalkEntity.getInviteId());

        //推送供应商
        OtherDocumentSupplierTbVO otherDocumentSupplierTbVO = new OtherDocumentSupplierTbVO();
        otherDocumentSupplierTbVO.setSourceId(otherTalkEntity.getInviteId().toString());
        otherDocumentSupplierTbVO.setSourceType("云南建投洽商谈判");
        otherDocumentSupplierTbVO.setNoticeType(4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(otherTalkEntity.getTalkStartTime());
        otherDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(otherTalkEntity.getTalkEndTime());
        otherDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        otherDocumentSupplierTbVO.setMemo(otherTalkEntity.getMemo());
        otherDocumentSupplierTbVO.setTalkMoney(otherTalkEntity.getTalkMoney());
        otherDocumentSupplierTbVO.setTalkNum(otherTalkEntity.getTalkNum());
        otherDocumentSupplierTbVO.setTenderName(otherTalkEntity.getTalkName());
        otherDocumentSupplierTbVO.setSystemId(idmWebEnterpriseApi.getEnterpriseByTenantId(InvocationInfoProxy.getTenantid()).getData().getId().toString());
        String stringFb = JSONObject.toJSONString(otherDocumentSupplierTbVO);
        logger.info("洽商谈判发布" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }
        //招标公告发布成功后 改招标状态 为报价中
        otherInviteEntity.setTenderState(TenderStateEnum.报价中.getCode());
        otherInviteEntity.setStopTime(otherTalkEntity.getTalkEndTime());
        otherInviteService.saveOrUpdate(otherInviteEntity);
        return queryDetail(id);
    }

    @Override
    public OtherTalkVO extendTalk(OtherTalkDetailVO otherTalkDetailVO) {
        OtherTalkDetailEntity otherDocumentRecordEntity = BeanMapper.map(otherTalkDetailVO, OtherTalkDetailEntity.class);
        otherTalkDetailService.save(otherDocumentRecordEntity);
        OtherTalkEntity otherTalkEntity = super.selectById(otherTalkDetailVO.getTalkId());
        otherTalkEntity.setTalkEndTime(otherTalkDetailVO.getNewTime());
        boolean b = super.updateById(otherTalkEntity);

        //推送供方
        OtherSupplierSellVO supplierSellVO = new OtherSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(otherTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(otherTalkDetailVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);

        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }
        //更新招标截止时间
        OtherInviteEntity inviteEntity = otherInviteService.selectById(otherTalkEntity.getInviteId());
        inviteEntity.setStopTime(otherTalkEntity.getTalkEndTime());
        otherInviteService.saveOrUpdate(inviteEntity);
        return queryDetail(otherTalkDetailVO.getTalkId());
    }

    @Override
    public OtherTalkVO saveTalk(Long documentId) {
        OtherTalkEntity entity = new OtherTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        OtherDocumentEntity documentEntity = otherDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        otherDocumentService.saveOrUpdate(documentEntity);
        //查询招标立项信息
        OtherDocumentEntity otherDocumentEntity = otherDocumentService.selectById(documentId);
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherDocumentEntity.getInviteId());
        entity.setProjectCode(otherDocumentEntity.getProjectCode());
        entity.setInviteId(otherDocumentEntity.getInviteId());
        entity.setProjectId(otherDocumentEntity.getProjectId());
        entity.setProjectName(otherDocumentEntity.getProjectName());
        entity.setOrgId(otherDocumentEntity.getOrgId());
        entity.setOrgName(otherDocumentEntity.getOrgName());
        entity.setParentOrgId(otherDocumentEntity.getParentOrgId());
        entity.setParentOrgName(otherDocumentEntity.getParentOrgName());
        entity.setBrandFlag(otherDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(otherDocumentEntity.getPurchaseType());
        entity.setTalkName(otherInviteEntity.getTenderName());
        super.save(entity);

        //回写招标阶段

        otherInviteEntity.setTenderStage(7);
        otherInviteService.updateById(otherInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("洽商谈判");
        processEntity.setTenderId(otherDocumentEntity.getInviteId());
        processEntity.setType(5);
        processEntity.setFrontendUrl("other/talkNegotiate");
        processService.saveOrUpdate(processEntity);

        OtherTalkVO vo = BeanMapper.map(entity, OtherTalkVO.class);

        OtherTalkVO otherTalkVO = queryDetail(vo.getId());
        return otherTalkVO;
    }

    @Override
    public OtherTalkVO queryDetail(Long id) {
        OtherTalkEntity otherTalkEntity = super.selectById(id);
        OtherTalkVO otherTalkVO = BeanMapper.map(otherTalkEntity, OtherTalkVO.class);

        //确认轮数
        Integer talkNum = otherTalkEntity.getTalkNum();
        if (otherTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        OtherDocumentVO otherDocumentVO = otherDocumentService.queryDocDetail(otherTalkEntity.getBillId(), talkNum);

        //查询供应商报价方案数据


        otherTalkVO.setOtherDocumentDetailSellList(otherDocumentVO.getOtherDocumentDetailSellList());
        otherTalkVO.setOtherDocumentSupplierSchemeList(otherDocumentVO.getOtherDocumentSupplierSchemeList());

        //查询首轮报价的供应商信息
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambda = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambda.eq(OtherDocumentSupplierEntity::getDocumentId, otherTalkEntity.getBillId());
        lambda.eq(OtherDocumentSupplierEntity::getTalkNum, 0);
        List<OtherDocumentSupplierEntity> supplierList = otherDocumentSupplierService.list(lambda);
        List<OtherDocumentSupplierVO> documentSupplierVOList = BeanMapper.mapList(supplierList,OtherDocumentSupplierVO.class);
        otherTalkVO.setOtherDocumentSupplierList(documentSupplierVOList);

        //查询变更历史记录
        LambdaQueryWrapper<OtherTalkRecordEntity> lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(OtherTalkRecordEntity::getBillId,otherTalkEntity.getBillId());
        lambdaRecord.orderByAsc(OtherTalkRecordEntity::getTalkNum);
        List<OtherTalkRecordEntity> otherTalkRecordEntityList = otherTalkRecordService.list(lambdaRecord);
        List<OtherTalkRecordVO> otherTalkRecordList = BeanMapper.mapList(otherTalkRecordEntityList, OtherTalkRecordVO.class);
        otherTalkVO.setTalkRecordEntityList(otherTalkRecordList);
        return otherTalkVO;
    }
    @Transactional
    @Override
    public OtherTalkVO againSaveTalk(Long id) {
        OtherTalkEntity entity = new OtherTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询招标立项信息
        OtherTalkEntity otherTalkEntity = super.selectById(id);
        entity.setProjectCode(otherTalkEntity.getProjectCode());
        entity.setProjectId(otherTalkEntity.getProjectId());
        entity.setProjectName(otherTalkEntity.getProjectName());
        entity.setOrgId(otherTalkEntity.getOrgId());
        entity.setOrgName(otherTalkEntity.getOrgName());
        entity.setParentOrgId(otherTalkEntity.getParentOrgId());
        entity.setParentOrgName(otherTalkEntity.getParentOrgName());
        entity.setBrandFlag(otherTalkEntity.getBrandFlag());
        entity.setBillId(otherTalkEntity.getBillId());
        entity.setInviteId(otherTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(otherTalkEntity.getTalkNum() + 1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(otherTalkEntity.getPurchaseType());
        super.save(entity);

        //保存历史记录表
        OtherTalkRecordEntity otherTalkRecordEntity =  BeanMapper.map(otherTalkEntity, OtherTalkRecordEntity.class);
        otherTalkRecordEntity.setTalkId(otherTalkEntity.getId());
        otherTalkRecordEntity.setId(null);
        otherTalkRecordService.save(otherTalkRecordEntity);
        //新增历史记录子表
        List<OtherTalkDetailEntity> otherTalkDetailList = otherTalkEntity.getOtherTalkDetailList();
        List<OtherTalkRecordDetailEntity> otherTalkRecordDetailEntityList = BeanMapper.mapList(otherTalkDetailList, OtherTalkRecordDetailEntity.class);
        for (OtherTalkRecordDetailEntity otherTalkRecordDetailEntity : otherTalkRecordDetailEntityList){
            otherTalkRecordDetailEntity.setId(null);
            otherTalkRecordDetailEntity.setRecordId(otherTalkRecordEntity.getId());
        }
        otherTalkRecordDetailService.saveBatch(otherTalkRecordDetailEntityList);

        //删除老数据
        super.removeById(id,false);

        //修改进展表信息
        LambdaQueryWrapper<ProcessEntity> lambdaProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId,id);
        lambdaProcess.eq(ProcessEntity::getTenderId,otherTalkEntity.getInviteId());
        ProcessEntity processEntity = processService.getOne(lambdaProcess);
        processEntity.setBillId(entity.getId());
        processService.updateById(processEntity);
        OtherTalkVO vo = BeanMapper.map(entity, OtherTalkVO.class);
        addLastSell(otherTalkEntity.getTalkNum(),otherTalkEntity.getBillId());

        return queryDetail(entity.getId());
    }

    @Override
    public OtherTalkVO replenishSell(Long id) {
        OtherTalkEntity otherTalkEntity = super.selectById(id);

        Integer talkNum = otherTalkEntity.getTalkNum();
        Long billId = otherTalkEntity.getBillId();
        addLastSell(talkNum,billId);

        return new OtherTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        //获取最新轮数
        OtherTalkEntity otherTalkEntity = super.selectById(id);
        Integer talkNum = otherTalkEntity.getTalkNum();
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambdaSupplier = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId, otherTalkEntity.getBillId());
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getTalkNum, talkNum);
        List<OtherDocumentSupplierEntity> supplierList = otherDocumentSupplierService.list(lambdaSupplier);
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambdaSupplierFirst = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierFirst.eq(OtherDocumentSupplierEntity::getDocumentId, otherTalkEntity.getBillId());
        lambdaSupplierFirst.eq(OtherDocumentSupplierEntity::getTalkNum, 0);
        List<OtherDocumentSupplierEntity> supplierListFirst = otherDocumentSupplierService.list(lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0){
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()){
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        Map<String, Object> stringListMap = new HashMap<>();
        OtherTalkEntity otherTalkEntity = baseMapper.selectById(talkId);
        List<OtherQuotationMaterialVO> materialVOList = new ArrayList<>();
        //查询所有数据
        List<OtherDocumentSellEntity> otherDocumentSellEntities = otherDocumentSellService.selectMaterialType(otherTalkEntity.getBillId());
        Integer talkNum = otherDocumentSellEntities.get(0).getTalkNum();
        List<OtherDocumentSellVO> sellEntityList = BeanMapper.mapList(otherDocumentSellEntities, OtherDocumentSellVO.class);
        //根据材料分类
        Map<Long, List<OtherDocumentSellVO>> listMap = sellEntityList.stream().filter(map->map.getDetailId() != null).collect(Collectors.groupingBy(OtherDocumentSellVO::getDetailId));
            for (Long materialTypeId : listMap.keySet()) {
                OtherQuotationMaterialVO materialVO = new OtherQuotationMaterialVO();
                //获取供应商
                List<OtherDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (OtherDocumentSellVO sellVO : materialTypeList) {
                    materialVO  =  BeanMapper.map(sellVO, OtherQuotationMaterialVO.class);
                }
                List<OtherQuotationSupplierVO> otherQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, OtherQuotationSupplierVO.class);
                //供应商ID去重
                List<OtherQuotationSupplierVO> supplierVOS = otherQuotationSupplierVOS.stream()
                        .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSupplierId()))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                //根据供应商分类
                Map<Long, List<OtherDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map->map.getSupplierId() != null).collect(Collectors.groupingBy(OtherDocumentSellVO::getSupplierId));

                for (OtherQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    //获取方案
                    List<OtherDocumentSellVO> otherDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (OtherDocumentSellVO otherDocumentSellVO : otherDocumentSellVOS) {
                        supplierVO.setSupplierName(otherDocumentSellVO.getSupplierName());
                    }
                    List<OtherQuotationSchemeVO> otherQuotationSchemeVOS = BeanMapper.mapList(otherDocumentSellVOS, OtherQuotationSchemeVO.class);
                    //根据方案名称去重
                    List<OtherQuotationSchemeVO> schemeVOS = otherQuotationSchemeVOS.stream()
                            .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<OtherDocumentSellVO>> schemeMap = otherDocumentSellVOS.stream().filter(map->map.getSchemeName() != null).collect(Collectors.groupingBy(OtherDocumentSellVO::getSchemeName));
                    for (OtherQuotationSchemeVO otherQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<OtherDocumentSellVO> priceList = schemeMap.get(otherQuotationSchemeVO.getSchemeName());
                        //如果轮数小于最大轮数，添加一个空的对象
                        if (priceList.size()<talkNum+1){
                            OtherDocumentSellVO documentSellVO = new OtherDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0,documentSellVO);
                        }
                        otherQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        stringListMap.put("MaterialTypeList",materialVOList);
        stringListMap.put("offerNum",otherDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public OtherTalkVO saveOrUpdates(OtherTalkVO saveorUpdateVO) {
        OtherTalkEntity entity = BeanMapper.map(saveorUpdateVO, OtherTalkEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        OtherTalkVO vo = BeanMapper.map(entity, OtherTalkVO.class);
        OtherTalkVO otherTalkVO = queryDetail(vo.getId());
        return otherTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        //补足未报价供应商信息
        //查询上一轮数
        //查询报价信息,判断本轮没有报价的供应商
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambdaSupplier = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getTalkNum, talkNum);
        List<OtherDocumentSupplierEntity> supplierList = otherDocumentSupplierService.list(lambdaSupplier);

        //查询
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambdaSupplierLast = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierLast.eq(OtherDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplierLast.eq(OtherDocumentSupplierEntity::getTalkNum, talkNum - 1);
        List<OtherDocumentSupplierEntity> supplierListLast = otherDocumentSupplierService.list(lambdaSupplierLast);
        List<Long> supplierPk = supplierList.stream().map(OtherDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List<OtherDocumentSupplierEntity> documentSupplieotherityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List<OtherDocumentSupplierEntity> documentSupplieotherityNewList = BeanMapper.mapList(documentSupplieotherityDataList, OtherDocumentSupplierEntity.class);
        if (documentSupplieotherityNewList.size() == 0){
            return;
        }

        //推送供应商数据提示信息
        List<SupplierReplenishVO> replenishVOArrayList = new ArrayList<>();
        OtherDocumentEntity otherDocumentEntity = otherDocumentService.selectById(docId);
        for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : documentSupplieotherityNewList){
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(otherDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(otherDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        logger.info("再次洽商推送供方接口数据:" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateSupOffer, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("再次洽商推送供方接口数据response:" + stringCommonResponse.getMsg());
        }

        List<Long> supplierPkNew = documentSupplieotherityNewList.stream().map(OtherDocumentSupplierEntity::getId).collect(Collectors.toList());

        for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : documentSupplieotherityNewList){
            otherDocumentSupplierEntity.setId(IdWorker.getId());
            otherDocumentSupplierEntity.setTalkNum(talkNum);
        }
        otherDocumentSupplierService.saveBatch(documentSupplieotherityNewList);

        //查询上一轮未报价供应商的方案
        LambdaQueryWrapper<OtherDocumentSchemeEntity> lambdaScheme = Wrappers.<OtherDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentId, docId);
        lambdaScheme.eq(OtherDocumentSchemeEntity::getTalkNum, talkNum - 1);
        lambdaScheme.in(OtherDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List<OtherDocumentSchemeEntity> schemeList = otherDocumentSchemeService.list(lambdaScheme);
        List<Long> schemePkList = schemeList.stream().map(OtherDocumentSchemeEntity::getId).collect(Collectors.toList());
        for (OtherDocumentSchemeEntity otherDocumentSchemeEntity : schemeList){
            otherDocumentSchemeEntity.setId(IdWorker.getId());
            otherDocumentSchemeEntity.setTalkNum(talkNum);
            for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : documentSupplieotherityNewList){
                if (otherDocumentSchemeEntity.getSupplierId().equals(otherDocumentSupplierEntity.getSupplierId())){
                    otherDocumentSchemeEntity.setDocumentSupplierId(otherDocumentSupplierEntity.getId());
                }
            }
        }
        otherDocumentSchemeService.saveBatch(schemeList);

        //复制上一轮未报价的供应商的附件信息
        for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : documentSupplieotherityNewList){
            for (OtherDocumentSupplierEntity otherDocumentSupplierLastEntity : supplierListLast){
                if (otherDocumentSupplierEntity.getSupplierId().equals(otherDocumentSupplierLastEntity.getSupplierId())){
                    CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                            otherDocumentSupplierLastEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType",
                            otherDocumentSupplierEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType"
                    );
                    if (!responseCopy.isSuccess()) {
                        throw new BusinessException("再次洽商附件复制失败:" + responseCopy.getMsg());
                    }
                }

            }
        }
        //查询上一轮未报价供应商的方案详情
        LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId, docId);
        lambdaSell.eq(OtherDocumentSellEntity::getTalkNum, talkNum - 1);
        lambdaSell.in(OtherDocumentSellEntity::getSchemeId, schemePkList);
        List<OtherDocumentSellEntity> sellList = otherDocumentSellService.list(lambdaSell);
        for (OtherDocumentSellEntity otherDocumentSellEntity : sellList){
            otherDocumentSellEntity.setId(null);
            otherDocumentSellEntity.setTalkNum(talkNum);
            for (OtherDocumentSchemeEntity otherDocumentSchemeEntity : schemeList){
                if (otherDocumentSellEntity.getSupplierId().equals(otherDocumentSchemeEntity.getSupplierId()) &&
                        otherDocumentSellEntity.getSchemeName().equals(otherDocumentSchemeEntity.getSchemeName())){
                    otherDocumentSellEntity.setSchemeId(otherDocumentSchemeEntity.getId());
                }

            }
        }
        otherDocumentSellService.saveBatch(sellList);
    }
}
