package com.ejianc.business.tender.abolish.service.impl;

import com.ejianc.business.assist.material.api.IMaterialBatchPlanApi;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.purchaseplan.vo.api.IPurchasePlanApi;
import com.ejianc.business.rent.api.IRentPlanApi;
import com.ejianc.business.rent.vo.RentPlanEnum;
import com.ejianc.business.tender.abolish.bean.WasteEntity;
import com.ejianc.business.tender.abolish.service.IWasteService;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailRecordEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailRecordService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.rent.bean.RentInviteDetailRecordEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentInviteDetailRecordService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("waste")
public class WasteBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWasteService wasteService;
    /** 评标 */
    @Autowired
    private IExpertEvaluatingService evaluatingService;

    @Autowired
    private IBatPlanApi batPlanApi;
    @Autowired
    private IStuffInviteDetailRecordService stuffInviteDetailRecordService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IEquipmentInviteDetailRecordService equipmentInviteDetailRecordService;
    @Autowired
    private IPurchasePlanApi purchasePlanApi;
    @Autowired
    private IRentPlanApi rentPlanApi;
    @Autowired
    private IRentInviteDetailRecordService rentInviteDetailRecordService;
    @Autowired
    private IMaterialBatchPlanApi materialBatchPlanApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        // 释放采购计划，有审批流时发送废标通知给供应商，供应商状态为已淘汰
//		wasteService.updateGysByWaste(billId);
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        // 直审情况下，走此方法，不走提交后方法，需要在此处做判断，发布内部消息
        // 20211214 修改为审批通过后修改供应商状态，并发送内部消息
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE
                .getBillStateCode().equals(state)) {
            wasteService.updateGysByWaste(billId);//修改状态
            // 获取废标信息
            WasteEntity wasteEntity = wasteService.getById(billId);
            evaluatingService.stateCheckout(wasteEntity.getTenderId());//评标校验
            // 材料招标释放采购计划
            if (CommonUtils.TYPE_MATERIAL == wasteEntity.getType()) {
                QueryParam stuffInviteDetailQueryParam = new QueryParam();
                stuffInviteDetailQueryParam.getParams()
                        .put("invite_id", new Parameter(QueryParam.EQ, wasteEntity.getTenderId()));
                List<StuffInviteDetailRecordEntity> stuffInviteDetailEntityList = stuffInviteDetailRecordService
                        .queryList(stuffInviteDetailQueryParam);
                // 获取采购计划ID
                if (CollectionUtils.isNotEmpty(stuffInviteDetailEntityList)) {
                    List<String> planIdList = stuffInviteDetailEntityList.stream()
                            .map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
                            .collect(Collectors.toList());
                    // 释放采购计划
                    if (wasteEntity.getPurchaseType() == 0 ){
                        CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
                        if (!response.isSuccess()) {
                            throw new BusinessException("修改批次计划状态失败" + response.getMsg());
                        }
                    }else {
                        CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
                        if (!response.isSuccess()) {
                            throw new BusinessException("修改采购申请状态失败" + response.getMsg());
                        }
                    }
                }
            }
            // 设备采购释放采购计划
            else if(CommonUtils.TYPE_EQUIPMENT == wasteEntity.getType()){
                EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(wasteEntity.getTenderId());
                equipmentInviteService.updateApiState(equipmentInviteEntity, PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState(),
                        PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState());
            }
            // 设备租赁释放采购计划
            else if(CommonUtils.TYPE_RENT == wasteEntity.getType()){
                RentInviteEntity rentInviteEntity = rentInviteService.selectById(wasteEntity.getTenderId());
                rentInviteService.updateApiState(rentInviteEntity, RentPlanEnum.PLAN_STATE_WAIT.getPlanState(),
                        RentPlanEnum.PLAN_STATE_WAIT.getPlanState());
            }
            else if (CommonUtils.TYPE_RMAT == wasteEntity.getType()) {
                RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(wasteEntity.getTenderId());
                rmatInviteService.updateApiState(rmatInviteEntity, BatchPlanEnum.PLAN_STATE_WAIT.getPlanState(),
                        MaterialBatchPlanEnum.PLAN_STATE_WAIT.getPlanState());
            }
            // 发送消息
            wasteService.sendMsgByWaste(wasteEntity.getType(), wasteEntity.getTenderId());
            // 废标生效
            wasteService.updateExpertEvaluatingByWaste(wasteEntity.getTenderId());
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.error("该功能不支持！");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
