package com.ejianc.business.tender.common.controller;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.tender.common.service.ICheckService;
import com.ejianc.business.tender.common.vo.CheckVo;
import com.ejianc.business.tender.expert.bean.ExpertRepetitionEntity;
import com.ejianc.business.tender.expert.service.IExpertRepetitionService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 流程表
 *
 * @author generator
 */
@Controller
@RequestMapping("check")
public class CheckController implements Serializable {

    @Autowired
    private ICheckService service;
    @Autowired
    private IExpertRepetitionService expertRepetitionService;
    private final Logger logger = LoggerFactory.getLogger(getClass());


    /**
     * 报名报价校验
     */
    @RequestMapping(value = "/checkSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> checkSupplier(@RequestBody CheckVo checkVo) {
        Long inviteId = Long.valueOf(checkVo.getInviteId());
        Long supplierId = Long.valueOf(checkVo.getSupplierId());
        String type = checkVo.getType();
        Integer flag = checkVo.getFlag();
        return service.checkSupplier(inviteId, supplierId, type, flag);
    }
    /**
     * 查询二次报价是否开开始评标
     */
    @RequestMapping(value = "/checkBidFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> checkBidFlag(@RequestBody CheckVo checkVo) {
        Long inviteId = Long.valueOf(checkVo.getInviteId());
        List<ExpertRepetitionEntity> repetitionEntityList = expertRepetitionService.list(new QueryWrapper<ExpertRepetitionEntity>().eq("invite_id", inviteId).eq("publish_flag", 1).orderByDesc("talk_num"));
        if (CollectionUtils.isNotEmpty(repetitionEntityList)){

            return CommonResponse.success("开始评标状态:",repetitionEntityList.get(0).getBidFlag().toString());
        }
        return CommonResponse.success("开始评标状态:","0");
    }

    /**
     *  预警-供应商合同签订金额预警
     */
    @RequestMapping(value = "/supplierMnyWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> supplierMnyWarn(@RequestBody JSONArray jsonParam) {
        String s = service.supplierMnyWarn(jsonParam);
        return  CommonResponse.success(s);
    }

    @Autowired
    private ICheckSupplierApi checkSupplierApi;

//    @RequestMapping(value = "/test", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<CheckSupplierDTO> test(Long id){
//        CommonResponse<CheckSupplierDTO> checkSupplierDTOCommonResponse = checkSupplierApi.queryCheckDTO(id,);
//        return checkSupplierDTOCommonResponse;
//    }

}
