package com.ejianc.business.tender.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.vo.CertificateVO;
import com.ejianc.business.pro.supplier.vo.LimitDTO;
import com.ejianc.business.pro.supplier.vo.LimitVO;
import com.ejianc.business.tender.common.service.ICheckService;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.CertsDTO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("checkService")
public class CheckServiceImpl implements ICheckService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IStuffInviteService stuffInviteService;

    @Autowired
    private ISubInviteService subInviteService;

    @Autowired
    private IEquipmentInviteService equipmentInviteService;

    @Autowired
    private IRentInviteService rentInviteService;

    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IOtherInviteService otherInviteService;

    @Autowired
    private ICheckSupplierApi checkSupplierApi;
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<String> checkSupplier(Long inviteId, Long supplierId, String type, Integer flag) {
        String supplierType = null;
        String name = flag == 0 ? "报名" : "报价";
        logger.info("进行供应商报名报价校验");
        logger.info("校验数据:招标主键:" + inviteId + ",供应商主键:" + supplierId + ",招标类型:" + type + ",类型:" + name);
        logger.info("调用api");
        CommonResponse<CheckSupplierDTO> response = checkSupplierApi.queryCheckDTO(supplierId,null);
        logger.info("查询供应商response：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess()) {
            throw new BusinessException("查询供应商详情报错" + response.getMsg());
        }
        //异常供应商校验
        CheckSupplierDTO supplierDTO = response.getData();
        logger.info("供应商查询结果：{}", JSONObject.toJSONString(supplierDTO));
        if (supplierDTO.getInException() != null && supplierDTO.getInException()) {
            throw new BusinessException("很抱歉，您已被招标单位列入异常供应商,无法" + name);
        }
        //供货内容校验
        StuffInviteEntity inviteEntity = null;
        String supplierIdContent = null;
        String supplierContent = null;
        if (type.equals("MATERIAL")) {
            inviteEntity = stuffInviteService.selectById(inviteId);
            supplierType = "material";
            supplierIdContent = supplierDTO.getMaterialContentId();
            supplierContent = supplierDTO.getMaterialContent();
            if (supplierDTO.getRevolvMaterialContentId() != null) {
                supplierIdContent = supplierIdContent + "," + supplierDTO.getRevolvMaterialContentId();
                supplierContent = supplierContent + "," + supplierDTO.getRevolvMaterialContent();
            }
        }
        else if (type.equals("SUB")) {
            SubInviteEntity subInviteEntity = subInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(subInviteEntity, StuffInviteEntity.class);
            //判断资质条件
            List<CertsDTO> certs = supplierDTO.getCerts();
            List<CertificateVO> certificateVOS = supplierDTO.getfCertificateVOS();
            List<Long> certsList = certs.stream().map(CertsDTO::getCertId).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(certificateVOS)) {
                List<Long> certificateList = certificateVOS.stream().map(CertificateVO::getSuperiorId).filter(Objects::nonNull).map(Long::valueOf).collect(Collectors.toList());
                certsList.addAll(certificateList);
            }
            //专业分包
            if (subInviteEntity.getSubType() == 1471313836879101953L) {
                supplierIdContent = supplierDTO.getMajorContentId();
                supplierContent = supplierDTO.getMajorContent();
                supplierType = "major";
                //招标工程资质ID
                Long projectQualificationId = subInviteEntity.getProjectQualificationId();
                if (!certsList.contains(projectQualificationId)) {
                    throw new BusinessException("您的资质证件不满足本次招标的资质证件要求，无法" + name);
                }
            }
            else {
                supplierIdContent = supplierDTO.getLaborContentId();
                supplierContent = supplierDTO.getLaborContent();
                supplierType = "labor";
            }
        }
        else if (type.equals("PURCHASE")) {
            EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(equipmentInviteEntity, StuffInviteEntity.class);
            supplierIdContent = supplierDTO.getEquipmentContentId();
            supplierContent = supplierDTO.getEquipmentContent();
            supplierType = "equipment";
        }
        else if (type.equals("RENT")) {
            RentInviteEntity rentInviteEntity = rentInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(rentInviteEntity, StuffInviteEntity.class);
            supplierIdContent = supplierDTO.getEquipmentContentId();
            supplierContent = supplierDTO.getEquipmentContent();
            supplierType = "equipment";
        }
        else if (type.equals("RMAT")) {
            RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(rmatInviteEntity, StuffInviteEntity.class);
            supplierIdContent = supplierDTO.getRevolvMaterialContentId();
            supplierContent = supplierDTO.getRevolvMaterialContent();
            if (supplierDTO.getMaterialContentId() != null) {
                supplierIdContent = supplierIdContent + "," + supplierDTO.getMaterialContentId();
                supplierContent = supplierContent + "," + supplierDTO.getMaterialContent();
            }
            supplierType = "revolvMaterial";
        }
        else if (type.equals("OTHER")) {
            OtherInviteEntity otherInviteEntity = otherInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(otherInviteEntity, StuffInviteEntity.class);
            supplierIdContent = supplierDTO.getOtherContentId();
            supplierContent = supplierDTO.getOtherContent();
            supplierType = "other";
        }
        //类型限制
        if(StringUtils.isEmpty(supplierDTO.getSupplyType())){
            throw new BusinessException("很抱歉，您的供应商类型为空!");
        }
        String[] supplyType = supplierDTO.getSupplyType().split(",");
        logger.info("供应商类别" + supplierDTO.getSupplyTypeName());
        if (!(Arrays.asList(supplyType).contains(supplierType))) {
            if (!(supplierType.equals("material") && (Arrays.asList(supplyType).contains("revolvMaterial")))){
                throw new BusinessException("很抱歉，您的供应商类型与招标类型不一致,无法" + name);
            }
        }
        //判断招标是否有供货内容
        if (StringUtils.isNotEmpty(inviteEntity.getPurchaseId())) {
            logger.info("招标供货内容" + inviteEntity.getPurchaseName());
            logger.info("供应商供货内容" + supplierContent);
            String[] purchaseId = inviteEntity.getPurchaseId().split(",");
            if (StringUtils.isEmpty(supplierIdContent)) {
                throw new BusinessException("很抱歉，您的供货内容与招标不匹配,无法" + name);
            }
            String[] contentId = supplierIdContent.split(",");
            List<String> purchaseIdList = Arrays.asList(purchaseId);
            List<String> contentIdList = Arrays.asList(contentId);
            logger.info("招标供货内容ID" + JSONObject.toJSONString(purchaseIdList));
            logger.info("供应商供货内容ID" + JSONObject.toJSONString(contentIdList));
            List<String> list = purchaseIdList.stream().filter(contentIdList::contains).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                throw new BusinessException("很抱歉，您的供货内容与招标不匹配,无法" + name);
            }
            //获取供应商限额详情
            List<LimitVO> limitVOS = supplierDTO.getLimitVOS();
            List<String> limitList = limitVOS.stream().filter(LimitVO::getState).map(LimitVO::getContentId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
            Map<Long, BigDecimal> limitSingleMap = limitVOS.stream().filter(a -> a.getSingle() != null).collect(Collectors.toMap(LimitVO::getContentId, LimitVO::getSingle, (k1, k2) -> k2));
            Map<Long, BigDecimal> limitAllYearMap = limitVOS.stream().filter(a -> a.getAllYear() != null).collect(Collectors.toMap(LimitVO::getContentId, LimitVO::getAllYear, (k1, k2) -> k2));
            List<String> list1 = purchaseIdList.stream().filter(limitList::contains).collect(Collectors.toList());

            //供货内容没有设置年度经营额
            if (CollectionUtils.isEmpty(list1)) {
                List<LimitVO> list2 = limitVOS.stream().filter(a -> a.getContentId() == null && a.getContentName() == null).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(list2)) {
                    if (type.equals("MATERIAL")) {
                        //如果是材料招标,需要查询材料和周转材的数据,如果供应商包含材料和周转材资质,以材料为准
                        if (Arrays.asList(supplyType).contains("material")){
                            List<BigDecimal> materialSingleList = list2.stream().filter(a -> a.getSupplyType().equals("material")).map(LimitVO::getSingle).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(materialSingleList)){
                                BigDecimal single = materialSingleList.stream().findFirst().get();
                                if (inviteEntity.getTenderMoney().compareTo(single) > 0) {
                                    throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
                                }
                            }

                        }else if (Arrays.asList(supplyType).contains("revolvMaterial")){
                            List<BigDecimal> materialSingleList = list2.stream().filter(a -> a.getSupplyType().equals("revolvMaterial")).map(LimitVO::getSingle).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(materialSingleList)){
                                BigDecimal single = materialSingleList.stream().findFirst().get();
                                if (inviteEntity.getTenderMoney().compareTo(single) > 0) {
                                    throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
                                }
                            }

                        }
//                        List<BigDecimal> materialSingleList = list2.stream().filter(a -> a.getSupplyType().equals("material")).map(LimitVO::getSingle).collect(Collectors.toList());
//                        List<BigDecimal> revolvMaterialSingleList = list2.stream().filter(a -> a.getSupplyType().equals("revolvMaterial")).map(LimitVO::getSingle).collect(Collectors.toList());
//                        List<BigDecimal> materialAllYearList = list2.stream().filter(a -> a.getSupplyType().equals("material")).map(LimitVO::getAllYear).collect(Collectors.toList());
//                        List<BigDecimal> revolvMaterialAllYearList = list2.stream().filter(a -> a.getSupplyType().equals("revolvMaterial")).map(LimitVO::getAllYear).collect(Collectors.toList());
//                        if (CollectionUtils.isNotEmpty(materialSingleList) && CollectionUtils.isNotEmpty(revolvMaterialSingleList)) {
//                            materialSingleList.addAll(revolvMaterialSingleList);
//                            BigDecimal singleMin = Collections.min(materialSingleList);
//                            if (inviteEntity.getTenderMoney().compareTo(singleMin) > 0) {
//                                throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
//                            }
//                        }
//                        if (CollectionUtils.isNotEmpty(materialAllYearList) && CollectionUtils.isNotEmpty(revolvMaterialAllYearList)) {
//                            materialAllYearList.addAll(revolvMaterialAllYearList);
//                            BigDecimal allYearMin = Collections.min(materialAllYearList);
//                            if ((supplierDTO.getSumContractMny().add(inviteEntity.getTenderMoney())).compareTo(allYearMin) > 0) {
//                                throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
//                            }
//                        }
                    }
                    else {
                        String finalSupplierType = supplierType;
                        List<LimitVO> list3 = list2.stream().filter(a -> a.getSupplyType().equals(finalSupplierType)).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(list3) && list3.size() > 0 && list3.get(0).getSingle() != null) {
                            if (inviteEntity.getTenderMoney().compareTo(list3.get(0).getSingle()) > 0) {
                                logger.info("招标控制金额-{}", inviteEntity.getTenderMoney());
                                logger.info("单次签订限额-{}", list3.get(0).getSingle());
                                throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
                            }

                            if (CollectionUtils.isNotEmpty(list3) && list3.size() > 0 && (supplierDTO.getSumContractMny().add(inviteEntity.getTenderMoney())).compareTo(list3.get(0).getAllYear()) > 0) {
                                logger.info("招标控制金额-{}", inviteEntity.getTenderMoney());
                                logger.info("年度签订合同金额-{}", list3.get(0).getAllYear());
                                throw new BusinessException("很抱歉，您本年度签订合同金额超出年度签订金额，无法" + name);
                            }
                        }
                    }
                }
            }
            BigDecimal minSingle = null;
            BigDecimal minAllYear = null;
            boolean singleFlag = true;
            boolean allYearFlag = true;
            Long firstContentId = null;
            //获取招标设置的供货内容的第一个id
            if(CollectionUtils.isNotEmpty(list1)) {
                String firstId = list1.stream().findFirst().get();
                firstContentId = Long.parseLong(firstId);
                if (limitSingleMap.get(Long.parseLong(firstId)) != null) {
                    minSingle = limitSingleMap.get(Long.parseLong(firstId));
                }else{
                    singleFlag = false;
                }
                //年度经营额
                if (limitAllYearMap.get(Long.parseLong(firstId)) != null) {
                    minAllYear = limitAllYearMap.get(Long.parseLong(firstId));
                }else {
                    allYearFlag = false;
                }
                CommonResponse<CheckSupplierDTO> response2 = checkSupplierApi.queryCheckDTO(supplierId,firstContentId);
                logger.info("查询供应商response：{}", JSONObject.toJSONString(response));
                if (!response.isSuccess()) {
                    throw new BusinessException("查询供应商详情报错" + response.getMsg());
                }
                //异常供应商校验
                CheckSupplierDTO supplierDTO2 = response2.getData();
                if (singleFlag && minSingle != null) {
                    logger.info("招标控制金额-{}", inviteEntity.getTenderMoney());
                    logger.info("单次签订限额-{}", minSingle);
                    if (inviteEntity.getTenderMoney() != null &&  inviteEntity.getTenderMoney().compareTo(minSingle) > 0) {
                        throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
                    }
                }
                if (allYearFlag && minAllYear != null) {
                    logger.info("招标控制金额-{}", inviteEntity.getTenderMoney());
                    logger.info("年度签订合同金额-{}", minAllYear);
                    if (inviteEntity.getTenderMoney() != null && (supplierDTO2.getSumContractMny().add(inviteEntity.getTenderMoney())).compareTo(minAllYear) > 0) {
                        throw new BusinessException("很抱歉，您本年度签订合同金额超出年度签订金额，无法" + name);
                    }
                }
            }



//            for (String id : list1) {
//                //单次经营额
//                if (limitSingleMap.get(Long.parseLong(id)) != null) {
//                    if (minSingle == null) {
//                        minSingle = limitSingleMap.get(Long.parseLong(id));
//                    }
//                    else {
//                        if (limitSingleMap.get(Long.parseLong(id)).compareTo(minSingle) > 0) {
//                            minSingle = limitSingleMap.get(Long.parseLong(id));
//                        }
//                    }
//                }
//                else {
//                    singleFlag = false;
//                }
//                //年度经营额
//                if (limitAllYearMap.get(Long.parseLong(id)) != null) {
//                    if (minAllYear == null) {
//                        minAllYear = limitAllYearMap.get(Long.parseLong(id));
//                    }
//                    else {
//                        if (limitAllYearMap.get(Long.parseLong(id)).compareTo(minAllYear) > 0) {
//                            minAllYear = limitAllYearMap.get(Long.parseLong(id));
//                        }
//                    }
//                }
//                else {
//                    allYearFlag = false;
//                }
//            }


        }

        return CommonResponse.success("供应商校验成功!");
    }

    @Override
    public String supplierMnyWarn(JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
            UserContext userContextCache =sessionManager.getUserContext();
    //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        Long orgId = userContextCache.getOrgId();
        OrgVO orgVO = orgApi.getOneById(orgId).getData();
        String innerCode = orgVO.getInnerCode();
        String[] parentIds = innerCode.split("\\|");
        //根组织Id
        String parentId = parentIds[0];
        OrgVO parentOrg = orgApi.getOneById(Long.parseLong(parentId)).getData();

        //查询合同池
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        CommonResponse<List<ContractPoolVO>> contractResponse = contractPoolApi.getSupplierSignMny(contractPoolVO);
        logger.info("查询合同池response：{}", JSONObject.toJSONString(contractResponse));
        if (!contractResponse.isSuccess()) {
            throw new BusinessException("查询合同池" + contractResponse.getMsg());
        }
        List<ContractPoolVO> contractPoolVOList = contractResponse.getData();
        Map<Long, SupplierDTO> supplierMap = new HashMap<>();
        Map<Long, String> limitVOMap = new HashMap<>();
        Map<String, BigDecimal> limitMap = new HashMap<>();
        Map<String, BigDecimal> supplierSignMnyMap = new HashMap<>();
        logger.info("查询合同池response：{}", JSONObject.toJSONString(contractPoolVOList));

        if (CollectionUtils.isNotEmpty(contractPoolVOList)) {
            List<Long> supplierIds = contractPoolVOList.stream().map(ContractPoolVO::getPartybId).collect(Collectors.toList());
            Map<String, List<Long>> supplierIdsMap = new HashMap<>();
            supplierIdsMap.put("ids", supplierIds);
            logger.info("供应商Ids:" + JSONObject.toJSONString(supplierIdsMap));

            //查询供应商信息
            CommonResponse<List<SupplierDTO>> supplierDTOCommonResponse = proSupplierApi.queryPostSupplierByIds(supplierIdsMap);
            logger.info("supplierDTOCommonResponse:" + JSONObject.toJSONString(supplierDTOCommonResponse));
            if (!supplierDTOCommonResponse.isSuccess()) {
                throw new BusinessException("根据id查询供应商失败！" + supplierDTOCommonResponse.getMsg());
            }
            List<SupplierDTO> supplierDTOList = supplierDTOCommonResponse.getData();

            if (CollectionUtils.isNotEmpty(supplierDTOList)) {
                supplierMap = supplierDTOList.stream().collect(Collectors.toMap(SupplierDTO::getId, Function.identity()));
                logger.info("supplierMap:" + JSONObject.toJSONString(supplierMap));
            }

            //查询限额设置
            CommonResponse<List<LimitDTO>> limitListResponse = checkSupplierApi.getLimitList();
            logger.info("limitListResponse:" + JSONObject.toJSONString(limitListResponse));
            if (!limitListResponse.isSuccess()) {
                throw new BusinessException("查询限额设置失败！" + limitListResponse.getMsg());
            }
            List<LimitDTO> limitDTOList = limitListResponse.getData();
            if (CollectionUtils.isNotEmpty(limitDTOList)) {
                limitMap = limitDTOList.stream().filter(e -> (null != e.getContentId() && null != e.getAllYear())).collect(Collectors.groupingBy((s -> s.getContentId() + "-" + s.getGreadId()),
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAllYear()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                List<LimitDTO> limitDTOS = limitDTOList.stream().filter(e -> (null != e.getContentId() && null != e.getAllYear())).collect(
                        Collectors.collectingAndThen(
                                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(LimitDTO::getContentId))), ArrayList::new)
                );
                limitVOMap = limitDTOS.stream().collect(Collectors.toMap(LimitDTO::getContentId, LimitDTO::getContentName));

            }

            supplierSignMnyMap = contractPoolVOList.stream().filter(e -> e.getContractTaxMny() != null).collect(Collectors.groupingBy((s -> s.getPartybId() + "-" + s.getPurchaseId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            logger.info("supplierSignMnyMap:"+JSON.toJSONString(supplierSignMnyMap));

        }

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            DecimalFormat df = new DecimalFormat("###,##0.00");
            for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                JSONObject set = orgSettings.getJSONObject(i1);
                if (set.getBoolean("default") || parentId.equals(set.getLong("orgId"))) {
                    JSONArray warningSettings = set.getJSONArray("warningSetings");


                    for (int j1 = 0; j1 < warningSettings.size(); j1++) {
                        JSONObject set1 = warningSettings.getJSONObject(j1);
                        BigDecimal rate = null ==set1.getBigDecimal("parameterValue")? BigDecimal.ZERO: ComputeUtil.safeDiv(set1.getBigDecimal("parameterValue"), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        logger.info("rate:"+rate);

                        BigDecimal ratePercent = rate.multiply(new BigDecimal(100));
                        Map<Long, SupplierDTO> finalSupplierMap = supplierMap;
                        Map<String, BigDecimal> finalLimitMap = limitMap;
                        Map<Long, String> finalLimitVOMap = limitVOMap;
                        supplierSignMnyMap.forEach((key, value) -> {
                            boolean high = false;
                            boolean meddle = false;
                            boolean low = false;
                            JSONObject useSetHigh = null;
                            JSONObject useSetMeddle = null;
                            JSONObject useSetLow = null;
                            String[] partybIds = key.split("-");
                            logger.info("key:"+key);
                            String partybId = partybIds[0];
                            logger.info("partybId:"+partybId);
                            String purchaseId = partybIds[1];
                            logger.info("purchaseId:"+purchaseId);
                            String purchaseName = null;
                            if (finalLimitVOMap.containsKey(Long.parseLong(purchaseId))){
                                purchaseName = finalLimitVOMap.get(Long.parseLong(purchaseId));
                            }

                            if (finalSupplierMap.containsKey(Long.parseLong(partybId))) {
                                SupplierDTO supplierDTO = finalSupplierMap.get(Long.parseLong(partybId));
                                Long gradeId = supplierDTO.getGradeId();
                                String limitKey = purchaseId + "-" + gradeId;
                                if (finalLimitMap.containsKey(limitKey)) {
                                    BigDecimal bigDecimalLimit = finalLimitMap.get(limitKey);
                                     //计算不能超过的金额
                                    BigDecimal bigDecimalMax = ComputeUtil.safeMultiply(bigDecimalLimit, rate);
                                    if ("高".equals(set1.getString("warningLevel"))) {
                                        if(value.compareTo(bigDecimalMax) == 1){
                                            high = true;
                                            useSetHigh = set1;
                                        }
                                    }
                                    if ("中".equals(set1.getString("warningLevel"))) {
                                        if(value.compareTo(bigDecimalMax) == 1){
                                            meddle = true;
                                            useSetMeddle = set1;
                                        }
                                    }
                                    if ("低".equals(set1.getString("warningLevel"))) {
                                        if(value.compareTo(bigDecimalMax) == 1){
                                            low = true;
                                            useSetLow = set1;
                                        }
                                    }
                                    if (high || meddle || low) {
                                        EarlyWarnTransVO vo = new EarlyWarnTransVO();
                                        vo.setBillName(set.getString("moduleName"));
                                        vo.setPcTitle("111");
                                        //vo.setPcUrl(PC_URL + contractEntity.getId());
                                        vo.setOrgId(Long.parseLong(parentId));
                                        //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                                        vo.setSendOrgId(parentId);
                                        vo.setOrgName(parentOrg.getName());
                                        // vo.setSourceId(projectPoolSetVO.getId().toString());
                                        vo.setTenantId(tenantId);
                                        vo.setWarnSetId(set.getLong("warnId"));
                                        vo.setEarlywarnName(set.getString("warnName"));
                                        vo.setWarnType(set.getString("warnType"));
//                                        String tmpContent = set.getString("warningContentTemplate");

                                        if (high) {
                                            vo.setWarnLevel("高");
                                            vo.setWarnSetParamId(useSetHigh.getLong("id"));
//                                          供应商名称】的供货内容【预警的供货内容】截止目前为止，合同签订金额【累计合同签订金额】元，达到了限额【供货内容的限额】元的【预警值%】请重点关注。@李继发 
                                            String earlywarnContent  = "【" + supplierDTO.getName() + "】" + "的供货内容" +
                                                    "【" + purchaseName + "】" + "截止目前为止，合同签订金额【" + df.format(value) + "】元，达到了限额【" + df.format(bigDecimalLimit)+ "】元的【" +ratePercent+"%】请重点关注。";
                                                    vo.setEarlywarnContent(earlywarnContent);
                                        } else if (meddle) {
                                            vo.setWarnLevel("中");
                                            vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                            String earlywarnContent  = "【" + supplierDTO.getName() + "】" + "的供货内容" +
                                                    "【" + purchaseName + "】" + "截止目前为止，合同签订金额【" + df.format(value) + "】元，达到了限额【" + df.format(bigDecimalLimit)+ "】元的【" +ratePercent+"%】请重点关注。";
                                                    vo.setEarlywarnContent(earlywarnContent);
                                        } else {
                                            vo.setWarnLevel("低");
                                            vo.setWarnSetParamId(useSetLow.getLong("id"));
                                            String earlywarnContent  = "【" + supplierDTO.getName() + "】" + "的供货内容" +
                                                    "【" + purchaseName + "】" + "截止目前为止，合同签订金额【" + df.format(value) + "】元，达到了限额【" + df.format(bigDecimalLimit)+ "】元的【"+ ratePercent+"%】请重点关注。";
                                                    vo.setEarlywarnContent(earlywarnContent);
                                        }
                                        warnList.add(vo);
                                    }
                                }
                                }
                                });
                        }
                }

            }

        }
        logger.info("预警消息实体:"+JSON.toJSONString(warnList)+"warnCode"+warnCode);

        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            throw new BusinessException("回调预警任务服务失"+warnResp.getMsg());
        }
        return "任务接受处理成功！";
            }

    }
