package com.ejianc.business.tender.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteVO;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping("/equipmentInviteFileUpdate/")
public class EquipmentInviteFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IEquipmentInviteService equipmentInviteService;



    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(updateData.getLong("billId"));
        equipmentInviteEntity.setContractFileId(updateData.getLong("fileId"));
        equipmentInviteEntity.setContractFileHighlightId(updateData.getLong("fileId"));
        equipmentInviteEntity.setContractFilePath(updateData.getString("fileOnlinePath"));
        equipmentInviteEntity.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        //将合同文件同步状态设置为已同步
        equipmentInviteEntity.setContractFileSyncFlag(true);
        equipmentInviteService.saveOrUpdate(equipmentInviteEntity, false);

        resp.put("message", "招标文件信息更新成功");
        resp.put("billData", equipmentInviteEntity);
        return CommonResponse.success("招标文件信息更新成功！", resp);
    }

    @GetMapping(value = "getBillDataJson")
    public CommonResponse<EquipmentInviteVO> getBillDataJson(@RequestParam Long id) {
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(id);
        EquipmentInviteVO vo = BeanMapper.map(equipmentInviteEntity, EquipmentInviteVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
//        if(CollectionUtils.isNotEmpty(vo.getSubDetailRecord())) {
//            //合同明细清单处理
//            vo.getSubDetailRecord().forEach(item -> {
//                switch (item.getCalculateType()) {
//                    case 0:
//                        item.setCalculateTypeName("理计");
//                        break;
//                    case 1:
//                        item.setCalculateTypeName("过磅");
//                        break;
//                    case 2:
//                        item.setCalculateTypeName("点数");
//                        break;
//                }
//                item.setRateStr(priceFmt.format(null != item.getRate() ? item.getRate() : BigDecimal.ZERO));
//                item.setMoneyTaxStr(mnyFmt.format(null != item.getMoneyTax() ? item.getMoneyTax() : BigDecimal.ZERO));
//            });
//        }
        return CommonResponse.success(vo);
    }


}
