package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.equipment.bean.EquipmentAdviceEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentBidEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentBidService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentAdviceSupplierPushVO;
import com.ejianc.business.tender.equipment.vo.EquipmentAdviceVO;
import com.ejianc.business.tender.stuff.bean.StuffAdviceEntity;
import com.ejianc.business.tender.stuff.bean.StuffBidEntity;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.stuff.service.IStuffBidService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.vo.StuffAdviceVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.equipment.mapper.EquipmentAdviceMapper;
import com.ejianc.business.tender.equipment.bean.EquipmentAdviceEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentAdviceService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 设备-中标通知书
 * 
 * @author generator
 * 
 */
@Service("equipmentAdviceService")
public class EquipmentAdviceServiceImpl extends BaseServiceImpl<EquipmentAdviceMapper, EquipmentAdviceEntity> implements IEquipmentAdviceService{
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentBidService equipmentBidService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000002";//此处需要根据实际修改
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
        EquipmentAdviceEntity equipmentAdviceEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            equipmentAdviceEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            equipmentAdviceEntity.setSignFlag(1);
        }
        if(status == 4){
            equipmentAdviceEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(equipmentAdviceEntity.getId());
            cv.setContractName(equipmentAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(equipmentAdviceEntity);

        return CommonResponse.success("更新成功!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        EquipmentAdviceEntity equipmentAdviceEntity = super.selectById(id);
        equipmentAdviceEntity.setSendFlag(0);
        super.updateById(equipmentAdviceEntity);
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentAdviceEntity.getInviteId());
        EquipmentAdviceSupplierPushVO equipmentAdviceSupplierPushVO = BeanMapper.map(equipmentAdviceEntity, EquipmentAdviceSupplierPushVO.class);

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        equipmentAdviceSupplierPushVO.setSystemId(ejcCloudSystemCode.getData());
        equipmentAdviceSupplierPushVO.setSourceType("云南建投材料中标通知书");
        equipmentAdviceSupplierPushVO.setSourceId(equipmentAdviceEntity.getId().toString());
        equipmentAdviceSupplierPushVO.setBidTitle(equipmentAdviceEntity.getTitleName());
        equipmentAdviceSupplierPushVO.setSourceProjectId(equipmentAdviceEntity.getProjectId() != null ? equipmentAdviceEntity.getProjectId().toString() : null);
        equipmentAdviceSupplierPushVO.setSourceOrgId(equipmentAdviceEntity.getOrgId().toString());
        equipmentAdviceSupplierPushVO.setSourceUnitId(equipmentAdviceEntity.getUnitId().toString());
//        equipmentAdviceSupplierPushVO.setType("TYPE_MATERIAL");
        equipmentAdviceSupplierPushVO.setType(CommonUtils.getGysType(CommonUtils.TYPE_EQUIPMENT));
        equipmentAdviceSupplierPushVO.setTenderType(equipmentInviteEntity.getTenderType());
        equipmentAdviceSupplierPushVO.setBidDate(equipmentAdviceEntity.getNoticeDate());
        equipmentAdviceSupplierPushVO.setMoney(equipmentAdviceEntity.getMoney());
        equipmentAdviceSupplierPushVO.setMoneyTax(equipmentAdviceEntity.getMoneyTax());

        String dataInfo = JSONObject.toJSONString(equipmentAdviceSupplierPushVO);

        boolean b = stuffAdviceService.pushBillToSupCenter(dataInfo, equipmentAdviceEntity.getSupplierId(), equipmentAdviceEntity.getId(),
                BILL_TYPE, PUSH_ADVICE_SERVER_URL, equipmentAdviceEntity.getTitleName());
        if (!b){
            throw new BusinessException("推送供方失败!");
        }
        return null;
    }

    @Override
    public List<EquipmentAdviceVO> queryAdviceList(Long id) {
        EquipmentBidEntity equipmentBidEntity = equipmentBidService.selectById(id);
        LambdaQueryWrapper<EquipmentAdviceEntity> lambdaAdvice = Wrappers.<EquipmentAdviceEntity>lambdaQuery();
        lambdaAdvice.eq(EquipmentAdviceEntity::getInviteId, equipmentBidEntity.getInviteId());
        List<EquipmentAdviceEntity> list = super.list(lambdaAdvice);
        List<EquipmentAdviceVO> equipmentAdviceVOS = BeanMapper.mapList(list, EquipmentAdviceVO.class);
        //处理签章附件信息
        if (CollectionUtils.isNotEmpty(equipmentAdviceVOS)) {
            List<Long> attachIds = equipmentAdviceVOS.stream().map(EquipmentAdviceVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    for (EquipmentAdviceVO equipmentAdviceVO : equipmentAdviceVOS) {
                        AttachmentVO attachmentVO = attacMap.get(equipmentAdviceVO.getId());
                        if (attachmentVO != null) {
                            equipmentAdviceVO.setAttachId(attachmentVO.getId());
                            equipmentAdviceVO.setFileName(attachmentVO.getFileName());
                            equipmentAdviceVO.setFilePath(attachmentVO.getFilePath());
                        }
                    }
                }
            }
        }
        return equipmentAdviceVOS;
    }
}
