package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.api.ICorpPurchaseApplyApi;
import com.ejianc.business.proequipmentcorppur.purchaseplan.api.ICorpPurchasePlanApi;
import com.ejianc.business.purchaseplan.vo.api.IPurchasePlanApi;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailRecordEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentInviteMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailBidderVO;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailRecordVO;
import com.ejianc.business.tender.pricelib.MaterialPriceHistoryApiVO;
import com.ejianc.business.tender.pricelib.PriceCheckCodeEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Service("equipmentInviteService")
public class EquipmentInviteServiceImpl extends BaseServiceImpl<EquipmentInviteMapper, EquipmentInviteEntity> implements IEquipmentInviteService {
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubInviteService subInviteService;

    @Autowired
    private IPurchasePlanApi batPlanApi;

    @Autowired
    private ICorpPurchaseApplyApi corpPurchasePlanApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id,tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id,abolishType);
    }

    @Override
    public List<EquipmentInviteDetailVO> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<EquipmentInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        LambdaQueryWrapper<ProcessEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ProcessEntity::getTenderId, tenderId);
        lambda.eq(ProcessEntity::getBillId, tenderId);
        List<ProcessEntity> list = processService.list(lambda);
        switch (list.get(0).getType()){
            case 0: map = equipmentInviteService.getSuffAbolishType(tenderId);break;
            case 1: map = equipmentInviteService.getSubAbolishType(tenderId);break;
        }
        return map;
    }

    @Override
    public Map<String, Object> getSuffAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(tenderId);
        EquipmentInviteVO vo = BeanMapper.map(equipmentInviteEntity, EquipmentInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    @Override
    public Map<String, Object> getSubAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        SubInviteEntity subInviteEntity = subInviteService.selectById(tenderId);
        SubInviteVO vo = BeanMapper.map(subInviteEntity, SubInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    @Override
    public List<EquipmentInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }

    @Override
    public void updateApiState(EquipmentInviteEntity entity, Integer BatchPlanState, Integer MaterialBatchPlanState) {
        List<String> batPlanList = entity.getEquipmentDetailRecord().stream().map(EquipmentInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
        if (entity.getPurchaseType()==0){
            if (CollectionUtils.isNotEmpty(batPlanList)) {
                CommonResponse<String> response = batPlanApi.updateBatPlanQuote(batPlanList, BatchPlanState);
                if (!response.isSuccess()) {
                    throw new BusinessException("修改计划状态失败" + response.getMsg());
                }
            }
        }else {
            if (CollectionUtils.isNotEmpty(batPlanList)) {
                CommonResponse<String> response = corpPurchasePlanApi.updateBatApplyByQuoteType(batPlanList, MaterialBatchPlanState);
                if (!response.isSuccess()) {
                    throw new BusinessException("修改公司设备采购计划状态失败" + response.getMsg());
                }
            }
        }
    }

    @Override
    public ParamsCheckVO priceCheckParams(EquipmentInviteVO inviteVO) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<>();

        if(null!=inviteVO.getEstablishType()&&1==inviteVO.getEstablishType()){
            //定标立项
            if(CollectionUtil.isNotEmpty(inviteVO.getEquipmentDetailRecord())){
                for (EquipmentInviteDetailRecordVO detailVO : inviteVO.getEquipmentDetailRecord()) {
                    if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                        if(CollectionUtil.isNotEmpty(detailVO.getEquipmentDetailBidder())){
                            for (EquipmentInviteDetailBidderVO bidderVO : detailVO.getEquipmentDetailBidder()) {
                                if(!"del".equals(bidderVO.getRowState())){
                                    MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                                    priceHistoryApiVO.setPrice(bidderVO.getPrice());
                                    priceHistoryApiVO.setTaxPrice(bidderVO.getTaxPrice());
                                    priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                                    priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                                    priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                                    priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                                }
                            }
                        }
                    }
                }
            }

        }else{
            //招标立项
            if(CollectionUtil.isNotEmpty(inviteVO.getEquipmentDetailRecord())){
                for (EquipmentInviteDetailRecordVO detailVO : inviteVO.getEquipmentDetailRecord()) {
                    if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                        MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                        priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                        priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                        priceHistoryApiVO.setSpec(detailVO.getSpec());
                        priceHistoryApiVO.setPrice(detailVO.getPrice());
                        priceHistoryApiVO.setTaxPrice(detailVO.getTaxPrice());
                        priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                        priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                        priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                        priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                        materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                    }
                }
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(inviteVO.getOrgId());
        ParamsCheckVO paramsCheckVO = priceCheckParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }

    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<MaterialPriceHistoryApiVO> detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        if(org.apache.commons.collections.CollectionUtils.isEmpty(detailList)){//传入集合为空直接返回结果
            logger.info("detailList为空直接返回结果");
            return paramsCheckVO;
        }
        String MAX_CODE = PriceCheckCodeEnum.设备采购招标最高价.getCode();
        String MIN_CODE =PriceCheckCodeEnum.设备采购招标最低价.getCode();
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if(null==orgId){
            logger.info("orgId为空");
            return paramsCheckVO;
        }
        //查询高价比例
//        CommonResponse<BillParamVO> maxParamByCode = paramConfigApi.getBillParamByCode(MAX_CODE);
        CommonResponse<List<BillParamVO>> maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE,orgId);
        if(!maxParamByCode.isSuccess() && null == maxParamByCode.getData()){
            logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
//            throw new BusinessException("获取历史高价控制参数失败");
        }
        //查询高价比例
//        CommonResponse<BillParamVO> minParamByCode = paramConfigApi.getBillParamByCode(MIN_CODE);
        CommonResponse<List<BillParamVO>> minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE,orgId);
        if(!minParamByCode.isSuccess() && null == minParamByCode.getData()){
            logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
//            throw new BusinessException("获取历史低价控制参数失败");
        }
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("招标历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("招标历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.设备采购价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.设备采购价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                for (MaterialPriceHistoryApiVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("物资：{}--高价：{}---低价：{}",detailVO.getMaterialName()+detailVO.getSpec(),split[1],split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("招标单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("招标单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                for (MaterialPriceHistoryApiVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("物资：{}--高价：{}---低价：{}",detailVO.getMaterialName()+detailVO.getSpec(),split[1],split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if(price.compareTo(minPriceParam) < 0){
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("招标单价小于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("招标单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        /*添加参数控制区域---*/
        String[] paramsArr = {"alert", "warn", "none"};
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArr) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else{
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
}
