package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeService;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentNoticeDetailMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentNoticeMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeSupplierDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeSupplierService;
import com.ejianc.business.tender.equipment.vo.*;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffNoticeDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
@Service("equipmentNoticeService")
public class EquipmentNoticeServiceImpl extends BaseServiceImpl<EquipmentNoticeMapper, EquipmentNoticeEntity> implements IEquipmentNoticeService {

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IEquipmentNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private EquipmentNoticeDetailMapper equipmentNoticeDetailMapper;

    @Autowired
    private IEquipmentNoticeSupplierService supplierService;

    @Autowired
    private IEquipmentInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        baseMapper.updateEndTime(noticeId,newTime);
    }

    @Transactional
    @Override
    public CommonResponse publish(EquipmentNoticeVO equipmentNoticeVO) throws InvocationTargetException, IllegalAccessException {
        //插入主表数据
        EquipmentNoticeEntity equipmentNoticeEntity = baseMapper.selectById(equipmentNoticeVO.getId());
        EquipmentInviteEntity inviteEntity = inviteService.selectById(equipmentNoticeEntity.getInviteId());
        equipmentNoticeEntity.setPublishFlag(0);
        baseMapper.updateById(equipmentNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        EquipmentNoticeSupplierTbVO equipmentNoticeSupplierTbVO = new EquipmentNoticeSupplierTbVO();
        BeanUtils.copyProperties(equipmentNoticeSupplierTbVO, equipmentNoticeEntity);
        equipmentNoticeSupplierTbVO.setNoticeStartTime(sdf.format(equipmentNoticeEntity.getNoticeStartTime()));
        equipmentNoticeSupplierTbVO.setNoticeEndTime(sdf.format(equipmentNoticeEntity.getNoticeEndTime()));
        equipmentNoticeSupplierTbVO.setNoticeType(0);
        if (equipmentNoticeEntity.getPurchaseType()==1){
            equipmentNoticeSupplierTbVO.setSourceProjectId(null);
        }else {
            equipmentNoticeSupplierTbVO.setSourceProjectId(equipmentNoticeEntity.getProjectId().toString());
        }
        equipmentNoticeSupplierTbVO.setSourceId(equipmentNoticeEntity.getInviteId().toString());
        equipmentNoticeSupplierTbVO.setSourceType("云南建投招标公告");
        equipmentNoticeSupplierTbVO.setSourceOrgId(equipmentNoticeEntity.getOrgId().toString());
        equipmentNoticeSupplierTbVO.setSourceUnitId(equipmentNoticeEntity.getUnitId().toString());
        equipmentNoticeSupplierTbVO.setType("PURCHASE");
        equipmentNoticeSupplierTbVO.setTenderName(equipmentNoticeEntity.getNoticeName());
        equipmentNoticeSupplierTbVO.setSourceEmployeeId(equipmentNoticeEntity.getEmployeeId().toString());
        equipmentNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        equipmentNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        equipmentNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        equipmentNoticeSupplierTbVO.setId(null);
        equipmentNoticeSupplierTbVO.setCreateTime(null);
        equipmentNoticeSupplierTbVO.setUpdateTime(null);
        equipmentNoticeSupplierTbVO.setCreateUserCode(null);
        equipmentNoticeSupplierTbVO.setUpdateUserCode(null);
        equipmentNoticeSupplierTbVO.setSyncEsFlag(null);
        equipmentNoticeSupplierTbVO.setVersion(null);
        equipmentNoticeSupplierTbVO.setTenantId(null);
        equipmentNoticeSupplierTbVO.setDr(null);
        //插入物资
//        List<EquipmentNoticeDetailEntity> noticeDetailEntityList = equipmentNoticeDetailMapper.selectList(new LambdaQueryWrapper<EquipmentNoticeDetailEntity>().eq(EquipmentNoticeDetailEntity::getNoticeId, equipmentNoticeVO.getId()));
        List<EquipmentNoticeDetailVO> noticeDetailEntityList =  equipmentNoticeDetailMapper.selectSumDetail(equipmentNoticeVO.getId());
        List<EquipmentNoticeDetailTbVO> equipmentNoticeDetailVOS = new ArrayList<>();
        for (EquipmentNoticeDetailVO equipmentNoticeDetailEntity : noticeDetailEntityList) {
            EquipmentNoticeDetailTbVO equipmentNoticeDetailTbVO = new EquipmentNoticeDetailTbVO();
            BeanUtils.copyProperties(equipmentNoticeDetailTbVO, equipmentNoticeDetailEntity);
            equipmentNoticeDetailTbVO.setMemo(equipmentNoticeDetailTbVO.getSumMemo());
            equipmentNoticeDetailTbVO.setNum(equipmentNoticeDetailTbVO.getSumNum());
            equipmentNoticeDetailTbVO.setMoney(equipmentNoticeDetailTbVO.getSumMoney());
            equipmentNoticeDetailTbVO.setMoneyTax(equipmentNoticeDetailTbVO.getSumMoneyTax());
            equipmentNoticeDetailTbVO.setPriceTender(equipmentNoticeDetailEntity.getPrice());
            equipmentNoticeDetailTbVO.setTaxPriceTender(equipmentNoticeDetailEntity.getTaxPrice());
            equipmentNoticeDetailTbVO.setSourceId(equipmentNoticeEntity.getInviteId().toString());
            equipmentNoticeDetailTbVO.setSourceMaterialId(equipmentNoticeDetailEntity.getMaterialId()==null?null: equipmentNoticeDetailEntity.getMaterialId().toString());
            equipmentNoticeDetailTbVO.setSourceMaterialTypeId(equipmentNoticeDetailEntity.getMaterialTypeId()==null?null: equipmentNoticeDetailEntity.getMaterialTypeId().toString());
            equipmentNoticeDetailVOS.add(equipmentNoticeDetailTbVO);

        }
        equipmentNoticeSupplierTbVO.setPurchaseDetailList(equipmentNoticeDetailVOS);
        //是否是邀请招标
        if (equipmentNoticeVO.getTenderType()==1){
            List<EquipmentNoticeSupplierDetailEntity> detailEntityList = noticeSupplierDetailService.list(new LambdaQueryWrapper<EquipmentNoticeSupplierDetailEntity>().eq(EquipmentNoticeSupplierDetailEntity::getInviteId, equipmentNoticeEntity.getInviteId()).eq(EquipmentNoticeSupplierDetailEntity::getDr, 0));
            List<EquipmentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (EquipmentNoticeSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                EquipmentNoticeSupplierDetailTbVO equipmentNoticeSupplierDetailTbVO = new EquipmentNoticeSupplierDetailTbVO();
                equipmentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                equipmentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo 暂时写死
                equipmentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(equipmentNoticeSupplierDetailTbVO);
            }
            equipmentNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        //调用第三方接口
//        CommonResponse<JSONObject> response = null;
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, JSON.toJSONString(equipmentNoticeSupplierTbVO),cacheManager);
//            if(!response.isSuccess()) {
//                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            return CommonResponse.error("调用平台报名接口失败");
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(equipmentNoticeSupplierTbVO), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }

        //招标公告发布成功后 改招标状态 为报名中
        inviteEntity.setTenderState(TenderStateEnum.报名中.getCode());
        inviteEntity.setStopTime(equipmentNoticeEntity.getNoticeEndTime());
        inviteService.saveOrUpdate(inviteEntity);
        return CommonResponse.success("公告信息推送成功");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<EquipmentNoticeEntity>().eq(EquipmentNoticeEntity::getInviteId,sourceId)).getId();
    }

    @Override
    public boolean selectFile(EquipmentNoticeVO vo) {
        List<EquipmentNoticeSupplierEntity> noticeSupplierEntityList = supplierService.list(new QueryWrapper<EquipmentNoticeSupplierEntity>().eq("notice_id", vo.getId()).eq("dr", 0));
        List<EquipmentNoticeSupplierVO> equipmentNoticeSupplierVOS = BeanMapper.mapList(noticeSupplierEntityList, EquipmentNoticeSupplierVO.class);
        //处理供应商附件信息
        if (CollectionUtils.isNotEmpty(equipmentNoticeSupplierVOS)){
            List<Long> attachIds = equipmentNoticeSupplierVOS.stream().map(EquipmentNoticeSupplierVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds",attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId),Function.identity());
                    Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                    for (EquipmentNoticeSupplierVO equipmentNoticeSupplierVO : equipmentNoticeSupplierVOS){
                        List<AttachmentVO> attachmentVOList = attacMap.get(equipmentNoticeSupplierVO.getId());
                        if (attachmentVOList!=null){
                            ArrayList<Map<String, Object>> list = new ArrayList<>();
                            for (AttachmentVO attachmentVO : attachmentVOList) {
                                HashMap<String, Object> hashMap = new HashMap<>();
                                hashMap.put("attachId",attachmentVO.getId());
                                hashMap.put("name",attachmentVO.getFileName());
                                list.add(hashMap);
                            }
                            equipmentNoticeSupplierVO.setFile(list);
                        }else {
                            equipmentNoticeSupplierVO.setAttachId(null);
                            equipmentNoticeSupplierVO.setFileName(null);
                        }
                    }
                }
            }
            vo.setNoticeSupplierDetail(equipmentNoticeSupplierVOS);
        }
        return true;
    }
}
