package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentWinnoticeMapper;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.*;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.service.IStuffPicketageSupplierService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.List;

/**
 * 中标公告表
 * 
 * @author generator
 * 
 */
@Service("equipmentWinnoticeService")
public class EquipmentWinnoticeServiceImpl extends BaseServiceImpl<EquipmentWinnoticeMapper, EquipmentWinnoticeEntity> implements IEquipmentWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    @Autowired
    private IEquipmentNoticeService equipmentNoticeService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentBidDetailService equipmentBidDetailService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentBidSupplierService equipmentBidSupplierService;
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IEquipmentPicketageSupplierService equipmentPicketageSupplierService;
    @Autowired
    private CacheManager cacheManager;
    @Value("${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Transactional
    @Override
    public EquipmentWinnoticeVO saveWinnotice(Long picketageId) {
        EquipmentWinnoticeEntity entity = new EquipmentWinnoticeEntity();
        entity.setPicketageId(picketageId);
        EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(picketageId);
        EquipmentInviteEntity inviteEntity = equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId());
        entity.setInviteId(equipmentPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName()+"中标公告");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());

        //采购方式(0-项目采购,1-单位采购)
        if (inviteEntity.getPurchaseType().equals(0)){
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)){
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }

        EquipmentDocumentEntity equipmentDocumentEntity = equipmentDocumentService.selectById(equipmentPicketageEntity.getDocumentId());
        entity.setEmployeeId(equipmentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setLineTypeName(CommonUtils.getTypeName(2));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate(entity, false);

        //回写定标数据
        equipmentPicketageEntity.setWinnoticeStatus(1);
        equipmentPicketageEntity.setWinnoticeId(entity.getId());
        equipmentPicketageService.updateById(equipmentPicketageEntity);

        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        equipmentInviteService.updateById(inviteEntity);
//回写定标子表数据
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
        for (EquipmentPicketageSupplierEntity equipmentPicketageSupplierEntity : picketageSupplierList){
            equipmentPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        equipmentPicketageSupplierService.updateBatchById(picketageSupplierList);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/winnotice");
        processService.saveOrUpdate(processEntity);
        EquipmentWinnoticeVO equipmentWinnoticeVO = BeanMapper.map(entity, EquipmentWinnoticeVO.class);
        return equipmentWinnoticeVO;
    }

    @Override
    public EquipmentWinnoticeVO queryDetail(Long id) {
        EquipmentWinnoticeEntity equipmentWinnoticeEntity = super.selectById(id);
        EquipmentWinnoticeVO equipmentWinnoticeVO = BeanMapper.map(equipmentWinnoticeEntity, EquipmentWinnoticeVO.class);
        EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(equipmentWinnoticeEntity.getPicketageId());
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
        List<EquipmentPicketageSupplierVO> equipmentPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, EquipmentPicketageSupplierVO.class);
        equipmentWinnoticeVO.setPicketageSupplierList(equipmentPicketageSupplierList);
        return equipmentWinnoticeVO;
    }

    @Override
    public EquipmentWinnoticeVO publishWinnotice(Long id) {
        
        //更新发布状态
        EquipmentWinnoticeEntity equipmentWinnoticeEntity = super.selectById(id);
        equipmentWinnoticeEntity.setPublishFlag(0);
        super.updateById(equipmentWinnoticeEntity);

        //回写定标数据
        EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(equipmentWinnoticeEntity.getPicketageId());
        equipmentPicketageEntity.setWinnoticeStatus(2);
        equipmentPicketageService.updateById(equipmentPicketageEntity);

        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId());

        //调用供方接口
        //调用第三方报名接口
        //推送供应商
        EquipmentWinVO winVO = new EquipmentWinVO();
        winVO.setSourceType("云南建投中标公告");
        winVO.setSourceId(Long.toString(equipmentWinnoticeEntity.getInviteId()));
        winVO.setBillCode(equipmentInviteEntity.getBillCode());
        //采购方式(0-项目采购,1-单位采购)
        if (equipmentInviteEntity.getPurchaseType() == 0){
            winVO.setSourceProjectId(Long.toString(equipmentInviteEntity.getProjectId()));
            winVO.setProjectName(equipmentInviteEntity.getProjectName());
            winVO.setProjectCode(equipmentInviteEntity.getProjectCode());
        }

        if (equipmentInviteEntity.getPurchaseType() == 1){
            winVO.setOrgName(equipmentInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(equipmentInviteEntity.getOrgId()));

        }
        winVO.setSourceUnitId(Long.toString(equipmentInviteEntity.getUnitId()));
        winVO.setUnitName(equipmentInviteEntity.getUnitName());
        winVO.setType("PURCHASE");
        winVO.setTenderName(equipmentInviteEntity.getTenderName());
        winVO.setTenderType(equipmentInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(equipmentWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(equipmentWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(equipmentWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(equipmentInviteEntity.getPurchaseType());
        winVO.setWinDate(equipmentWinnoticeEntity.getWinDate());
        winVO.setStopDate(equipmentWinnoticeEntity.getStopDate());
        winVO.setWinTitle(equipmentWinnoticeEntity.getTitleName());
        winVO.setMemo(equipmentWinnoticeEntity.getMemo());
        winVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        //明细设置
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
        ArrayList<EquipmentWinDetailVO> winDetailVOS = new ArrayList<>();
        for (EquipmentPicketageSupplierEntity equipmentPicketageSupplierEntity : picketageSupplierList){
            EquipmentWinDetailVO winDetailVO = new EquipmentWinDetailVO();
            winDetailVO.setWinId(equipmentWinnoticeEntity.getId());
            winDetailVO.setSupplierName(equipmentPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(equipmentPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = shareSupplierApi.queryById(equipmentPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(equipmentPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString(winVO);
        logger.info("中标公告发布" + stringFb);
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winSaveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标公告同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public EquipmentWinnoticeVO saveOrUpdates(EquipmentWinnoticeEntity entity) {
        super.saveOrUpdate(entity,false);
        return queryDetail(entity.getId());
    }
}
