package com.ejianc.business.tender.expert.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSchemeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentTalkEntity;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.business.tender.expert.bean.*;
import com.ejianc.business.tender.expert.service.*;
import com.ejianc.business.tender.expert.vo.*;
import com.ejianc.business.tender.other.bean.OtherDocumentSchemeEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherTalkEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentSchemeService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.rent.bean.RentDocumentSchemeEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentTalkEntity;
import com.ejianc.business.tender.rent.service.IRentDocumentSchemeService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentTalkService;
import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSchemeEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatTalkEntity;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSchemeService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatTalkService;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 材料专家评标主表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("stuffEvaluation")
public class ExpertEvaluatingController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "EXPERT_EVALUATION";//此处需要根据实际修改

    @Autowired
    private IExpertEvaluatingService service;
    @Autowired
    private IExpertRepetitionService expertRepetitionService;
    @Autowired
    private IExpertEvaluatingDetailService detailService;
    @Autowired
    private IExpertEvaluatingDetailService evaluatingDetailService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IExpertRecordService expertRecordService;
    @Autowired
    private IExpertRecordScoreService expertRecordScoreService;
    @Autowired
    private IExpertRecordHistoryService expertRecordHistoryService;
    @Autowired
    private IExpertRecordScoreHistoryService expertRecordScoreHistoryService;
    @Autowired
    private IExpertRecordTotalService totalService;
    @Autowired
    private IStuffTalkService stuffTalkService;
    @Autowired
    private ISubTalkService subTalkService;
    @Autowired
    private IEquipmentTalkService equipmentTalkService;
    @Autowired
    private IRentTalkService rentTalkService;
    @Autowired
    private IRmatTalkService rmatTalkService;
    @Autowired
    private IOtherTalkService otherTalkService;
    @Autowired
    private SessionManager sessionManager;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IStuffInviteService stuffInviteService;

    @Autowired
    private ISubInviteService subInviteService;

    @Autowired
    private IEquipmentInviteService equipmentInviteService;

    @Autowired
    private IRentInviteService rentInviteService;

    @Autowired
    private IRmatInviteService rmatInviteService;

    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IStuffDocumentSchemeService stuffDocumentSchemeService;
    @Autowired
    private ISubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;



    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpertEvaluatingVO> saveOrUpdate(@RequestBody ExpertEvaluatingVO saveorUpdateVO) {
        ExpertEvaluatingEntity entity = BeanMapper.map(saveorUpdateVO, ExpertEvaluatingEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertEvaluatingVO> queryDetail(Long id) {
        ExpertEvaluatingEntity entity = service.selectById(id);
        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);

        if (entity.getInviteType()==4){
            RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(entity.getInviteId());
            vo.setRentalType(rmatInviteEntity.getRentalType());
            vo.setBackType(rmatInviteEntity.getBackType());
            vo.setRentalStacking(rmatInviteEntity.getRentalStacking());
            vo.setBackStacking(rmatInviteEntity.getBackStacking());
        }

        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param documentId
     * @Description queryDetail 招标文件一步接口
     */
    @RequestMapping(value = "/saveEvaluation", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertEvaluatingVO> saveEvaluation(@RequestParam Long documentId) {
        ExpertEvaluatingVO vo = service.saveEvaluation(documentId);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @param inviteId
     * @Description stateCheckout 校验接口
     */
    @RequestMapping(value = "/stateCheckout", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> stateCheckout(@RequestParam Long inviteId) {
        service.stateCheckout(inviteId);
        return CommonResponse.success("修改成功！");
    }
    /**
     * @Description queryExpertDetail 查询评标结果列表
     * @param inviteId
     */
    @RequestMapping(value = "/queryScoreDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ExpertEvaluatingDetailScoreVO>> queryScoreDetail(@RequestParam Long inviteId ,Long evaluationId) {
        List<ExpertEvaluatingDetailScoreVO> vo = service.queryScoreDetail(inviteId, evaluationId);
        if(CollectionUtils.isNotEmpty(vo)){
            return CommonResponse.success("查询评标结果成功！",vo);
        }
        return CommonResponse.success("暂时无人评标！",vo);
    }
    /**
     * @Description queryExpertDetail 查询评标结果列表详情
     * @param
     */
    @RequestMapping(value = "/queryExpertDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryExpertDetail(@RequestBody ExpertEvaluatingDetailScoreVO vo) {
        Map<String, Object> map = service.queryExpertDetail(vo);
        return CommonResponse.success("查询成功！",map);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertEvaluatingVO> vos) {
        service.removeByIds(vos.stream().map(ExpertEvaluatingVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ExpertEvaluatingEntity> page = service.queryPage(param,false);
        IPage<ExpertEvaluatingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertEvaluatingVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExpertEvaluatingEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StuffEvaluation-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param pageNumber
     * @Return void
     */
    @RequestMapping(value = "/refStuffEvaluationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> refStuffEvaluationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                            String condition,
                                                                            String searchObject,
                                                                            String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExpertEvaluatingEntity> page = service.queryPage(param,false);
        IPage<ExpertEvaluatingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertEvaluatingVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description 待审批
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryPendingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryPendingList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Page<ExpertEvaluatingVO> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        Integer evaluationState = 0;
        Integer evaluationState1 = 3;
        //查询待审批专家评标列表
        List<ExpertEvaluatingVO> pageData = service.queryPendingList(page,param.getSearchText(),evaluationState,evaluationState1,param.getParams().get("employeeId").getValue().toString());
        pageData.forEach(expertEvaluatingVO -> expertEvaluatingVO.setType(CommonUtils.getTypeName(expertEvaluatingVO.getInviteType())));
        page.setRecords(pageData);
        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * @Description 已审批
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryApprovedList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryApprovedList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Page<ExpertEvaluatingVO> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        Integer evaluationState = 1;
        Integer evaluationState1 = null;
        //查询已审批专家评标列表
        List<ExpertEvaluatingVO> pageData = service.queryPendingList(page,param.getSearchText(),evaluationState,evaluationState1,param.getParams().get("employeeId").getValue().toString());
        pageData.forEach(expertEvaluatingVO -> expertEvaluatingVO.setType(CommonUtils.getTypeName(expertEvaluatingVO.getInviteType())));
        page.setRecords(pageData);
        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * @Description 已失效
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryExpiredList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryExpiredList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Page<ExpertEvaluatingVO> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        Integer evaluationState = 2;
        Integer evaluationState1 = null;
        //查询已失效专家评标列表
        List<ExpertEvaluatingVO> pageData = service.queryPendingList(page,param.getSearchText(),evaluationState,evaluationState1,param.getParams().get("employeeId").getValue().toString());
        pageData.forEach(expertEvaluatingVO -> expertEvaluatingVO.setType(CommonUtils.getTypeName(expertEvaluatingVO.getInviteType())));
        page.setRecords(pageData);
        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * @Description 专家评标汇总列表
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryGatherList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryGatherList(@RequestBody QueryParam param) {
//        /** 模糊搜索配置字段示例 */
//        List<String> fuzzyFields = param.getFuzzyFields();
//        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//
//        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Page<ExpertEvaluatingVO> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        //查询待汇总列表
        List<ExpertEvaluatingVO> pageData = service.queryGatherList(page,param.getSearchText(), (Integer) param.getParams().get("gatherStatus").getValue(),sessionManager.getUserContext().getEmployeeId());
        for (ExpertEvaluatingVO evaluatingVO : pageData) {
            Integer bidNum = 0;
            List<ExpertEvaluatingDetailEntity> detailList = detailService.list(new QueryWrapper<ExpertEvaluatingDetailEntity>().eq("evaluation_id", evaluatingVO.getId()));
            for (ExpertEvaluatingDetailEntity detailEntity : detailList) {
                if (detailEntity.getEvaluationState()==1){
                    bidNum++;
                }
            }
            evaluatingVO.setBidNum(bidNum+"/"+detailList.size());
            evaluatingVO.setType(CommonUtils.getTypeName(evaluatingVO.getInviteType()));
        }
        page.setRecords(pageData);
        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * @Description 汇总驳回接口
     * @param
     * @Return
     */
    @RequestMapping(value = "/reject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse reject(@RequestBody ExpertEvaluatingDetailVO detailVO) {

        Long expertId = detailVO.getExpertId();
        Long evaluationId = detailVO.getEvaluationId();

        //查询评分主表
        List<ExpertRecordEntity> recordList = expertRecordService.list(new QueryWrapper<ExpertRecordEntity>().eq("evaluation_id", evaluationId).eq("employee_id", expertId));
        ExpertRecordTotalEntity totalEntity = BeanMapper.map(recordList.get(0), ExpertRecordTotalEntity.class);
        totalEntity.setRejectTime(new DateTime());
        totalEntity.setRejectReason(detailVO.getRejectReason());
        totalEntity.setEvaluationTime(detailVO.getEvaluationTime());
        totalService.saveOrUpdate(totalEntity);

        List<ExpertRepetitionEntity> repetitionEntityList = expertRepetitionService.list(new QueryWrapper<ExpertRepetitionEntity>().eq("invite_id", recordList.get(0).getInviteId()).eq("bid_flag", 0).orderByDesc("talk_num"));
        if (repetitionEntityList.size()>0){
            throw new BusinessException("已开启二次报价");
        }

        for (ExpertRecordEntity recordEntity : recordList) {
            //查询子表保存到历史字表
            List<ExpertRecordScoreEntity> recordScoreList = expertRecordScoreService.list(new QueryWrapper<ExpertRecordScoreEntity>().eq("record_id", recordEntity.getId()));
            List<ExpertRecordScoreHistoryEntity> recordScoreHistoryList = BeanMapper.mapList(recordScoreList, ExpertRecordScoreHistoryEntity.class);
            for (ExpertRecordScoreHistoryEntity scoreHistoryEntity : recordScoreHistoryList) {
                expertRecordScoreHistoryService.saveOrUpdate(scoreHistoryEntity);
                expertRecordScoreService.removeById(scoreHistoryEntity.getId());
            }
        }
        List<ExpertRecordHistoryEntity> expertRecordHistoryList = BeanMapper.mapList(recordList, ExpertRecordHistoryEntity.class);
        for (ExpertRecordHistoryEntity expertRecordHistoryEntity : expertRecordHistoryList) {
            expertRecordHistoryEntity.setTotalId(totalEntity.getId());
            expertRecordHistoryService.saveOrUpdate(expertRecordHistoryEntity);
            expertRecordService.removeById(expertRecordHistoryEntity.getId());
        }
        //更新评标状态
        detailService.update(new UpdateWrapper<ExpertEvaluatingDetailEntity>().set("evaluation_state",3).eq("expert_id",expertId).eq("evaluation_id",evaluationId));
        // 驳回给专家发消息
        // 查询主表信息
        ExpertEvaluatingEntity expertEvaluating = service.selectById(evaluationId);
        List<ExpertEvaluatingDetailEntity> evaluationList = expertEvaluating.getStuffEvaluationDetailEntities();
        String leaderName = "";
        if(CollectionUtils.isNotEmpty(evaluationList)){
            leaderName = evaluationList.stream().filter(t -> t.getLeader() == 0).map(ExpertEvaluatingDetailEntity::getExpertName).collect(Collectors.joining());
        }
        List<String> messageType = new ArrayList<>();
        //系统消息
        messageType.add("sys");
        messageType.add("dingding");
        //微信消息
        //messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(expertId+ "");
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        String formUrl = frontendBaseHost+"ejc-tender-frontend/#/bidRecordList";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String name = expertEvaluating.getPurchaseType()==0?expertEvaluating.getProjectName():expertEvaluating.getOrgName();
        logger.info("发送信息给专家:>----------" + sender);
//					String subject = entity.getExpertName() + "专家您好，" +name+ "已于"+sdf.format(expertEvaluating.getStartTime())+"开始评标,请尽快评标!";
//					String content = entity.getExpertName() + "专家您好，" +name+ "已于"+sdf.format(expertEvaluating.getStartTime())+"开始评标!"+"<a href=" + '"' + formUrl + '"' + ">请尽快评标</a>";
        String subject = "您对" +name+ "的评标结果被本次评标组长[" + leaderName + "]驳回，请尽快重新评标，避免没有完成本次评标任务。";
        String content = "您对" +name+ "的评标结果被本次评标组长[" + leaderName + "]驳回，请尽快重新评标，避免没有完成本次评标任务。"
                +"<a href=" + '"' + formUrl + '"' + ">请尽快评标</a>";
        logger.info("发送信息的内容:>----------"+content);
//					new SendMsgUtils().sendSysMsg(sender,subject,content,pushMessageApi);
        new SendMsgUtils().sendMsgByMsgType(messageType,sender,subject,content,pushMessageApi);
        return CommonResponse.success("驳回成功！");
    }

    /**
     * @Description 汇总查看详情接口
     * @param
     * @Return
     */
    @RequestMapping(value = "/rejectDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> rejectDetail(Long id) {
        ExpertEvaluatingDetailEntity detailVO = evaluatingDetailService.selectById(id);
        Long expertId = detailVO.getExpertId();
        Long evaluationId = detailVO.getEvaluationId();
        //返回专家信息
        Map<String, Object> data = new HashMap();
        data.put("expertDetail",detailVO);
        ExpertEvaluatingDetailVO expertEvaluatingDetailVO = BeanMapper.map(detailVO, ExpertEvaluatingDetailVO.class);
        data.put("expertEvaluatingDetailVO", expertEvaluatingDetailVO);
        //返回历史记录
        List<ExpertRecordTotalEntity> historyList = totalService.list(new QueryWrapper<ExpertRecordTotalEntity>().eq("employee_id", expertId).eq("evaluation_id",evaluationId ));
        data.put("historyList",historyList);
        //判断评标状态
        if (detailVO.getEvaluationState()==1){
            List<List<ExpertRecordVO>> lists = expertRecordService.queryDetail(evaluationId, expertId);
            data.put("supplierDetail", lists);
        }else {
            List<List<ExpertRecordHistoryVO>> lists = new ArrayList<>();
            if(historyList.size()>0){
                lists = expertRecordHistoryService.queryDetail(historyList.get(historyList.size()-1).getId(), evaluationId, expertId);
            }
            data.put("supplierDetail",lists);
        }
        return CommonResponse.success("查询成功！",data);
    }

    /**
     * @Description 评标汇总接口
     * @param
     * @Return
     */
    @RequestMapping(value = "/collect", method = RequestMethod.POST )
    @ResponseBody
    public CommonResponse collect(@RequestBody CollectVO collectVO) {
        service.collect(collectVO);
        return CommonResponse.success("评标汇总成功！");
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryCollectDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertEvaluatingVO> queryCollectDetail(Long id) {
        ExpertEvaluatingEntity entity = service.selectById(id);
        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        Integer bidNum = 0;
        for (ExpertEvaluatingDetailVO detailEntity : vo.getStuffEvaluationDetailEntities()) {
            if (detailEntity.getEvaluationState()==1){
                bidNum++;
            }
        }
        vo.setBidNum(bidNum+"/"+vo.getStuffEvaluationDetailEntities().size());
        Integer num = 0;

        //赋值评标汇总和二次评标按钮状态
        //状态,0-专家未评分完成,1-有二次评标未完成,2-正常
        if (bidNum < vo.getStuffEvaluationDetailEntities().size()){
            vo.setEvaStatus(0);
        }else if (bidNum == vo.getStuffEvaluationDetailEntities().size()){
            //是否有二次评标未生效的数据
            LambdaQueryWrapper<ExpertRepetitionEntity> lambdaRepetition = Wrappers.<ExpertRepetitionEntity>lambdaQuery();
            lambdaRepetition.eq(ExpertRepetitionEntity::getEvaluatingId, entity.getId());
            lambdaRepetition.eq(ExpertRepetitionEntity::getBidFlag, 0);
            ExpertRepetitionEntity expertRepetitionServiceOne = expertRepetitionService.getOne(lambdaRepetition);
            if (expertRepetitionServiceOne != null){
                vo.setEvaStatus(1);
            }else{
                vo.setEvaStatus(2);
            }
        }

        //查询轮数
        LambdaQueryWrapper<ExpertRepetitionEntity> lambdaRepetition2 = Wrappers.<ExpertRepetitionEntity>lambdaQuery();
        lambdaRepetition2.eq(ExpertRepetitionEntity::getInviteId, entity.getInviteId());
        lambdaRepetition2.eq(ExpertRepetitionEntity::getBidFlag, 1);
        lambdaRepetition2.orderByAsc(ExpertRepetitionEntity::getTalkNum);
        List<ExpertRepetitionEntity> expertRepetitionEntityList2 = expertRepetitionService.list(lambdaRepetition2);
        if(CollectionUtils.isNotEmpty(expertRepetitionEntityList2)){
            vo.setTalkNum(expertRepetitionEntityList2.get(0).getTalkNum());
        }else{
            vo.setTalkNum(0);
        }

        //查询报价历史
        LambdaQueryWrapper<ExpertRepetitionEntity> lambdaRepetition = Wrappers.<ExpertRepetitionEntity>lambdaQuery();
        lambdaRepetition.eq(ExpertRepetitionEntity::getInviteId, entity.getInviteId());
        lambdaRepetition.eq(ExpertRepetitionEntity::getBidFlag, 1);
        List<ExpertRepetitionEntity> expertRepetitionEntityList = expertRepetitionService.list(lambdaRepetition);
        List<ExpertRepetitionVO> expertRepetitionVOS = null;
        if (CollectionUtils.isNotEmpty(expertRepetitionEntityList)){
            expertRepetitionVOS = BeanMapper.mapList(expertRepetitionEntityList, ExpertRepetitionVO.class);
        }
        vo.setRepetitionVOList(expertRepetitionVOS);

        List<ExpertRepetitionEntity> repetitionEntityList = expertRepetitionService.list(new QueryWrapper<ExpertRepetitionEntity>().eq("invite_id", entity.getInviteId()).eq("publish_flag", 1).orderByDesc("talk_num"));
        if (repetitionEntityList.size()>0){
            num = repetitionEntityList.get(0).getTalkNum();
        }
        //TODO 招标修改
        if (entity.getInviteType()==0){
            List<StuffTalkEntity> talkEntityList = stuffTalkService.list(new QueryWrapper<StuffTalkEntity>().eq("invite_id", entity.getInviteId()).orderByDesc("talk_num"));
            if (talkEntityList.size()>0){
                num = talkEntityList.get(0).getTalkNum();
            }
//            //获取最新轮数
//            StuffDocumentSchemeEntity stuffDocumentSchemeEntity = stuffDocumentSchemeService.list(new QueryWrapper<StuffDocumentSchemeEntity>().eq("document_id", vo.getDocumentId()).orderByDesc("talk_num")).get(0);
//            num = stuffDocumentSchemeEntity.getTalkNum();

            StuffDocumentVO stuffDocumentVO = stuffDocumentService.queryDetail1(vo.getDocumentId(),num);
            vo.setScoreResult(service.queryScoreDetail(entity.getInviteId(),entity.getId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getStuffDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getStuffDocumentSupplierSchemeList());
            //赋值招标金额
            StuffInviteEntity inviteEntity = stuffInviteService.selectById(vo.getInviteId());
            vo.setTenderMoney(inviteEntity.getTenderMoney());
            vo.setTenderType(inviteEntity.getTenderType());
        }else if(entity.getInviteType()==1){
            List<SubTalkEntity> talkEntityList = subTalkService.list(new QueryWrapper<SubTalkEntity>().eq("invite_id", entity.getInviteId()).orderByDesc("talk_num"));
            if (talkEntityList.size()>0){
                num = talkEntityList.get(0).getTalkNum();
            }
            //获取最新轮数
//            SubDocumentSchemeEntity stuffDocumentSchemeEntity = subDocumentSchemeService.list(new QueryWrapper<SubDocumentSchemeEntity>().eq("document_id", vo.getDocumentId()).orderByDesc("talk_num")).get(0);
//            num = stuffDocumentSchemeEntity.getTalkNum();


            SubDocumentVO stuffDocumentVO = subDocumentService.queryDetail1(vo.getDocumentId(),num);
            vo.setScoreResult(service.queryScoreDetail(entity.getInviteId(),entity.getId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getSubDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getSubDocumentSupplierSchemeList());
            //赋值招标金额
            SubInviteEntity subInviteEntity = subInviteService.selectById(vo.getInviteId());
            vo.setTenderMoney(subInviteEntity.getTenderMoney());
            vo.setTenderType(subInviteEntity.getTenderType());
        }else if (entity.getInviteType()==2){
            List<EquipmentTalkEntity> talkEntityList = equipmentTalkService.list(new QueryWrapper<EquipmentTalkEntity>().eq("invite_id", entity.getInviteId()).orderByDesc("talk_num"));
            if (talkEntityList.size()>0){
                num = talkEntityList.get(0).getTalkNum();
            }

            //获取最新轮数
//            EquipmentDocumentSchemeEntity stuffDocumentSchemeEntity = equipmentDocumentSchemeService.list(new QueryWrapper<EquipmentDocumentSchemeEntity>().eq("document_id", vo.getDocumentId()).orderByDesc("talk_num")).get(0);
//            num= stuffDocumentSchemeEntity.getTalkNum();

            EquipmentDocumentVO stuffDocumentVO = equipmentDocumentService.queryDetail1(vo.getDocumentId(),num);
            vo.setScoreResult(service.queryScoreDetail(entity.getInviteId(),entity.getId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getEquipmentDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getEquipmentDocumentSupplierSchemeList());
            //赋值招标金额
            EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(vo.getInviteId());
            vo.setTenderMoney(equipmentInviteEntity.getTenderMoney());
            vo.setTenderType(equipmentInviteEntity.getTenderType());
        }else if (entity.getInviteType()==3){
            List<RentTalkEntity> talkEntityList = rentTalkService.list(new QueryWrapper<RentTalkEntity>().eq("invite_id", entity.getInviteId()).orderByDesc("talk_num"));
            if (talkEntityList.size()>0){
                num = talkEntityList.get(0).getTalkNum();
            }

            //获取最新轮数
//            RentDocumentSchemeEntity stuffDocumentSchemeEntity = rentDocumentSchemeService.list(new QueryWrapper<RentDocumentSchemeEntity>().eq("document_id", vo.getDocumentId()).orderByDesc("talk_num")).get(0);
//            num= stuffDocumentSchemeEntity.getTalkNum();
            RentDocumentVO stuffDocumentVO = rentDocumentService.queryDetail1(vo.getDocumentId(),num);
            vo.setScoreResult(service.queryScoreDetail(entity.getInviteId(),entity.getId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getRentDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getRentDocumentSupplierSchemeList());
            //赋值招标金额
            RentInviteEntity rentInviteEntity = rentInviteService.selectById(vo.getInviteId());
            vo.setTenderMoney(rentInviteEntity.getTenderMoney());
            vo.setTenderType(rentInviteEntity.getTenderType());
            vo.setRentType(rentInviteEntity.getRentType());
        }else if (entity.getInviteType()==4){
            List<RmatTalkEntity> talkEntityList = rmatTalkService.list(new QueryWrapper<RmatTalkEntity>().eq("invite_id", entity.getInviteId()).orderByDesc("talk_num"));
            if (talkEntityList.size()>0){
                num = talkEntityList.get(0).getTalkNum();
            }

            //获取最新轮数
//            RmatDocumentSchemeEntity stuffDocumentSchemeEntity = rmatDocumentSchemeService.list(new QueryWrapper<RmatDocumentSchemeEntity>().eq("document_id", vo.getDocumentId()).orderByDesc("talk_num")).get(0);
//            num = stuffDocumentSchemeEntity.getTalkNum();
            RmatDocumentVO stuffDocumentVO = rmatDocumentService.queryDetail1(vo.getDocumentId(),num);
            vo.setScoreResult(service.queryScoreDetail(entity.getInviteId(),entity.getId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getRmatDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getRmatDocumentSupplierSchemeList());
            //赋值招标金额
            RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(vo.getInviteId());
            vo.setTenderMoney(rmatInviteEntity.getTenderMoney());
            vo.setTenderType(rmatInviteEntity.getTenderType());
            vo.setRentType(rmatInviteEntity.getRentType());
            vo.setRentalType(rmatInviteEntity.getRentalType());
            vo.setBackType(rmatInviteEntity.getBackType());
            vo.setRentalStacking(rmatInviteEntity.getRentalStacking());
            vo.setBackStacking(rmatInviteEntity.getBackStacking());
        }else if (entity.getInviteType()==5){
            List<OtherTalkEntity> talkEntityList = otherTalkService.list(new QueryWrapper<OtherTalkEntity>().eq("invite_id", entity.getInviteId()).orderByDesc("talk_num"));
            if (talkEntityList.size()>0){
                num = talkEntityList.get(0).getTalkNum();
            }

            //获取最新轮数
//            OtherDocumentSchemeEntity stuffDocumentSchemeEntity = otherDocumentSchemeService.list(new QueryWrapper<OtherDocumentSchemeEntity>().eq("document_id", vo.getDocumentId()).orderByDesc("talk_num")).get(0);
//            num = stuffDocumentSchemeEntity.getTalkNum();
            OtherDocumentVO stuffDocumentVO = otherDocumentService.queryDetail1(vo.getDocumentId(),num);
            vo.setScoreResult(service.queryScoreDetail(entity.getInviteId(),entity.getId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getOtherDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getOtherDocumentSupplierSchemeList());
            //赋值招标金额
            OtherInviteEntity otherInviteEntity = otherInviteService.selectById(vo.getInviteId());
            vo.setTenderMoney(otherInviteEntity.getTenderMoney());
            vo.setTenderType(otherInviteEntity.getTenderType());
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description queryList 查询评标进度报表列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryProgressSheet", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProgressSheetVO>> queryProgressSheet(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("expertName");
        fuzzyFields.add("mobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fieldName");
        fuzzyFields.add("typeName");
        fuzzyFields.add("gradeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time_c", QueryParam.DESC);
        param.setOrderMap(orderMap);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("unitId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Page<ProgressSheetVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ProgressSheetVO> list = service.queryProgressSheet(wrapper,page);
        IPage<ProgressSheetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description 评标进度报表导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExportSheet", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSheet(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("expertName");
        fuzzyFields.add("mobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fieldName");
        fuzzyFields.add("typeName");
        fuzzyFields.add("gradeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Page<ProgressSheetVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("unitId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time_c", QueryParam.DESC);
        param.setOrderMap(orderMap);
        List<ProgressSheetVO> list = service.queryProgressSheet(wrapper,page);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sheet-expert.xlsx", beans, response);
    }
}
