package com.ejianc.business.tender.expert.service;

import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSchemeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSupplierEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordScoreEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.vo.ExpertRecordScoreVO;
import com.ejianc.business.tender.other.bean.OtherDocumentSchemeEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSchemeEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSchemeEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.expert.vo.ExpertRecordVO;
import com.ejianc.business.tender.expert.bean.TemplateDetailEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSchemeEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * 评标记录表
 * 
 * @author generator
 * 
 */
public interface IExpertRecordService extends IBaseService<ExpertRecordEntity> {


    List<StuffDocumentSupplierEntity> selectSupplierList(Long documentId, Integer talkNum);

    List<StuffDocumentSchemeEntity> selectSchemeList(Long id, Long supplierId);

    List<TemplateDetailEntity> selectTemplateList(Long templateId);

    Integer selectExist(Long employeeId,Long documentId);

    List<ExpertRecordVO> selectDetail();

    List<ExpertRecordScoreEntity> selectScore(Long id);

    ExpertEvaluatingEntity selectEvaluation(Long id);

    List<ExpertRecordVO> selectBySupplier(Long employeeId, Long documentId);

    List<List<ExpertRecordVO>> saveOrUpdateList(List<List<Map>> supplierDetail);

    Map<String, Object> querySupplierList(Long documentId, Long templateId, Long id) throws InvocationTargetException, IllegalAccessException;

    List<TemplateDetailEntity> selectTemplateDetail(Long parentId);

    List<ExpertRecordScoreVO> selectByParentId(Long scoringTemplateDetailParentId,Long recordId);

    List<List<ExpertRecordVO>> queryDetail(Long evaluationId, Long expertId);

    List<SubDocumentSupplierEntity> selectSubSupplierList(Long documentId, Integer talkNum);

    List<SubDocumentSchemeEntity> selectSubSchemeList(Long id,Long supplierId);

    List<EquipmentDocumentSupplierEntity> selectEquipmentSupplierList(Long documentId, Integer talkNum);

    List<EquipmentDocumentSchemeEntity> selectEquipmentSchemeList(Long id,Long supplierId);

    List<RentDocumentSupplierEntity> selectRentSupplierList(Long documentId, Integer talkNum);

    List<RentDocumentSchemeEntity> selectRentSchemeList(Long id,Long supplierId);

    List<RmatDocumentSchemeEntity> selectRmatSchemeList(Long id,Long supplierId);

    List<RmatDocumentSupplierEntity> selectRmatSupplierList(Long documentId, Integer talkNum);

    List<OtherDocumentSchemeEntity> selectOtherSchemeList(Long id,Long supplierId);

    List<OtherDocumentSupplierEntity> selectOtherSupplierList(Long documentId, Integer talkNum);
}
