package com.ejianc.business.tender.expert.service.impl;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderDetailVO;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentTalkMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSchemeService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSellService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.expert.bean.*;
import com.ejianc.business.tender.expert.service.*;
import com.ejianc.business.tender.expert.vo.*;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherTalkMapper;
import com.ejianc.business.tender.other.service.IOtherDocumentSchemeService;
import com.ejianc.business.tender.other.service.IOtherDocumentSellService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.mapper.RentTalkMapper;
import com.ejianc.business.tender.rent.service.IRentDocumentSchemeService;
import com.ejianc.business.tender.rent.service.IRentDocumentSellService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.mapper.RmatTalkMapper;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSchemeService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSellService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.mapper.StuffTalkMapper;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSchemeService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSellService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubTalkMapper;
import com.ejianc.business.tender.sub.service.ISubDocumentSchemeService;
import com.ejianc.business.tender.sub.service.ISubDocumentSellService;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.expert.mapper.ExpertEvaluatingMapper;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料专家评标主表
 *
 * @author generator
 */
@Service("expertEvaluatingService")
public class ExpertEvaluatingServiceImpl extends BaseServiceImpl<ExpertEvaluatingMapper, ExpertEvaluatingEntity> implements IExpertEvaluatingService {
    @Autowired
    private IExpertRecordService expertRecordService;
    @Autowired
    private IExpertRecordScoreService expertRecordScoreService;
    @Autowired
    private IExpertEvaluatingDetailService IExpertEvaluatingDetailService;
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "EXPERT_EVALUATION";//此处需要根据实际修改
    @Autowired
    private IExpertEvaluatingService service;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private ITemplateDetailService templateDetailService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private StuffTalkMapper stuffTalkMapper;
    @Autowired
    private SubTalkMapper subTalkMapper;
    @Autowired
    private EquipmentTalkMapper equipmentTalkMapper;
    @Autowired
    private RentTalkMapper rentTalkMapper;
    @Autowired
    private RmatTalkMapper rmatTalkMapper;
    @Autowired
    private OtherTalkMapper otherTalkMapper;
    @Autowired
    private IExpertService expertService;
    @Autowired
    private IStuffDocumentSellService documentSellService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IStuffDocumentSchemeService documentSchemeService;
    @Autowired
    private ISubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;
    @Autowired
    private IEvaluationDetailService evaluationDetailService;
    @Autowired
    private IExpertRecordService recordService;
    @Autowired
    private IExpertEvaluatingDetailService detailService;


    @Override
    public List<ExpertEvaluatingVO> queryPendingList(Page<ExpertEvaluatingVO> page, String searchText, Integer evaluationState, Integer evaluationState1, String employeeId) {
        return baseMapper.queryPendingList(page, searchText, evaluationState, evaluationState1, employeeId);
    }

    @Override
    public Boolean updateState(Integer evaluationState, Long id, Long employeeId, DateTime evaluationTime) {
        return baseMapper.updateState(evaluationState, id, employeeId, evaluationTime);
    }

    //查询供应商方案接口
    @Override
    public List<ExpertEvaluatingDetailScoreVO> queryScoreDetail(Long inviteId, Long evaluationId) {
        ExpertEvaluatingEntity expertEvaluating = service.selectById(evaluationId);
        if (null == expertEvaluating) {
            return null;
        }
        int size = expertEvaluating.getStuffEvaluationDetailEntities().size();
        List<ExpertEvaluatingDetailScoreVO> listVO = new ArrayList<>();
        //评分记录主表
        LambdaQueryWrapper<ExpertRecordEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertRecordEntity::getInviteId, inviteId);
        lambda.in(ExpertRecordEntity::getEvaluationId, evaluationId);
        lambda.eq(ExpertRecordEntity::getFlag, 1);
        List<ExpertRecordEntity> list = expertRecordService.list(lambda);
        if (CollectionUtils.isNotEmpty(list)) {
            BigDecimal bigDecimal = new BigDecimal(0);
            list.forEach(v -> {
                ExpertEvaluatingDetailScoreVO reslutVO = BeanMapper.map(v, ExpertEvaluatingDetailScoreVO.class);
                if (v.getSumScore() == null) {//总分判空
                    v.setSumScore(bigDecimal);
                }
                reslutVO.setAvgScore(v.getSumScore());
                reslutVO.setGrossScore(v.getSumScore());
                if (v.getMoneyTax() == null) {//总额判空
                    v.setMoneyTax(bigDecimal);
                }
                if (v.getMoney() == null) {
                    v.setMoneyTax(bigDecimal);
                }
                reslutVO.setSchemeNameMoney(v.getSchemeName() + "(含税:" + v.getMoneyTax().setScale(2, BigDecimal.ROUND_HALF_UP) + "元;无税:" + v.getMoney().setScale(2, BigDecimal.ROUND_HALF_UP) + "元)");
                //当只有一个方案被一个专家评分后不会进入下面去重，所以需要在这里处理
                reslutVO.setExpertNum(1 + "/" + size);
                if (reslutVO.getPassFlag() == null) {
                    reslutVO.setPassFlag(1);
                }
                switch (reslutVO.getPassFlag()) {
                    case 1:
                        reslutVO.setPassNum(1 + "/" + 1);
                        break;
                    case 2:
                        reslutVO.setPassNum(0 + "/" + 1);
                        break;
                }
                if (reslutVO.getCollectPassFlag() == null) {
                    reslutVO.setCollectPassFlag(1);
                }
                listVO.add(reslutVO);
            });
//                上面查询的是一个专家对一个方案的总分，这里将其去重得到每个方案的总分和平均分
            for (int i = 0; i < listVO.size() - 1; i++) {
                int avg = 1;
                int pass = 0;
                if (listVO.get(i).getPassFlag().equals(1)) {//主方案是否通过
                    pass += 1;
                }
                for (int j = listVO.size() - 1; j > i; j--) {
                    //相同条件，相同供应商的相同方案
                    if (listVO.get(j).getSupplierId().equals(listVO.get(i).getSupplierId()) && listVO.get(j).getDocumentSchemeId().equals(listVO.get(i).getDocumentSchemeId())) {
                        //此方案被评标的专家个数
                        ++avg;
                        listVO.get(i).setGrossScore(listVO.get(i).getGrossScore().add(listVO.get(j).getGrossScore()));
                        listVO.get(i).setAvgScore(new BigDecimal(listVO.get(i).getGrossScore().doubleValue() / avg));
                        listVO.get(i).setExpertNum(avg + "/" + size);
                        //此方案是否通过计算
                        if (listVO.get(j).getPassFlag().equals(1)) {//重复是否通过
                            pass++;
                        }
                        listVO.get(i).setPassNum(pass + "/" + avg);
                        //删除重复的，留下最终的方案评分
                        listVO.remove(j);
                    }
                }
            }
            if (expertEvaluating.getDistinctionFlag().equals(0)) {//是否区分商务/技术
                return service.getAvgScore(listVO);
            }
            else {
                return listVO;
            }
        }
        return listVO;
    }

    //专家失效接口
    @Override
    public void stateCheckout(Long inviteId) {
        LambdaQueryWrapper<ExpertEvaluatingEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertEvaluatingEntity::getInviteId, inviteId);
        List<ExpertEvaluatingEntity> list = service.list(lambda);
        if (CollectionUtils.isNotEmpty(list)) {
            LambdaQueryWrapper<ExpertEvaluatingDetailEntity> lambda2 = Wrappers.lambdaQuery();
            lambda2.eq(ExpertEvaluatingDetailEntity::getEvaluationId, list.get(0).getId());
            lambda2.in(ExpertEvaluatingDetailEntity::getEvaluationState, 0, 3);
            List<ExpertEvaluatingDetailEntity> list1 = IExpertEvaluatingDetailService.list(lambda2);
            list1.forEach(v -> {
                v.setEvaluationState(2);
            });
            if (CollectionUtils.isNotEmpty(list1)) {
                IExpertEvaluatingDetailService.saveOrUpdateBatch(list1);
            }
        }
    }

    //查询专家评分详情接口
    @Override
    public Map<String, Object> queryExpertDetail(ExpertEvaluatingDetailScoreVO vo) {
        Map<String, Object> detailMap = new HashMap<>();
        ////查询评标记录
        LambdaQueryWrapper<ExpertRecordEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertRecordEntity::getInviteId, vo.getInviteId());
        lambda.eq(ExpertRecordEntity::getEvaluationId, vo.getEvaluationId());
        lambda.eq(ExpertRecordEntity::getSupplierId, vo.getSupplierId());
        lambda.eq(ExpertRecordEntity::getDocumentSchemeId, vo.getDocumentSchemeId());
        lambda.eq(ExpertRecordEntity::getFlag, 1);
        List<ExpertRecordEntity> recordEntityList = expertRecordService.list(lambda);
        List<ExpertRecordVO> recordVOList = BeanMapper.mapList(recordEntityList, ExpertRecordVO.class);
        //是否区分商务/技术
        ExpertEvaluatingEntity expertEvaluating = service.selectById(vo.getEvaluationId());
        Integer distinctionFlag = expertEvaluating.getDistinctionFlag();
        //获取商务、技术
        List<ExpertRecordVO> recordVOList2 = new ArrayList<>();//商务
        List<ExpertRecordVO> recordVOList3 = new ArrayList<>();//技术
        if (CollectionUtils.isNotEmpty(recordVOList) && distinctionFlag.equals(0)) {
            for (ExpertRecordVO recordVO : recordVOList) {
                LambdaQueryWrapper<ExpertEntity> lambda2 = Wrappers.lambdaQuery();
                lambda2.eq(ExpertEntity::getExpertId, recordVO.getEmployeeId());
                List<ExpertEntity> list = expertService.list(lambda2);
                if (CollectionUtils.isNotEmpty(list)) {
                    switch (list.get(0).getType()) {
                        case 0:
                            recordVOList2.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                            break;
                        case 1:
                            recordVOList3.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                            break;
                        case 2:
                            recordVOList2.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                            recordVOList3.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                            break;
                    }
                }
            }
        }
        else {//不区分商务技术，专家都有分数
            recordVOList2.addAll(BeanMapper.mapList(recordVOList, ExpertRecordVO.class));
            recordVOList3.addAll(BeanMapper.mapList(recordVOList, ExpertRecordVO.class));
        }
        //商务得分值
        recordVOList2 = service.getRecordVO(recordVOList2, 0);
        //技术得分值
        recordVOList3 = service.getRecordVO(recordVOList3, 1);
        //商务表头
        List<TemplateDetailVO> businessHead = service.getHead(vo.getTemplateId(), 0);
        //商务表头
        List<TemplateDetailVO> technologyHead = service.getHead(vo.getTemplateId(), 1);
        detailMap.put("businessHead", businessHead);
        detailMap.put("businessDatail", recordVOList2);
        detailMap.put("technologyHead", technologyHead);
        detailMap.put("technologyDateil", recordVOList3);
        return detailMap;
    }

    //供应商方案平均分处理
    @Override
    public List<ExpertEvaluatingDetailScoreVO> getAvgScore(List<ExpertEvaluatingDetailScoreVO> list) {
        for (ExpertEvaluatingDetailScoreVO expertEvaluatingDetailScoreVO : list) {
            LambdaQueryWrapper<ExpertRecordEntity> lambda = Wrappers.lambdaQuery();
            lambda.eq(ExpertRecordEntity::getInviteId, expertEvaluatingDetailScoreVO.getInviteId());
            lambda.eq(ExpertRecordEntity::getEvaluationId, expertEvaluatingDetailScoreVO.getEvaluationId());
            lambda.eq(ExpertRecordEntity::getSupplierId, expertEvaluatingDetailScoreVO.getSupplierId());
            lambda.eq(ExpertRecordEntity::getDocumentSchemeId, expertEvaluatingDetailScoreVO.getDocumentSchemeId());
            lambda.eq(ExpertRecordEntity::getFlag, 1);
            List<ExpertRecordEntity> recordEntityList = expertRecordService.list(lambda);
            List<ExpertRecordVO> recordVOList = BeanMapper.mapList(recordEntityList, ExpertRecordVO.class);
            //是否区分商务/技术
            ExpertEvaluatingEntity expertEvaluating = service.selectById(expertEvaluatingDetailScoreVO.getEvaluationId());
            Integer distinctionFlag = expertEvaluating.getDistinctionFlag();
            //获取商务、技术
            List<ExpertRecordVO> recordVOList2 = new ArrayList<>();//商务
            List<ExpertRecordVO> recordVOList3 = new ArrayList<>();//技术
            if (CollectionUtils.isNotEmpty(recordVOList) && distinctionFlag.equals(0)) {
                for (ExpertRecordVO recordVO : recordVOList) {
                    LambdaQueryWrapper<ExpertEntity> lambda2 = Wrappers.lambdaQuery();
                    lambda2.eq(ExpertEntity::getExpertId, recordVO.getEmployeeId());
                    List<ExpertEntity> expertList = expertService.list(lambda2);
                    if (CollectionUtils.isNotEmpty(expertList)) {
                        switch (expertList.get(0).getType()) {
                            case 0:
                                recordVOList2.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                                break;
                            case 1:
                                recordVOList3.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                                break;
                            case 2:
                                recordVOList2.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                                recordVOList3.add(BeanMapper.map(recordVO, ExpertRecordVO.class));
                                break;
                        }
                    }
                }
            }

            //商务
            BigDecimal bussScore = service.getScore(recordVOList2, 0);
            //技术
            BigDecimal techScore = service.getScore(recordVOList3, 1);
            if (CollectionUtils.isNotEmpty(recordVOList2) && CollectionUtils.isNotEmpty(recordVOList3)) {
                expertEvaluatingDetailScoreVO.setAvgScore(bussScore.divide(new BigDecimal(recordVOList2.size()), 8, BigDecimal.ROUND_HALF_UP).add(techScore.divide(new BigDecimal(recordVOList3.size()), 8, BigDecimal.ROUND_HALF_UP)));
            }
            else if (CollectionUtils.isNotEmpty(recordVOList2)) {
                expertEvaluatingDetailScoreVO.setAvgScore(bussScore.divide(new BigDecimal(recordVOList2.size()), 8, BigDecimal.ROUND_HALF_UP));
            }
            else if (CollectionUtils.isNotEmpty(recordVOList3)) {
                expertEvaluatingDetailScoreVO.setAvgScore(techScore.divide(new BigDecimal(recordVOList3.size()), 8, BigDecimal.ROUND_HALF_UP));
            }
        }
        return list;
    }

    //获去总分数
    @Override
    public BigDecimal getScore(List<ExpertRecordVO> recordVOList, Integer type) {
        BigDecimal score = new BigDecimal(0);
        for (ExpertRecordVO recordVO : recordVOList) {
            //查询出 商务/技术 模板父级
            LambdaQueryWrapper<TemplateDetailEntity> templateDetailLambda = Wrappers.lambdaQuery();
            templateDetailLambda.eq(TemplateDetailEntity::getTemplateId, recordVO.getTemplateId());
            //商务//技术 筛选条件
            templateDetailLambda.eq(TemplateDetailEntity::getScoringType, type);
            templateDetailLambda.isNull(TemplateDetailEntity::getParentId);
            List<TemplateDetailEntity> templateDetailEntityList = templateDetailService.list(templateDetailLambda);
            if (CollectionUtils.isNotEmpty(templateDetailEntityList)) {
                List<Long> parentIds = templateDetailEntityList.stream().map(TemplateDetailEntity::getId).collect(Collectors.toList());
                //查询 商务/技术 得分父级
                LambdaQueryWrapper<ExpertRecordScoreEntity> expertRecordScoreLambda = Wrappers.lambdaQuery();
                expertRecordScoreLambda.eq(ExpertRecordScoreEntity::getRecordId, recordVO.getId());
                expertRecordScoreLambda.isNotNull(ExpertRecordScoreEntity::getScoringTemplateDetailId);
                expertRecordScoreLambda.in(ExpertRecordScoreEntity::getScoringTemplateDetailParentId, parentIds);
                List<ExpertRecordScoreEntity> expertRecordScoreEntityList = expertRecordScoreService.list(expertRecordScoreLambda);
                List<ExpertRecordScoreVO> expertRecordScoreVOList = BeanMapper.mapList(expertRecordScoreEntityList, ExpertRecordScoreVO.class);
                if (CollectionUtils.isNotEmpty(expertRecordScoreVOList)) {
                    for (ExpertRecordScoreVO expertRecordScoreVO : expertRecordScoreVOList) {
                        //查询得分子级
                        LambdaQueryWrapper<ExpertRecordScoreEntity> expertRecordScoreLambda2 = Wrappers.lambdaQuery();
                        expertRecordScoreLambda2.eq(ExpertRecordScoreEntity::getRecordId, recordVO.getId());
                        expertRecordScoreLambda2.eq(ExpertRecordScoreEntity::getScoringTemplateDetailParentId, expertRecordScoreVO.getScoringTemplateDetailParentId());
                        expertRecordScoreLambda2.isNull(ExpertRecordScoreEntity::getScoringTemplateDetailId);
                        List<ExpertRecordScoreEntity> expertRecordScoreEntityList2 = expertRecordScoreService.list(expertRecordScoreLambda2);
                        List<ExpertRecordScoreVO> expertRecordScoreVOList2 = BeanMapper.mapList(expertRecordScoreEntityList2, ExpertRecordScoreVO.class);
                        for (ExpertRecordScoreVO expertRecordScoreVO2 : expertRecordScoreVOList2) {
                            if (expertRecordScoreVO2.getScore() != null) {
                                score = score.add(expertRecordScoreVO2.getScore().multiply(expertRecordScoreVO.getWeight().divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP)));
                            }
                        }
                    }
                }
            }
        }
        return score;
    }

    //评标汇总接口
    @Override
    public void collect(CollectVO collectVO) {
        String id = collectVO.getEvaluationId();
        String gatherReason = collectVO.getGatherReason();
        List<ExpertEvaluatingDetailScoreVO> scoreResultList = collectVO.getScoreResultList();
        ExpertEvaluatingEntity evaluatingEntity = service.selectById(id);
        evaluatingEntity.setGatherStatus(1);
        evaluatingEntity.setGatherReason(gatherReason);
        //推荐的供应商数据
        List<ExpertEvaluatingDetailScoreVO> detailScoreList = scoreResultList.stream().filter(t -> t.getReferFlag() != null && t.getReferFlag() == 1).collect(Collectors.toList());
        //通过的供应商数据
        List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2 = scoreResultList.stream().filter(t -> t.getCollectPassFlag() != null && t.getCollectPassFlag() == 1).collect(Collectors.toList());
        //未通过供应商数据
        List<ExpertEvaluatingDetailScoreVO> detailScoreVOList = scoreResultList.stream().filter(t -> t.getCollectPassFlag() != null && t.getCollectPassFlag() == 2).collect(Collectors.toList());
        List<ExpertEvaluatingDetailEntity> detailList = detailService.list(new QueryWrapper<ExpertEvaluatingDetailEntity>().eq("evaluation_id", id));
        for (ExpertEvaluatingDetailEntity detailEntity : detailList) {
            if (detailEntity.getEvaluationState() == 0 || detailEntity.getEvaluationState() == 3) {
                detailEntity.setEvaluationState(2);
            }
            if (detailEntity.getEvaluationState() == 1) {
                List<ExpertEntity> expertList = expertService.list(new QueryWrapper<ExpertEntity>().eq("expert_id", detailEntity.getExpertId()));
                EvaluationDetailEntity evaluationDetailEntity = new EvaluationDetailEntity();
                evaluationDetailEntity.setEvaluationName(evaluatingEntity.getEvaluationName());
                evaluationDetailEntity.setInvitingUnit(evaluatingEntity.getProjectName() == null ? evaluatingEntity.getOrgName() : evaluatingEntity.getProjectName());
                evaluationDetailEntity.setLinkman(evaluatingEntity.getEmployeeName());
                evaluationDetailEntity.setPhone(evaluatingEntity.getEmployeeMobile());
                evaluationDetailEntity.setEvaluateDate(detailEntity.getEvaluationTime());
                evaluationDetailEntity.setExpertId(expertList.get(0).getId());
                evaluationDetailService.saveOrUpdate(evaluationDetailEntity);
            }
            detailService.saveOrUpdate(detailEntity);
        }
        service.saveOrUpdate(evaluatingEntity);
        //TODO 招标修改
        //材料线
        if (evaluatingEntity.getInviteType() == 0) {
            dealStuffData(detailScoreList, detailScoreVOList2, detailScoreVOList);

            //评标汇总结束后 修改招标状态 为专家评标结束
            StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(evaluatingEntity.getInviteId());
            stuffInviteEntity.setTenderState(TenderStateEnum.专家评标结束.getCode());
            stuffInviteService.saveOrUpdate(stuffInviteEntity);
        }
        //分包线
        else if (evaluatingEntity.getInviteType() == 1) {
            dealSubData(detailScoreList, detailScoreVOList2, detailScoreVOList);

            //评标汇总结束后 修改招标状态 为专家评标结束
            SubInviteEntity subInviteEntity = subInviteService.selectById(evaluatingEntity.getInviteId());
            subInviteEntity.setTenderState(TenderStateEnum.专家评标结束.getCode());
            subInviteService.saveOrUpdate(subInviteEntity);
        }
        //设备采购
        else if (evaluatingEntity.getInviteType() == 2) {
            dealEquipmentData(detailScoreList, detailScoreVOList2, detailScoreVOList);

            //评标汇总结束后 修改招标状态 为专家评标结束
            EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(evaluatingEntity.getInviteId());
            equipmentInviteEntity.setTenderState(TenderStateEnum.专家评标结束.getCode());
            equipmentInviteService.saveOrUpdate(equipmentInviteEntity);
        }
        //设备租赁
        else if (evaluatingEntity.getInviteType() == 3) {
            dealRentData(detailScoreList, detailScoreVOList2, detailScoreVOList);

            //评标汇总结束后 修改招标状态 为专家评标结束
            RentInviteEntity rentInviteEntity = rentInviteService.selectById(evaluatingEntity.getInviteId());
            rentInviteEntity.setTenderState(TenderStateEnum.专家评标结束.getCode());
            rentInviteService.saveOrUpdate(rentInviteEntity);
        }
        //周转材租赁
        else if (evaluatingEntity.getInviteType() == 4) {
            dealRmatData(detailScoreList, detailScoreVOList2, detailScoreVOList);

            //评标汇总结束后 修改招标状态 为专家评标结束
            RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(evaluatingEntity.getInviteId());
            rmatInviteEntity.setTenderState(TenderStateEnum.专家评标结束.getCode());
            rmatInviteService.saveOrUpdate(rmatInviteEntity);
        }
        //其他租赁
        else if (evaluatingEntity.getInviteType() == 5) {
            dealOtherData(detailScoreList, detailScoreVOList2, detailScoreVOList);

            //评标汇总结束后 修改招标状态 为专家评标结束
            OtherInviteEntity otherInviteEntity = otherInviteService.selectById(evaluatingEntity.getInviteId());
            otherInviteEntity.setTenderState(TenderStateEnum.专家评标结束.getCode());
            otherInviteService.saveOrUpdate(otherInviteEntity);
        }
    }

    public void dealStuffData(List<ExpertEvaluatingDetailScoreVO> detailScoreList, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList) {
        //回写推荐sell表
        StuffDocumentEntity documentEntity = stuffDocumentService.list(new QueryWrapper<StuffDocumentEntity>().eq("invite_id", detailScoreList.get(0).getInviteId())).get(0);
        List<StuffDocumentSellEntity> sellEntityList = documentSellService.list(new QueryWrapper<StuffDocumentSellEntity>()
                .eq("document_id", documentEntity.getId())
                .eq("scheme_id", detailScoreList.get(0).getDocumentSchemeId())
                .eq("supplier_id", detailScoreList.get(0).getSupplierId())
                .orderByDesc("talk_num"));
        List<StuffDocumentSellEntity> sellEntityList1 = sellEntityList.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
        for (StuffDocumentSellEntity sellEntity : sellEntityList1) {
            sellEntity.setReferFlag(1);
            documentSellService.saveOrUpdate(sellEntity);
        }
        //回写评分表
        for (ExpertEvaluatingDetailScoreVO detailScoreVO : detailScoreList) {
            List<ExpertRecordEntity> recordEntityList = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", detailScoreVO.getDocumentSchemeId())
                    .eq("supplier_id", detailScoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList) {
                recordEntity.setReferFlag(1);
                recordService.saveOrUpdate(recordEntity);
            }
        }

        //未通过方案
        for (ExpertEvaluatingDetailScoreVO scoreVO : detailScoreVOList) {
            //回写sell表
            List<StuffDocumentSellEntity> sellEntity1List = documentSellService.list(new QueryWrapper<StuffDocumentSellEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<StuffDocumentSellEntity> sellEntityList2 = sellEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (StuffDocumentSellEntity sellEntity2 : sellEntityList2) {
                sellEntity2.setPassFlag(2);
                documentSellService.saveOrUpdate(sellEntity2);
            }
            //回写方案表
            List<StuffDocumentSchemeEntity> schemeEntity1List = documentSchemeService.list(new QueryWrapper<StuffDocumentSchemeEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<StuffDocumentSchemeEntity> schemeEntityList2 = schemeEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (StuffDocumentSchemeEntity schemeEntity2 : schemeEntityList2) {
                schemeEntity2.setPassFlag(2);
                documentSchemeService.saveOrUpdate(schemeEntity2);
            }
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(2);
                recordEntity.setCollectMemo(scoreVO.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //回写通过记录的汇总备注
        for (ExpertEvaluatingDetailScoreVO scoreVO2 : detailScoreVOList2) {
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO2.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO2.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(1);
                recordEntity.setCollectMemo(scoreVO2.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
    }

    public void dealSubData(List<ExpertEvaluatingDetailScoreVO> detailScoreList, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList) {
        //回写推荐sell表
        SubDocumentEntity documentEntity = subDocumentService.list(new QueryWrapper<SubDocumentEntity>().eq("invite_id", detailScoreList.get(0).getInviteId())).get(0);
        List<SubDocumentSellEntity> sellEntityList = subDocumentSellService.list(new QueryWrapper<SubDocumentSellEntity>()
                .eq("document_id", documentEntity.getId())
                .eq("scheme_id", detailScoreList.get(0).getDocumentSchemeId())
                .eq("supplier_id", detailScoreList.get(0).getSupplierId())
                .orderByDesc("talk_num"));
        List<SubDocumentSellEntity> sellEntityList1 = sellEntityList.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
        for (SubDocumentSellEntity sellEntity : sellEntityList1) {
            sellEntity.setReferFlag(1);
            subDocumentSellService.saveOrUpdate(sellEntity);
        }
        //回写评分表
        for (ExpertEvaluatingDetailScoreVO detailScoreVO : detailScoreList) {
            List<ExpertRecordEntity> recordEntityList = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", detailScoreVO.getDocumentSchemeId())
                    .eq("supplier_id", detailScoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList) {
                recordEntity.setReferFlag(1);
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //未通过方案
        for (ExpertEvaluatingDetailScoreVO scoreVO : detailScoreVOList) {
            //回写sell表
            List<SubDocumentSellEntity> sellEntity1List = subDocumentSellService.list(new QueryWrapper<SubDocumentSellEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<SubDocumentSellEntity> sellEntityList2 = sellEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (SubDocumentSellEntity sellEntity1 : sellEntityList2) {
                sellEntity1.setPassFlag(2);
                subDocumentSellService.saveOrUpdate(sellEntity1);
            }
            //回写方案表
            List<SubDocumentSchemeEntity> schemeEntity1List = subDocumentSchemeService.list(new QueryWrapper<SubDocumentSchemeEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<SubDocumentSchemeEntity> schemeEntityList2 = schemeEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (SubDocumentSchemeEntity schemeEntity2 : schemeEntityList2) {
                schemeEntity2.setPassFlag(2);
                subDocumentSchemeService.saveOrUpdate(schemeEntity2);
            }
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(2);
                recordEntity.setCollectMemo(scoreVO.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //回写通过记录的汇总备注
        for (ExpertEvaluatingDetailScoreVO scoreVO2 : detailScoreVOList2) {
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO2.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO2.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(1);
                recordEntity.setCollectMemo(scoreVO2.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
    }

    public void dealEquipmentData(List<ExpertEvaluatingDetailScoreVO> detailScoreList, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList) {
        //回写推荐sell表
        EquipmentDocumentEntity documentEntity = equipmentDocumentService.list(new QueryWrapper<EquipmentDocumentEntity>().eq("invite_id", detailScoreList.get(0).getInviteId())).get(0);
        List<EquipmentDocumentSellEntity> sellEntityList = equipmentDocumentSellService.list(new QueryWrapper<EquipmentDocumentSellEntity>()
                .eq("document_id", documentEntity.getId())
                .eq("scheme_id", detailScoreList.get(0).getDocumentSchemeId())
                .eq("supplier_id", detailScoreList.get(0).getSupplierId())
                .orderByDesc("talk_num"));
        List<EquipmentDocumentSellEntity> sellEntityList1 = sellEntityList.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
        for (EquipmentDocumentSellEntity sellEntity : sellEntityList1) {
            sellEntity.setReferFlag(1);
            equipmentDocumentSellService.saveOrUpdate(sellEntity);
        }
        //回写评分表
        for (ExpertEvaluatingDetailScoreVO detailScoreVO : detailScoreList) {
            List<ExpertRecordEntity> recordEntityList = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", detailScoreVO.getDocumentSchemeId())
                    .eq("supplier_id", detailScoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList) {
                recordEntity.setReferFlag(1);
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //未通过方案
        for (ExpertEvaluatingDetailScoreVO scoreVO : detailScoreVOList) {
            //回写sell表
            List<EquipmentDocumentSellEntity> sellEntity1List = equipmentDocumentSellService.list(new QueryWrapper<EquipmentDocumentSellEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<EquipmentDocumentSellEntity> sellEntityList2 = sellEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (EquipmentDocumentSellEntity sellEntity1 : sellEntityList2) {
                sellEntity1.setPassFlag(2);
                equipmentDocumentSellService.saveOrUpdate(sellEntity1);
            }
            //回写方案表
            List<EquipmentDocumentSchemeEntity> schemeEntity1List = equipmentDocumentSchemeService.list(new QueryWrapper<EquipmentDocumentSchemeEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<EquipmentDocumentSchemeEntity> schemeEntityList2 = schemeEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (EquipmentDocumentSchemeEntity schemeEntity2 : schemeEntityList2) {
                schemeEntity2.setPassFlag(2);
                equipmentDocumentSchemeService.saveOrUpdate(schemeEntity2);
            }
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(2);
                recordEntity.setCollectMemo(scoreVO.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //回写通过记录的汇总备注
        for (ExpertEvaluatingDetailScoreVO scoreVO2 : detailScoreVOList2) {
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO2.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO2.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(1);
                recordEntity.setCollectMemo(scoreVO2.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
    }

    public void dealRentData(List<ExpertEvaluatingDetailScoreVO> detailScoreList, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList) {
        //回写推荐sell表
        RentDocumentEntity documentEntity = rentDocumentService.list(new QueryWrapper<RentDocumentEntity>().eq("invite_id", detailScoreList.get(0).getInviteId())).get(0);
        List<RentDocumentSellEntity> sellEntityList = rentDocumentSellService.list(new QueryWrapper<RentDocumentSellEntity>()
                .eq("document_id", documentEntity.getId())
                .eq("scheme_id", detailScoreList.get(0).getDocumentSchemeId())
                .eq("supplier_id", detailScoreList.get(0).getSupplierId())
                .orderByDesc("talk_num"));
        List<RentDocumentSellEntity> sellEntityList1 = sellEntityList.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
        for (RentDocumentSellEntity sellEntity : sellEntityList1) {
            sellEntity.setReferFlag(1);
            rentDocumentSellService.saveOrUpdate(sellEntity);
        }
        //回写评分表
        for (ExpertEvaluatingDetailScoreVO detailScoreVO : detailScoreList) {
            List<ExpertRecordEntity> recordEntityList = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", detailScoreVO.getDocumentSchemeId())
                    .eq("supplier_id", detailScoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList) {
                recordEntity.setReferFlag(1);
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //未通过方案
        for (ExpertEvaluatingDetailScoreVO scoreVO : detailScoreVOList) {
            //回写sell表
            List<RentDocumentSellEntity> sellEntity1List = rentDocumentSellService.list(new QueryWrapper<RentDocumentSellEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<RentDocumentSellEntity> sellEntityList2 = sellEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (RentDocumentSellEntity sellEntity1 : sellEntityList2) {
                sellEntity1.setPassFlag(2);
                rentDocumentSellService.saveOrUpdate(sellEntity1);
            }
            //回写方案表
            List<RentDocumentSchemeEntity> schemeEntity1List = rentDocumentSchemeService.list(new QueryWrapper<RentDocumentSchemeEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<RentDocumentSchemeEntity> schemeEntityList2 = schemeEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (RentDocumentSchemeEntity schemeEntity2 : schemeEntityList2) {
                schemeEntity2.setPassFlag(2);
                rentDocumentSchemeService.saveOrUpdate(schemeEntity2);
            }
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(2);
                recordEntity.setCollectMemo(scoreVO.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //回写通过记录的汇总备注
        for (ExpertEvaluatingDetailScoreVO scoreVO2 : detailScoreVOList2) {
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO2.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO2.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(1);
                recordEntity.setCollectMemo(scoreVO2.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
    }

    public void dealRmatData(List<ExpertEvaluatingDetailScoreVO> detailScoreList, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList) {
        //回写推荐sell表
        RmatDocumentEntity documentEntity = rmatDocumentService.list(new QueryWrapper<RmatDocumentEntity>().eq("invite_id", detailScoreList.get(0).getInviteId())).get(0);
        List<RmatDocumentSellEntity> sellEntityList = rmatDocumentSellService.list(new QueryWrapper<RmatDocumentSellEntity>()
                .eq("document_id", documentEntity.getId())
                .eq("scheme_id", detailScoreList.get(0).getDocumentSchemeId())
                .eq("supplier_id", detailScoreList.get(0).getSupplierId())
                .orderByDesc("talk_num"));
        List<RmatDocumentSellEntity> sellEntityList1 = sellEntityList.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
        for (RmatDocumentSellEntity sellEntity : sellEntityList1) {
            sellEntity.setReferFlag(1);
            rmatDocumentSellService.saveOrUpdate(sellEntity);
        }
        //回写评分表
        for (ExpertEvaluatingDetailScoreVO detailScoreVO : detailScoreList) {
            List<ExpertRecordEntity> recordEntityList = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", detailScoreVO.getDocumentSchemeId())
                    .eq("supplier_id", detailScoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList) {
                recordEntity.setReferFlag(1);
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //未通过方案
        for (ExpertEvaluatingDetailScoreVO scoreVO : detailScoreVOList) {
            //回写sell表
            List<RmatDocumentSellEntity> sellEntity1List = rmatDocumentSellService.list(new QueryWrapper<RmatDocumentSellEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<RmatDocumentSellEntity> sellEntityList2 = sellEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (RmatDocumentSellEntity sellEntity1 : sellEntityList2) {
                sellEntity1.setPassFlag(2);
                rmatDocumentSellService.saveOrUpdate(sellEntity1);
            }
            //回写方案表
            List<RmatDocumentSchemeEntity> schemeEntity1List = rmatDocumentSchemeService.list(new QueryWrapper<RmatDocumentSchemeEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<RmatDocumentSchemeEntity> schemeEntityList2 = schemeEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (RmatDocumentSchemeEntity schemeEntity2 : schemeEntityList2) {
                schemeEntity2.setPassFlag(2);
                rmatDocumentSchemeService.saveOrUpdate(schemeEntity2);
            }
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(2);
                recordEntity.setCollectMemo(scoreVO.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //回写通过记录的汇总备注
        for (ExpertEvaluatingDetailScoreVO scoreVO2 : detailScoreVOList2) {
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO2.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO2.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(1);
                recordEntity.setCollectMemo(scoreVO2.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
    }

    public void dealOtherData(List<ExpertEvaluatingDetailScoreVO> detailScoreList, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList2, List<ExpertEvaluatingDetailScoreVO> detailScoreVOList) {
        //回写推荐sell表
        OtherDocumentEntity documentEntity = otherDocumentService.list(new QueryWrapper<OtherDocumentEntity>().eq("invite_id", detailScoreList.get(0).getInviteId())).get(0);
        List<OtherDocumentSellEntity> sellEntityList = otherDocumentSellService.list(new QueryWrapper<OtherDocumentSellEntity>()
                .eq("document_id", documentEntity.getId())
                .eq("scheme_id", detailScoreList.get(0).getDocumentSchemeId())
                .eq("supplier_id", detailScoreList.get(0).getSupplierId())
                .orderByDesc("talk_num"));
        List<OtherDocumentSellEntity> sellEntityList1 = sellEntityList.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
        for (OtherDocumentSellEntity sellEntity : sellEntityList1) {
            sellEntity.setReferFlag(1);
            otherDocumentSellService.saveOrUpdate(sellEntity);
        }
        //回写评分表
        for (ExpertEvaluatingDetailScoreVO detailScoreVO : detailScoreList) {
            List<ExpertRecordEntity> recordEntityList = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", detailScoreVO.getDocumentSchemeId())
                    .eq("supplier_id", detailScoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList) {
                recordEntity.setReferFlag(1);
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //未通过方案
        for (ExpertEvaluatingDetailScoreVO scoreVO : detailScoreVOList) {
            //回写sell表
            List<OtherDocumentSellEntity> sellEntity1List = otherDocumentSellService.list(new QueryWrapper<OtherDocumentSellEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<OtherDocumentSellEntity> sellEntityList2 = sellEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (OtherDocumentSellEntity sellEntity1 : sellEntityList2) {
                sellEntity1.setPassFlag(2);
                otherDocumentSellService.saveOrUpdate(sellEntity1);
            }
            //回写方案表
            List<OtherDocumentSchemeEntity> schemeEntity1List = otherDocumentSchemeService.list(new QueryWrapper<OtherDocumentSchemeEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()).orderByDesc("talk_num"));
            List<OtherDocumentSchemeEntity> schemeEntityList2 = schemeEntity1List.stream().filter(t -> t.getTalkNum().equals(sellEntityList.get(0).getTalkNum())).collect(Collectors.toList());
            for (OtherDocumentSchemeEntity schemeEntity2 : schemeEntityList2) {
                schemeEntity2.setPassFlag(2);
                otherDocumentSchemeService.saveOrUpdate(schemeEntity2);
            }
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(2);
                recordEntity.setCollectMemo(scoreVO.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
        //回写通过记录的汇总备注
        for (ExpertEvaluatingDetailScoreVO scoreVO2 : detailScoreVOList2) {
            //回写记录表
            List<ExpertRecordEntity> recordEntityList1 = recordService.list(new QueryWrapper<ExpertRecordEntity>()
                    .eq("document_id", documentEntity.getId())
                    .eq("document_scheme_id", scoreVO2.getDocumentSchemeId())
                    .eq("supplier_id", scoreVO2.getSupplierId()));
            for (ExpertRecordEntity recordEntity : recordEntityList1) {
                recordEntity.setCollectPassFlag(1);
                recordEntity.setCollectMemo(scoreVO2.getCollectMemo());
                recordService.saveOrUpdate(recordEntity);
            }
        }
    }

    @Override
    public List<ExpertEvaluatingVO> queryGatherList(Page<ExpertEvaluatingVO> page, String searchText, Integer gatherStatus, Long employeeId) {
        return baseMapper.queryGatherList(page, searchText, gatherStatus, employeeId);
    }

    //获取评分详情表头
    @Override
    public List<TemplateDetailVO> getHead(Long templateId, Integer type) {
        List<TemplateDetailVO> templateDetailVOS = new ArrayList<>();
        LambdaQueryWrapper<TemplateDetailEntity> templateDetailLambda = Wrappers.lambdaQuery();
        templateDetailLambda.eq(TemplateDetailEntity::getTemplateId, templateId);
        templateDetailLambda.eq(TemplateDetailEntity::getScoringType, type);
        List<TemplateDetailEntity> list = templateDetailService.list(templateDetailLambda);
        if (CollectionUtils.isNotEmpty(list)) {
            templateDetailVOS = TreeNodeBUtil.buildTree(BeanMapper.mapList(list, TemplateDetailVO.class));
        }
        return templateDetailVOS;
    }


    //获取评分详情内容
    //type---商务/技术（0-1）
    //recordVOList  集合
    @Override
    public List<ExpertRecordVO> getRecordVO(List<ExpertRecordVO> recordVOList, Integer type) {
        //商务/技术 得分值
        if (CollectionUtils.isNotEmpty(recordVOList)) {
            //查询出 商务/技术 模板父级
            LambdaQueryWrapper<TemplateDetailEntity> templateDetailLambda = Wrappers.lambdaQuery();
            templateDetailLambda.eq(TemplateDetailEntity::getTemplateId, recordVOList.get(0).getTemplateId());
            //商务//技术 筛选条件
            templateDetailLambda.eq(TemplateDetailEntity::getScoringType, type);
            templateDetailLambda.isNull(TemplateDetailEntity::getParentId);
            List<TemplateDetailEntity> templateDetailEntityList = templateDetailService.list(templateDetailLambda);
            if (CollectionUtils.isNotEmpty(templateDetailEntityList)) {
                List<Long> parentIds = templateDetailEntityList.stream().map(TemplateDetailEntity::getId).collect(Collectors.toList());
                for (ExpertRecordVO recordVO : recordVOList) {
                    BigDecimal score = new BigDecimal(0);
                    LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
                    expertLambda.eq(ExpertEntity::getExpertId, recordVO.getEmployeeId());
                    List<ExpertEntity> list = expertService.list(expertLambda);
                    if (CollectionUtils.isNotEmpty(list)) {
                        switch (list.get(0).getType()) {
                            case 0:
                                recordVO.setSupplierName("商务专家");
                                break;
                            case 1:
                                recordVO.setSupplierName("技术专家");
                                break;
                            case 2:
                                recordVO.setSupplierName("商务技术专家");
                                break;
                        }
                    }
                    //查询 商务/技术 得分父级
                    LambdaQueryWrapper<ExpertRecordScoreEntity> expertRecordScoreLambda = Wrappers.lambdaQuery();
                    expertRecordScoreLambda.eq(ExpertRecordScoreEntity::getRecordId, recordVO.getId());
                    expertRecordScoreLambda.isNotNull(ExpertRecordScoreEntity::getScoringTemplateDetailId);
                    expertRecordScoreLambda.in(ExpertRecordScoreEntity::getScoringTemplateDetailParentId, parentIds);
                    List<ExpertRecordScoreEntity> expertRecordScoreEntityList = expertRecordScoreService.list(expertRecordScoreLambda);
                    List<ExpertRecordScoreVO> expertRecordScoreVOList = BeanMapper.mapList(expertRecordScoreEntityList, ExpertRecordScoreVO.class);
                    if (CollectionUtils.isNotEmpty(expertRecordScoreVOList)) {
                        for (ExpertRecordScoreVO expertRecordScoreVO : expertRecordScoreVOList) {
                            //查询得分子级
                            LambdaQueryWrapper<ExpertRecordScoreEntity> expertRecordScoreLambda2 = Wrappers.lambdaQuery();
                            expertRecordScoreLambda2.eq(ExpertRecordScoreEntity::getRecordId, recordVO.getId());
                            expertRecordScoreLambda2.eq(ExpertRecordScoreEntity::getScoringTemplateDetailParentId, expertRecordScoreVO.getScoringTemplateDetailParentId());
                            expertRecordScoreLambda2.isNull(ExpertRecordScoreEntity::getScoringTemplateDetailId);
                            List<ExpertRecordScoreEntity> expertRecordScoreEntityList2 = expertRecordScoreService.list(expertRecordScoreLambda2);
                            List<ExpertRecordScoreVO> expertRecordScoreVOList2 = BeanMapper.mapList(expertRecordScoreEntityList2, ExpertRecordScoreVO.class);
                            for (ExpertRecordScoreVO expertRecordScoreVO2 : expertRecordScoreVOList2) {
                                if (expertRecordScoreVO2.getScore() == null) {
                                    expertRecordScoreVO2.setScore(new BigDecimal(0));
                                }
                                if (expertRecordScoreVO2.getScore() != null) {
                                    score = score.add(expertRecordScoreVO2.getScore().multiply(expertRecordScoreVO.getWeight().divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP)));
                                }
                            }
                            //父子级链接
                            expertRecordScoreVO.setExpertRecordScoreVOList(expertRecordScoreVOList2);
                        }
                        //得分
                        recordVO.setStuffRecordScoreVos(expertRecordScoreVOList);
                    }
                    recordVO.setSumScore(score);
                    recordVO.setSchemeNameMoney(recordVO.getSchemeName() + "含税:(" + recordVO.getMoneyTax().setScale(2, BigDecimal.ROUND_HALF_UP) + "元;无税:" + recordVO.getMoney().setScale(2, BigDecimal.ROUND_HALF_UP) + "元)");
                }
            }
            else {
                return new ArrayList<ExpertRecordVO>();//查不到模板子表，证明改模板是单一的
            }
        }
        return recordVOList;
    }

    //下一步接口
    @Override
    public ExpertEvaluatingVO saveEvaluation(Long documentId) {
        ExpertEvaluatingVO vo = new ExpertEvaluatingVO();
        LambdaQueryWrapper<ProcessEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ProcessEntity::getBillId, documentId);
        List<ProcessEntity> list = processService.list(lambda);
        switch (list.get(0).getType()) {
            case 0:
                vo = service.suffNext(documentId);
                break;
            case 1:
                vo = service.subNext(documentId);
                break;
            case 2:
                vo = service.equipmentNext(documentId);
                break;
            case 3:
                vo = service.rentNext(documentId);
                break;
            case 4:
                vo = service.rmatNext(documentId);
                break;
            case 5:
                vo = service.otherNext(documentId);
                break;
        }
        return vo;
    }

    //材料下一步
    @Override
    public ExpertEvaluatingVO suffNext(Long documentId) {
        ExpertEvaluatingEntity entity = new ExpertEvaluatingEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询文件主表信息
        StuffDocumentEntity stuffDocumentEntity = stuffDocumentService.selectById(documentId);
//查询招标立项
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        //更新下一步状态
        stuffDocumentEntity.setNextFlag(0);
        stuffDocumentService.updateById(stuffDocumentEntity);

        LambdaQueryWrapper<StuffTalkEntity> lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(StuffTalkEntity::getBillId, documentId);
        StuffTalkEntity stuffTalkEntity = stuffTalkMapper.selectOne(lambdaTalk);
        if (null != stuffTalkEntity) {
            stuffTalkEntity.setNextFlag(0);
            stuffTalkMapper.updateById(stuffTalkEntity);
        }
        //复制主表信息
        entity.setProjectId(stuffDocumentEntity.getProjectId());
        entity.setProjectName(stuffDocumentEntity.getProjectName());
        entity.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        entity.setOrgId(stuffDocumentEntity.getOrgId());
        entity.setOrgName(stuffDocumentEntity.getOrgName());
        entity.setParentOrgId(stuffDocumentEntity.getParentOrgId());
        entity.setParentOrgName(stuffDocumentEntity.getParentOrgName());
        entity.setProjectCode(stuffDocumentEntity.getProjectCode());
        entity.setEvaluationName(stuffDocumentEntity.getDocumentName());
        entity.setEmployeeId(stuffDocumentEntity.getEmployeeId());
        entity.setEmployeeName(stuffDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
        entity.setInviteId(stuffDocumentEntity.getInviteId());
        entity.setDocumentId(stuffDocumentEntity.getId());
        entity.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        entity.setUnitId(stuffInviteEntity.getUnitId());
        entity.setUnitName(stuffInviteEntity.getUnitName());
        entity.setGatherStatus(0);
        entity.setInviteType(0);//招标类型
        entity.setDistinctionFlag(1);
        entity.setFlagNew(1);
        entity.setChangeVersion(1);
        //复制子表
        if (CollectionUtils.isNotEmpty(stuffDocumentEntity.getExpertVOList())) {
            List<ExpertEvaluatingDetailEntity> detailEntities = BeanMapper.mapList(stuffDocumentEntity.getExpertVOList(), ExpertEvaluatingDetailEntity.class);
            for (ExpertEvaluatingDetailEntity evaluationDetailEntity : detailEntities) {
                evaluationDetailEntity.setId(null);
                evaluationDetailEntity.setEvaluationState(0);
                evaluationDetailEntity.setLeader(1);
            }
            entity.setStuffEvaluationDetailEntities(detailEntities);
        }
        service.saveOrUpdate(entity, false);
        //回写招标阶段
//        Integer tenderStage = 4;
//        stuffInviteService.updateTenderStage(String.valueOf(stuffDocumentEntity.getInviteId()), tenderStage);
//        回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("专家评标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/evaluationCard");
        processService.saveOrUpdate(processEntity);

        //招标文件下一步 专家评标 改招标状态 为专家评标中
        stuffInviteEntity.setTenderState(TenderStateEnum.专家评标中.getCode());
        stuffInviteEntity.setTenderStage(TenderStageEnum.EXPERT_STATE.getTenderTypeCode());
        stuffInviteEntity.setStopTime(null);
        stuffInviteService.saveOrUpdate(stuffInviteEntity);

        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        return vo;
    }

    //分包下一步
    @Override
    public ExpertEvaluatingVO subNext(Long documentId) {
        ExpertEvaluatingEntity entity = new ExpertEvaluatingEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询文件主表信息
        SubDocumentEntity subDocumentEntity = subDocumentService.selectById(documentId);
//查询招标立项
        SubInviteEntity subInviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        //更新下一步状态
        subDocumentEntity.setNextFlag(0);
        subDocumentService.updateById(subDocumentEntity);

        LambdaQueryWrapper<SubTalkEntity> lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(SubTalkEntity::getBillId, documentId);
        SubTalkEntity subTalkEntity = subTalkMapper.selectOne(lambdaTalk);
        if (null != subTalkEntity) {
            subTalkEntity.setNextFlag(0);
            subTalkMapper.updateById(subTalkEntity);
        }
        //复制主表信息
        entity.setProjectId(subDocumentEntity.getProjectId());
        entity.setProjectName(subDocumentEntity.getProjectName());
        entity.setPurchaseType(subDocumentEntity.getPurchaseType());
        entity.setOrgId(subDocumentEntity.getOrgId());
        entity.setOrgName(subDocumentEntity.getOrgName());
        entity.setParentOrgId(subDocumentEntity.getParentOrgId());
        entity.setParentOrgName(subDocumentEntity.getParentOrgName());
        entity.setProjectCode(subDocumentEntity.getProjectCode());
        entity.setEvaluationName(subDocumentEntity.getDocumentName());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setDocumentId(subDocumentEntity.getId());
        entity.setPurchaseType(subDocumentEntity.getPurchaseType());
        entity.setGatherStatus(0);
        entity.setUnitId(subInviteEntity.getUnitId());
        entity.setUnitName(subInviteEntity.getUnitName());
        entity.setInviteType(1);//招标类型
        entity.setDistinctionFlag(1);
        entity.setSubType(subDocumentEntity.getSubType());//分包类型
        entity.setFlagNew(1);
        entity.setChangeVersion(1);
        //复制子表
        if (CollectionUtils.isNotEmpty(subDocumentEntity.getExpertVOList())) {
            List<ExpertEvaluatingDetailEntity> detailEntities = BeanMapper.mapList(subDocumentEntity.getExpertVOList(), ExpertEvaluatingDetailEntity.class);
            for (ExpertEvaluatingDetailEntity evaluationDetailEntity : detailEntities) {
                evaluationDetailEntity.setId(null);
                evaluationDetailEntity.setEvaluationState(0);
                evaluationDetailEntity.setLeader(1);
            }
            entity.setStuffEvaluationDetailEntities(detailEntities);
        }
        service.saveOrUpdate(entity, false);
        //回写招标阶段
//        Integer tenderStage = 4;
//        subInviteService.updateTenderStage(String.valueOf(subDocumentEntity.getInviteId()), tenderStage);
//        回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("专家评标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("stuff/evaluationCard");
        processService.saveOrUpdate(processEntity);


        //招标文件下一步 专家评标 改招标状态 为专家评标中
        subInviteEntity.setTenderState(TenderStateEnum.专家评标中.getCode());
        subInviteEntity.setTenderStage(com.ejianc.business.tender.sub.vo.TenderStageEnum.EXPERT_STATE.getTenderTypeCode());
        subInviteEntity.setStopTime(null);
        subInviteService.saveOrUpdate(subInviteEntity);

        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        return vo;
    }

    //设备采购下一步
    @Override
    public ExpertEvaluatingVO equipmentNext(Long documentId) {
        ExpertEvaluatingEntity entity = new ExpertEvaluatingEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询文件主表信息
        EquipmentDocumentEntity equipmentDocumentEntity = equipmentDocumentService.selectById(documentId);
//查询招标立项
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId());
        //更新下一步状态
        equipmentDocumentEntity.setNextFlag(0);
        equipmentDocumentService.updateById(equipmentDocumentEntity);

        LambdaQueryWrapper<EquipmentTalkEntity> lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(EquipmentTalkEntity::getBillId, documentId);
        EquipmentTalkEntity equipmentTalkEntity = equipmentTalkMapper.selectOne(lambdaTalk);
        if (null != equipmentTalkEntity) {
            equipmentTalkEntity.setNextFlag(0);
            equipmentTalkMapper.updateById(equipmentTalkEntity);
        }
        //复制主表信息
        entity.setProjectId(equipmentDocumentEntity.getProjectId());
        entity.setProjectName(equipmentDocumentEntity.getProjectName());
        entity.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        entity.setOrgId(equipmentDocumentEntity.getOrgId());
        entity.setOrgName(equipmentDocumentEntity.getOrgName());
        entity.setParentOrgId(equipmentDocumentEntity.getParentOrgId());
        entity.setParentOrgName(equipmentDocumentEntity.getParentOrgName());
        entity.setProjectCode(equipmentDocumentEntity.getProjectCode());
        entity.setEvaluationName(equipmentDocumentEntity.getDocumentName());
        entity.setEmployeeId(equipmentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        entity.setInviteId(equipmentDocumentEntity.getInviteId());
        entity.setDocumentId(equipmentDocumentEntity.getId());
        entity.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        entity.setUnitId(equipmentInviteEntity.getUnitId());
        entity.setUnitName(equipmentInviteEntity.getUnitName());
        entity.setGatherStatus(0);
        entity.setInviteType(2);//招标类型
        entity.setDistinctionFlag(1);
        entity.setFlagNew(1);
        entity.setChangeVersion(1);
        //复制子表
        if (CollectionUtils.isNotEmpty(equipmentDocumentEntity.getExpertVOList())) {
            List<ExpertEvaluatingDetailEntity> detailEntities = BeanMapper.mapList(equipmentDocumentEntity.getExpertVOList(), ExpertEvaluatingDetailEntity.class);
            for (ExpertEvaluatingDetailEntity evaluationDetailEntity : detailEntities) {
                evaluationDetailEntity.setId(null);
                evaluationDetailEntity.setEvaluationState(0);
                evaluationDetailEntity.setLeader(1);
            }
            entity.setStuffEvaluationDetailEntities(detailEntities);
        }
        service.saveOrUpdate(entity, false);
        //回写招标阶段
//        Integer tenderStage = 4;
//        equipmentInviteService.updateTenderStage(String.valueOf(equipmentDocumentEntity.getInviteId()), tenderStage);
//        回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("专家评标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("stuff/evaluationCard");
        processService.saveOrUpdate(processEntity);

        //招标文件下一步 专家评标 改招标状态 为专家评标中
        equipmentInviteEntity.setTenderState(TenderStateEnum.专家评标中.getCode());
        equipmentInviteEntity.setTenderStage(TenderStageEnum.EXPERT_STATE.getTenderTypeCode());
        equipmentInviteEntity.setStopTime(null);
        equipmentInviteService.saveOrUpdate(equipmentInviteEntity);

        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        return vo;
    }

    //设备租赁下一步
    @Override
    public ExpertEvaluatingVO rentNext(Long documentId) {
        ExpertEvaluatingEntity entity = new ExpertEvaluatingEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询文件主表信息
        RentDocumentEntity rentDocumentEntity = rentDocumentService.selectById(documentId);
//查询招标立项
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentDocumentEntity.getInviteId());
        //更新下一步状态
        rentDocumentEntity.setNextFlag(0);
        rentDocumentService.updateById(rentDocumentEntity);

        LambdaQueryWrapper<RentTalkEntity> lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(RentTalkEntity::getBillId, documentId);
        RentTalkEntity rentTalkEntity = rentTalkMapper.selectOne(lambdaTalk);
        if (null != rentTalkEntity) {
            rentTalkEntity.setNextFlag(0);
            rentTalkMapper.updateById(rentTalkEntity);
        }
        //复制主表信息
        entity.setProjectId(rentDocumentEntity.getProjectId());
        entity.setProjectName(rentDocumentEntity.getProjectName());
        entity.setPurchaseType(rentDocumentEntity.getPurchaseType());
        entity.setOrgId(rentDocumentEntity.getOrgId());
        entity.setOrgName(rentDocumentEntity.getOrgName());
        entity.setParentOrgId(rentDocumentEntity.getParentOrgId());
        entity.setParentOrgName(rentDocumentEntity.getParentOrgName());
        entity.setProjectCode(rentDocumentEntity.getProjectCode());
        entity.setEvaluationName(rentDocumentEntity.getDocumentName());
        entity.setEmployeeId(rentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        entity.setInviteId(rentDocumentEntity.getInviteId());
        entity.setDocumentId(rentDocumentEntity.getId());
        entity.setPurchaseType(rentDocumentEntity.getPurchaseType());
        entity.setUnitId(rentInviteEntity.getUnitId());
        entity.setUnitName(rentInviteEntity.getUnitName());
        entity.setGatherStatus(0);
        entity.setInviteType(3);//招标类型
        entity.setDistinctionFlag(1);
        entity.setFlagNew(1);
        entity.setChangeVersion(1);
        entity.setEquipmentType(rentInviteEntity.getEquipmentType());
        //复制子表
        if (CollectionUtils.isNotEmpty(rentDocumentEntity.getExpertVOList())) {
            List<ExpertEvaluatingDetailEntity> detailEntities = BeanMapper.mapList(rentDocumentEntity.getExpertVOList(), ExpertEvaluatingDetailEntity.class);
            for (ExpertEvaluatingDetailEntity evaluationDetailEntity : detailEntities) {
                evaluationDetailEntity.setId(null);
                evaluationDetailEntity.setEvaluationState(0);
                evaluationDetailEntity.setLeader(1);
            }
            entity.setStuffEvaluationDetailEntities(detailEntities);
        }
        service.saveOrUpdate(entity, false);
        //回写招标阶段
//        Integer tenderStage = 4;
//        rentInviteService.updateTenderStage(String.valueOf(rentDocumentEntity.getInviteId()), tenderStage);
//        回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("专家评标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("stuff/evaluationCard");
        processService.saveOrUpdate(processEntity);

        //招标文件下一步 专家评标 改招标状态 为专家评标中
        rentInviteEntity.setTenderState(TenderStateEnum.专家评标中.getCode());
        rentInviteEntity.setTenderStage(TenderStageEnum.EXPERT_STATE.getTenderTypeCode());
        rentInviteEntity.setStopTime(null);
        rentInviteService.saveOrUpdate(rentInviteEntity);

        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        return vo;
    }

    //周转材下一步
    @Override
    public ExpertEvaluatingVO rmatNext(Long documentId) {
        ExpertEvaluatingEntity entity = new ExpertEvaluatingEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询文件主表信息
        RmatDocumentEntity rmatDocumentEntity = rmatDocumentService.selectById(documentId);
//查询招标立项
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatDocumentEntity.getInviteId());
        //更新下一步状态
        rmatDocumentEntity.setNextFlag(0);
        rmatDocumentService.updateById(rmatDocumentEntity);

        LambdaQueryWrapper<RmatTalkEntity> lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(RmatTalkEntity::getBillId, documentId);
        RmatTalkEntity rmatTalkEntity = rmatTalkMapper.selectOne(lambdaTalk);
        if (null != rmatTalkEntity) {
            rmatTalkEntity.setNextFlag(0);
            rmatTalkMapper.updateById(rmatTalkEntity);
        }
        //复制主表信息
        entity.setProjectId(rmatDocumentEntity.getProjectId());
        entity.setProjectName(rmatDocumentEntity.getProjectName());
        entity.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        entity.setOrgId(rmatDocumentEntity.getOrgId());
        entity.setOrgName(rmatDocumentEntity.getOrgName());
        entity.setParentOrgId(rmatDocumentEntity.getParentOrgId());
        entity.setParentOrgName(rmatDocumentEntity.getParentOrgName());
        entity.setProjectCode(rmatDocumentEntity.getProjectCode());
        entity.setEvaluationName(rmatDocumentEntity.getDocumentName());
        entity.setEmployeeId(rmatDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        entity.setInviteId(rmatDocumentEntity.getInviteId());
        entity.setDocumentId(rmatDocumentEntity.getId());
        entity.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        entity.setUnitId(rmatInviteEntity.getUnitId());
        entity.setUnitName(rmatInviteEntity.getUnitName());
        entity.setGatherStatus(0);
        entity.setInviteType(4);//招标类型
        entity.setDistinctionFlag(1);
        entity.setFlagNew(1);
        entity.setChangeVersion(1);
        //复制子表
        if (CollectionUtils.isNotEmpty(rmatDocumentEntity.getExpertVOList())) {
            List<ExpertEvaluatingDetailEntity> detailEntities = BeanMapper.mapList(rmatDocumentEntity.getExpertVOList(), ExpertEvaluatingDetailEntity.class);
            for (ExpertEvaluatingDetailEntity evaluationDetailEntity : detailEntities) {
                evaluationDetailEntity.setId(null);
                evaluationDetailEntity.setEvaluationState(0);
                evaluationDetailEntity.setLeader(1);
            }
            entity.setStuffEvaluationDetailEntities(detailEntities);
        }
        service.saveOrUpdate(entity, false);
        //回写招标阶段
//        Integer tenderStage = 4;
//        rmatInviteService.updateTenderStage(String.valueOf(rmatDocumentEntity.getInviteId()), tenderStage);
//        回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("专家评标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(4);
        processEntity.setFrontendUrl("stuff/evaluationCard");
        processService.saveOrUpdate(processEntity);

        //招标文件下一步 专家评标 改招标状态 为专家评标中
        rmatInviteEntity.setTenderState(TenderStateEnum.专家评标中.getCode());
        rmatInviteEntity.setTenderStage(com.ejianc.business.tender.sub.vo.TenderStageEnum.EXPERT_STATE.getTenderTypeCode());
        rmatInviteEntity.setStopTime(null);
        rmatInviteService.saveOrUpdate(rmatInviteEntity);

        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        vo.setRentalType(rmatInviteEntity.getRentalType());
        vo.setBackType(rmatInviteEntity.getBackType());
        vo.setRentalStacking(rmatInviteEntity.getRentalStacking());
        vo.setBackStacking(rmatInviteEntity.getBackStacking());
        return vo;
    }

    //其他下一步
    @Override
    public ExpertEvaluatingVO otherNext(Long documentId) {
        ExpertEvaluatingEntity entity = new ExpertEvaluatingEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询文件主表信息
        OtherDocumentEntity otherDocumentEntity = otherDocumentService.selectById(documentId);
//查询招标立项
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherDocumentEntity.getInviteId());
        //更新下一步状态
        otherDocumentEntity.setNextFlag(0);
        otherDocumentService.updateById(otherDocumentEntity);

        LambdaQueryWrapper<OtherTalkEntity> lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(OtherTalkEntity::getBillId, documentId);
        OtherTalkEntity otherTalkEntity = otherTalkMapper.selectOne(lambdaTalk);
        if (null != otherTalkEntity) {
            otherTalkEntity.setNextFlag(0);
            otherTalkMapper.updateById(otherTalkEntity);
        }
        //复制主表信息
        entity.setProjectId(otherDocumentEntity.getProjectId());
        entity.setProjectName(otherDocumentEntity.getProjectName());
        entity.setPurchaseType(otherDocumentEntity.getPurchaseType());
        entity.setOrgId(otherDocumentEntity.getOrgId());
        entity.setOrgName(otherDocumentEntity.getOrgName());
        entity.setParentOrgId(otherDocumentEntity.getParentOrgId());
        entity.setParentOrgName(otherDocumentEntity.getParentOrgName());
        entity.setProjectCode(otherDocumentEntity.getProjectCode());
        entity.setEvaluationName(otherDocumentEntity.getDocumentName());
        entity.setEmployeeId(otherDocumentEntity.getEmployeeId());
        entity.setEmployeeName(otherDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        entity.setInviteId(otherDocumentEntity.getInviteId());
        entity.setDocumentId(otherDocumentEntity.getId());
        entity.setPurchaseType(otherDocumentEntity.getPurchaseType());
        entity.setUnitId(otherInviteEntity.getUnitId());
        entity.setUnitName(otherInviteEntity.getUnitName());
        entity.setGatherStatus(0);
        entity.setInviteType(5);//招标类型
        entity.setDistinctionFlag(1);
        entity.setFlagNew(1);
        entity.setChangeVersion(1);
        //复制子表
        if (CollectionUtils.isNotEmpty(otherDocumentEntity.getExpertVOList())) {
            List<ExpertEvaluatingDetailEntity> detailEntities = BeanMapper.mapList(otherDocumentEntity.getExpertVOList(), ExpertEvaluatingDetailEntity.class);
            for (ExpertEvaluatingDetailEntity evaluationDetailEntity : detailEntities) {
                evaluationDetailEntity.setId(null);
                evaluationDetailEntity.setEvaluationState(0);
                evaluationDetailEntity.setLeader(1);
            }
            entity.setStuffEvaluationDetailEntities(detailEntities);
        }
        service.saveOrUpdate(entity, false);
        //回写招标阶段
//        Integer tenderStage = 4;
//        otherInviteService.updateTenderStage(String.valueOf(otherDocumentEntity.getInviteId()), tenderStage);
//        回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("专家评标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(5);
        processEntity.setFrontendUrl("stuff/evaluationCard");
        processService.saveOrUpdate(processEntity);

        //招标文件下一步 专家评标 改招标状态 为专家评标中
        otherInviteEntity.setTenderState(TenderStateEnum.专家评标中.getCode());
        otherInviteEntity.setTenderStage(com.ejianc.business.tender.sub.vo.TenderStageEnum.EXPERT_STATE.getTenderTypeCode());
        otherInviteEntity.setStopTime(null);
        otherInviteService.saveOrUpdate(otherInviteEntity);

        ExpertEvaluatingVO vo = BeanMapper.map(entity, ExpertEvaluatingVO.class);
        return vo;
    }
    /* 评标进度报表*/
    @Override
    public List<ProgressSheetVO> queryProgressSheet(QueryWrapper queryWrapper,Page<ProgressSheetVO> page) {
        return baseMapper.queryProgressSheet(queryWrapper,page);
    }
}
