package com.ejianc.business.tender.expert.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import com.ejianc.business.tender.expert.bean.ExpertEntity;
import com.ejianc.business.tender.expert.service.IExpertService;
import com.ejianc.business.tender.expert.vo.ExpertFieldDetailVO;
import com.ejianc.business.tender.stuff.bean.StuffTalkEntity;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.expert.mapper.ExpertFieldDetailMapper;
import com.ejianc.business.tender.expert.bean.ExpertFieldDetailEntity;
import com.ejianc.business.tender.expert.service.IExpertFieldDetailService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 专家领域表
 * 
 * @author generator
 * 
 */
@Service("expertFieldDetailService")
public class ExpertFieldDetailServiceImpl extends BaseServiceImpl<ExpertFieldDetailMapper, ExpertFieldDetailEntity> implements IExpertFieldDetailService{

    @Autowired
    private IExpertFieldDetailService service;
    @Autowired
    private IExpertService expertService;
    @Override
    public void saveOrUpdate(Long expertId,String fieldName) {
        //如果是修改先删除之前的在新增
        LambdaQueryWrapper<ExpertFieldDetailEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertFieldDetailEntity::getExpertId,expertId);
        List<ExpertFieldDetailEntity> list = service.list(lambda);
        if(CollectionUtil.isNotEmpty(list)){
            service.removeByIds(list.stream().map(ExpertFieldDetailEntity::getId).collect(Collectors.toList()),true);
        }
        String[] split = fieldName.split("、");
        ArrayList<ExpertFieldDetailEntity> expertFieldDetailEntities = new ArrayList<>();
        for (String s : split) {
            ExpertFieldDetailEntity expertFieldDetailEntity = new ExpertFieldDetailEntity();
            expertFieldDetailEntity.setExpertId(expertId);
            expertFieldDetailEntity.setFieldName(s);
            expertFieldDetailEntities.add(expertFieldDetailEntity);
        }
        service.saveOrUpdateBatch(expertFieldDetailEntities, expertFieldDetailEntities.size(), false);
    }

    @Override
    public void removes(List<Long> expertIds) {
        LambdaQueryWrapper<ExpertFieldDetailEntity> lambda = Wrappers.lambdaQuery();
        lambda.in(ExpertFieldDetailEntity::getExpertId,expertIds);
        lambda.eq(ExpertFieldDetailEntity::getDr, 0);
        List<ExpertFieldDetailEntity> list = service.list(lambda);
        service.removeByIds(list.stream().map(ExpertFieldDetailEntity::getId).collect(Collectors.toList()),true);
    }

    @Override
    public List<Long> queryExpertIds(String fieldNames) {
        String[] split = fieldNames.split("、");
        LambdaQueryWrapper<ExpertFieldDetailEntity> lambda = Wrappers.lambdaQuery();
        lambda.in(ExpertFieldDetailEntity::getFieldName,split);
        List<ExpertFieldDetailEntity> list = service.list(lambda);
        List<Long> expertIds = new ArrayList();
        if(CollectionUtil.isNotEmpty(list)){
            expertIds = list.stream().map(ExpertFieldDetailEntity::getExpertId).distinct().collect(Collectors.toList());
        }
        return expertIds;
    }
//查询符合邻域的专家
    @Override
    public List<String> queryExpertIdsTwo(String fieldNames) {
        String[] split = fieldNames.split("、");
        LambdaQueryWrapper<ExpertFieldDetailEntity> lambda = Wrappers.lambdaQuery();
        lambda.in(ExpertFieldDetailEntity::getFieldName,split);
        List<ExpertFieldDetailEntity> list = service.list(lambda);
        List<String> collect1 = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(list)){
            List<Long> collect = list.stream().map(ExpertFieldDetailEntity::getExpertId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
            expertLambda.in(ExpertEntity::getExpertId, collect);
            expertLambda.in(ExpertEntity::getBillState, 1,3);
            expertLambda.eq(ExpertEntity::getState, 0);
            expertLambda.eq(ExpertEntity::getEmployeeType, 1);//edit by sunyj
            List<ExpertEntity> expertEntityList = expertService.list(expertLambda);
            List<Long> collect2 = expertEntityList.stream().map(ExpertEntity::getExpertId).distinct().collect(Collectors.toList());
            collect1 = collect2.stream().map(x -> x + "").distinct().collect(Collectors.toList());
        }
        return collect1;
    }
}
