package com.ejianc.business.tender.expert.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSchemeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSchemeMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSupplierMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentBidService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSchemeService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.business.tender.expert.bean.*;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.mapper.ExpertRecordScoreMapper;
import com.ejianc.business.tender.expert.mapper.ExpertEvaluatingMapper;
import com.ejianc.business.tender.expert.service.*;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingDetailVO;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingVO;
import com.ejianc.business.tender.expert.vo.ExpertRecordScoreVO;
import com.ejianc.business.tender.other.bean.OtherDocumentSchemeEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.mapper.OtherDocumentSchemeMapper;
import com.ejianc.business.tender.other.mapper.OtherDocumentSupplierMapper;
import com.ejianc.business.tender.other.service.IOtherDocumentSchemeService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.rent.bean.RentDocumentSchemeEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.mapper.RentDocumentSchemeMapper;
import com.ejianc.business.tender.rent.mapper.RentDocumentSupplierMapper;
import com.ejianc.business.tender.rent.service.IRentDocumentSchemeService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSchemeEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSchemeMapper;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSupplierMapper;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSchemeService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.mapper.*;
import com.ejianc.business.tender.expert.vo.ExpertRecordVO;
import com.ejianc.business.tender.expert.mapper.TemplateDetailMapper;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSchemeService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSchemeEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.mapper.SubDocumentSchemeMapper;
import com.ejianc.business.tender.sub.mapper.SubDocumentSupplierMapper;
import com.ejianc.business.tender.sub.service.ISubDocumentSchemeService;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 评标记录表
 *
 * @author generator
 */
@Service("expertRecordService")
public class ExpertRecordServiceImpl extends BaseServiceImpl<ExpertRecordMapper, ExpertRecordEntity> implements IExpertRecordService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    StuffDocumentSchemeMapper schemeMapper;
    @Autowired
    private IStuffDocumentSchemeService stuffDocumentSchemeService;
    @Autowired
    private ISubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;

    @Autowired
    StuffDocumentSupplierMapper supplierMapper;

    @Autowired
    SubDocumentSchemeMapper subSchemeMapper;

    @Autowired
    EquipmentDocumentSchemeMapper equipmentDocumentSchemeMapper;

    @Autowired
    RentDocumentSchemeMapper rentDocumentSchemeMapper;

    @Autowired
    RmatDocumentSchemeMapper rmatDocumentSchemeMapper;

    @Autowired
    OtherDocumentSchemeMapper otherDocumentSchemeMapper;

    @Autowired
    SubDocumentSupplierMapper subSupplierMapper;

    @Autowired
    EquipmentDocumentSupplierMapper equipmentDocumentSupplierMapper;

    @Autowired
    RentDocumentSupplierMapper rentDocumentSupplierMapper;

    @Autowired
    RmatDocumentSupplierMapper rmatDocumentSupplierMapper;

    @Autowired
    OtherDocumentSupplierMapper otherDocumentSupplierMapper;


    @Autowired
    TemplateDetailMapper templateDetailMapper;

    @Autowired
    ExpertRecordScoreMapper scoreMapper;

    @Autowired
    StuffDocumentSellMapper sellMapper;

    @Autowired
    ExpertEvaluatingMapper evaluationMapper;

    @Autowired
    private IExpertRecordScoreService recordScoreService;

    @Autowired
    private IExpertRecordService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IStuffDocumentService documentService;

    @Autowired
    private ISubDocumentService subDocumentService;

    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;

    @Autowired
    private IRentDocumentService rentDocumentService;

    @Autowired
    private IRmatDocumentService rmatDocumentService;

    @Autowired
    private IOtherDocumentService otherDocumentService;

    @Autowired
    private IExpertRecordTotalService totalService;

    @Autowired
    private IExpertService expertService;

    @Autowired
    private IStuffInviteService stuffInviteService;

    @Autowired
    private ISubInviteService subInviteService;

    @Autowired
    private IEquipmentInviteService equipmentInviteService;

    @Autowired
    private IRentInviteService rentInviteService;

    @Autowired
    private IRmatInviteService rmatInviteService;

    @Autowired
    private IOtherInviteService otherInviteService;

    @Autowired
    private IExpertEvaluatingDetailService expertEvaluatingDetailService;

    @Override
    public List<StuffDocumentSupplierEntity> selectSupplierList(Long documentId, Integer talkNum) {
        return supplierMapper.selectSupplierList(documentId,talkNum);
    }

    @Override
    public List<StuffDocumentSchemeEntity> selectSchemeList(Long id, Long supplierId) {
        return schemeMapper.selectSchemeList(id, supplierId);
    }

    @Override
    public List<TemplateDetailEntity> selectTemplateList(Long templateId) {
        return templateDetailMapper.selectTemplateList(templateId);
    }

    @Override
    public Integer selectExist(Long employeeId, Long evaluationId) {
        return baseMapper.selectCount(new QueryWrapper<ExpertRecordEntity>().eq("evaluation_id", evaluationId).eq("employee_id", employeeId).eq("dr", 0));
    }

    @Override
    public List<ExpertRecordVO> selectDetail() {
        return baseMapper.selectDetail();
    }

    @Override
    public List<ExpertRecordScoreEntity> selectScore(Long id) {
        return scoreMapper.selectList(new QueryWrapper<ExpertRecordScoreEntity>().eq("record_id", id).eq("dr", 0).isNotNull("scoring_template_detail_id"));
    }

    @Override
    public ExpertEvaluatingEntity selectEvaluation(Long id) {
        return evaluationMapper.selectById(id);
    }

    @Override
    public List<ExpertRecordVO> selectBySupplier(Long employeeId, Long documentId) {
        return baseMapper.selectBySupplier(employeeId, documentId);
    }

    @Override
    public List<List<ExpertRecordVO>> saveOrUpdateList(List<List<Map>> supplierDetail) {
        Boolean flag = true;
        List<List<ExpertRecordVO>> supplierDetail1 = new ArrayList<>();
        for (List<Map> stuffRecordVOList : supplierDetail) {
            List<ExpertRecordVO> expertRecordVOS = new ArrayList<>();
            for (Map stuffRecordVO : stuffRecordVOList) {
                ExpertRecordVO expertRecordVO1 = JSON.parseObject(JSON.toJSONString(stuffRecordVO), new TypeReference<ExpertRecordVO>() {
                });
                ExpertRecordEntity entity = BeanMapper.map(expertRecordVO1, ExpertRecordEntity.class);
                service.saveOrUpdate(entity, false);
                ExpertRecordVO vo = BeanMapper.map(entity, ExpertRecordVO.class);
                List<ExpertRecordScoreVO> expertRecordScoreVOS = new ArrayList<>();
                if (recordScoreService.selectById(expertRecordVO1.getExpertRecordScoreVos().get(0).getId())!=null){
                    flag = false;
                }
                for (ExpertRecordScoreVO expertRecordScoreVo : expertRecordVO1.getExpertRecordScoreVos()) {
                    if (flag){
                        expertRecordScoreVo.setId(null);
                        expertRecordScoreVo.setCreateTime(null);
                        expertRecordScoreVo.setUpdateTime(null);
                    }
                    ExpertRecordScoreEntity entity0 = BeanMapper.map(expertRecordScoreVo, ExpertRecordScoreEntity.class);
                    entity0.setRecordId(vo.getId());
                    recordScoreService.saveOrUpdate(entity0, false);
                    ExpertRecordScoreVO expertRecordScoreVO = BeanMapper.map(entity0, ExpertRecordScoreVO.class);
                    List<ExpertRecordScoreVO> expertRecordScoreVOS1 = new ArrayList<>();
                    for (ExpertRecordScoreVO expertRecordScoreVo1 : expertRecordScoreVo.getExpertRecordScoreVOList()) {
                        if (flag){
                            expertRecordScoreVo1.setId(null);
                            expertRecordScoreVo1.setCreateTime(null);
                            expertRecordScoreVo1.setUpdateTime(null);
                        }
                        expertRecordScoreVo1.setRecordId(vo.getId());
                        expertRecordScoreVo1.setScoringTemplateDetailParentId(expertRecordScoreVo.getScoringTemplateDetailParentId()==null?null:expertRecordScoreVo.getScoringTemplateDetailParentId());
                        ExpertRecordScoreEntity entity1 = BeanMapper.map(expertRecordScoreVo1, ExpertRecordScoreEntity.class);
                        recordScoreService.saveOrUpdate(entity1, false);
                        expertRecordScoreVOS1.add(BeanMapper.map(entity1,ExpertRecordScoreVO.class));
                    }
                    expertRecordScoreVO.setExpertRecordScoreVOList(expertRecordScoreVOS1);
                    expertRecordScoreVOS.add(expertRecordScoreVO);
                }
                vo.setStuffRecordScoreVos(expertRecordScoreVOS);
                expertRecordVOS.add(vo);
            }
            supplierDetail1.add(expertRecordVOS);
        }
        return supplierDetail1;
    }

    @Override
    public Map<String, Object> querySupplierList(Long documentId, Long templateId, Long id) throws InvocationTargetException, IllegalAccessException {
        String employeeName = sessionManager.getUserContext().getEmployeeName();
        Long employeeId = sessionManager.getUserContext().getEmployeeId();
        Map<String, Object> detailMap = new HashMap<>();
        List<List<ExpertRecordVO>> lists = new ArrayList<>();
        //查询基本信息
        ExpertEvaluatingEntity evaluationDetail = service.selectEvaluation(id);
        ExpertEvaluatingVO expertEvaluatingVO = BeanMapper.map(evaluationDetail, ExpertEvaluatingVO.class);
        //根据专家查询备注信息
        ExpertEvaluatingDetailEntity evaluatingDetailEntity = expertEvaluatingDetailService.list(new QueryWrapper<ExpertEvaluatingDetailEntity>().eq("expert_id", employeeId).eq("evaluation_id",id)).get(0);
        ExpertEvaluatingDetailVO expertEvaluatingDetailVO = BeanMapper.map(evaluatingDetailEntity, ExpertEvaluatingDetailVO.class);

        //查询供应商报价
        //TODO 招标修改
        switch (evaluationDetail.getInviteType()){
            case 0:
                StuffDocumentVO sellDetail = documentService.queryDetailNum(documentId);
                detailMap.put("sellDetail", sellDetail);
                //赋值招标金额
                StuffInviteEntity inviteEntity = stuffInviteService.selectById(evaluationDetail.getInviteId());
                expertEvaluatingVO.setTenderMoney(inviteEntity.getTenderMoney());
                break;
            case 1:
                SubDocumentVO sellDetail1  = subDocumentService.queryDetailNum(documentId);
                detailMap.put("sellDetail", sellDetail1);
                //赋值招标金额
                SubInviteEntity subInviteEntity = subInviteService.selectById(evaluationDetail.getInviteId());
                expertEvaluatingVO.setTenderMoney(subInviteEntity.getTenderMoney());
                break;
            case 2:
                EquipmentDocumentVO sellDetail2  = equipmentDocumentService.queryDetailNum(documentId);
                detailMap.put("sellDetail", sellDetail2);
                //赋值招标金额
                EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(evaluationDetail.getInviteId());
                expertEvaluatingVO.setTenderMoney(equipmentInviteEntity.getTenderMoney());
                break;
            case 3:
                RentDocumentVO sellDetail3  = rentDocumentService.queryDetailNum(documentId);
                detailMap.put("sellDetail", sellDetail3);
                //赋值招标金额
                RentInviteEntity rentInviteEntity = rentInviteService.selectById(evaluationDetail.getInviteId());
                expertEvaluatingVO.setTenderMoney(rentInviteEntity.getTenderMoney());
                break;
            case 4:
                RmatDocumentVO sellDetail4  = rmatDocumentService.queryDetailNum(documentId);
                detailMap.put("sellDetail", sellDetail4);
                //赋值招标金额
                RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(evaluationDetail.getInviteId());
                expertEvaluatingVO.setTenderMoney(rmatInviteEntity.getTenderMoney());
                expertEvaluatingVO.setRentalType(rmatInviteEntity.getRentalType());
                expertEvaluatingVO.setBackType(rmatInviteEntity.getBackType());
                expertEvaluatingVO.setRentalStacking(rmatInviteEntity.getRentalStacking());
                expertEvaluatingVO.setBackStacking(rmatInviteEntity.getBackStacking());
                break;
            case 5:
                OtherDocumentVO sellDetail5  = otherDocumentService.queryDetailNum(documentId);
                detailMap.put("sellDetail", sellDetail5);
                //赋值招标金额
                OtherInviteEntity otherInviteEntity = otherInviteService.selectById(evaluationDetail.getInviteId());
                expertEvaluatingVO.setTenderMoney(otherInviteEntity.getTenderMoney());
                break;
        }
        //基本信息put
        if (evaluationDetail.getInviteType() == 3){
            RentInviteEntity rentInviteEntity = rentInviteService.selectById(evaluationDetail.getInviteId());
            expertEvaluatingVO.setRentType(rentInviteEntity.getRentType());
        }

        detailMap.put("evaluationDetail", expertEvaluatingVO);
        detailMap.put("expertEvaluatingDetailVO", expertEvaluatingDetailVO);
        //查询历史记录
        List<ExpertRecordTotalEntity> historyList = totalService.list(new QueryWrapper<ExpertRecordTotalEntity>().eq("employee_id", employeeId).eq("evaluation_id",id ));
        detailMap.put("historyList",historyList);
        if (service.selectExist(employeeId, id) == 0) {
            //查询评分指标
            List<TemplateDetailEntity> templateList = service.selectTemplateList(templateId);
            List<ExpertRecordScoreVO> expertRecordScoreVOS = new ArrayList<>();
            //查询专家类型符合模板
            if (evaluationDetail.getDistinctionFlag()==0){
                ExpertEntity expertEntity = expertService.list(new QueryWrapper<ExpertEntity>().eq("expert_id", employeeId)).get(0);
                templateList =  templateList.stream().filter(t->t.getScoringType().equals(expertEntity.getType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(templateList) && expertEntity.getType()==2){
                    templateList = service.selectTemplateList(templateId);
                }
            }
            for (TemplateDetailEntity templateDetail : templateList) {
                templateDetail.setCreateTime(null);
                templateDetail.setUpdateTime(null);
                ExpertRecordScoreVO stuffRecordScore = new ExpertRecordScoreVO();
                BeanUtils.copyProperties(stuffRecordScore, templateDetail);
                stuffRecordScore.setScoringTemplateDetailParentId(templateDetail.getId());
                stuffRecordScore.setScoringTemplateDetailId(templateDetail.getId());
                stuffRecordScore.setId(null);

                //模板详情
                List<TemplateDetailEntity>  stuffRecordDetailList =  service.selectTemplateDetail(templateDetail.getId());
                List<ExpertRecordScoreVO> scoreVOList = BeanMapper.mapList(stuffRecordDetailList, ExpertRecordScoreVO.class);
//                for (ExpertRecordScoreVO expertRecordScoreVO : scoreVOList) {
//                   expertRecordScoreVO.setId(null);
//                    expertRecordScoreVO.setCreateTime(null);
//                    expertRecordScoreVO.setUpdateTime(null);
//                }
                stuffRecordScore.setExpertRecordScoreVOList(scoreVOList);

                expertRecordScoreVOS.add(stuffRecordScore);
            }
            //查询供应商
            //TODO 招标修改
            if (evaluationDetail.getInviteType()==0){
                //获取最新轮数
                StuffDocumentSchemeEntity stuffDocumentSchemeEntity = stuffDocumentSchemeService.list(new QueryWrapper<StuffDocumentSchemeEntity>().eq("document_id", documentId).orderByDesc("talk_num")).get(0);
                Integer talkNum = stuffDocumentSchemeEntity.getTalkNum();
                List<StuffDocumentSupplierEntity> supplierList = service.selectSupplierList(documentId,talkNum);
                for (StuffDocumentSupplierEntity supplierEntity : supplierList) {
                    List<ExpertRecordVO> recordVOList = new ArrayList<>();
                    //查询方案
                    List<StuffDocumentSchemeEntity> schemeList = service.selectSchemeList(supplierEntity.getSupplierId(), documentId);
                    for (StuffDocumentSchemeEntity schemeEntity : schemeList) {
                        ExpertRecordVO expertRecordVO = new ExpertRecordVO();
                        expertRecordVO.setInviteId(evaluationDetail.getInviteId());
                        expertRecordVO.setTaxMemo(supplierEntity.getTaxMemo());
                        expertRecordVO.setDocumentId(documentId);
                        expertRecordVO.setSupplierId(supplierEntity.getSupplierId());
                        expertRecordVO.setSupplierName(supplierEntity.getSupplierName());
                        expertRecordVO.setEmployeeId(employeeId);
                        expertRecordVO.setEmployeeName(employeeName);
                        expertRecordVO.setTemplateId(templateId);
                        expertRecordVO.setDocumentSchemeId(schemeEntity.getId());
                        expertRecordVO.setSchemeName(schemeEntity.getSchemeName());
                        expertRecordVO.setStuffRecordScoreVos(expertRecordScoreVOS);
                        expertRecordVO.setMoney(schemeEntity.getMoney());
                        expertRecordVO.setMoneyTax(schemeEntity.getMoneyTax());
                        expertRecordVO.setEvaluationId(id);
                        recordVOList.add(expertRecordVO);
                    }
                    lists.add(recordVOList);
                }
            }else if (evaluationDetail.getInviteType()==1){
                //获取最新轮数
                SubDocumentSchemeEntity stuffDocumentSchemeEntity = subDocumentSchemeService.list(new QueryWrapper<SubDocumentSchemeEntity>().eq("document_id", documentId).orderByDesc("talk_num")).get(0);
                Integer talkNum = stuffDocumentSchemeEntity.getTalkNum();
                List<SubDocumentSupplierEntity> supplierList = service.selectSubSupplierList(documentId,talkNum);
                for (SubDocumentSupplierEntity supplierEntity : supplierList) {
                    List<ExpertRecordVO> recordVOList = new ArrayList<>();
                    //查询方案
                    List<SubDocumentSchemeEntity> schemeList = service.selectSubSchemeList(supplierEntity.getSupplierId(), documentId);
                    for (SubDocumentSchemeEntity schemeEntity : schemeList) {
                        ExpertRecordVO expertRecordVO = new ExpertRecordVO();
                        expertRecordVO.setInviteId(evaluationDetail.getInviteId());
                        expertRecordVO.setTaxMemo(supplierEntity.getTaxMemo());
                        expertRecordVO.setDocumentId(documentId);
                        expertRecordVO.setSupplierId(supplierEntity.getSupplierId());
                        expertRecordVO.setSupplierName(supplierEntity.getSupplierName());
                        expertRecordVO.setEmployeeId(employeeId);
                        expertRecordVO.setEmployeeName(employeeName);
                        expertRecordVO.setTemplateId(templateId);
                        expertRecordVO.setDocumentSchemeId(schemeEntity.getId());
                        expertRecordVO.setSchemeName(schemeEntity.getSchemeName());
                        expertRecordVO.setStuffRecordScoreVos(expertRecordScoreVOS);
                        expertRecordVO.setMoney(schemeEntity.getMoney());
                        expertRecordVO.setMoneyTax(schemeEntity.getMoneyTax());
                        expertRecordVO.setEvaluationId(id);
                        recordVOList.add(expertRecordVO);
                    }
                    lists.add(recordVOList);
                }
            }else if (evaluationDetail.getInviteType()==2){
                //获取最新轮数
                EquipmentDocumentSchemeEntity stuffDocumentSchemeEntity = equipmentDocumentSchemeService.list(new QueryWrapper<EquipmentDocumentSchemeEntity>().eq("document_id", documentId).orderByDesc("talk_num")).get(0);
                Integer talkNum = stuffDocumentSchemeEntity.getTalkNum();
                List<EquipmentDocumentSupplierEntity> supplierList = service.selectEquipmentSupplierList(documentId,talkNum);
                for (EquipmentDocumentSupplierEntity supplierEntity : supplierList) {
                    List<ExpertRecordVO> recordVOList = new ArrayList<>();
                    //查询方案
                    List<EquipmentDocumentSchemeEntity> schemeList = service.selectEquipmentSchemeList(supplierEntity.getSupplierId(), documentId);
                    for (EquipmentDocumentSchemeEntity schemeEntity : schemeList) {
                        ExpertRecordVO expertRecordVO = new ExpertRecordVO();
                        expertRecordVO.setInviteId(evaluationDetail.getInviteId());
                        expertRecordVO.setTaxMemo(supplierEntity.getTaxMemo());
                        expertRecordVO.setDocumentId(documentId);
                        expertRecordVO.setSupplierId(supplierEntity.getSupplierId());
                        expertRecordVO.setSupplierName(supplierEntity.getSupplierName());
                        expertRecordVO.setEmployeeId(employeeId);
                        expertRecordVO.setEmployeeName(employeeName);
                        expertRecordVO.setTemplateId(templateId);
                        expertRecordVO.setDocumentSchemeId(schemeEntity.getId());
                        expertRecordVO.setSchemeName(schemeEntity.getSchemeName());
                        expertRecordVO.setStuffRecordScoreVos(expertRecordScoreVOS);
                        expertRecordVO.setMoney(schemeEntity.getMoney());
                        expertRecordVO.setMoneyTax(schemeEntity.getMoneyTax());
                        expertRecordVO.setEvaluationId(id);
                        recordVOList.add(expertRecordVO);
                    }
                    lists.add(recordVOList);
                }
            }else if (evaluationDetail.getInviteType()==3){
                //获取最新轮数
                RentDocumentSchemeEntity stuffDocumentSchemeEntity = rentDocumentSchemeService.list(new QueryWrapper<RentDocumentSchemeEntity>().eq("document_id", documentId).orderByDesc("talk_num")).get(0);
                Integer talkNum = stuffDocumentSchemeEntity.getTalkNum();
                List<RentDocumentSupplierEntity> supplierList = service.selectRentSupplierList(documentId,talkNum);
                for (RentDocumentSupplierEntity supplierEntity : supplierList) {
                    List<ExpertRecordVO> recordVOList = new ArrayList<>();
                    //查询方案
                    List<RentDocumentSchemeEntity> schemeList = service.selectRentSchemeList(supplierEntity.getSupplierId(), documentId);
                    for (RentDocumentSchemeEntity schemeEntity : schemeList) {
                        ExpertRecordVO expertRecordVO = new ExpertRecordVO();
                        expertRecordVO.setInviteId(evaluationDetail.getInviteId());
                        expertRecordVO.setTaxMemo(supplierEntity.getTaxMemo());
                        expertRecordVO.setDocumentId(documentId);
                        expertRecordVO.setSupplierId(supplierEntity.getSupplierId());
                        expertRecordVO.setSupplierName(supplierEntity.getSupplierName());
                        expertRecordVO.setEmployeeId(employeeId);
                        expertRecordVO.setEmployeeName(employeeName);
                        expertRecordVO.setTemplateId(templateId);
                        expertRecordVO.setDocumentSchemeId(schemeEntity.getId());
                        expertRecordVO.setSchemeName(schemeEntity.getSchemeName());
                        expertRecordVO.setStuffRecordScoreVos(expertRecordScoreVOS);
                        expertRecordVO.setMoney(schemeEntity.getMoney());
                        expertRecordVO.setMoneyTax(schemeEntity.getMoneyTax());
                        expertRecordVO.setEvaluationId(id);
                        recordVOList.add(expertRecordVO);
                    }
                    lists.add(recordVOList);
                }
            }else if (evaluationDetail.getInviteType()==4){
                //获取最新轮数
                RmatDocumentSchemeEntity stuffDocumentSchemeEntity = rmatDocumentSchemeService.list(new QueryWrapper<RmatDocumentSchemeEntity>().eq("document_id", documentId).orderByDesc("talk_num")).get(0);
                Integer talkNum = stuffDocumentSchemeEntity.getTalkNum();
                List<RmatDocumentSupplierEntity> supplierList = service.selectRmatSupplierList(documentId,talkNum);
                for (RmatDocumentSupplierEntity supplierEntity : supplierList) {
                    List<ExpertRecordVO> recordVOList = new ArrayList<>();
                    //查询方案
                    List<RmatDocumentSchemeEntity> schemeList = service.selectRmatSchemeList(supplierEntity.getSupplierId(), documentId);
                    for (RmatDocumentSchemeEntity schemeEntity : schemeList) {
                        ExpertRecordVO expertRecordVO = new ExpertRecordVO();
                        expertRecordVO.setInviteId(evaluationDetail.getInviteId());
                        expertRecordVO.setTaxMemo(supplierEntity.getTaxMemo());
                        expertRecordVO.setDocumentId(documentId);
                        expertRecordVO.setSupplierId(supplierEntity.getSupplierId());
                        expertRecordVO.setSupplierName(supplierEntity.getSupplierName());
                        expertRecordVO.setEmployeeId(employeeId);
                        expertRecordVO.setEmployeeName(employeeName);
                        expertRecordVO.setTemplateId(templateId);
                        expertRecordVO.setDocumentSchemeId(schemeEntity.getId());
                        expertRecordVO.setSchemeName(schemeEntity.getSchemeName());
                        expertRecordVO.setStuffRecordScoreVos(expertRecordScoreVOS);
                        expertRecordVO.setMoney(schemeEntity.getMoney());
                        expertRecordVO.setMoneyTax(schemeEntity.getMoneyTax());
                        expertRecordVO.setEvaluationId(id);
                        recordVOList.add(expertRecordVO);
                    }
                    lists.add(recordVOList);
                }
            }else if (evaluationDetail.getInviteType()==5){
                //获取最新轮数
                OtherDocumentSchemeEntity stuffDocumentSchemeEntity = otherDocumentSchemeService.list(new QueryWrapper<OtherDocumentSchemeEntity>().eq("document_id", documentId).orderByDesc("talk_num")).get(0);
                Integer talkNum = stuffDocumentSchemeEntity.getTalkNum();
                List<OtherDocumentSupplierEntity> supplierList = service.selectOtherSupplierList(documentId,talkNum);
                for (OtherDocumentSupplierEntity supplierEntity : supplierList) {
                    List<ExpertRecordVO> recordVOList = new ArrayList<>();
                    //查询方案
                    List<OtherDocumentSchemeEntity> schemeList = service.selectOtherSchemeList(supplierEntity.getSupplierId(), documentId);
                    for (OtherDocumentSchemeEntity schemeEntity : schemeList) {
                        ExpertRecordVO expertRecordVO = new ExpertRecordVO();
                        expertRecordVO.setInviteId(evaluationDetail.getInviteId());
                        expertRecordVO.setTaxMemo(supplierEntity.getTaxMemo());
                        expertRecordVO.setDocumentId(documentId);
                        expertRecordVO.setSupplierId(supplierEntity.getSupplierId());
                        expertRecordVO.setSupplierName(supplierEntity.getSupplierName());
                        expertRecordVO.setEmployeeId(employeeId);
                        expertRecordVO.setEmployeeName(employeeName);
                        expertRecordVO.setTemplateId(templateId);
                        expertRecordVO.setDocumentSchemeId(schemeEntity.getId());
                        expertRecordVO.setSchemeName(schemeEntity.getSchemeName());
                        expertRecordVO.setStuffRecordScoreVos(expertRecordScoreVOS);
                        expertRecordVO.setMoney(schemeEntity.getMoney());
                        expertRecordVO.setMoneyTax(schemeEntity.getMoneyTax());
                        expertRecordVO.setEvaluationId(id);
                        recordVOList.add(expertRecordVO);
                    }
                    lists.add(recordVOList);
                }
            }

            detailMap.put("supplierDetail", lists);
            return detailMap;
        }
        List<ExpertRecordEntity> recordEntityList = service.list(new QueryWrapper<ExpertRecordEntity>().eq("evaluation_id", id).eq("employee_id", employeeId));
        List<ExpertRecordVO> recordVOList = BeanMapper.mapList(recordEntityList, ExpertRecordVO.class);
        List<ExpertRecordVO> recordVOList1;
        Map<Long,List<ExpertRecordVO>> addMap = new HashMap<>();
        ArrayList<String> scoringRubricsList = new ArrayList<>();
        for (ExpertRecordVO recordVO : recordVOList) {
            // 是否已经添加，添加过的取原来的方案list，在后添加方案，否则就是新的list
            boolean addFlag = addMap.containsKey(recordVO.getSupplierId());
            if (addFlag){
                recordVOList1 = addMap.get(recordVO.getSupplierId());
            } else {
                recordVOList1 = new ArrayList<>();
            }
            //查出所有子表数据
            List<ExpertRecordScoreEntity> scoreVOList = service.selectScore(recordVO.getId());
            List<ExpertRecordScoreVO> scoreVOList2 = BeanMapper.mapList(scoreVOList, ExpertRecordScoreVO.class);
            for (ExpertRecordScoreVO expertRecordScoreVO : scoreVOList2) {
                List<ExpertRecordScoreVO>  scoreVOList3 = service.selectByParentId(expertRecordScoreVO.getScoringTemplateDetailParentId(),recordVO.getId());
                expertRecordScoreVO.setExpertRecordScoreVOList(scoreVOList3);
            }
            recordVO.setStuffRecordScoreVos(scoreVOList2);
            recordVOList1.add(recordVO);
            // 未添加到map，代表首次查询，添加到map中
            if (!addFlag) {
                addMap.put(recordVO.getSupplierId(),recordVOList1);
            }
//            lists.add(recordVOList1);
        }
        // 循环处理供应商及报价信息
        for (Map.Entry<Long,List<ExpertRecordVO>> entry: addMap.entrySet()) {
            lists.add(entry.getValue());
        }
        if (CollectionUtils.isNotEmpty(lists)){
        for (ExpertRecordVO recordVO : lists.get(0)) {
            for (ExpertRecordScoreVO expertRecordScoreVo : recordVO.getExpertRecordScoreVos()) {
                for (ExpertRecordScoreVO recordScoreVO : expertRecordScoreVo.getExpertRecordScoreVOList()) {
                    scoringRubricsList.add(recordScoreVO.getScoringRubrics());
                    logger.info("评分标准排列顺序=================="+JSONObject.toJSONString(scoringRubricsList));
                }
            }
        }
        }
            for (List<ExpertRecordVO> list : lists) {
                for (ExpertRecordVO recordVO : list) {
                    for (ExpertRecordScoreVO expertRecordScoreVo : recordVO.getExpertRecordScoreVos()) {
                        List<ExpertRecordScoreVO> scoreVOList = expertRecordScoreVo.getExpertRecordScoreVOList();
                        List<ExpertRecordScoreVO> scoreVOList1 = new ArrayList<>();
                        Map<String, ExpertRecordScoreVO> map = scoreVOList.stream().collect(Collectors.toMap(ExpertRecordScoreVO::getScoringRubrics, Function.identity()));
                        for (String s : scoringRubricsList) {
                            if(map.containsKey(s)){
                                scoreVOList1.add(map.get(s));
                            }
                        }
                        expertRecordScoreVo.getExpertRecordScoreVOList().clear();
                        expertRecordScoreVo.setExpertRecordScoreVOList(scoreVOList1);
                        logger.info("排列后的数据"+JSONObject.toJSONString(scoreVOList1));
                    }
                }
            }
        detailMap.put("supplierDetail", lists);
        return detailMap;
    }

    @Override
    public List<TemplateDetailEntity> selectTemplateDetail(Long parentId) {
        return templateDetailMapper.selectList(new QueryWrapper<TemplateDetailEntity>().eq("parent_id",parentId).eq("dr",0));
    }

    @Override
    public List<ExpertRecordScoreVO> selectByParentId(Long scoringTemplateDetailParentId,Long recordId) {
        return BeanMapper.mapList(recordScoreService.list(new QueryWrapper<ExpertRecordScoreEntity>().eq("scoring_template_detail_parent_id",scoringTemplateDetailParentId).eq("record_id",recordId).isNull("scoring_template_detail_id").orderBy(true,true,"scoring_rubrics")),ExpertRecordScoreVO.class);
    }

    @Override
    public List<List<ExpertRecordVO>> queryDetail(Long evaluationId, Long expertId) {
        List<List<ExpertRecordVO>> lists = new ArrayList<>();
        List<ExpertRecordEntity> recordEntityList = service.list(new QueryWrapper<ExpertRecordEntity>().eq("evaluation_id", evaluationId).eq("employee_id", expertId));
        List<ExpertRecordVO> recordVOList = BeanMapper.mapList(recordEntityList, ExpertRecordVO.class);
        List<ExpertRecordVO> recordVOList1;
        Map<Long,List<ExpertRecordVO>> addMap = new HashMap<>();
        for (ExpertRecordVO recordVO : recordVOList) {
            // 是否已经添加，添加过的取原来的方案list，在后添加方案，否则就是新的list
            boolean addFlag = addMap.containsKey(recordVO.getSupplierId());
            if (addFlag){
                recordVOList1 = addMap.get(recordVO.getSupplierId());
            } else {
                recordVOList1 = new ArrayList<>();
            }
            //查出所有子表数据
            List<ExpertRecordScoreEntity> scoreVOList = service.selectScore(recordVO.getId());
            List<ExpertRecordScoreVO> scoreVOList2 = BeanMapper.mapList(scoreVOList, ExpertRecordScoreVO.class);
            for (ExpertRecordScoreVO expertRecordScoreVO : scoreVOList2) {
                List<ExpertRecordScoreVO>  scoreVOList3 = service.selectByParentId(expertRecordScoreVO.getScoringTemplateDetailParentId(),recordVO.getId());
                expertRecordScoreVO.setExpertRecordScoreVOList(scoreVOList3);
            }
            recordVO.setStuffRecordScoreVos(scoreVOList2);
            recordVOList1.add(recordVO);
            // 未添加到map，代表首次查询，添加到map中
            if (!addFlag) {
                addMap.put(recordVO.getSupplierId(),recordVOList1);
            }
//            lists.add(recordVOList1);
        }
        // 循环处理供应商及报价信息
        for (Map.Entry<Long,List<ExpertRecordVO>> entry: addMap.entrySet()) {
            lists.add(entry.getValue());
        }
        return lists;
    }

    @Override
    public List<SubDocumentSupplierEntity> selectSubSupplierList(Long documentId,Integer talkNum) {
        return subSupplierMapper.selectSubSupplierList(documentId,talkNum);
    }

    @Override
    public List<SubDocumentSchemeEntity> selectSubSchemeList(Long id,Long supplierId) {
        return subSchemeMapper.selectSubSchemeList(id,supplierId);
    }

    @Override
    public List<EquipmentDocumentSupplierEntity> selectEquipmentSupplierList(Long documentId,Integer talkNum) {
        return equipmentDocumentSupplierMapper.selectEquipmentSupplierList(documentId,talkNum);
    }

    @Override
    public List<EquipmentDocumentSchemeEntity> selectEquipmentSchemeList(Long id,Long supplierId) {
        return equipmentDocumentSchemeMapper.selectEquipmentSchemeList(id,supplierId);
    }

    @Override
    public List<RentDocumentSupplierEntity> selectRentSupplierList(Long documentId,Integer talkNum) {
        return rentDocumentSupplierMapper.selectRentSupplierList(documentId,talkNum);
    }

    @Override
    public List<RentDocumentSchemeEntity> selectRentSchemeList(Long id, Long supplierId) {
        return rentDocumentSchemeMapper.selectRentSchemeList(id,supplierId);
    }

    @Override
    public List<RmatDocumentSupplierEntity> selectRmatSupplierList(Long documentId,Integer talkNum) {
        return rmatDocumentSupplierMapper.selectRmatSupplierList(documentId,talkNum);
    }

    @Override
    public List<RmatDocumentSchemeEntity> selectRmatSchemeList(Long id, Long supplierId) {
        return rmatDocumentSchemeMapper.selectRmatSchemeList(id,supplierId);
    }

    @Override
    public List<OtherDocumentSupplierEntity> selectOtherSupplierList(Long documentId,Integer talkNum) {
        return otherDocumentSupplierMapper.selectOtherSupplierList(documentId,talkNum);
    }

    @Override
    public List<OtherDocumentSchemeEntity> selectOtherSchemeList(Long id, Long supplierId) {
        return otherDocumentSchemeMapper.selectOtherSchemeList(id,supplierId);
    }
}

