package com.ejianc.business.tender.expert.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentAdviceService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.impl.EquipmentAdviceBpmServiceImpl;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.RandomRuleEntity;
import com.ejianc.business.tender.expert.service.IExpertFieldDetailService;
import com.ejianc.business.tender.expert.service.IRandomRuleService;
import com.ejianc.business.tender.expert.vo.*;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherAdviceService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentAdviceService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.expert.mapper.ExpertMapper;
import com.ejianc.business.tender.expert.bean.ExpertEntity;
import com.ejianc.business.tender.expert.service.IExpertService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 专家库主表
 * 
 * @author generator
 * 
 */
@Service("expertService")
public class ExpertServiceImpl extends BaseServiceImpl<ExpertMapper, ExpertEntity> implements IExpertService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IStuffInviteService stuffInviteService;//材料招标立项
    @Autowired
    private ISubInviteService subInviteService;//分包招标立项
    @Autowired
    private IEquipmentInviteService equipmentInviteService;//设备采购招标立项
    @Autowired
    private IRentInviteService rentInviteService;//设备租赁招标立项
    @Autowired
    private IRmatInviteService rmatInviteService;//周转材招标立项
    @Autowired
    private IOtherInviteService otherInviteService;//其他招标立项
    @Autowired
    private IEmployeeApi employeeApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "EXPERT_CODE";//此处需要根据实际修改
    @Autowired
    private IExpertService service;
    @Autowired
    private IRandomRuleService randomRuleService;
    @Autowired
    private IExpertFieldDetailService expertFieldDetailService;
    @Autowired
    private ExpertEvaluatingDetailServiceImpl expertEvaluatingDetailService ;
    @Value("${parentOrgId.wztgzx}")
    private Long wztgzx;//物资统购中心部门id
    @Value("${parentOrgId.bjkj}")
    private Long bjkj;
    @Value("${parentOrgId.bjkjName}")
    private String bjkjName;

    @Override
    public Boolean dislodge(Long expertId) {
        LambdaQueryWrapper<ExpertEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertEntity::getExpertId,expertId);
        List<ExpertEntity> expertEntities = baseMapper.selectList(lambda);
        if(CollectionUtil.isNotEmpty(expertEntities)){
            return false;
        }
        return true;
    }

    @Override
    public List<ExpertVO> randomSelectPlus(Integer expertNum, List<ExpertVO> expertVOS,Long inviteId,Integer inviteType) {
        List<RandomRuleVO> randomRuleVOList = this.randomPlus(inviteId, inviteType);
        Collections.shuffle(randomRuleVOList);//打乱顺序
        List<String> oExpertIdList = expertVOS.stream().filter(item->null!=item.getExpertId()).map(item->item.getExpertId().toString()).distinct().collect(Collectors.toList());
        List<String> nExpertIdList = new ArrayList<String>();//新专家列表
        for (RandomRuleVO randomRuleVO : randomRuleVOList) {
            //更新数据
            for (String s : oExpertIdList) {
                if(randomRuleVO.getRandomExpertIdStore().contains(s)){
                    randomRuleVO.getRandomExpertIdStore().remove(s);
                    if(randomRuleVO.getNum()>0){
                        randomRuleVO.setNum(randomRuleVO.getNum()-1);
                    }
                }
            }
            while (nExpertIdList.size()< expertNum && randomRuleVO.getRandomExpertIdStore().size()!=0 && randomRuleVO.getNum()>0) {
                randomRuleVO.setNum(randomRuleVO.getNum()-1);
                List<String> expertIdStore = new ArrayList<>(randomRuleVO.getRandomExpertIdStore());
                int randomIndex = (int) (Math.floor(Math.random() * expertIdStore.size()));
                nExpertIdList.add(expertIdStore.get(randomIndex));
                oExpertIdList.add(expertIdStore.get(randomIndex));
                randomRuleVO.getRandomExpertIdStore().remove(expertIdStore.get(randomIndex));//排除最新抽取的
            }
        }
        List<Long> expertIds = nExpertIdList.stream().map(v -> Long.valueOf(v)).distinct().collect(Collectors.toList());
        List<ExpertEntity> list = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(expertIds)){
            LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
            expertLambda.in(ExpertEntity::getExpertId, expertIds);
            list.addAll(service.list(expertLambda));
        }
        if(nExpertIdList.size()<expertNum){//有剩余再随机
            LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
            expertLambda.in(ExpertEntity::getBillState, 1,3);
            expertLambda.eq(ExpertEntity::getState, 0);
            expertLambda.eq(ExpertEntity::getEmployeeType, 1);//edit by sunyj
            if(CollectionUtil.isNotEmpty(oExpertIdList)){
                expertLambda.notIn(ExpertEntity::getExpertId, oExpertIdList.stream().map(v -> Long.valueOf(v)).distinct().collect(Collectors.toList()));
            }
            List<ExpertEntity> expertEntities = this.randomList(expertNum-nExpertIdList.size(), service.list(expertLambda));
            list.addAll(expertEntities);
        }
        return BeanMapper.mapList(list, ExpertVO.class);
    }
    //plus抽取公用方法
    public List<RandomRuleVO> randomPlus(Long inviteId,Integer inviteType){
        logger.info("招标立项id:{},立项类型：{}",inviteId,inviteType);
        Long orgId = null;
        String contractType = "";//合同类型 合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
        String purchaseId= "";// 采购方式ID/供货内容
        /**
         * 材料-MATERIAL,分包-SUB，设备采购-PURCHASE,设备租赁-RENT,周转材租赁-RMAT,其他-OTHER
         *
         * @param type 招标立项类型  0-材料,1-.....
         * @return 供应商材料类型
         */
        switch (inviteType) {
            case CommonUtils.TYPE_MATERIAL:
            {//"材料招标"
                StuffInviteEntity inviteEntity = stuffInviteService.selectById(inviteId);
                logger.info(CommonUtils.getTypeName(inviteType)+"招标立项数据:"+JSONObject.toJSONString(inviteEntity));
                orgId = inviteEntity.getParentOrgId() != null ? inviteEntity.getParentOrgId() : inviteEntity.getOrgId();//没有上级组织去本身
                contractType = inviteEntity.getContractType();
            }
            break;
            case CommonUtils.TYPE_SUB:
            {//分包招标
                SubInviteEntity inviteEntity = subInviteService.selectById(inviteId);
                logger.info(CommonUtils.getTypeName(inviteType)+"招标立项数据:"+JSONObject.toJSONString(inviteEntity));
                orgId = inviteEntity.getParentOrgId() != null ? inviteEntity.getParentOrgId() : inviteEntity.getOrgId();//没有上级组织去本身
            }
            break;
            case CommonUtils.TYPE_EQUIPMENT:
            {//设备采购
                EquipmentInviteEntity inviteEntity = equipmentInviteService.selectById(inviteId);
                logger.info(CommonUtils.getTypeName(inviteType)+"招标立项数据:"+JSONObject.toJSONString(inviteEntity));
                orgId = inviteEntity.getParentOrgId() != null ? inviteEntity.getParentOrgId() : inviteEntity.getOrgId();//没有上级组织去本身
                purchaseId = inviteEntity.getPurchaseId();
            }
            break;
            case CommonUtils.TYPE_RENT:
            {//设备租赁
                RentInviteEntity inviteEntity = rentInviteService.selectById(inviteId);
                logger.info(CommonUtils.getTypeName(inviteType)+"招标立项数据:"+JSONObject.toJSONString(inviteEntity));
                orgId = inviteEntity.getParentOrgId() != null ? inviteEntity.getParentOrgId() : inviteEntity.getOrgId();//没有上级组织去本身
                purchaseId = inviteEntity.getPurchaseId();
            }
            break;
            case CommonUtils.TYPE_RMAT:
            {//周转材租赁
                RmatInviteEntity inviteEntity = rmatInviteService.selectById(inviteId);
                logger.info(CommonUtils.getTypeName(inviteType)+"招标立项数据:"+JSONObject.toJSONString(inviteEntity));
                orgId = inviteEntity.getParentOrgId() != null ? inviteEntity.getParentOrgId() : inviteEntity.getOrgId();//没有上级组织去本身
            }
            break;
            case CommonUtils.TYPE_OTHER:
            {//其他
                OtherInviteEntity inviteEntity = otherInviteService.selectById(inviteId);
                logger.info(CommonUtils.getTypeName(inviteType)+"招标立项数据:"+JSONObject.toJSONString(inviteEntity));
                orgId = inviteEntity.getParentOrgId() != null ? inviteEntity.getParentOrgId() : inviteEntity.getOrgId();//没有上级组织去本身
            }
            break;
            default:
                throw new BusinessException("招标立项类型不存在[" + inviteType + "]");
        }
        if(null==orgId){
            throw new BusinessException("未获取到招标立项["+inviteId+"]类型[" + CommonUtils.getTypeName(inviteType) + "]的基层单位id!");
        }
        logger.info("基层单位id:{}",orgId);
        //根据类型获取抽取规则
        LambdaQueryWrapper<RandomRuleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RandomRuleEntity::getInviteType, inviteType);
        List<RandomRuleEntity> randomRuleList = randomRuleService.list(wrapper);
        if(CollectionUtil.isEmpty(randomRuleList)){
            throw new BusinessException("未查询到"+CommonUtils.getTypeName(inviteType)+"类型抽取规则！");
        }
        List<RandomRuleVO> randomRuleVOList= BeanMapper.mapList(randomRuleList,RandomRuleVO.class);
        List<RandomRuleVO> removeList = new ArrayList<>();

        for (RandomRuleVO randomRuleVO : randomRuleVOList) {//根据规则为抽取库赋值
            if(RandomRuleVO.FLAG_NO.equals(randomRuleVO.getFlag())){//不使用自定义赋值
                randomRuleVO.setTypeId(orgId);
            }
            if(RandomRuleVO.FLAG_YES.equals(randomRuleVO.getFiltrationFlag())){//规则开启过滤
                switch (inviteType) {//过滤抽取规则
                    case CommonUtils.TYPE_MATERIAL:
                    {//"材料招标"
                        if("辅料中心".equals(randomRuleVO.getFiltrationName())){//不为周转材过滤
                            if(!(randomRuleVO.getFiltration().equals(contractType))){//不为周转材过滤
                                removeList.add(randomRuleVO);
//                                randomRuleVOList.remove(randomRuleVO);
                            }
                        }
                    }
                    break;
                    case CommonUtils.TYPE_SUB:
                    {//分包招标

                    }
                    break;
                    case CommonUtils.TYPE_EQUIPMENT:
                    {//设备采购
                        if(null==purchaseId){
                            purchaseId = "";
                        }
                        if("机械设备租赁分公司".equals(randomRuleVO.getFiltrationName())){
                            String[] split = randomRuleVO.getFiltration().split(",");
                            for (String s : split) {
                                if(!(purchaseId.contains(s))){
                                    removeList.add(randomRuleVO);
//                                    randomRuleVOList.remove(randomRuleVO);
                                    break;
                                }
                            }
                        }
                    }
                    break;
                    case CommonUtils.TYPE_RENT:
                    {//设备租赁
                        if(StringUtils.isNotBlank(purchaseId)){
                            String[] split = purchaseId.split(",");
                            for (String s : split) {
                                if(!(purchaseId.contains(s) && "机械设备租赁分公司".equals(randomRuleVO.getFiltrationName()))){
                                    removeList.add(randomRuleVO);
//                                    randomRuleVOList.remove(randomRuleVO);
                                    break;
                                }
                            }
                        }
                    }
                    break;
                    case CommonUtils.TYPE_RMAT:
                    {//周转材租赁

                    }
                    break;
                    case CommonUtils.TYPE_OTHER:
                    {//其他

                    }
                    break;
                    default:
                        throw new BusinessException("招标立项类型不存在[" + inviteType + "]");
                }
            }
            switch (RandomRuleTypeEnum.getEnumByName(randomRuleVO.getType())){
                case 组织: randomRuleVO.setRandomExpertIdStore(getExpertIds(randomRuleVO.getTypeId()));break;
                case 部门: randomRuleVO.setRandomExpertIdStore(getDeptExpertIds(randomRuleVO.getTypeId()));break;
                case 领域: randomRuleVO.setRandomExpertIdStore(expertFieldDetailService.queryExpertIdsTwo(randomRuleVO.getTypeName()));break;
            }
        }
        logger.info("抽取规则删除："+JSONObject.toJSONString(removeList));
        randomRuleVOList.removeAll(removeList);
        logger.info("抽取规则："+JSONObject.toJSONString(randomRuleVOList));
        return randomRuleVOList;
    }
    @Override
    public List<String> checkOutPlus(List<ExpertVO> expertVOS, Long inviteId, Integer inviteType) {
        List<String> list = new ArrayList<>();//条件
        List<RandomRuleVO> randomRuleVOList = this.randomPlus(inviteId, inviteType);
//        Collections.shuffle(randomRuleVOList);//打乱顺序
        List<String> oExpertIdList = expertVOS.stream().filter(item->null!=item.getExpertId()).map(item->item.getExpertId().toString()).distinct().collect(Collectors.toList());
        for (RandomRuleVO randomRuleVO : randomRuleVOList) {
            //更新数据
            for (String s : oExpertIdList) {
                if(randomRuleVO.getRandomExpertIdStore().contains(s)){
                    randomRuleVO.getRandomExpertIdStore().remove(s);
                    if(randomRuleVO.getNum()>0){
                        randomRuleVO.setNum(randomRuleVO.getNum()-1);
                    }
                }
            }
            if(randomRuleVO.getNum()>0){
                switch (RandomRuleTypeEnum.getEnumByName(randomRuleVO.getType())){
                    case 组织: list.add("专家所属组织为”"+randomRuleVO.getTypeName()+"“缺少”"+randomRuleVO.getNum()+"人");;break;
                    case 部门: list.add("专家所属部门为”"+randomRuleVO.getTypeName()+"“缺少”"+randomRuleVO.getNum()+"人");;break;
                    case 领域: list.add("专家专业领域为”"+randomRuleVO.getTypeName()+"“缺少”"+randomRuleVO.getNum()+"人");;break;
                }
            }
        }
        return list;
    }


    //抽取方法二
    @Override
    public List<ExpertVO> randomSelectTwo(Integer expertNum, List<ExpertVO> expertVOS,Long inviteId) {
        Map<String, Integer> map = new LinkedHashMap<>();//条件
        Map<String, Map<String,String>> mapId = new HashMap<>();//分类库
        List<String> olist =new ArrayList<>();//列表已经存在专家id
        initialCondition(map,olist, mapId, inviteId, expertVOS);//初始话条件
        List<String> nlist = new ArrayList<String>();//新专家列表
        for (String s : map.keySet()) {
            while (nlist.size()<expertNum && map.get(s)!=0 && mapId.get(s).size()!=0) {
                List<String> strings = new ArrayList<>(mapId.get(s).keySet());
                int randomIndex = (int) (Math.floor(Math.random() * strings.size()));
                nlist.add(strings.get(randomIndex));
                olist.add(strings.get(randomIndex));
                updateCondition(map,olist,mapId);
            }
        }
        List<Long> expertIds = nlist.stream().map(v -> Long.valueOf(v)).distinct().collect(Collectors.toList());
        List<ExpertEntity> list = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(expertIds)){
            LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
            expertLambda.in(ExpertEntity::getExpertId, expertIds);
           list.addAll(service.list(expertLambda));
        }
        if(nlist.size()<expertNum){
            LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
            expertLambda2.in(ExpertEntity::getBillState, 1,3);
            expertLambda2.eq(ExpertEntity::getState, 0);
            expertLambda2.eq(ExpertEntity::getEmployeeType, 1);//edit by sunyj
            if(CollectionUtil.isNotEmpty(olist)){
                expertLambda2.notIn(ExpertEntity::getExpertId, olist.stream().map(v -> Long.valueOf(v)).distinct().collect(Collectors.toList()));
            }
            List<ExpertEntity> expertEntities = this.randomList(expertNum-nlist.size(), service.list(expertLambda2));
            list.addAll(expertEntities);
        }
        return BeanMapper.mapList(list, ExpertVO.class);
    }


    //条件 和 专家库更新
    public  Map updateCondition(Map<String, Integer> map, List<String> expertVOS, Map<String, Map<String,String>> mapId) {
        for (String s : map.keySet()) {
            if(map.get(s)!=0 && mapId.get(s).size()!=0){
                for (String expertId : expertVOS) {
                    if(mapId.get(s).containsKey(expertId)){
                        if(map.get(s)!=0){
                            map.put(s,map.get(s)-1);
                        }
                        mapId.get(s).remove(expertId);
                    }
                }
            }
        }
        return map;
    }

    //初始化条件库
    public Map<String, Integer>  initialCondition(Map<String, Integer> map, List<String> olist, Map<String, Map<String,String>> mapId, Long inviteId, List<ExpertVO> expertVOS) {
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(inviteId);
        List<Long> collect = expertVOS.stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList());
        olist = collect.stream().map(v->v+"").distinct().collect(Collectors.toList());//列表已有专家

        String [] fieldNames = {ExpertNumEnum.物资类.getName(), ExpertNumEnum.工程经济类.getName(),
                ExpertNumEnum.施工技术及施工质量管理类.getName(),ExpertNumEnum.统购中心.getName()};
        List<String> arrayList = new ArrayList<>(Arrays.asList(fieldNames));
        //科技
        String contractType= stuffInviteEntity.getContractType()==null?"":stuffInviteEntity.getContractType();
        if("1".equals(contractType)){//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
            arrayList.add(bjkjName);
        }
        Collections.shuffle(arrayList);//打乱顺序
        List<String> wzIds = expertFieldDetailService.queryExpertIdsTwo(ExpertNumEnum.物资类.getName());//物资类专家id集合
        Map<String, String>  collect1= wzIds.stream().collect(Collectors.toMap(item -> item, item -> item, (v1, v2) -> v2));
        List<String> gcIds = expertFieldDetailService.queryExpertIdsTwo(ExpertNumEnum.工程经济类.getName());//工程经济类专家id集合
        Map<String, String> collect2 = gcIds.stream().collect(Collectors.toMap(item -> item, item -> item, (v1, v2) -> v2));
        List<String> sgIds = expertFieldDetailService.queryExpertIdsTwo(ExpertNumEnum.施工技术及施工质量管理类.getName());//施工技术即施工质量管理类专家id集合
        Map<String, String> collect3 = sgIds.stream().collect(Collectors.toMap(item -> item, item -> item, (v1, v2) -> v2));
        Long aLong = stuffInviteEntity.getParentOrgId() != null ? stuffInviteEntity.getParentOrgId() : stuffInviteEntity.getOrgId();//没有上级组织去本身
//        List<String> ssXmIds = getExpertIds(aLong);//实施项目
//        Map<String, String> collect4 = ssXmIds.stream().collect(Collectors.toMap(item -> item, item -> item, (v1, v2) -> v2));
        logger.info("统购中心部门id:{}",wztgzx);
        List<String> wzTgIds = getDeptExpertIds(wztgzx);//物资统购中心
        logger.info("统购中心部门专家数据:{}",wzTgIds);
        Map<String, String> collect5 = wzTgIds.stream().collect(Collectors.toMap(item -> item, item -> item, (v1, v2) -> v2));
        logger.info(bjkjName+"组织id:{}",bjkj);
        List<String> bjKjIds = getExpertIds(bjkj);//辅料中心
        logger.info("统购中心部门专家数据:{}",bjKjIds);
        Map<String, String> collect6 = bjKjIds.stream().collect(Collectors.toMap(item -> item, item -> item, (v1, v2) -> v2));
        for (String s : arrayList) {
            if(bjkjName.equals(s)){
                map.put(s,1);
            }else {
                map.put(s,ExpertNumEnum.getEnumByName(s).getCode());
            }
            if (s.equals(ExpertNumEnum.物资类.getName())){
                mapId.put(s,collect1);
            }
            if (s.equals(ExpertNumEnum.工程经济类.getName())){
                mapId.put(s,collect2);
            }
            if (s.equals(ExpertNumEnum.施工技术及施工质量管理类.getName())){
                mapId.put(s,collect3);
            }
//            if (s.equals(ExpertNumEnum.实施项目基层单位.getName())){
//                mapId.put(s,collect4);
//            }
            if (s.equals(ExpertNumEnum.统购中心.getName())){
                mapId.put(s,collect5);
            }
            if (s.equals(bjkjName)){
                mapId.put(s,collect6);
            }
        }
        updateCondition(map,olist,mapId);//去重
        return map;//校验条件
    }
    //校验接口
    @Override
    public List<String> checkout(List<ExpertVO> expertVOS, Long inviteId) {
        Map<String, Integer> map = new LinkedHashMap<>();//条件
        Map<String, Map<String,String>> mapId = new HashMap<>();//分类库
        List<String> olist =new ArrayList<>();//列表已经存在专家id
        Map<String, Integer> condition = initialCondition(map, olist, mapId, inviteId, expertVOS);//初始话条件
        List<String> list = new ArrayList<>();//条件
        String [] fieldNames = {ExpertNumEnum.物资类.getName(), ExpertNumEnum.工程经济类.getName(),
                ExpertNumEnum.施工技术及施工质量管理类.getName(),ExpertNumEnum.统购中心.getName(),bjkjName};
        for (int i = 0; i < fieldNames.length; i++) {
            if(i<2){
                if(condition.containsKey(fieldNames[i])&&condition.get(fieldNames[i])>0){
                    list.add("专家专业领域为”"+fieldNames[i]+"“缺少”"+condition.get(fieldNames[i])+"人");
                }
            }else if(ExpertNumEnum.统购中心.getName().equals(fieldNames[i])){
                if(condition.containsKey(fieldNames[i])&&condition.get(fieldNames[i])>0){
                    list.add("专家所属部门为”"+fieldNames[i]+"“缺少”"+condition.get(fieldNames[i])+"人");
                }
            }else{
                if(condition.containsKey(fieldNames[i])&&condition.get(fieldNames[i])>0){
                    list.add("专家所属组织为”"+fieldNames[i]+"“缺少”"+condition.get(fieldNames[i])+"人");
                }
            }
        }
        return list;
    }


    //查询组织本级的专家
    @Override
    public List<String> getExpertIds(Long parentOrgId) {
        if(null==parentOrgId){
            return new ArrayList<>();
        }
        CommonResponse<List<OrgVO>> response = iOrgApi.findChildrenByParentId(parentOrgId);
        List<Long> longs = new ArrayList<>();
        longs.add(parentOrgId);
//        if(CollectionUtil.isNotEmpty(response.getData())){
//            List<Long> orgIds = response.getData().stream().map(item -> item.getId()).collect(Collectors.toList());
//            longs.addAll(orgIds);
//        }
        LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
        expertLambda.in(ExpertEntity::getBillState, 1,3);
        expertLambda.eq(ExpertEntity::getState, 0);
        expertLambda.eq(ExpertEntity::getEmployeeType, 1);//edit by sunyj
        expertLambda.in(ExpertEntity::getUnitId, longs);
        List<ExpertEntity> list = service.list(expertLambda);
        List<String> expertIds = list.stream().filter(item->item.getExpertId()!=null).map(item->item.getExpertId().toString()).distinct().collect(Collectors.toList());
        return expertIds;
    }
    //查询该部门的专家
    @Override
    public List<String> getDeptExpertIds(Long dept) {
        if(null==dept){
            return new ArrayList<>();
        }
        LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
        expertLambda.in(ExpertEntity::getBillState, 1,3);
        expertLambda.eq(ExpertEntity::getState, 0);
        expertLambda.eq(ExpertEntity::getEmployeeType, 1);//edit by sunyj
        expertLambda.eq(ExpertEntity::getDeptId, dept);
        List<ExpertEntity> list = service.list(expertLambda);
        List<String> expertIds = list.stream().filter(item->item.getExpertId()!=null).map(item->item.getExpertId().toString()).distinct().collect(Collectors.toList());
        return expertIds;
    }


    @Override
    public List<ExpertVO> randomSelect(Integer expertNum, String fieldNames) {
        LambdaQueryWrapper<ExpertEntity> expertLambda = Wrappers.lambdaQuery();
        if (fieldNames!=null){
            List<Long> expertIds = expertFieldDetailService.queryExpertIds(fieldNames);
            if(CollectionUtil.isNotEmpty(expertIds)){
                expertLambda.in(ExpertEntity::getExpertId, expertIds);
            }
        }
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        expertLambda.in(ExpertEntity::getBillState, billStates);
        expertLambda.eq(ExpertEntity::getState, 0);
        expertLambda.eq(ExpertEntity::getEmployeeType, 1);//edit by sunyj
        List<ExpertEntity> list = service.list(expertLambda);
        List<ExpertEntity> expertEntities = this.randomList(expertNum, list);
        List<ExpertVO> expertVOS = BeanMapper.mapList(expertEntities, ExpertVO.class);
        return expertVOS;
    }

    @Override
    public IPage<ExpertVO> manualSelect(Integer pageNumber, Integer pageSize, String fieldNames, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("expertName");
        param.getFuzzyFields().add("mobile");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("postName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //处理fieldName
        if(fieldNames!=null){
            List<Long> expertIds = expertFieldDetailService.queryExpertIds(fieldNames);
            if(CollectionUtil.isNotEmpty(expertIds)){
                param.getParams().put("expertId", new Parameter(QueryParam.IN,expertIds));
            }
        }
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
//        List<Integer> employeeTypes = new ArrayList<>();
//        employeeTypes.add(2);//离职
//        employeeTypes.add(3);//退休
        param.getParams().put("state", new Parameter("eq",0));
        param.getParams().put("employeeType", new Parameter(QueryParam.EQ,1));//edit by sunyj
        param.getParams().put("billState", new Parameter(QueryParam.IN,billStates));
        IPage<ExpertEntity> page = service.queryPage(param,false);
        IPage<ExpertVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertVO.class));
        return pageData;
    }

    @Override
    public ExpertVO saveOrUpdate(ExpertVO saveOrUpdateVO) {
        ExpertEntity entity = BeanMapper.map(saveOrUpdateVO, ExpertEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            Boolean dislodge = service.dislodge(entity.getExpertId());
            if(dislodge){
                entity.setOldExpertId(entity.getExpertId());
            }else {
                throw new BusinessException("专家已存在！");
            }
        }else {
            if(!entity.getExpertId().equals(entity.getOldExpertId())){
                Boolean dislodge = service.dislodge(entity.getExpertId());
                if(dislodge){
                    entity.setOldExpertId(entity.getExpertId());
                }else {
                    throw new BusinessException("专家已存在！");
                }
            }
        }
        switch (entity.getType()){
            case 0: entity.setTypeName("商务专家");break;
            case 1: entity.setTypeName("技术专家");break;
            case 2: entity.setTypeName("商务技术专家");break;
        };
        service.saveOrUpdate(entity, false);
        expertFieldDetailService.saveOrUpdate(entity.getExpertId(), entity.getFieldName());
        ExpertVO vo = BeanMapper.map(entity, ExpertVO.class);
        return vo;
    }
//是否待评标
    @Override
    public Boolean bidEvaluation(Long id) {
        ExpertEntity expertEntity = service.selectById(id);
        //该专家是否有未评标
        LambdaQueryWrapper<ExpertEvaluatingDetailEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertEvaluatingDetailEntity::getExpertId,expertEntity.getExpertId());
        lambda.in(ExpertEvaluatingDetailEntity::getEvaluationState,0,3);
        List<ExpertEvaluatingDetailEntity> list = expertEvaluatingDetailService.list(lambda);
        if(CollectionUtil.isNotEmpty(list)){
            return true;
        }
        return false;
    }

    /*随机方法
     *value:随机数
     *list:随机总集合
     * 唯一判断----
     * */
    public List<ExpertEntity> randomList(Integer value , List<ExpertEntity> list){
        if(value<list.size()){
            List<ExpertEntity> randList= new ArrayList<>();
            Map<Integer, ExpertEntity> map = new HashMap<>();
            while (map.size()<value) {
                int randomIndex = (int) (Math.floor(Math.random() * list.size()));
                if(!map.containsKey(randomIndex)){
                    map.put(randomIndex, list.get(randomIndex));
                }
            }

            randList.addAll(map.values());
//            numSet.forEach(val->{
//                randList.add(list.get(val));
//            });
//            randList.addAll(numSet);
            return randList;
        }
        return list;
    }

    @Override
    public List<ExpertVO> randomExpertForSupplier(RandomSupplierExpertVO randomExpertVO) {
        logger.info("随机获取供应商准入考察专家，参数：{}",JSONObject.toJSONString(randomExpertVO));
        List<ExpertVO> res = new ArrayList<>();
        String [] fieldNames = null;
        Map<String,List<String>> map = null;
        List<String> deptName = null;
        Map<String,List<String>> unitNameMap = null;
        switch (randomExpertVO.getSupplierType()){
            case "labor":
            case "major":
                {
                    /**
                     * 主营类别 = 劳务  或 专业时
                     * 总人数：
                     * 大于等于6人；
                     * 选取方式：
                     * 随机 大于等于 4
                     * 专业类型：
                     * 生产管理类  大于等于1；
                     * 施工技术及施工质量管理类  大于等于1；
                     * 安全及设备管理类  大于等于1
                     * 工程经济类  大于等于1
                     * 该任职信息中—部门：
                     * 成本合约部  大于等于1
                     * 所属单位：
                     * 准入申请单位本上第一个分子公司或集团 大于等于1
                     * */
                    /** 1、定义各种专业领域 已选择专家*/
                    fieldNames = new String[]{"生产管理类", "施工技术及施工质量管理类", "安全及设备管理类", "工程经济类"};
                    map = new HashMap<>();//每个分类  --- 以及选择的专家id
                    deptName = new ArrayList<>();
                    unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                    if(ListUtil.isNotEmpty(randomExpertVO.getExpertVOS())){
                        for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                            for (String s : fieldNames) {
                                if(expertVO.getFieldName().contains(s)){
                                    List<String> ex = map.computeIfAbsent(s, k -> new ArrayList<>());
                                    ex.add(expertVO.getExpertId()+"");
                                }
                            }
                            if("成本合约部".equals(expertVO.getDeptName())){
                                deptName.add(expertVO.getExpertId()+"");
                            }
                            if(StringUtils.isNotEmpty(expertVO.getUnitName())){
                                unitNameMap.computeIfAbsent(expertVO.getUnitName(), k -> new ArrayList<>()).add(expertVO.getExpertId()+"");
                            }
                        }
                    }
                    for (String s : fieldNames) {
                        if((map.get(s)==null || map.get(s).size()==0) && res.size()<= randomExpertVO.getExpertNum()-1){
                            List<ExpertVO> select = randomSelect(1,s);
                            if(ListUtil.isNotEmpty(select)){
                                res.addAll(select);
                                randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                                if("成本合约部".equals(select.get(0).getDeptName())){
                                    deptName.add(select.get(0).getExpertId()+"");
                                }
                                if(StringUtils.isNotEmpty(select.get(0).getUnitName())){
                                    unitNameMap.computeIfAbsent(select.get(0).getUnitName(), k -> new ArrayList<>()).add(select.get(0).getExpertId()+"");
                                }
                            }
                        }
                    }
                    /** 部门处理 */
                    if(randomExpertVO.getExpertNum()>0 && ListUtil.isEmpty(deptName)){
                        LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                        expertLambda2.in(ExpertEntity::getBillState, 1,3);
                        expertLambda2.eq(ExpertEntity::getState, 0);
                        expertLambda2.eq(ExpertEntity::getDeptName, "成本合约部");
                        List<ExpertEntity> expertEntities = this.randomList(1, service.list(expertLambda2));
                        if(ListUtil.isNotEmpty(expertEntities)){
                            randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                            res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                            unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), k -> new ArrayList<>()).add(expertEntities.get(0).getExpertId()+"");
                        }
                    }
                    /** 所属单位处理 */
                    /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
                    /** 如果还没选满 在随机选择剩余的专家 */
                    if(randomExpertVO.getExpertNum()>0){
                        LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                        expertLambda2.in(ExpertEntity::getBillState, 1,3);
                        expertLambda2.eq(ExpertEntity::getState, 0);
                        List<Long> ids = randomExpertVO.getExpertVOS()==null?new ArrayList<>():randomExpertVO.getExpertVOS().stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList());
                        ids.addAll(res.stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList()));
                        if(ListUtil.isNotEmpty(ids)){
                            expertLambda2.notIn(ExpertEntity::getExpertId, ids.stream().distinct().collect(Collectors.toList()));
                        }
                        List<ExpertEntity> expertEntities = this.randomList(randomExpertVO.getExpertNum(), service.list(expertLambda2));
                        res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                    }
                }
                break;
            case "other":
            case "consult":
                {
                /**
                 * 主营类别= 其他或咨询 时
                 *
                 * 总人数：
                 * 大于等于6人；
                 *
                 * 选取方式：
                 * 随机 大于等于 4
                 *
                 * 所属单位：
                 * 准入申请单位本上第一个分子公司或集团 大于等于1
                 * */
                /** 1、定义各种专业领域 已选择专家*/
                unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                if(ListUtil.isNotEmpty(randomExpertVO.getExpertVOS())){
                    for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                        if(StringUtils.isNotEmpty(expertVO.getUnitName())){
                            unitNameMap.computeIfAbsent(expertVO.getUnitName(), k -> new ArrayList<>()).add(expertVO.getExpertId()+"");
                        }
                    }
                }
                /** 所属单位处理 */
                /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
                /** 如果还没选满 在随机选择剩余的专家 */
                if(randomExpertVO.getExpertNum()>0){
                    LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in(ExpertEntity::getBillState, 1,3);
                    expertLambda2.eq(ExpertEntity::getState, 0);
                    List<Long> ids = randomExpertVO.getExpertVOS()==null?new ArrayList<>():randomExpertVO.getExpertVOS().stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList());
                    ids.addAll(res.stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList()));
                    if(ListUtil.isNotEmpty(ids)){
                        expertLambda2.notIn(ExpertEntity::getExpertId, ids.stream().distinct().collect(Collectors.toList()));
                    }
                    List<ExpertEntity> expertEntities = this.randomList(randomExpertVO.getExpertNum(), service.list(expertLambda2));
                    res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                }
            }
                break;
            case "material":
                {
                    /**
                     * 主营类别= 物资 时
                     *
                     * 总人数：
                     * 大于等于6人；
                     *
                     * 选取方式：
                     * 随机 大于等于 4
                     *
                     * 专业类型：
                     * 物资类  大于等于2；
                     * 施工技术及施工质量管理类  大于等于1；
                     * 工程经济类  大于等于1
                     *
                     * 该任职信息中—部门：
                     * 统购中心  大于等于1
                     *
                     * 所属单位：
                     * 准入申请单位本上第一个分子公司或集团 大于等于1
                     * */
                    /** 1、定义各种专业领域 已选择专家*/
                    fieldNames = new String[]{"物资类", "施工技术及施工质量管理类", "工程经济类"};
                    map = new HashMap<>();//每个分类  --- 以及选择的专家id
                    deptName = new ArrayList<>();
                    unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                    if(ListUtil.isNotEmpty(randomExpertVO.getExpertVOS())){
                        for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                            for (String s : fieldNames) {
                                if(expertVO.getFieldName().contains(s)){
                                    List<String> ex = map.computeIfAbsent(s, k -> new ArrayList<>());
                                    ex.add(expertVO.getExpertId()+"");
                                }
                            }
                            if("统购中心".equals(expertVO.getDeptName())){
                                deptName.add(expertVO.getExpertId()+"");
                            }
                            if(StringUtils.isNotEmpty(expertVO.getUnitName())){
                                unitNameMap.computeIfAbsent(expertVO.getUnitName(), k -> new ArrayList<>()).add(expertVO.getExpertId()+"");
                            }
                        }
                    }
                    for (String s : fieldNames) {
                        if((map.get(s)==null || map.get(s).size()==0) && res.size()<= randomExpertVO.getExpertNum()-("物资类".equals(s)?2:1)){
                            List<ExpertVO> select = "物资类".equals(s)?randomSelect(2,s):randomSelect(1,s);
                            if(ListUtil.isNotEmpty(select)){
                                res.addAll(select);
                                for (ExpertVO expertVO : select) {
                                    randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                                    if("统购中心".equals(expertVO.getDeptName())){
                                        deptName.add(expertVO.getExpertId()+"");
                                    }
                                    if(StringUtils.isNotEmpty(expertVO.getUnitName())){
                                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), k -> new ArrayList<>()).add(expertVO.getExpertId()+"");
                                    }
                                }
                            }
                        }
                    }
                    /** 部门处理 */
                    if(randomExpertVO.getExpertNum()>0 && ListUtil.isEmpty(deptName)){
                        LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                        expertLambda2.in(ExpertEntity::getBillState, 1,3);
                        expertLambda2.eq(ExpertEntity::getState, 0);
                        expertLambda2.eq(ExpertEntity::getDeptName, "统购中心");
                        List<ExpertEntity> expertEntities = this.randomList(1, service.list(expertLambda2));
                        if(ListUtil.isNotEmpty(expertEntities)){
                            randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                            res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                            unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), k -> new ArrayList<>()).add(expertEntities.get(0).getExpertId()+"");
                        }
                    }
                    /** 所属单位处理 */
                    /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
                    /** 如果还没选满 在随机选择剩余的专家 */
                    if(randomExpertVO.getExpertNum()>0){
                        LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                        expertLambda2.in(ExpertEntity::getBillState, 1,3);
                        expertLambda2.eq(ExpertEntity::getState, 0);
                        List<Long> ids = randomExpertVO.getExpertVOS()==null?new ArrayList<>():randomExpertVO.getExpertVOS().stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList());
                        ids.addAll(res.stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList()));
                        if(ListUtil.isNotEmpty(ids)){
                            expertLambda2.notIn(ExpertEntity::getExpertId, ids.stream().distinct().collect(Collectors.toList()));
                        }
                        List<ExpertEntity> expertEntities = this.randomList(randomExpertVO.getExpertNum(), service.list(expertLambda2));
                        res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                    }
                }
                break;
            case "equipment":
                {
                /**
                 * 主营类别= 设备 时
                 *
                 * 总人数：
                 * 大于等于5人；
                 *
                 * 选取方式：
                 * 随机 大于等于 3
                 *
                 * 专业类型：
                 * 安全及设备管理类  大于等于2；
                 * 施工技术及施工质量管理类  大于等于1；
                 * 工程经济类  大于等于1
                 *
                 * 该任职信息中—部门：
                 * 安全监督管理部  大于等于1
                 *
                 * 所属单位：
                 * 准入申请单位本上第一个分子公司或集团 大于等于1
                 *
                 * 当供货内容包含：塔式起重机、施工升降机（人货两用）、施工升降机（货用）中任意一个时，所属单位：
                 * 机械设备租赁公司  大于等于1
                 * */
                /** 1、定义各种专业领域 已选择专家*/
                fieldNames = new String[]{"安全及设备管理类", "施工技术及施工质量管理类", "工程经济类"};
                map = new HashMap<>();//每个分类  --- 以及选择的专家id
                deptName = new ArrayList<>();
                unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                if(ListUtil.isNotEmpty(randomExpertVO.getExpertVOS())){
                    for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                        for (String s : fieldNames) {
                            if(expertVO.getFieldName().contains(s)){
                                List<String> ex = map.computeIfAbsent(s, k -> new ArrayList<>());
                                ex.add(expertVO.getExpertId()+"");
                            }
                        }
                        if("安全监督管理部".equals(expertVO.getDeptName())){
                            deptName.add(expertVO.getExpertId()+"");
                        }
                        if(StringUtils.isNotEmpty(expertVO.getUnitName())){
                            unitNameMap.computeIfAbsent(expertVO.getUnitName(), k -> new ArrayList<>()).add(expertVO.getExpertId()+"");
                        }
                    }
                }
                for (String s : fieldNames) {
                    if((map.get(s)==null || map.get(s).size()==0) && res.size()<= randomExpertVO.getExpertNum()-("安全及设备管理类".equals(s)?2:1)){
                        List<ExpertVO> select = "安全及设备管理类".equals(s)?randomSelect(2,s):randomSelect(1,s);
                        if(ListUtil.isNotEmpty(select)){
                            res.addAll(select);
                            for (ExpertVO expertVO : select) {
                                randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                                if("安全监督管理部".equals(expertVO.getDeptName())){
                                    deptName.add(expertVO.getExpertId()+"");
                                }
                                if(StringUtils.isNotEmpty(expertVO.getUnitName())){
                                    unitNameMap.computeIfAbsent(expertVO.getUnitName(), k -> new ArrayList<>()).add(expertVO.getExpertId()+"");
                                }
                            }
                        }
                    }
                }
                /** 部门处理 */
                if(randomExpertVO.getExpertNum()>0 && ListUtil.isEmpty(deptName)){
                    LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in(ExpertEntity::getBillState, 1,3);
                    expertLambda2.eq(ExpertEntity::getState, 0);
                    expertLambda2.eq(ExpertEntity::getDeptName, "安全监督管理部");
                    List<ExpertEntity> expertEntities = this.randomList(1, service.list(expertLambda2));
                    if(ListUtil.isNotEmpty(expertEntities)){
                        randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                        res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), k -> new ArrayList<>()).add(expertEntities.get(0).getExpertId()+"");
                    }
                }
                /** 所属单位处理 */
                /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
                /** 处理供货内容有关的所属单位*/
                if(randomExpertVO.getExpertNum()>0){
                    if(randomExpertVO.getSupplyContent()){
                        if(ListUtil.isEmpty(unitNameMap.get("机械设备租赁公司"))){
                            LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                            expertLambda2.in(ExpertEntity::getBillState, 1,3);
                            expertLambda2.eq(ExpertEntity::getState, 0);
                            expertLambda2.eq(ExpertEntity::getUnitName, "机械设备租赁公司");
                            List<ExpertEntity> expertEntities = this.randomList(1, service.list(expertLambda2));
                            if(ListUtil.isNotEmpty(expertEntities)){
                                randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                                res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                                unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), k -> new ArrayList<>()).add(expertEntities.get(0).getExpertId()+"");
                            }
                        }
                    }
                }
                /** 如果还没选满 在随机选择剩余的专家 */
                if(randomExpertVO.getExpertNum()>0){
                    LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in(ExpertEntity::getBillState, 1,3);
                    expertLambda2.eq(ExpertEntity::getState, 0);
                    List<Long> ids = randomExpertVO.getExpertVOS()==null?new ArrayList<>():randomExpertVO.getExpertVOS().stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList());
                    ids.addAll(res.stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList()));
                    if(ListUtil.isNotEmpty(ids)){
                        expertLambda2.notIn(ExpertEntity::getExpertId, ids.stream().distinct().collect(Collectors.toList()));
                    }
                    List<ExpertEntity> expertEntities = this.randomList(randomExpertVO.getExpertNum(), service.list(expertLambda2));
                    res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                }
            }
                break;
            case "revolvMaterial":
                {
                    /**
                     *
                     * 主营类别= 周转材 时
                     *
                     * 总人数：
                     * 大于等于6人；
                     *
                     * 选取方式：
                     * 随机 大于等于 4
                     *
                     * 专业类型：
                     * 物资类  大于等于2；
                     * 施工技术及施工质量管理类  大于等于1；
                     * 工程经济类  大于等于1
                     *
                     * 该任职信息中—部门：
                     * 统购中心  大于等于1
                     *
                     * 所属单位：
                     * 准入申请单位本上第一个分子公司或集团 大于等于1
                     * 辅料中心  大于等于1
                     * */
                    /** 1、定义各种专业领域 已选择专家*/
                    fieldNames = new String[]{"物资类", "施工技术及施工质量管理类", "工程经济类"};
                    map = new HashMap<>();//每个分类  --- 以及选择的专家id
                    deptName = new ArrayList<>();
                    unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                    if(ListUtil.isNotEmpty(randomExpertVO.getExpertVOS())){
                        for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                            for (String s : fieldNames) {
                                if(expertVO.getFieldName().contains(s)){
                                    List<String> ex = map.computeIfAbsent(s, k -> new ArrayList<>());
                                    ex.add(expertVO.getExpertId()+"");
                                }
                            }
                            if("统购中心".equals(expertVO.getDeptName())){
                                deptName.add(expertVO.getExpertId()+"");
                            }
                            if(StringUtils.isNotEmpty(expertVO.getUnitName())){
                                unitNameMap.computeIfAbsent(expertVO.getUnitName(), k -> new ArrayList<>()).add(expertVO.getExpertId()+"");
                            }
                        }
                    }
                    for (String s : fieldNames) {
                        if((map.get(s)==null || map.get(s).size()==0) && res.size()<= randomExpertVO.getExpertNum()-("物资类".equals(s)?2:1)){
                            List<ExpertVO> select = "物资类".equals(s)?randomSelect(2,s):randomSelect(1,s);
                            if(ListUtil.isNotEmpty(select)){
                                res.addAll(select);
                                for (ExpertVO expertVO : select) {
                                    randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                                    if("统购中心".equals(expertVO.getDeptName())){
                                        deptName.add(expertVO.getExpertId()+"");
                                    }
                                    if(StringUtils.isNotEmpty(expertVO.getUnitName())){
                                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), k -> new ArrayList<>()).add(expertVO.getExpertId()+"");
                                    }
                                }
                            }
                        }
                    }
                    /** 部门处理 */
                    if(randomExpertVO.getExpertNum()>0 && ListUtil.isEmpty(deptName)){
                        LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                        expertLambda2.in(ExpertEntity::getBillState, 1,3);
                        expertLambda2.eq(ExpertEntity::getState, 0);
                        expertLambda2.eq(ExpertEntity::getDeptName, "统购中心");
                        List<ExpertEntity> expertEntities = this.randomList(1, service.list(expertLambda2));
                        if(ListUtil.isNotEmpty(expertEntities)){
                            randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                            res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                            unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), k -> new ArrayList<>()).add(expertEntities.get(0).getExpertId()+"");
                        }
                    }
                    /** 所属单位处理 */
                    /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
                    if(randomExpertVO.getExpertNum()>0){
                        /** 处理辅料中心 */
                        if(ListUtil.isEmpty(unitNameMap.get("辅料中心"))){
                            LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                            expertLambda2.in(ExpertEntity::getBillState, 1,3);
                            expertLambda2.eq(ExpertEntity::getState, 0);
                            expertLambda2.eq(ExpertEntity::getUnitName, "辅料中心");
                            List<ExpertEntity> expertEntities = this.randomList(1, service.list(expertLambda2));
                            if(ListUtil.isNotEmpty(expertEntities)){
                                randomExpertVO.setExpertNum(randomExpertVO.getExpertNum()-1);
                                res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                                unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), k -> new ArrayList<>()).add(expertEntities.get(0).getExpertId()+"");
                            }
                        }
                    }
                    /** 如果还没选满 在随机选择剩余的专家 */
                    if(randomExpertVO.getExpertNum()>0){
                        LambdaQueryWrapper<ExpertEntity> expertLambda2 = Wrappers.lambdaQuery();
                        expertLambda2.in(ExpertEntity::getBillState, 1,3);
                        expertLambda2.eq(ExpertEntity::getState, 0);
                        List<Long> ids = randomExpertVO.getExpertVOS()==null?new ArrayList<>():randomExpertVO.getExpertVOS().stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList());
                        ids.addAll(res.stream().map(ExpertVO::getExpertId).distinct().collect(Collectors.toList()));
                        if(ListUtil.isNotEmpty(ids)){
                            expertLambda2.notIn(ExpertEntity::getExpertId, ids.stream().distinct().collect(Collectors.toList()));
                        }
                        List<ExpertEntity> expertEntities = this.randomList(randomExpertVO.getExpertNum(), service.list(expertLambda2));
                        res.addAll(BeanMapper.mapList(expertEntities,ExpertVO.class));
                    }
                }
                break;
            default:
                break;
        }
        return res;
    }

    @Override
    public List<String> checkForSupplier(RandomSupplierExpertVO randomExpertVO) {
        logger.info("校验供应商准入考察专家，参数：{}",JSONObject.toJSONString(randomExpertVO));
        List<String> res = new ArrayList<>();
        String [] fieldNames = null;
        Map<String,List<String>> fieldMap = null;
        Map<String,List<String>> deptName = null;
        Map<String,List<String>> unitNameMap = null;
        switch (randomExpertVO.getSupplierType()){
            case "labor":
            case "major":
                {
                /**
                 * 主营类别 = 劳务  或 专业时
                 *
                 * 总人数：
                 * 大于等于6人；
                 *
                 * 选取方式：
                 * 随机 大于等于 4
                 *
                 * 专业类型：
                 * 生产管理类  大于等于1；
                 * 施工技术及施工质量管理类  大于等于1；
                 * 安全及设备管理类  大于等于1
                 * 工程经济类  大于等于1
                 *
                 * 该任职信息中—部门：
                 * 成本合约部  大于等于1
                 *
                 * 所属单位：
                 * 准入申请单位本上第一个分子公司或集团 大于等于1
                 * */
                /** 1、定义各种专业领域 已选择专家*/
                if(randomExpertVO.getExpertJSONArray().size()==0){
                    res.add("主营类别为劳务专业时，专家总数需大于等于6人，目前0人");
                    res.add("主营类别为劳务专业时，随机专家总数需大于等于4人，目前0人");
                    res.add("主营类别为劳务专业时，生产管理类专家总数需大于等于1人，目前0人");
                    res.add("主营类别为劳务专业时，施工技术及施工质量管理类专家总数需大于等于1人，目前0人");
                    res.add("主营类别为劳务专业时，安全及设备管理类专家总数需大于等于1人，目前0人");
                    res.add("主营类别为劳务专业时，工程经济类专家总数需大于等于1人，目前0人");
                    res.add("主营类别为劳务专业时，成本合约部专家总数需大于等于1人，目前0人");
                    break;
                }
                if(randomExpertVO.getExpertJSONArray().size()<6){
                    res.add("主营类别为劳务专业时，专家总数需大于等于6人，目前"+randomExpertVO.getExpertJSONArray().size()+"人");
                }
                fieldNames = new String[]{"生产管理类", "施工技术及施工质量管理类", "安全及设备管理类", "工程经济类"};
                fieldMap = new HashMap<>();//每个分类  --- 以及选择的专家id
                deptName = new HashMap<>();//每个部门  --- 以及选择的专家id
                unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                int randomWay = 0;
                for (int i = 0; i < randomExpertVO.getExpertJSONArray().size(); i++) {
                    JSONObject expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                    for (String s : fieldNames) {
                        fieldMap.computeIfAbsent(s, k -> new ArrayList<>());
                        if(expertVO.getString("fieldName").contains(s)){
                            List<String> ex = fieldMap.get(s);
                            ex.add(expertVO.getString("expertId"));
                        }
                    }
                    if(StringUtils.isNotEmpty(expertVO.getString("deptName"))){
                        deptName.computeIfAbsent(expertVO.getString("deptName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                    }
                    if(StringUtils.isNotEmpty(expertVO.getString("unitName"))){
                        unitNameMap.computeIfAbsent(expertVO.getString("unitName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                    }
                    /** 1、随机 2、手动 */
                    if("1".equals(expertVO.getString("chooseWay"))){
                        randomWay++;
                    }
                }
                /** 选取方式：随机 大于等于 4 */
                if(randomWay<4){
                    res.add("主营类别为劳务专业时，随机专家总数需大于等于4人，目前"+randomWay+"人");
                }
                for (String s : fieldNames) {
                    if(fieldMap.get(s).size()<1){
                        res.add("主营类别为劳务专业时，"+s+"专家总数需大于等于1人，目前0人");
                    }
                }
                /** 部门：成本合约部  大于等于1 */
                if(deptName.get("成本合约部")==null){
                    res.add("主营类别为劳务专业时，成本合约部专家总数需大于等于1人，目前0人");
                }
                /** 所属单位：准入申请单位本上第一个分子公司或集团 大于等于1 */
                /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
            }
                break;
            case "other":
            case "consult":
                {
                /**
                 * 主营类别= 其他或咨询 时
                 *
                 * 总人数：
                 * 大于等于6人；
                 *
                 * 选取方式：
                 * 随机 大于等于 4
                 *
                 * 所属单位：
                 * 准入申请单位本上第一个分子公司或集团 大于等于1
                 * */
                /** 1、定义各种专业领域 已选择专家*/
                if(randomExpertVO.getExpertJSONArray().size()==0){
                    res.add("主营类别为其他或咨询时，专家总数需大于等于6人，目前0人");
                    res.add("主营类别为其他或咨询时，随机专家总数需大于等于4人，目前0人");
                    break;
                }
                if(randomExpertVO.getExpertJSONArray().size()<6){
                    res.add("主营类别为其他或咨询时，专家总数需大于等于6人，目前"+randomExpertVO.getExpertJSONArray().size()+"人");
                }
                unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                int randomWay = 0;
                for (int i = 0; i < randomExpertVO.getExpertJSONArray().size(); i++) {
                    JSONObject expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                    if(StringUtils.isNotEmpty(expertVO.getString("unitName"))){
                        unitNameMap.computeIfAbsent(expertVO.getString("unitName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                    }
                    /** 1、随机 2、手动 */
                    if("1".equals(expertVO.getString("chooseWay"))){
                        randomWay++;
                    }
                }
                /** 选取方式：随机 大于等于 4 */
                if(randomWay<4){
                    res.add("主营类别为其他或咨询时，随机专家总数需大于等于4人，目前"+randomWay+"人");
                }
                /** 所属单位：准入申请单位本上第一个分子公司或集团 大于等于1 */
                /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
            }
                break;
            case "material":
                {
                    /**
                     * 主营类别= 物资 时
                     *
                     * 总人数：
                     * 大于等于6人；
                     *
                     * 选取方式：
                     * 随机 大于等于 4
                     *
                     * 专业类型：
                     * 物资类  大于等于2；
                     * 施工技术及施工质量管理类  大于等于1；
                     * 工程经济类  大于等于1
                     *
                     * 该任职信息中—部门：
                     * 统购中心  大于等于1
                     *
                     * 所属单位：
                     * 准入申请单位本上第一个分子公司或集团 大于等于1
                     * */
                if(randomExpertVO.getExpertJSONArray().size()==0){
                    res.add("主营类别为物资时，专家总数需大于等于6人，目前0人");
                    res.add("主营类别为物资时，随机专家总数需大于等于4人，目前0人");
                    res.add("主营类别为物资时，物资类专家总数需大于等于2人，目前0人");
                    res.add("主营类别为物资时，施工技术及施工质量管理类专家总数需大于等于1人，目前0人");
                    res.add("主营类别为物资时，工程经济类专家总数需大于等于1人，目前0人");
                    res.add("主营类别为物资时，统购中心专家总数需大于等于1人，目前0人");
                    break;
                }
                if(randomExpertVO.getExpertJSONArray().size()<6){
                    res.add("主营类别为物资时，专家总数需大于等于6人，目前"+randomExpertVO.getExpertJSONArray().size()+"人");
                }
                fieldNames = new String[]{"物资类", "施工技术及施工质量管理类", "工程经济类"};
                fieldMap = new HashMap<>();//每个分类  --- 以及选择的专家id
                deptName = new HashMap<>();//每个部门  --- 以及选择的专家id
                unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                int randomWay = 0;
                for (int i = 0; i < randomExpertVO.getExpertJSONArray().size(); i++) {
                    JSONObject expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                    for (String s : fieldNames) {
                        fieldMap.computeIfAbsent(s, k -> new ArrayList<>());
                        if(expertVO.getString("fieldName").contains(s)){
                            List<String> ex = fieldMap.get(s);
                            ex.add(expertVO.getString("expertId"));
                        }
                    }
                    if(StringUtils.isNotEmpty(expertVO.getString("deptName"))){
                        deptName.computeIfAbsent(expertVO.getString("deptName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                    }
                    if(StringUtils.isNotEmpty(expertVO.getString("unitName"))){
                        unitNameMap.computeIfAbsent(expertVO.getString("unitName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                    }
                    /** 1、随机 2、手动 */
                    if("1".equals(expertVO.getString("chooseWay"))){
                        randomWay++;
                    }
                }
                /** 选取方式：随机 大于等于 4 */
                if(randomWay<4){
                    res.add("主营类别为物资时，随机专家总数需大于等于4人，目前"+randomWay+"人");
                }
                for (String s : fieldNames) {
                    if("物资类".equals(s)){
                        if(fieldMap.get(s).size()<2){
                            res.add("主营类别为物资时，物资类专家总数需大于等于2人，目前"+fieldMap.get(s).size()+"人");
                        }
                    }else if(fieldMap.get(s).size()<1){
                        res.add("主营类别为物资时，"+s+"专家总数需大于等于1人，目前0人");
                    }
                }
                /** 部门：成本合约部  大于等于1 */
                if(deptName.get("统购中心")==null){
                    res.add("主营类别为物资时，统购中心专家总数需大于等于1人，目前0人");
                }
                /** 所属单位：准入申请单位本上第一个分子公司或集团 大于等于1 */
                /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
            }
                break;
            case "equipment":
                {
                    /**
                     * 主营类别= 设备 时
                     *
                     * 总人数：
                     * 大于等于5人；
                     *
                     * 选取方式：
                     * 随机 大于等于 3
                     *
                     * 专业类型：
                     * 安全及设备管理类  大于等于2；
                     * 施工技术及施工质量管理类  大于等于1；
                     * 工程经济类  大于等于1
                     *
                     * 该任职信息中—部门：
                     * 安全监督管理部  大于等于1
                     *
                     * 所属单位：
                     * 准入申请单位本上第一个分子公司或集团 大于等于1
                     *
                     * 当供货内容包含：塔式起重机、施工升降机（人货两用）、施工升降机（货用）中任意一个时，所属单位：
                     * 机械设备租赁公司  大于等于1
                     * */
                    if(randomExpertVO.getExpertJSONArray().size()==0){
                        res.add("主营类别为设备时，专家总数需大于等于5人，目前0人");
                        res.add("主营类别为设备时，随机专家总数需大于等于3人，目前0人");
                        res.add("主营类别为设备时，安全及设备管理类专家总数需大于等于2人，目前0人");
                        res.add("主营类别为设备时，施工技术及施工质量管理类专家总数需大于等于1人，目前0人");
                        res.add("主营类别为设备时，工程经济类专家总数需大于等于1人，目前0人");
                        res.add("主营类别为设备时，安全监督管理部专家总数需大于等于1人，目前0人");
                        break;
                    }
                    if(randomExpertVO.getExpertJSONArray().size()<5){
                        res.add("主营类别为设备时，专家总数需大于等于5人，目前"+randomExpertVO.getExpertJSONArray().size()+"人");
                    }
                    fieldNames = new String[]{"安全及设备管理类", "施工技术及施工质量管理类", "工程经济类"};
                    fieldMap = new HashMap<>();//每个分类  --- 以及选择的专家id
                    deptName = new HashMap<>();//每个部门  --- 以及选择的专家id
                    unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                    int randomWay = 0;
                    for (int i = 0; i < randomExpertVO.getExpertJSONArray().size(); i++) {
                        JSONObject expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                        for (String s : fieldNames) {
                            fieldMap.computeIfAbsent(s, k -> new ArrayList<>());
                            if(expertVO.getString("fieldName").contains(s)){
                                List<String> ex = fieldMap.get(s);
                                ex.add(expertVO.getString("expertId"));
                            }
                        }
                        if(StringUtils.isNotEmpty(expertVO.getString("deptName"))){
                            deptName.computeIfAbsent(expertVO.getString("deptName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                        }
                        if(StringUtils.isNotEmpty(expertVO.getString("unitName"))){
                            unitNameMap.computeIfAbsent(expertVO.getString("unitName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                        }
                        /** 1、随机 2、手动 */
                        if("1".equals(expertVO.getString("chooseWay"))){
                            randomWay++;
                        }
                    }
                    /** 选取方式：随机 大于等于 3 */
                    if(randomWay<3){
                        res.add("主营类别为设备时，随机专家总数需大于等于3人，目前"+randomWay+"人");
                    }
                    for (String s : fieldNames) {
                        if("安全及设备管理类".equals(s)){
                            if(fieldMap.get(s).size()<2){
                                res.add("主营类别为设备时，安全及设备管理类专家总数需大于等于2人，目前"+fieldMap.get(s).size()+"人");
                            }
                        }else if(fieldMap.get(s).size()<1){
                            res.add("主营类别为设备时，"+s+"专家总数需大于等于1人，目前0人");
                        }
                    }
                    /** 部门：安全监督管理部  大于等于1 */
                    if(deptName.get("安全监督管理部")==null){
                        res.add("主营类别为设备时，安全监督管理部专家总数需大于等于1人，目前0人");
                    }
                    /** 所属单位：准入申请单位本上第一个分子公司或集团 大于等于1 */
                    /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
                    /** 供货内容处理 */
                    if(randomExpertVO.getSupplyContent() && ListUtil.isEmpty(unitNameMap.get("机械设备租赁公司"))){
                        res.add("主营类别为设备时，根据所选供货内容，所属单位为机械设备租赁公司的专家总数需大于等于1人，目前0人");
                    }
                }
                break;
            case "revolvMaterial":
                {
                    /**
                     *
                     * 主营类别= 周转材 时
                     *
                     * 总人数：
                     * 大于等于6人；
                     *
                     * 选取方式：
                     * 随机 大于等于 4
                     *
                     * 专业类型：
                     * 物资类  大于等于2；
                     * 施工技术及施工质量管理类  大于等于1；
                     * 工程经济类  大于等于1
                     *
                     * 该任职信息中—部门：
                     * 统购中心  大于等于1
                     *
                     * 所属单位：
                     * 准入申请单位本上第一个分子公司或集团 大于等于1
                     * 辅料中心  大于等于1
                     * */
                    if(randomExpertVO.getExpertJSONArray().size()==0){
                        res.add("主营类别为周转材时，专家总数需大于等于6人，目前0人");
                        res.add("主营类别为周转材时，随机专家总数需大于等于4人，目前0人");
                        res.add("主营类别为周转材时，物资类专家总数需大于等于2人，目前0人");
                        res.add("主营类别为周转材时，施工技术及施工质量管理类专家总数需大于等于1人，目前0人");
                        res.add("主营类别为周转材时，工程经济类专家总数需大于等于1人，目前0人");
                        res.add("主营类别为周转材时，统购中心专家总数需大于等于1人，目前0人");
                        break;
                    }
                    if(randomExpertVO.getExpertJSONArray().size()<6){
                        res.add("主营类别为周转材时，专家总数需大于等于6人，目前"+randomExpertVO.getExpertJSONArray().size()+"人");
                    }
                    fieldNames = new String[]{"物资类", "施工技术及施工质量管理类", "工程经济类"};
                    deptName = new HashMap<>();//每个部门  --- 以及选择的专家id
                    fieldMap = new HashMap<>();//每个分类  --- 以及选择的专家id
                    unitNameMap = new HashMap<>();//单位名称 --- 以及选择的专家id
                    int randomWay = 0;
                    for (int i = 0; i < randomExpertVO.getExpertJSONArray().size(); i++) {
                        JSONObject expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                        for (String s : fieldNames) {
                            fieldMap.computeIfAbsent(s, k -> new ArrayList<>());
                            if(expertVO.getString("fieldName").contains(s)){
                                List<String> ex = fieldMap.get(s);
                                ex.add(expertVO.getString("expertId"));
                            }
                        }
                        if(StringUtils.isNotEmpty(expertVO.getString("deptName"))){
                            deptName.computeIfAbsent(expertVO.getString("deptName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                        }
                        if(StringUtils.isNotEmpty(expertVO.getString("unitName"))){
                            unitNameMap.computeIfAbsent(expertVO.getString("unitName"), k -> new ArrayList<>()).add(expertVO.getString("expertId"));
                        }
                        /** 1、随机 2、手动 */
                        if("1".equals(expertVO.getString("chooseWay"))){
                            randomWay++;
                        }
                    }
                    /** 选取方式：随机 大于等于 4 */
                    if(randomWay<4){
                        res.add("主营类别为周转材时，随机专家总数需大于等于4人，目前"+randomWay+"人");
                    }
                    for (String s : fieldNames) {
                        if("物资类".equals(s)){
                            if(fieldMap.get(s).size()<2){
                                res.add("主营类别为周转材时，物资类专家总数需大于等于2人，目前"+fieldMap.get(s).size()+"人");
                            }
                        }else if(fieldMap.get(s).size()<1){
                            res.add("主营类别为周转材时，"+s+"专家总数需大于等于1人，目前0人");
                        }
                    }
                    /** 部门：成本合约部  大于等于1 */
                    if(deptName.get("统购中心")==null){
                        res.add("主营类别为周转材时，统购中心专家总数需大于等于1人，目前0人");
                    }
                    /** 所属单位：准入申请单位本上第一个分子公司或集团 大于等于1 */
                    /** 2024年10月8日 根据需求更改，不再进行所属单位条件过滤*/
                    /** 辅料中心 处理 */
                    if(ListUtil.isEmpty(unitNameMap.get("辅料中心"))){
                        res.add("主营类别为周转材时，所属单位为辅料中心的专家总数需大于等于1人，目前0人");
                    }
                }
                break;
            default:
                break;
        }
        return res;
    }
}
