package com.ejianc.business.tender.other.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.api.IPromaterialContractApi;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.proother.contract.api.IOtherContractApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.enums.DraftTypeEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailBidderVO;
import com.ejianc.business.tender.other.vo.OtherInviteDetailRecordVO;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.vo.OtherInviteDetailRecordVO;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubDocumentSupplierService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherInvite")
public class OtherInviteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TENDER_OTHER";//此处需要根据实际修改

    /** 参照查询：项目ID */
    private static final String CONDITION_PROJECT_ID = "projectId";
    /** 参照查询：组织ID */
    private static final String CONDITION_ORG_ID = "orgId";

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IOtherInviteService service;

    @Autowired
    private IOtherInviteDetailRecordService detailRecordService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private IBatPlanApi batPlanApi;

    @Autowired
    private IOtherPicketageService picketageService;

    @Autowired
    private IOtherPicketageRefsupplierService refsupplierService;

    @Autowired
    private IOtherContractApi contractApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IStuffInviteService stuffInviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IOtherDocumentService documentService;

    @Autowired
    private IOtherDocumentSupplierService documentSupplierService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherInviteVO> saveOrUpdate(@RequestBody OtherInviteVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        //处理子表供应商中标信息
        List<OtherInviteDetailRecordVO> otherInviteDetailList = saveorUpdateVO.getOtherDetailRecord();
        List<OtherInviteDetailBidderEntity> biddeotherityList = new ArrayList<OtherInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty(otherInviteDetailList)){
            for (OtherInviteDetailRecordVO otherInviteDetailVO : otherInviteDetailList){
                if (otherInviteDetailVO.getId() == null){
                    long id = IdWorker.getId();
                    otherInviteDetailVO.setId(id);
                }
                List<OtherInviteDetailBidderVO> bidderList = otherInviteDetailVO.getOtherDetailBidder();
                if(CollectionUtils.isNotEmpty(bidderList)){
                    for (OtherInviteDetailBidderVO bidderVO : bidderList){
                        bidderVO.setInviteDetailId(otherInviteDetailVO.getId());
                        OtherInviteDetailBidderEntity biddeotherity = BeanMapper.map(bidderVO, OtherInviteDetailBidderEntity.class);
                        biddeotherityList.add(biddeotherity);
                    }
                }
            }
        }
        
        OtherInviteEntity entity = BeanMapper.map(saveorUpdateVO, OtherInviteEntity.class);
        if (CollectionUtils.isNotEmpty(biddeotherityList)){
            entity.setOtherDetailBidder(biddeotherityList);
        }
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<String> oldPlanIdList = detailRecordService.list(new LambdaQueryWrapper<OtherInviteDetailRecordEntity>()
                .eq(OtherInviteDetailRecordEntity::getInviteId, saveorUpdateVO.getId()))
                .stream().map(OtherInviteDetailRecordEntity::getPlanId)
                .map(String::valueOf).distinct().collect(Collectors.toList());
        batPlanApi.updateBatPlanQuote(oldPlanIdList,BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
        entity.setSignStatus(TenderSignStatusEnum.未签订.getCode());

        //处理合同附件
        if (entity.getId() != null){
            OtherInviteEntity otherInviteOldEntity = service.getById(entity.getId());
            if(0==otherInviteOldEntity.getEstablishType()){
                if (otherInviteOldEntity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                    //如果招标文件生成方式没变,前后都是线上起草,模版变了则删除附件,
                    if(entity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                        if (!otherInviteOldEntity.getContractCategoryId().equals(entity.getContractCategoryId())){
                            if (otherInviteOldEntity.getContractFileId() != null){
                                attachmentApi.deleteFileByParam(otherInviteOldEntity.getId(),"BT220210000000015","contractFile");
                                CommonResponse<String> delete = attachmentApi.delete(otherInviteOldEntity.getContractFileId().toString());
                            }
                            entity.setContractFileId(null);
                            entity.setContractFilePath(null);
                            entity.setContractTemplateId(null);
                            entity.setContractTemplateName(null);
                            entity.setContractFileHighlightId(null);
                            entity.setContractFileHighlightPath(null);
                        }
                    }
                    //如果招标文件生成方式改变,则
                    if(entity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                        if (otherInviteOldEntity.getContractFileId() != null){
                            CommonResponse<String> delete = attachmentApi.deleteFileByParam(otherInviteOldEntity.getId(),"BT220210000000015","contractFile");
                            attachmentApi.delete(otherInviteOldEntity.getContractFileId().toString());
                        }
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                        entity.setContractCategoryId(null);
                        entity.setContractCategoryName(null);
                    }
                }
                //
                if (otherInviteOldEntity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                    //如果招标文件生成方式没变,前后都是线上起草,模版变了则删除附件,
                    if(entity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                    }
                    //如果招标文件生成方式改变,则
                    if(entity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                        if (otherInviteOldEntity.getContractFileId() != null){
                            CommonResponse<String> delete = attachmentApi.delete(otherInviteOldEntity.getContractFileId().toString());
                        }
                        entity.setContractFileId(null);
                        entity.setContractFilePath(null);
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                        entity.setContractFileHighlightId(null);
                        entity.setContractFileHighlightPath(null);
                    }
                }
            }
        }

    	service.saveOrUpdate(entity, false);
    	OtherInviteVO vo = BeanMapper.map(entity, OtherInviteVO.class);

        //处理供应商子表信息
        List<OtherInviteDetailRecordVO> otherInviteDetailVOList = vo.getOtherDetailRecord();
        List<OtherInviteDetailBidderVO> otherInviteDetailBidderVOList = vo.getOtherDetailBidder();
        if (CollectionUtils.isNotEmpty(otherInviteDetailBidderVOList)){
            Map<Long, List<OtherInviteDetailBidderVO>> bidderMap = otherInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(OtherInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(otherInviteDetailVOList)){
                for (OtherInviteDetailRecordVO otherInviteDetailVO : otherInviteDetailVOList){
                    List<OtherInviteDetailBidderVO> otherInviteDetailBidderVOS = bidderMap.get(otherInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(otherInviteDetailBidderVOS)){
                        otherInviteDetailVO.setOtherDetailBidder(otherInviteDetailBidderVOS);
                    }
                }
            }
        }
        //修改计划状态
        List<String> planIdList = entity.getOtherDetailRecord().stream().map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
        batPlanApi.updateBatPlanQuote(planIdList,BatPlanEnum.PLAN_STATE_EXEC.getPlanState());
        
        
        if (entity.getEstablishType()==1){
            //修改招标状态
            List<Long> inviteIdList = entity.getOtherDetailRecord().stream().map(OtherInviteDetailRecordEntity::getPlanId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(inviteIdList)) {
                logger.info("修改招标状态id，inviteIdList={}", inviteIdList);
                UpdateWrapper<OtherInviteEntity> wrapper = new UpdateWrapper<>();
                wrapper.set("occupy_state",1).in("id", inviteIdList);
                service.update(wrapper);    
            }
        }
        

        //保存招标过程记录表
        if (!processService.selectByBillId(entity.getId())){
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType()==1){
                processEntity.setBillName("定标立项");
            }else {
                processEntity.setBillName("招标立项");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(5);
            processEntity.setFrontendUrl("other/invite/card");
            processService.saveOrUpdate(processEntity);
        }

        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherInviteVO> queryDetail(Long id) {
    	OtherInviteEntity entity = service.selectById(id);
        OtherInviteVO vo = BeanMapper.map(entity, OtherInviteVO.class);
        //处理供应商子表信息
        List<OtherInviteDetailRecordVO> otherInviteDetailVOList = vo.getOtherDetailRecord();
        List<OtherInviteDetailBidderVO> otherInviteDetailBidderVOList = vo.getOtherDetailBidder();
        if (CollectionUtils.isNotEmpty(otherInviteDetailBidderVOList)){
            Map<Long, List<OtherInviteDetailBidderVO>> bidderMap = otherInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(OtherInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(otherInviteDetailVOList)){
                for (OtherInviteDetailRecordVO otherInviteDetailVO : otherInviteDetailVOList){
                    List<OtherInviteDetailBidderVO> otherInviteDetailBidderVOS = bidderMap.get(otherInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(otherInviteDetailBidderVOS)){
                        otherInviteDetailVO.setOtherDetailBidder(otherInviteDetailBidderVOS);
                    }
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherInviteVO> vos) {
        List<Long> idList = vos.stream().map(OtherInviteVO::getId).collect(Collectors.toList());
        for (Long inviteId : idList) {
            List<String> planIdList = detailRecordService.list(new LambdaQueryWrapper<OtherInviteDetailRecordEntity>()
                    .eq(OtherInviteDetailRecordEntity::getInviteId, inviteId))
                    .stream().map(OtherInviteDetailRecordEntity::getPlanId)
                    .map(String::valueOf).distinct().collect(Collectors.toList());
            batPlanApi.updateBatPlanQuote(planIdList,BatPlanEnum.PLAN_STATE_WAIT.getPlanState());

            //修改招标状态
            OtherInviteEntity inviteEntity = service.selectById(inviteId);
            if (inviteEntity.getEstablishType()==1){
                List<String> inviteIdList = detailRecordService.list(new LambdaQueryWrapper<OtherInviteDetailRecordEntity>()
                        .eq(OtherInviteDetailRecordEntity::getInviteId, inviteId))
                        .stream().map(OtherInviteDetailRecordEntity::getPlanId)
                        .map(String::valueOf).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(inviteIdList)) {
                    UpdateWrapper<OtherInviteEntity> wrapper = new UpdateWrapper<>();
                    wrapper.set("occupy_state",0).in("id", inviteIdList);
                    service.update(wrapper);
                }
            }
        }
        service.removeByIds(vos.stream().map(OtherInviteVO::getId).collect(Collectors.toList()),true);
        processService.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId,vos.stream().map(OtherInviteVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OtherInviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseTypeName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("employeeId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().put("employeeId", new Parameter(QueryParam.NE, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");

        Parameter purchaseId = param.getParams().get("purchaseId");
        if(null!=purchaseId){
            List<String> purchaseIdList = Arrays.asList(param.getParams().get("purchaseId").getValue().toString().split(","));
            logger.info("purchaseId-------{}", param.getParams().get("purchaseId").getValue().toString());
            if (purchaseIdList.size() > 1){

                String sqlStr = "";
                for (String s : purchaseIdList) {
                    sqlStr += " purchase_id like \"%" + s + "%\" or";
                }
                sqlStr = sqlStr.substring(0, sqlStr.length() - 2);
                logger.info("sqlStr----{}", sqlStr);
                param.getParams().put("", new Parameter(QueryParam.SQL, "(" + sqlStr + ")"));
            }else {
                param.getParams().put("", new Parameter(QueryParam.SQL, " ( purchase_id like \"%" + param.getParams().get("purchaseId").getValue().toString() + "%\" )"));
            }
        }
        logger.info("param------{}", JSONObject.toJSONString(param.getParams()));
        param.getParams().remove("purchaseId");



        Parameter tenderState = param.getParams().get("tenderState");
        Boolean enrollFinishFlag = false;//报名截止
        Boolean quoteFinishFlag = false;//报价截止
        if(null!=tenderState){
            if (tenderState.getValue().toString().equals("1") || tenderState.getValue().toString().equals("2")){//报名中、报价中
                param.getParams().put("stopTime", new Parameter(QueryParam.GT, new Date()));
            }else if (tenderState.getValue().toString().equals("11")){
                enrollFinishFlag = true;
                param.getParams().put("stopTime", new Parameter(QueryParam.LT, new Date()));
                param.getParams().put("tenderState", new Parameter(QueryParam.EQ, 1));
            }else if (tenderState.getValue().toString().equals("21")){
                quoteFinishFlag = true;
                param.getParams().put("stopTime", new Parameter(QueryParam.LT, new Date()));
                param.getParams().put("tenderState", new Parameter(QueryParam.EQ, 2));
            }
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OtherInviteEntity> page = service.queryPage(param,false);
        IPage<OtherInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherInviteVO.class));
        Date newData = new Date();
        for (OtherInviteVO record : pageData.getRecords()) {
            switch (record.getTenderType()){
                case 0:
                    record.setTenderTypeName("平台公开招标");
                    break;
                case 1:
                    record.setTenderTypeName("邀请招标");
                    break;
                case 2:
                    record.setTenderTypeName("询价");
                    break;
                case 3:
                    record.setTenderTypeName("竞争性谈判");
                    break;
                case 4:
                    record.setTenderTypeName("单一来源");
                    break;
                case 5:
                    record.setTenderTypeName("紧急招标");
                    break;
            }
            switch (record.getSignStatus()){
                case 0:
                    record.setSignStatusName("未签订");
                    break;
                case 1:
                    record.setSignStatusName("部分签订");
                    break;
                case 2:
                    record.setSignStatusName("全部已签");
                    break;
                case 3:
                    record.setSignStatusName("已关闭");
                    break;
            }
            if (null != record.getTenderState()){
                if (enrollFinishFlag){
                    record.setTenderStateName("报名截止");
                }else if (quoteFinishFlag){
                    record.setTenderStateName("报价截止");
                }else {
                    switch (record.getTenderState()) {
                        case 1:
                            if (null != record.getStopTime() && record.getStopTime().compareTo(newData) > 0){
                                record.setTenderStateName("报名中");
                            }else {
                                record.setTenderStateName("报名截止");
                            }
                            break;
                        case 2:
                            if (null != record.getStopTime() && record.getStopTime().compareTo(newData) > 0){
                                record.setTenderStateName("报价中");
                            }else {
                                record.setTenderStateName("报价截止");
                            }
                            break;
                        case 3:
                            record.setTenderStateName("专家评标中");
                            break;
                        case 4:
                            record.setTenderStateName("专家评标结束");
                            break;
                    }
                }
            }
            record.setEstablishTypeName(record.getEstablishType()==0?"招标立项":"定标立项");
            record.setPurchaseTypeName(record.getPurchaseType()==0?"项目采购":"单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("purchaseName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OtherInviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<OtherInviteVO> voList = JSON.parseArray(JSON.toJSONString(list), OtherInviteVO.class);
        for (OtherInviteVO otherInviteVO : voList) {
            switch (otherInviteVO.getTenderType()){
                case 0:
                    otherInviteVO.setTenderTypeName("平台公开招标");
                    break;
                case 1:
                    otherInviteVO.setTenderTypeName("邀请招标");
                    break;
                case 2:
                    otherInviteVO.setTenderTypeName("询价");
                    break;
                case 3:
                    otherInviteVO.setTenderTypeName("竞争性谈判");
                    break;
                case 4:
                    otherInviteVO.setTenderTypeName("单一来源");
                    break;
                case 5:
                    otherInviteVO.setTenderTypeName("紧急招标");
                    break;
            }
            otherInviteVO.setEstablishTypeName(otherInviteVO.getEstablishType()==0?"招标立项":"定标立项");
            otherInviteVO.setPurchaseTypeName(otherInviteVO.getPurchaseType()==0?"项目采购":"单位采购");
            otherInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode(otherInviteVO.getBillState()).getDescription());
            otherInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(otherInviteVO.getTenderStage()).getDescription());

            //处理报价供应商导出问题
            List<OtherDocumentEntity> documentEntityList = documentService.list(new LambdaQueryWrapper<OtherDocumentEntity>().eq(OtherDocumentEntity::getInviteId, otherInviteVO.getId()));
            if(CollectionUtils.isNotEmpty(documentEntityList)){
                List<OtherDocumentSupplierEntity> documentSupplierEntityList = documentSupplierService.list(new LambdaQueryWrapper<OtherDocumentSupplierEntity>().eq(OtherDocumentSupplierEntity::getDocumentId, documentEntityList.get(0).getId()).groupBy(OtherDocumentSupplierEntity::getSupplierId));
                if(CollectionUtils.isNotEmpty(documentSupplierEntityList)){
                    StringBuffer sb = new StringBuffer();
                    for(int j=0;j<documentSupplierEntityList.size();j++){
                        if(j==(documentSupplierEntityList.size()-1)){
                            sb.append(documentSupplierEntityList.get(j).getSupplierName());
                        }else{
                            sb.append(documentSupplierEntityList.get(j).getSupplierName()+",");
                        }
                    }
                    otherInviteVO.setSupplierTenderName(sb.toString());
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("材料立项.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOtherInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherInviteVO>> refOtherInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("tenderPlatform", new Parameter(QueryParam.EQ, 2));
        param.getParams().put("occupyState", new Parameter(QueryParam.EQ, 0));

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 项目id
            if (_con.containsKey(CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get(CONDITION_PROJECT_ID).toString());
                CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("查询项目信息失败！");
                }
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
            }
            // 组织id
            if (_con.containsKey(CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get(CONDITION_ORG_ID).toString());
                CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
                OrgVO orgVO = orgResp.getData();
                /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                }
                else {
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                            .findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId)
                            .collect(Collectors.toList())));
                }
            }
            if(_con.containsKey("purchaseType")){
                Integer purchaseType = _con.getInteger("purchaseType");
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ,purchaseType));
            }
        }
        IPage<OtherInviteEntity> page = service.queryPage(param, false);
        IPage<OtherInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherInviteVO.class));

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<OtherInviteVO> otherInviteVOList = pageData.getRecords();
            List<String> idList = otherInviteVOList.stream().map(OtherInviteVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("inviteId", new Parameter(QueryParam.IN, idList));
            List<OtherInviteDetailRecordEntity> detailEntityList = detailRecordService.queryList(detailParam);
            List<OtherInviteDetailRecordVO> detailVOList = BeanMapper.mapList(detailEntityList, OtherInviteDetailRecordVO.class);
            Map<Long, List<OtherInviteDetailRecordVO>> detailMap = new HashMap<>();
            List<OtherInviteDetailRecordVO> mapList;
            // 按照planID对子表结果分组
            for (OtherInviteDetailRecordVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getInviteId())) {
                    detailMap.get(vo.getInviteId()).add(vo);
                }
                else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getInviteId(), mapList);
                }
            }
            // 将清单添加到主表中
            otherInviteVOList.forEach(t -> {
                t.setOtherDetailRecord(detailMap.get(t.getId()));
            });
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
     }

    /**
     * @Description saveOrUpdate 获取流/废标状态
     */
    @RequestMapping(value = "/getAType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = service.getAbolishType(tenderId);
        return CommonResponse.success("查询流/废标状态成功！",map);
    }
    /**
     * @Description 子表导出
     * @param
     * @Return void
     */
    @RequestMapping(value = "/detailExcelExport", method = RequestMethod.GET)
    @ResponseBody
    public void detailExcelExport(Long id,HttpServletResponse response) {
        OtherInviteVO otherInviteVO = queryDetail(id).getData();
        List<OtherInviteDetailRecordVO> detailList = otherInviteVO.getOtherDetailRecord();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("otherInviteDetail.xlsx", beans, response);
    }

    @RequestMapping(value = "/queryContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContract(@RequestBody OtherInviteVO inviteVO) {
        Long refId;
        //招标立项
        if (inviteVO.getEstablishType()==0){
            OtherPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<OtherPicketageEntity>().eq("invite_id", inviteVO.getId())).get(0);
            refId=picketageEntity.getId();
        }else {
            refId = inviteVO.getId();
        }
        logger.info("定标ID"+refId);
        List<OtherPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<OtherPicketageRefsupplierEntity>().eq("picketage_id", refId));
        List<String> idList = refsupplierList.stream().map(OtherPicketageRefsupplierEntity::getId).map(String::valueOf).collect(Collectors.toList());
        logger.info("定标参照ID"+JSONObject.toJSONString(idList));
        CommonResponse<List<SignContractVo>> response = contractApi.queryContractByTargetResultId(idList);
        if (!response.isSuccess()){
            throw new BusinessException("查询合同失败"+response.getMsg());
        }
        response.getData().forEach(t->t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        return CommonResponse.success(response.getData());
    }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadExcel")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "otherInvite-import.xlsx", "其他招标明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/uploadExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<OtherInviteDetailRecordVO> successList = new ArrayList<>();
        List<OtherInviteDetailRecordVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();

                    List<String> datas = result.get(i);
                    OtherInviteDetailRecordVO detailVO = new OtherInviteDetailRecordVO();
                    detailVO.setId(IdWorker.getId());
                    detailVO.setMaterialTypeName(datas.get(0));
                    detailVO.setMaterialName(datas.get(1));
                    detailVO.setSpec(datas.get(2));
                    detailVO.setUnit(datas.get(3));

                    if (StringUtils.isBlank(datas.get(4))) {
                        errorMessage.append("[数量为必填项]");
                    } else {
                        try {
                            detailVO.setNum(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            errorMessage.append("[数量格式错误]");
                        }
                    }

                    //*招标控制单价（无税）
                    if (StringUtils.isBlank(datas.get(5))) {
                        errorMessage.append("[招标控制单价（无税）为必填项]");
                    } else {
                        try {
                            detailVO.setPrice(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            errorMessage.append("[招标控制单价（无税）必须为数字]");
                        }
                    }

                    //*招标控制单价
                    if (StringUtils.isBlank(datas.get(6))) {
                        errorMessage.append("[招标控制单价为必填项]");
                    } else {
                        try {
                            detailVO.setTaxPrice(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            errorMessage.append("[招标控制单价必须为数字]");
                        }
                    }

                    //*招标控制单价
                    if (StringUtils.isBlank(datas.get(7))) {
                        errorMessage.append("[税率%为必填项]");
                    } else {
                        try {
                            detailVO.setRate(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            errorMessage.append("[税率%必须为数字]");
                        }
                    }

                    detailVO.setAddress(datas.get(8));

                    //招标控制金额
                    try {
                        detailVO.setMoneyTax(new BigDecimal(datas.get(9)));
                    } catch (Exception e) {
                        errorMessage.append("[招标控制金额必须为数字]");
                    }

                    //招标控制金额(无税)
                    try {
                        detailVO.setMoney(new BigDecimal(datas.get(10)));
                    } catch (Exception e) {
                        errorMessage.append("[招标控制金额(无税)必须为数字]");
                    }
                    detailVO.setMemo(datas.get(11));

                    if (StringUtils.isBlank(errorMessage)) {
                        //重算金额
                        detailVO.setMoneyTax(ComputeUtil.safeMultiply(detailVO.getTaxPrice(), detailVO.getNum()));
                        //公式：无税=含税/（1+税率）
                        detailVO.setMoney(ComputeUtil.safeDiv(detailVO.getMoneyTax(), ComputeUtil.safeAdd(new BigDecimal(1), ComputeUtil.safeDiv(detailVO.getRate(), new BigDecimal(100)))));
                        detailVO.setPrice(ComputeUtil.safeDiv(detailVO.getTaxPrice(), ComputeUtil.safeAdd(new BigDecimal(1), ComputeUtil.safeDiv(detailVO.getRate(), new BigDecimal(100)))));
                        detailVO.setTax(ComputeUtil.safeSub(detailVO.getMoneyTax(), detailVO.getMoney()));
                        successList.add(detailVO);
                    }else {
                        detailVO.setErrorMsg(String.valueOf(errorMessage));
                        errorList.add(detailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
    @RequestMapping(value = "/closeSignStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        OtherInviteEntity entity = service.selectById(id);
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            //处于未签订、部分签订
            if (entity.getSignStatus() == 0 || entity.getSignStatus() == 1) {
                //招标立项
                if (establishType == 0) {
                    if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                        OtherPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<OtherPicketageEntity>().eq("invite_id", id)).get(0);
                        refId = picketageEntity.getId();
                    }
                }
                //定标立项
                else {
                    if (entity.getBillState() == 1 || entity.getBillState() == 3) {
                        refId = id;
                    }
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
            if (refId != null) {
                logger.info("定标ID" + refId);
                List<OtherPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<OtherPicketageRefsupplierEntity>().eq("picketage_id", refId));
                if (CollectionUtils.isNotEmpty(refsupplierList)){
                    refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.已关闭.getCode()));
                    refsupplierService.saveOrUpdateBatch(refsupplierList);
                    entity.setSignStatus(TenderSignStatusEnum.已关闭.getCode());
                    service.saveOrUpdate(entity);
                }else {
                    throw new BusinessException("不符合关闭条件");
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
        }
        else {
            throw new BusinessException("只有招标经办人才能关闭");
        }
        return CommonResponse.success("关闭成功！");
    }
    /**
     * @Description  判断当前登录人和招标经办人是否相同
     */
    @RequestMapping(value = "/judgeEmployee", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee (Long inviteId) {
        boolean flag = false;
        OtherInviteEntity entity = service.selectById(inviteId);
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            flag = true;
        }
        return CommonResponse.success("查询数据成功！", flag);
    }
}
