package com.ejianc.business.tender.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping("/otherInviteFileUpdate/")
public class OtherInviteFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOtherInviteService otherInviteService;



    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(updateData.getLong("billId"));
        otherInviteEntity.setContractFileId(updateData.getLong("fileId"));
        otherInviteEntity.setContractFileHighlightId(updateData.getLong("fileId"));
        otherInviteEntity.setContractFilePath(updateData.getString("fileOnlinePath"));
        otherInviteEntity.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        //将合同文件同步状态设置为已同步
        otherInviteEntity.setContractFileSyncFlag(true);
        otherInviteService.saveOrUpdate(otherInviteEntity, false);

        resp.put("message", "招标文件信息更新成功");
        resp.put("billData", otherInviteEntity);
        return CommonResponse.success("招标文件信息更新成功！", resp);
    }


    @GetMapping(value = "getBillDataJson")
    public CommonResponse<OtherInviteVO> getBillDataJson(@RequestParam Long id) {
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(id);
        OtherInviteVO vo = BeanMapper.map(otherInviteEntity, OtherInviteVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if(CollectionUtils.isNotEmpty(vo.getOtherDetailRecord())) {
            //合同明细清单处理
            vo.getOtherDetailRecord().forEach(item -> {
                item.setRateStr(priceFmt.format(null != item.getRate() ? item.getRate() : BigDecimal.ZERO));
                item.setMoneyTaxStr(mnyFmt.format(null != item.getMoneyTax() ? item.getMoneyTax() : BigDecimal.ZERO));
            });
        }
        return CommonResponse.success(vo);
    }

}
