package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.other.bean.OtherAdviceEntity;
import com.ejianc.business.tender.other.bean.OtherBidEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherBidService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherAdviceSupplierPushVO;
import com.ejianc.business.tender.other.vo.OtherAdviceVO;
import com.ejianc.business.tender.stuff.bean.StuffAdviceEntity;
import com.ejianc.business.tender.stuff.bean.StuffBidEntity;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.stuff.service.IStuffBidService;
import com.ejianc.business.tender.stuff.vo.StuffAdviceVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.other.mapper.OtherAdviceMapper;
import com.ejianc.business.tender.other.bean.OtherAdviceEntity;
import com.ejianc.business.tender.other.service.IOtherAdviceService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 其它-中标通知书
 * 
 * @author generator
 * 
 */
@Service("otherAdviceService")
public class OtherAdviceServiceImpl extends BaseServiceImpl<OtherAdviceMapper, OtherAdviceEntity> implements IOtherAdviceService{
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000004";//此处需要根据实际修改
    @Autowired
    private IOtherBidService otherBidService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
        OtherAdviceEntity otherAdviceEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            otherAdviceEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            otherAdviceEntity.setSignFlag(1);
        }
        if(status == 4){
            otherAdviceEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(otherAdviceEntity.getId());
            cv.setContractName(otherAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(otherAdviceEntity);

        return CommonResponse.success("更新成功!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        OtherAdviceEntity otherAdviceEntity = super.selectById(id);
        otherAdviceEntity.setSendFlag(0);
        super.updateById(otherAdviceEntity);
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherAdviceEntity.getInviteId());
        OtherAdviceSupplierPushVO otherAdviceSupplierPushVO = BeanMapper.map(otherAdviceEntity, OtherAdviceSupplierPushVO.class);

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        otherAdviceSupplierPushVO.setSystemId(ejcCloudSystemCode.getData());
        otherAdviceSupplierPushVO.setSourceType("云南建投材料中标通知书");
        otherAdviceSupplierPushVO.setSourceId(otherAdviceEntity.getId().toString());
        otherAdviceSupplierPushVO.setBidTitle(otherAdviceEntity.getTitleName());
        otherAdviceSupplierPushVO.setSourceProjectId(otherAdviceEntity.getProjectId() != null ? otherAdviceEntity.getProjectId().toString() : null);
        otherAdviceSupplierPushVO.setSourceOrgId(otherAdviceEntity.getOrgId().toString());
        otherAdviceSupplierPushVO.setSourceUnitId(otherAdviceEntity.getUnitId().toString());
//        otherAdviceSupplierPushVO.setType("TYPE_MATERIAL");
        otherAdviceSupplierPushVO.setType(CommonUtils.getGysType(CommonUtils.TYPE_OTHER));
        otherAdviceSupplierPushVO.setTenderType(otherInviteEntity.getTenderType());
        otherAdviceSupplierPushVO.setBidDate(otherAdviceEntity.getNoticeDate());
        otherAdviceSupplierPushVO.setMoney(otherAdviceEntity.getMoney());
        otherAdviceSupplierPushVO.setMoneyTax(otherAdviceEntity.getMoneyTax());

        String dataInfo = JSONObject.toJSONString(otherAdviceSupplierPushVO);

        boolean b = stuffAdviceService.pushBillToSupCenter(dataInfo, otherAdviceEntity.getSupplierId(), otherAdviceEntity.getId(),
                BILL_TYPE, PUSH_ADVICE_SERVER_URL, otherAdviceEntity.getTitleName());
        if (!b){
            throw new BusinessException("推送供方失败!");
        }
        return null;
    }

    @Override
    public List<OtherAdviceVO> queryAdviceList(Long id) {
        OtherBidEntity otherBidEntity = otherBidService.selectById(id);
        LambdaQueryWrapper<OtherAdviceEntity> lambdaAdvice = Wrappers.<OtherAdviceEntity>lambdaQuery();
        lambdaAdvice.eq(OtherAdviceEntity::getInviteId, otherBidEntity.getInviteId());
        List<OtherAdviceEntity> list = super.list(lambdaAdvice);
        List<OtherAdviceVO> otherAdviceVOS = BeanMapper.mapList(list, OtherAdviceVO.class);
        //处理签章附件信息
        if (CollectionUtils.isNotEmpty(otherAdviceVOS)) {
            List<Long> attachIds = otherAdviceVOS.stream().map(OtherAdviceVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    for (OtherAdviceVO otherAdviceVO : otherAdviceVOS) {
                        AttachmentVO attachmentVO = attacMap.get(otherAdviceVO.getId());
                        if (attachmentVO != null) {
                            otherAdviceVO.setAttachId(attachmentVO.getId());
                            otherAdviceVO.setFileName(attachmentVO.getFileName());
                            otherAdviceVO.setFilePath(attachmentVO.getFilePath());
                        }
                    }
                }
            }
        }
        return otherAdviceVOS;
    }
}
