package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherNoticeDetailMapper;
import com.ejianc.business.tender.other.mapper.OtherNoticeMapper;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherNoticeService;
import com.ejianc.business.tender.other.service.IOtherNoticeSupplierDetailService;
import com.ejianc.business.tender.other.service.IOtherNoticeSupplierService;
import com.ejianc.business.tender.other.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
@Service("otherNoticeService")
public class OtherNoticeServiceImpl extends BaseServiceImpl<OtherNoticeMapper, OtherNoticeEntity> implements IOtherNoticeService {

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IOtherNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private OtherNoticeDetailMapper otherNoticeDetailMapper;

    @Autowired
    private IOtherNoticeSupplierService supplierService;

    @Autowired
    private IOtherInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        baseMapper.updateEndTime(noticeId,newTime);
    }

    @Transactional
    @Override
    public CommonResponse publish(OtherNoticeVO otherNoticeVO) throws InvocationTargetException, IllegalAccessException {
        //插入主表数据
        OtherNoticeEntity otherNoticeEntity = baseMapper.selectById(otherNoticeVO.getId());
        OtherInviteEntity inviteEntity = inviteService.selectById(otherNoticeEntity.getInviteId());
        otherNoticeEntity.setPublishFlag(0);
        baseMapper.updateById(otherNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        OtherNoticeSupplierTbVO otherNoticeSupplierTbVO = new OtherNoticeSupplierTbVO();
        BeanUtils.copyProperties(otherNoticeSupplierTbVO, otherNoticeEntity);
        otherNoticeSupplierTbVO.setNoticeStartTime(sdf.format(otherNoticeEntity.getNoticeStartTime()));
        otherNoticeSupplierTbVO.setNoticeEndTime(sdf.format(otherNoticeEntity.getNoticeEndTime()));
        otherNoticeSupplierTbVO.setNoticeType(0);
        if (otherNoticeEntity.getPurchaseType()==1){
            otherNoticeSupplierTbVO.setSourceProjectId(null);
        }else {
            otherNoticeSupplierTbVO.setSourceProjectId(otherNoticeEntity.getProjectId().toString());
        }
        otherNoticeSupplierTbVO.setSourceId(otherNoticeEntity.getInviteId().toString());
        otherNoticeSupplierTbVO.setSourceType("云南建投招标公告");
        otherNoticeSupplierTbVO.setSourceOrgId(otherNoticeEntity.getOrgId().toString());
        otherNoticeSupplierTbVO.setSourceUnitId(otherNoticeEntity.getUnitId().toString());
        otherNoticeSupplierTbVO.setType("OTHER");
        otherNoticeSupplierTbVO.setTenderName(otherNoticeEntity.getNoticeName());
        otherNoticeSupplierTbVO.setSourceEmployeeId(otherNoticeEntity.getEmployeeId().toString());
        otherNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        otherNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        otherNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        otherNoticeSupplierTbVO.setId(null);
        otherNoticeSupplierTbVO.setCreateTime(null);
        otherNoticeSupplierTbVO.setUpdateTime(null);
        otherNoticeSupplierTbVO.setCreateUserCode(null);
        otherNoticeSupplierTbVO.setUpdateUserCode(null);
        otherNoticeSupplierTbVO.setSyncEsFlag(null);
        otherNoticeSupplierTbVO.setVersion(null);
        otherNoticeSupplierTbVO.setTenantId(null);
        otherNoticeSupplierTbVO.setDr(null);
        //插入物资
        List<OtherNoticeDetailEntity> noticeDetailEntityList = otherNoticeDetailMapper.selectList(new LambdaQueryWrapper<OtherNoticeDetailEntity>().eq(OtherNoticeDetailEntity::getNoticeId, otherNoticeVO.getId()));
        List<OtherNoticeDetailTbVO> otherNoticeDetailVOS = new ArrayList<>();
        for (OtherNoticeDetailEntity otherNoticeDetailEntity : noticeDetailEntityList) {
            OtherNoticeDetailTbVO otherNoticeDetailTbVO = new OtherNoticeDetailTbVO();
            BeanUtils.copyProperties(otherNoticeDetailTbVO, otherNoticeDetailEntity);
            otherNoticeDetailTbVO.setPriceTender(otherNoticeDetailEntity.getPrice());
            otherNoticeDetailTbVO.setTaxPriceTender(otherNoticeDetailEntity.getTaxPrice());
            otherNoticeDetailTbVO.setSourceId(otherNoticeEntity.getInviteId().toString());
            otherNoticeDetailTbVO.setSourceDetailId(otherNoticeDetailEntity.getId().toString());
            otherNoticeDetailTbVO.setSourceMaterialId(otherNoticeDetailEntity.getMaterialId()==null?null: otherNoticeDetailEntity.getMaterialId().toString());
            otherNoticeDetailTbVO.setSourceMaterialTypeId(otherNoticeDetailEntity.getMaterialTypeId()==null?null: otherNoticeDetailEntity.getMaterialTypeId().toString());
            otherNoticeDetailVOS.add(otherNoticeDetailTbVO);

        }
        otherNoticeSupplierTbVO.setOtherDetailList(otherNoticeDetailVOS);
        //是否是邀请招标
        if (otherNoticeVO.getTenderType()==1){
            List<OtherNoticeSupplierDetailEntity> detailEntityList = noticeSupplierDetailService.list(new LambdaQueryWrapper<OtherNoticeSupplierDetailEntity>().eq(OtherNoticeSupplierDetailEntity::getInviteId, otherNoticeEntity.getInviteId()).eq(OtherNoticeSupplierDetailEntity::getDr, 0));
            List<OtherNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (OtherNoticeSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                OtherNoticeSupplierDetailTbVO otherNoticeSupplierDetailTbVO = new OtherNoticeSupplierDetailTbVO();
                otherNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                otherNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo 暂时写死
                otherNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(otherNoticeSupplierDetailTbVO);
            }
            otherNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        //调用第三方接口
//        CommonResponse<JSONObject> response = null;
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, JSON.toJSONString(otherNoticeSupplierTbVO),cacheManager);
//            if(!response.isSuccess()) {
//                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            return CommonResponse.error("调用平台报名接口失败");
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(otherNoticeSupplierTbVO), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        //招标公告发布成功后 改招标状态 为报名中
        inviteEntity.setTenderState(TenderStateEnum.报名中.getCode());
        inviteEntity.setStopTime(otherNoticeEntity.getNoticeEndTime());
        inviteService.saveOrUpdate(inviteEntity);
        return CommonResponse.success("公告信息推送成功");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<OtherNoticeEntity>().eq(OtherNoticeEntity::getInviteId,sourceId)).getId();
    }

    @Override
    public boolean selectFile(OtherNoticeVO vo) {
        List<OtherNoticeSupplierEntity> noticeSupplieotherityList = supplierService.list(new QueryWrapper<OtherNoticeSupplierEntity>().eq("notice_id", vo.getId()).eq("dr", 0));
        List<OtherNoticeSupplierVO> otherNoticeSupplierVOS = BeanMapper.mapList(noticeSupplieotherityList, OtherNoticeSupplierVO.class);
        //处理供应商附件信息
        if (CollectionUtils.isNotEmpty(otherNoticeSupplierVOS)){
            List<Long> attachIds = otherNoticeSupplierVOS.stream().map(OtherNoticeSupplierVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds",attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId),Function.identity());
                    Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                    for (OtherNoticeSupplierVO otherNoticeSupplierVO : otherNoticeSupplierVOS){
                        List<AttachmentVO> attachmentVOList = attacMap.get(otherNoticeSupplierVO.getId());
                        if (attachmentVOList!=null){
                            ArrayList<Map<String, Object>> list = new ArrayList<>();
                            for (AttachmentVO attachmentVO : attachmentVOList) {
                                HashMap<String, Object> hashMap = new HashMap<>();
                                hashMap.put("attachId",attachmentVO.getId());
                                hashMap.put("name",attachmentVO.getFileName());
                                list.add(hashMap);
                            }
                            otherNoticeSupplierVO.setFile(list);
                        }else {
                            otherNoticeSupplierVO.setAttachId(null);
                            otherNoticeSupplierVO.setFileName(null);
                        }
                    }
                }
            }
            vo.setNoticeSupplierDetail(otherNoticeSupplierVOS);
        }
        return true;
    }
}
