package com.ejianc.business.tender.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.rent.vo.RentPicketageRefsupplierVO;
import com.ejianc.business.tender.rent.service.impl.RentPicketageBpmServiceImpl;
import com.ejianc.business.tender.rent.vo.RentDocumentSellVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentPicketageRefsupplier")
@Api(value = "定标供应商参照表(下游单据使用)", tags = {"定标供应商参照表(下游单据使用)"})
public class RentPicketageRefsupplierController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private RentPicketageBpmServiceImpl rentPicketageBpmService;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRentInviteService inviteService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRentPicketageRefsupplierService service;
    @Autowired
    private IRentInviteDetailBidderService rentInviteDetailBidderService;
    @Autowired
    private IRentInviteDetailRecordService rentInviteDetailRecordService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareSupplierApi supplierApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentPicketageRefsupplierVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody RentPicketageRefsupplierVO saveOrUpdateVO) {
    	RentPicketageRefsupplierEntity entity = BeanMapper.map(saveOrUpdateVO, RentPicketageRefsupplierEntity.class);
    	service.saveOrUpdate(entity, false);
    	RentPicketageRefsupplierVO vo = BeanMapper.map(entity, RentPicketageRefsupplierVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentPicketageRefsupplierVO> queryDetail(@RequestParam Long id) {
    	RentPicketageRefsupplierEntity entity = service.selectById(id);
    	RentPicketageRefsupplierVO vo = BeanMapper.map(entity, RentPicketageRefsupplierVO.class);
        if(0==entity.getPicketageFlag()) {
            RentPicketageEntity picketageEntity = rentPicketageService.selectById(entity.getPicketageId());
            vo.setInviteId(picketageEntity.getInviteId());
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }



    @ApiOperation("参照")
    @RequestMapping(value = "/refRentsupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentPicketageRefsupplierVO>> refRentsupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("picketageName");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //未占用状态
//        param.getParams().put("occupyFlag", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("picketageDate",QueryParam.DESC);

        //查询本下范围内日的合同
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        if(CollectionUtils.isNotEmpty(orgVOList)) {
            List<Long> ids = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, ids));
        }
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("purchaseType")) {
                Integer purchaseType = Integer.parseInt(conditionMap.get("purchaseType").toString());
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ, purchaseType));
            }
        }

        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(TenderSignStatusEnum.未签订.getCode());
        listStatus.add(TenderSignStatusEnum.部分签订.getCode());
        param.getParams().put("signStatus", new Parameter(QueryParam.IN, listStatus));
        new Integer(1);

        IPage<RentPicketageRefsupplierEntity> page = service.queryPage(param,false);
        IPage<RentPicketageRefsupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<RentPicketageRefsupplierEntity> records = page.getRecords();
        if (CollectionUtils.isNotEmpty(records)){
            List<Long> supplierIdList = records.stream().distinct().map(RentPicketageRefsupplierEntity::getSupplierId).collect(Collectors.toList());
            logger.info("supplierIdList:{}", JSONObject.toJSONString(supplierIdList));
            CommonResponse<List<SupplierDTO>> listCommonResponse = supplierApi.querySupplierDTOByIds(supplierIdList);
            Map<Long, String> supplierMap = new HashMap<>();
            if (listCommonResponse.isSuccess()){
                List<SupplierDTO> supplierVOList = listCommonResponse.getData();
                logger.info("supplierVOList:{}", JSONObject.toJSONString(supplierVOList));
                supplierMap = supplierVOList.stream().collect(Collectors.toMap(SupplierDTO::getId, SupplierDTO::getName));
            }else {
                throw new BusinessException("获取项目信息失败，失败原因：" + listCommonResponse.getMsg());
            }
            for (RentPicketageRefsupplierEntity rentPicketageRefsupplierEntity : records) {
                if (supplierMap.containsKey(rentPicketageRefsupplierEntity.getSupplierId())){
                    rentPicketageRefsupplierEntity.setSupplierName(supplierMap.get(rentPicketageRefsupplierEntity.getSupplierId()));
                }
                if (rentPicketageRefsupplierEntity.getPurchaseType() == 0) {
//                    (0-项目采购,1-单位采购)
                    rentPicketageRefsupplierEntity.setPurchaseTypeName("项目采购");
                }
                if (rentPicketageRefsupplierEntity.getPurchaseType() == 1) {
//                    (0-项目采购,1-单位采购)
                    rentPicketageRefsupplierEntity.setPurchaseTypeName("公司采购");
                }

                if (rentPicketageRefsupplierEntity.getPicketageFlag() == 0) {
                    //流程定标
                    RentPicketageEntity subPicketageEntity = rentPicketageService.selectById(rentPicketageRefsupplierEntity.getPicketageId());
                    RentInviteEntity rentInviteEntity= inviteService.selectById(subPicketageEntity.getInviteId());
                    rentPicketageRefsupplierEntity.setEquipmentType(rentInviteEntity.getEquipmentType());
                }else{
                    RentInviteEntity rentInviteEntity= inviteService.selectById(rentPicketageRefsupplierEntity.getPicketageId());
                    rentPicketageRefsupplierEntity.setEquipmentType(rentInviteEntity.getEquipmentType());
                }

            }
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentPicketageRefsupplierVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @ApiOperation("定标子表参照")
    @RequestMapping(value = "/refRentDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentDocumentSellVO>> refRentDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        Long id = null;

        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("id")) {
                id = Long.valueOf(conditionMap.get("id").toString());
            }
        }
        RentPicketageRefsupplierEntity rentPicketageRefsupplierEntity = service.selectById(id);
        Integer picketageFlag = rentPicketageRefsupplierEntity.getPicketageFlag();
        //定标类型0-流程定标,1-直接定标  区分数据源
        if (picketageFlag == 0) {
            RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(rentPicketageRefsupplierEntity.getPicketageId());
            param.getParams().put("documentId", new Parameter(QueryParam.EQ, rentPicketageEntity.getDocumentId()));
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, rentPicketageRefsupplierEntity.getSupplierId()));
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, rentPicketageRefsupplierEntity.getProjectId()));
            param.getParams().put("tenderFlag", new Parameter(QueryParam.EQ, 1));
            IPage<RentDocumentSellEntity> page = rentDocumentSellService.queryPage(param, false);
            IPage<RentDocumentSellVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<RentDocumentSellVO> rentDocumentSellVOList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(page.getRecords())) {
                rentDocumentSellVOList = BeanMapper.mapList(page.getRecords(), RentDocumentSellVO.class);
            }
            pageData.setRecords(rentDocumentSellVOList);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }

        if (picketageFlag == 1) {
            List<RentDocumentSellVO> rentDocumentSellVOS = new ArrayList<>();
            List<RentInviteDetailBidderEntity> bidderEntityList1 = rentInviteDetailBidderService.list(new QueryWrapper<RentInviteDetailBidderEntity>()
                    .eq("invite_id", rentPicketageRefsupplierEntity.getPicketageId())
                    .eq("supplier_id", rentPicketageRefsupplierEntity.getSupplierId())
                    .eq("dr", 0));
            for (RentInviteDetailBidderEntity bidderEntity : bidderEntityList1) {
                RentDocumentSellVO rentDocumentSellVO = new RentDocumentSellVO();
                RentInviteDetailRecordEntity recordEntity = rentInviteDetailRecordService.selectById(bidderEntity.getInviteDetailId());
                rentDocumentSellVO.setId(bidderEntity.getId());
                rentDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                rentDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                rentDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                rentDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                rentDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                rentDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                rentDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                rentDocumentSellVO.setUnit(recordEntity.getUnit());
                rentDocumentSellVO.setSpec(recordEntity.getSpec());
                rentDocumentSellVO.setDetailId(bidderEntity.getId());
                rentDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                rentDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                rentDocumentSellVO.setBrand(bidderEntity.getBrand());
                rentDocumentSellVO.setPrice(bidderEntity.getPrice());
                rentDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                rentDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                rentDocumentSellVO.setTenderNum(bidderEntity.getNum());
                rentDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                rentDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                rentDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                rentDocumentSellVOS.add(rentDocumentSellVO);
            }
            IPage<RentDocumentSellVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), rentDocumentSellVOS.size());
            // 进行分页处理
            pageDate.setRecords(rentDocumentSellVOS.stream().skip((long) (param.getPageIndex() - 1) * param.getPageSize())
                    .limit(param.getPageSize()).collect(Collectors.toList()));
            return CommonResponse.success("查询参照数据成功！", pageDate);
        }
        return null;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
