package com.ejianc.business.tender.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.rent.vo.RentDocumentSellVO;
import com.ejianc.business.tender.rent.mapper.RentDocumentSellMapper;
import com.ejianc.business.tender.stuff.bean.StuffPicketageRefsupplierEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 招标文件报价表
 * 
 * @author generator
 * 
 */
@Service("rentDocumentSellService")
public class RentDocumentSellServiceImpl extends BaseServiceImpl<RentDocumentSellMapper, RentDocumentSellEntity> implements IRentDocumentSellService {
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRentInviteDetailBidderService bidderService;
    @Autowired
    private IRentInviteDetailRecordService recordService;
    @Autowired
    private IRentPicketageRefsupplierService rentPicketageRefsupplierService;

    @Override
    public List<RentDocumentSellEntity> selectMaterialType(Long documentId) {
        return baseMapper.selectMaterialType(documentId);
    }

    @Override
    public List<RentDocumentSellVO> queryListByIds(Long id) {

        RentPicketageRefsupplierEntity rentPicketageRefsupplierEntity = rentPicketageRefsupplierService.selectById(id);
        List<RentDocumentSellVO> rentDocumentSellVOList = new ArrayList<>();
        RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(rentPicketageRefsupplierEntity.getPicketageId());
        //流程定标
        if (rentPicketageRefsupplierEntity.getPicketageFlag()==0){
            LambdaQueryWrapper<RentDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(RentDocumentSellEntity::getDocumentId,rentPicketageEntity.getDocumentId());
            listWrapper.eq(RentDocumentSellEntity::getSupplierId,rentPicketageRefsupplierEntity.getSupplierId());
            if (rentPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(RentDocumentSellEntity::getProjectId,rentPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(RentDocumentSellEntity::getTenderFlag,1);
            listWrapper.eq(RentDocumentSellEntity::getPassFlag,1);
            List<RentDocumentSellEntity> documentSellList = super.list(listWrapper);
            rentDocumentSellVOList = BeanMapper.mapList(documentSellList,RentDocumentSellVO.class);
        }
        //直接定标
        else if (rentPicketageRefsupplierEntity.getPicketageFlag()==1){
            List<RentInviteDetailBidderEntity> bidderEntityList = bidderService.list(new QueryWrapper<RentInviteDetailBidderEntity>().eq("invite_id", rentPicketageRefsupplierEntity.getPicketageId()).eq("supplier_id",rentPicketageRefsupplierEntity.getSupplierId()));
            for (RentInviteDetailBidderEntity bidderEntity : bidderEntityList) {
                RentDocumentSellVO rentDocumentSellVO = new RentDocumentSellVO();
                RentInviteDetailRecordEntity recordEntity = recordService.selectById(bidderEntity.getInviteDetailId());
                rentDocumentSellVO.setId(bidderEntity.getId());
                rentDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                rentDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                rentDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                rentDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                rentDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                rentDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                rentDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                rentDocumentSellVO.setUnit(recordEntity.getUnit());
                rentDocumentSellVO.setSpec(recordEntity.getSpec());
                rentDocumentSellVO.setDetailId(bidderEntity.getId());
                rentDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                rentDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                rentDocumentSellVO.setBrand(bidderEntity.getBrand());
                rentDocumentSellVO.setPrice(bidderEntity.getPrice());
                rentDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                rentDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                rentDocumentSellVO.setTenderNum(bidderEntity.getNum());
                rentDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                rentDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                rentDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                rentDocumentSellVO.setPlanEnterDate(recordEntity.getPlanEnterDate());
                rentDocumentSellVO.setPlanLeaveDate(recordEntity.getPlanLeaveDate());
                rentDocumentSellVO.setPlanDay(recordEntity.getPlanDay());
                rentDocumentSellVO.setFlagOil(recordEntity.getFlagOil());
                rentDocumentSellVO.setFlagOperation(recordEntity.getFlagOperation());
                rentDocumentSellVO.setBillingUnitName(recordEntity.getBillingUnitName());
                rentDocumentSellVO.setBillingUnitId(recordEntity.getBillingUnitId());
                rentDocumentSellVO.setRentNum(recordEntity.getRentNum());
                rentDocumentSellVOList.add(rentDocumentSellVO);
            }
        }
        return rentDocumentSellVOList;
    }
}
