package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.rent.vo.RentPlanEnum;
import com.ejianc.business.tender.enums.DraftTypeEnum;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentPicketageRefsupplierService;
import com.ejianc.business.tender.rent.vo.RentInviteDetailVO;
import com.ejianc.business.tender.rent.bean.RentInviteDetailEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentInviteDetailService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.bean.RentPicketageRefsupplierEntity;
import com.ejianc.business.tender.rent.vo.RentInviteDetailBidderVO;
import com.ejianc.business.tender.rent.vo.RentInviteVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("rentInvite")
public class RentInviteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private IRentInviteService service;

	@Autowired
	private IRentInviteDetailService detailService;

	@Autowired
	private IRentPicketageRefsupplierService picketageRefsupplierService;

	@Autowired
	private IProjectPoolApi projectPoolApi;
	

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentInviteEntity rentInviteEntity = service.selectById(billId);
		if(0==rentInviteEntity.getEstablishType()){
			if(DraftTypeEnum.线上起草.getCode().toString().equals(rentInviteEntity.getDraftType().toString())) {
				if(null == rentInviteEntity.getContractFileId()) {
					//确保线上起草方式时，用户已编辑合同文件
					return CommonResponse.error("请编辑招标文件并保存后再执行此操作！");
				}
				if(!rentInviteEntity.getContractFileSyncFlag()) {
					return CommonResponse.error("请重新进行招标文件编辑，同步单据信息到招标文件！");
				}
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentInviteEntity rentInviteEntity = service.selectById(billId);
		if(0==rentInviteEntity.getEstablishType()){
			if(DraftTypeEnum.线上起草.getCode().toString().equals(rentInviteEntity.getDraftType().toString())) {
				if(null == rentInviteEntity.getContractFileId()) {
					//确保线上起草方式时，用户已编辑合同文件
					return CommonResponse.error("请编辑招标文件并保存后再执行此操作！");
				}
				if(!rentInviteEntity.getContractFileSyncFlag()) {
					return CommonResponse.error("请重新进行招标文件编辑，同步单据信息到招标文件！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state ||BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
			RentInviteEntity inviteEntity = service.selectById(billId);
			List<RentInviteDetailVO> detailVOList = new ArrayList<>();
			if (inviteEntity.getPurchaseType()==0){
				 detailVOList = service.selectSumDetail(billId);
			}else {
				 detailVOList  =  service.selectOrgSumDetail(billId);
			}
			for (RentInviteDetailVO rentInviteDetailVO : detailVOList) {
				rentInviteDetailVO.setNum(rentInviteDetailVO.getSumNum());
				rentInviteDetailVO.setMoney(rentInviteDetailVO.getSumMoney());
				rentInviteDetailVO.setMoneyTax(rentInviteDetailVO.getSumMoneyTax());
				detailService.saveOrUpdate(BeanMapper.map(rentInviteDetailVO, RentInviteDetailEntity.class));
			}
			if (inviteEntity.getEstablishType()==1){
				// 获取采购计划ID
				if (CollectionUtils.isNotEmpty(inviteEntity.getRentDetailRecord())) {
					// 释放采购计划
					service.updateApiState(inviteEntity, RentPlanEnum.PLAN_STATE_OVER.getPlanState(), RentPlanEnum.PLAN_STATE_OVER.getPlanState());
				}
			}
			List<RentInviteDetailBidderVO> detailBidderList =  service.selectDetailBidder(billId);
			String tenderUnitNum = "";
			for (RentInviteDetailBidderVO detailBidderVO : detailBidderList) {
				RentPicketageRefsupplierEntity rentPicketageRefsupplierEntity = new RentPicketageRefsupplierEntity();
				rentPicketageRefsupplierEntity.setPicketageId(billId);
				rentPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName()+"定标");
				rentPicketageRefsupplierEntity.setPicketageDate(new Date());

				rentPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
				rentPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
				rentPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
				rentPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
				rentPicketageRefsupplierEntity.setProjectId(detailBidderVO.getDetailProjectId());
				rentPicketageRefsupplierEntity.setProjectName(detailBidderVO.getDetailProjectName());
				//如果是项目招标，子表orgId为项目部id
				if (inviteEntity.getPurchaseType()==0){
					Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
					CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(Collections.singletonList(detailBidderVO.getDetailProjectId()));
					if (jsonArrayCommonResponse.isSuccess()){
						JSONArray data = jsonArrayCommonResponse.getData();
						List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
						proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
						ProjectPoolSetVO projectPoolSetVO = proMap.get(detailBidderVO.getDetailProjectId());
						if (projectPoolSetVO != null){
							rentPicketageRefsupplierEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
							rentPicketageRefsupplierEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
						}
					}
				}else {
					rentPicketageRefsupplierEntity.setOrgId(detailBidderVO.getDetailOrgId());
					rentPicketageRefsupplierEntity.setOrgName(detailBidderVO.getDetailOrgName());
				}
				//暂时使用主表
//				rentPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
//				rentPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
//				rentPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
//				rentPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
//				rentPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
//				rentPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
//				rentPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
				rentPicketageRefsupplierEntity.setOccupyFlag(0);
				rentPicketageRefsupplierEntity.setPicketageFlag(1);
				rentPicketageRefsupplierEntity.setRentType(inviteEntity.getRentType());
				rentPicketageRefsupplierEntity.setSignStatus(0);
				rentPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
				picketageRefsupplierService.saveOrUpdate(rentPicketageRefsupplierEntity);
				BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4,BigDecimal.ROUND_HALF_UP);
				tenderUnitNum+=detailBidderVO.getSupplierName()+"("+sumNum+"),";
			}
			if (tenderUnitNum.length() > 1) {
				tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
			}
			inviteEntity.setTenderUnitNum(tenderUnitNum);
			service.saveOrUpdate(inviteEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getOccupyState()!= null && inviteEntity.getOccupyState()==1){
			return CommonResponse.error("招标已被占用,不能撤回!");
		}
		if (inviteEntity.getTenderStage()>1){
			return CommonResponse.error("招标处于"+ TenderStageEnum.getEnumByStateCode(inviteEntity.getTenderStage()).getDescription()+",不能撤回!");
		}
		if (inviteEntity.getEstablishType()==1){
			QueryWrapper<RentPicketageRefsupplierEntity> refWrapper = new QueryWrapper<>();
			refWrapper.eq("picketage_id",inviteEntity.getId());
			List<RentPicketageRefsupplierEntity> refsupplierEntityList = picketageRefsupplierService.list(refWrapper);
			for (RentPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
				if (refsupplierEntity.getSignStatus()!=0){
					return CommonResponse.error("存在已签订合同,不能撤回!");
				}
			}
			picketageRefsupplierService.remove(refWrapper);
		}
		detailService.delByInviteId(inviteEntity.getId());
//		QueryWrapper<RentInviteDetailEntity> detailWrapper = new QueryWrapper<>();
//		detailWrapper.eq("invite_id",inviteEntity.getId());
//		detailService.remove(detailWrapper);
		return CommonResponse.success();
//        return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getEstablishType()==1){
			// 获取采购计划ID
			if (CollectionUtils.isNotEmpty(inviteEntity.getRentDetailRecord())) {
				// 释放采购计划
				service.updateApiState(inviteEntity, RentPlanEnum.PLAN_STATE_EXEC.getPlanState(), RentPlanEnum.PLAN_STATE_EXEC.getPlanState());
			}
		}
		return CommonResponse.success();
	}


	@Override
	public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
		RentInviteEntity e = service.selectById(billId);
		ParamsCheckVO paramsCheckVO = service.priceCheckParams(BeanMapper.map(e,RentInviteVO.class));
		JSONObject object = new JSONObject();
		if(null!=paramsCheckVO&&CollectionUtils.isNotEmpty(paramsCheckVO.getDataSource())){
			object.put("priceFlag","是");//是单价异常
		}else{
			object.put("priceFlag","否");//否 单价异常
		}
		return CommonResponse.success(object);
	}
}
