package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.mapper.RentTalkMapper;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.rent.vo.*;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
@Service("rentTalkService")
public class RentTalkServiceImpl extends BaseServiceImpl<RentTalkMapper, RentTalkEntity> implements IRentTalkService {
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IRentTalkDetailService rentTalkDetailService;
    @Autowired
    private IRentTalkRecordService rentTalkRecordService;
    @Autowired
    private IRentTalkRecordDetailService rentTalkRecordDetailService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000003";
    @Autowired
    private IAttachmentApi attachmentApi;

    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    @Override
    public RentTalkVO publishTalk(Long id) {
        //更新发布状态
        RentTalkEntity rentTalkEntity = super.selectById(id);
        rentTalkEntity.setPublishFlag(0);
        super.updateById(rentTalkEntity);
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentTalkEntity.getInviteId());

        //推送供应商
        RentDocumentSupplierTbVO rentDocumentSupplierTbVO = new RentDocumentSupplierTbVO();
        rentDocumentSupplierTbVO.setSourceId(rentTalkEntity.getInviteId().toString());
        rentDocumentSupplierTbVO.setSourceType("云南建投洽商谈判");
        rentDocumentSupplierTbVO.setNoticeType(4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(rentTalkEntity.getTalkStartTime());
        rentDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(rentTalkEntity.getTalkEndTime());
        rentDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        rentDocumentSupplierTbVO.setMemo(rentTalkEntity.getMemo());
        rentDocumentSupplierTbVO.setTalkMoney(rentTalkEntity.getTalkMoney());
        rentDocumentSupplierTbVO.setTalkNum(rentTalkEntity.getTalkNum());
        rentDocumentSupplierTbVO.setTenderName(rentTalkEntity.getTalkName());
        rentDocumentSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString(rentDocumentSupplierTbVO);
        logger.info("洽商谈判发布" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }

        //招标公告发布成功后 改招标状态 为报价中
        rentInviteEntity.setTenderState(TenderStateEnum.报价中.getCode());
        rentInviteEntity.setStopTime(rentTalkEntity.getTalkEndTime());
        rentInviteService.saveOrUpdate(rentInviteEntity);

        return queryDetail(id);
    }

    @Override
    public RentTalkVO extendTalk(RentTalkDetailVO rentTalkDetailVO) {
        RentTalkDetailEntity rentDocumentRecordEntity = BeanMapper.map(rentTalkDetailVO, RentTalkDetailEntity.class);
        rentTalkDetailService.save(rentDocumentRecordEntity);
        RentTalkEntity rentTalkEntity = super.selectById(rentTalkDetailVO.getTalkId());
        rentTalkEntity.setTalkEndTime(rentTalkDetailVO.getNewTime());
        boolean b = super.updateById(rentTalkEntity);

        //推送供方
        RentSupplierSellVO supplierSellVO = new RentSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(rentTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(rentTalkDetailVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);

        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }

        //更新招标截止时间
        RentInviteEntity inviteEntity = rentInviteService.selectById(rentTalkEntity.getInviteId());
        inviteEntity.setStopTime(rentTalkEntity.getTalkEndTime());
        rentInviteService.saveOrUpdate(inviteEntity);
        return queryDetail(rentTalkDetailVO.getTalkId());
    }

    @Override
    public RentTalkVO saveTalk(Long documentId) {
        RentTalkEntity entity = new RentTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        RentDocumentEntity documentEntity = rentDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        rentDocumentService.saveOrUpdate(documentEntity);
        //查询招标立项信息
        RentDocumentEntity rentDocumentEntity = rentDocumentService.selectById(documentId);
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentDocumentEntity.getInviteId());
        entity.setProjectCode(rentDocumentEntity.getProjectCode());
        entity.setInviteId(rentDocumentEntity.getInviteId());
        entity.setProjectId(rentDocumentEntity.getProjectId());
        entity.setProjectName(rentDocumentEntity.getProjectName());
        entity.setOrgId(rentDocumentEntity.getOrgId());
        entity.setOrgName(rentDocumentEntity.getOrgName());
        entity.setParentOrgId(rentDocumentEntity.getParentOrgId());
        entity.setParentOrgName(rentDocumentEntity.getParentOrgName());
        entity.setBrandFlag(rentDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(rentDocumentEntity.getPurchaseType());
        entity.setTalkName(rentInviteEntity.getTenderName());
        super.save(entity);

        //回写招标阶段

        rentInviteEntity.setTenderStage(7);
        rentInviteService.updateById(rentInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("洽商谈判");
        processEntity.setTenderId(rentDocumentEntity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/talkNegotiate");
        processService.saveOrUpdate(processEntity);

        RentTalkVO vo = BeanMapper.map(entity, RentTalkVO.class);

        RentTalkVO rentTalkVO = queryDetail(vo.getId());
        return rentTalkVO;
    }

    @Override
    public RentTalkVO queryDetail(Long id) {
        RentTalkEntity rentTalkEntity = super.selectById(id);
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentTalkEntity.getInviteId());

        RentTalkVO rentTalkVO = BeanMapper.map(rentTalkEntity, RentTalkVO.class);
        rentTalkVO.setRentType(rentInviteEntity.getRentType());
        //确认轮数
        Integer talkNum = rentTalkEntity.getTalkNum();
        if (rentTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        RentDocumentVO rentDocumentVO = rentDocumentService.queryDocDetail(rentTalkEntity.getBillId(), talkNum);

        //查询供应商报价方案数据


        rentTalkVO.setRentDocumentDetailSellList(rentDocumentVO.getRentDocumentDetailSellList());
        rentTalkVO.setRentDocumentSupplierSchemeList(rentDocumentVO.getRentDocumentSupplierSchemeList());

        //查询首轮报价的供应商信息
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambda = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambda.eq(RentDocumentSupplierEntity::getDocumentId, rentTalkEntity.getBillId());
        lambda.eq(RentDocumentSupplierEntity::getTalkNum, 0);
        List<RentDocumentSupplierEntity> supplierList = rentDocumentSupplierService.list(lambda);
        List<RentDocumentSupplierVO> documentSupplierVOList = BeanMapper.mapList(supplierList,RentDocumentSupplierVO.class);
        rentTalkVO.setRentDocumentSupplierList(documentSupplierVOList);

        //查询变更历史记录
        LambdaQueryWrapper<RentTalkRecordEntity> lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(RentTalkRecordEntity::getBillId,rentTalkEntity.getBillId());
        lambdaRecord.orderByAsc(RentTalkRecordEntity::getTalkNum);
        List<RentTalkRecordEntity> rentTalkRecordEntityList = rentTalkRecordService.list(lambdaRecord);
        List<RentTalkRecordVO> rentTalkRecordList = BeanMapper.mapList(rentTalkRecordEntityList, RentTalkRecordVO.class);
        rentTalkVO.setTalkRecordEntityList(rentTalkRecordList);
        return rentTalkVO;
    }
    @Transactional
    @Override
    public RentTalkVO againSaveTalk(Long id) {
        RentTalkEntity entity = new RentTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询招标立项信息
        RentTalkEntity rentTalkEntity = super.selectById(id);
        entity.setProjectCode(rentTalkEntity.getProjectCode());
        entity.setProjectId(rentTalkEntity.getProjectId());
        entity.setProjectName(rentTalkEntity.getProjectName());
        entity.setOrgId(rentTalkEntity.getOrgId());
        entity.setOrgName(rentTalkEntity.getOrgName());
        entity.setParentOrgId(rentTalkEntity.getParentOrgId());
        entity.setParentOrgName(rentTalkEntity.getParentOrgName());
        entity.setBrandFlag(rentTalkEntity.getBrandFlag());
        entity.setBillId(rentTalkEntity.getBillId());
        entity.setInviteId(rentTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(rentTalkEntity.getTalkNum() + 1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(rentTalkEntity.getPurchaseType());
        super.save(entity);

        //保存历史记录表
        RentTalkRecordEntity rentTalkRecordEntity =  BeanMapper.map(rentTalkEntity, RentTalkRecordEntity.class);
        rentTalkRecordEntity.setTalkId(rentTalkEntity.getId());
        rentTalkRecordEntity.setId(null);
        rentTalkRecordService.save(rentTalkRecordEntity);
        //新增历史记录子表
        List<RentTalkDetailEntity> rentTalkDetailList = rentTalkEntity.getRentTalkDetailList();
        List<RentTalkRecordDetailEntity> rentTalkRecordDetailEntityList = BeanMapper.mapList(rentTalkDetailList, RentTalkRecordDetailEntity.class);
        for (RentTalkRecordDetailEntity rentTalkRecordDetailEntity : rentTalkRecordDetailEntityList){
            rentTalkRecordDetailEntity.setId(null);
            rentTalkRecordDetailEntity.setRecordId(rentTalkRecordEntity.getId());
        }
        rentTalkRecordDetailService.saveBatch(rentTalkRecordDetailEntityList);

        //删除老数据
        super.removeById(id,false);

        //修改进展表信息
        LambdaQueryWrapper<ProcessEntity> lambdaProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId,id);
        lambdaProcess.eq(ProcessEntity::getTenderId,rentTalkEntity.getInviteId());
        ProcessEntity processEntity = processService.getOne(lambdaProcess);
        processEntity.setBillId(entity.getId());
        processService.updateById(processEntity);
        RentTalkVO vo = BeanMapper.map(entity, RentTalkVO.class);
        addLastSell(rentTalkEntity.getTalkNum(),rentTalkEntity.getBillId());

        return queryDetail(entity.getId());
    }

    @Override
    public RentTalkVO replenishSell(Long id) {
        RentTalkEntity rentTalkEntity = super.selectById(id);

        Integer talkNum = rentTalkEntity.getTalkNum();
        Long billId = rentTalkEntity.getBillId();
        addLastSell(talkNum,billId);

        return new RentTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        //获取最新轮数
        RentTalkEntity rentTalkEntity = super.selectById(id);
        Integer talkNum = rentTalkEntity.getTalkNum();
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambdaSupplier = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, rentTalkEntity.getBillId());
        lambdaSupplier.eq(RentDocumentSupplierEntity::getTalkNum, talkNum);
        List<RentDocumentSupplierEntity> supplierList = rentDocumentSupplierService.list(lambdaSupplier);
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambdaSupplierFirst = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierFirst.eq(RentDocumentSupplierEntity::getDocumentId, rentTalkEntity.getBillId());
        lambdaSupplierFirst.eq(RentDocumentSupplierEntity::getTalkNum, 0);
        List<RentDocumentSupplierEntity> supplierListFirst = rentDocumentSupplierService.list(lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0){
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()){
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        Map<String, Object> stringListMap = new HashMap<>();
        RentTalkEntity rentTalkEntity = baseMapper.selectById(talkId);
        List<RentQuotationMaterialVO> materialVOList = new ArrayList<>();
        //查询所有数据
        List<RentDocumentSellEntity> rentDocumentSellEntities = rentDocumentSellService.selectMaterialType(rentTalkEntity.getBillId());
        Integer talkNum = rentDocumentSellEntities.get(0).getTalkNum();
        List<RentDocumentSellVO> sellEntityList = BeanMapper.mapList(rentDocumentSellEntities, RentDocumentSellVO.class);
        //根据项目分组
        Map<Long, List<RentDocumentSellVO>> collect = sellEntityList.stream().filter(map -> map.getProjectId() != null).collect(Collectors.groupingBy(RentDocumentSellVO::getProjectId));
        for (List<RentDocumentSellVO> sellVOS : collect.values()) {
            //根据材料分类
            Map<Long, List<RentDocumentSellVO>> listMap = sellVOS.stream().filter(map->map.getMaterialId() != null).collect(Collectors.groupingBy(RentDocumentSellVO::getMaterialId));
            for (Long materialTypeId : listMap.keySet()) {
                RentQuotationMaterialVO materialVO = new RentQuotationMaterialVO();
                //获取供应商
                List<RentDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (RentDocumentSellVO sellVO : materialTypeList) {
                    materialVO  =  BeanMapper.map(sellVO, RentQuotationMaterialVO.class);
                }
                List<RentQuotationSupplierVO> rentQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, RentQuotationSupplierVO.class);
                //供应商ID去重
                List<RentQuotationSupplierVO> supplierVOS = rentQuotationSupplierVOS.stream()
                        .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(RentQuotationSupplierVO::getSupplierId))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                //根据供应商分类
                Map<Long, List<RentDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map->map.getSupplierId() != null).collect(Collectors.groupingBy(RentDocumentSellVO::getSupplierId));

                for (RentQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    //获取方案
                    List<RentDocumentSellVO> rentDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (RentDocumentSellVO rentDocumentSellVO : rentDocumentSellVOS) {
                        supplierVO.setSupplierName(rentDocumentSellVO.getSupplierName());
                    }
                    List<RentQuotationSchemeVO> rentQuotationSchemeVOS = BeanMapper.mapList(rentDocumentSellVOS, RentQuotationSchemeVO.class);
                    //根据方案名称去重
                    List<RentQuotationSchemeVO> schemeVOS = rentQuotationSchemeVOS.stream()
                            .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<RentDocumentSellVO>> schemeMap = rentDocumentSellVOS.stream().filter(map->map.getSchemeName() != null).collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeName));
                    for (RentQuotationSchemeVO rentQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<RentDocumentSellVO> priceList = schemeMap.get(rentQuotationSchemeVO.getSchemeName());
                        //如果轮数小于最大轮数，添加一个空的对象
                        if (priceList.size()<talkNum+1){
                            RentDocumentSellVO documentSellVO = new RentDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0,documentSellVO);
                        }
                        rentQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        }
        stringListMap.put("MaterialTypeList",materialVOList);
        stringListMap.put("offerNum",rentDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public RentTalkVO saveOrUpdates(RentTalkVO saveorUpdateVO) {
        RentTalkEntity entity = BeanMapper.map(saveorUpdateVO, RentTalkEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        RentTalkVO vo = BeanMapper.map(entity, RentTalkVO.class);
        RentTalkVO rentTalkVO = queryDetail(vo.getId());
        return rentTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        //补足未报价供应商信息
        //查询上一轮数
        //查询报价信息,判断本轮没有报价的供应商
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambdaSupplier = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplier.eq(RentDocumentSupplierEntity::getTalkNum, talkNum);
        List<RentDocumentSupplierEntity> supplierList = rentDocumentSupplierService.list(lambdaSupplier);

        //查询
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambdaSupplierLast = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierLast.eq(RentDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplierLast.eq(RentDocumentSupplierEntity::getTalkNum, talkNum - 1);
        List<RentDocumentSupplierEntity> supplierListLast = rentDocumentSupplierService.list(lambdaSupplierLast);
        List<Long> supplierPk = supplierList.stream().map(RentDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List<RentDocumentSupplierEntity> documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List<RentDocumentSupplierEntity> documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList,RentDocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0){
            return;
        }

        //推送供应商数据提示信息
        List<SupplierReplenishVO> replenishVOArrayList = new ArrayList<>();
        RentDocumentEntity rentDocumentEntity = rentDocumentService.selectById(docId);
        for (RentDocumentSupplierEntity rentDocumentSupplierEntity : documentSupplierEntityNewList){
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(rentDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(rentDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        logger.info("再次洽商推送供方接口数据:" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateSupOffer, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("再次洽商推送供方接口数据response:" + stringCommonResponse.getMsg());
        }

        List<Long> supplierPkNew = documentSupplierEntityNewList.stream().map(RentDocumentSupplierEntity::getId).collect(Collectors.toList());

        for (RentDocumentSupplierEntity rentDocumentSupplierEntity : documentSupplierEntityNewList){
            rentDocumentSupplierEntity.setId(IdWorker.getId());
            rentDocumentSupplierEntity.setTalkNum(talkNum);
        }
        rentDocumentSupplierService.saveBatch(documentSupplierEntityNewList);

        //查询上一轮未报价供应商的方案
        LambdaQueryWrapper<RentDocumentSchemeEntity> lambdaScheme = Wrappers.<RentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentId, docId);
        lambdaScheme.eq(RentDocumentSchemeEntity::getTalkNum, talkNum - 1);
        lambdaScheme.in(RentDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List<RentDocumentSchemeEntity> schemeList = rentDocumentSchemeService.list(lambdaScheme);
        List<Long> schemePkList = schemeList.stream().map(RentDocumentSchemeEntity::getId).collect(Collectors.toList());
        for (RentDocumentSchemeEntity rentDocumentSchemeEntity : schemeList){
            rentDocumentSchemeEntity.setId(IdWorker.getId());
            rentDocumentSchemeEntity.setTalkNum(talkNum);
            for (RentDocumentSupplierEntity rentDocumentSupplierEntity : documentSupplierEntityNewList){
                if (rentDocumentSchemeEntity.getSupplierId().equals(rentDocumentSupplierEntity.getSupplierId())){
                    rentDocumentSchemeEntity.setDocumentSupplierId(rentDocumentSupplierEntity.getId());
                }
            }
        }
        rentDocumentSchemeService.saveBatch(schemeList);

        //复制上一轮未报价的供应商的附件信息
        for (RentDocumentSupplierEntity rentDocumentSupplierEntity : documentSupplierEntityNewList){
            for (RentDocumentSupplierEntity rentDocumentSupplierLastEntity : supplierListLast){
                if (rentDocumentSupplierEntity.getSupplierId().equals(rentDocumentSupplierLastEntity.getSupplierId())){
                    CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                            rentDocumentSupplierLastEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType",
                            rentDocumentSupplierEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType"
                    );
                    if (!responseCopy.isSuccess()) {
                        throw new BusinessException("再次洽商附件复制失败:" + responseCopy.getMsg());
                    }
                }

            }
        }
        //查询上一轮未报价供应商的方案详情
        LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, docId);
        lambdaSell.eq(RentDocumentSellEntity::getTalkNum, talkNum - 1);
        lambdaSell.in(RentDocumentSellEntity::getSchemeId, schemePkList);
        List<RentDocumentSellEntity> sellList = rentDocumentSellService.list(lambdaSell);
        for (RentDocumentSellEntity rentDocumentSellEntity : sellList){
            rentDocumentSellEntity.setId(null);
            rentDocumentSellEntity.setTalkNum(talkNum);
            for (RentDocumentSchemeEntity rentDocumentSchemeEntity : schemeList){
                if (rentDocumentSellEntity.getSupplierId().equals(rentDocumentSchemeEntity.getSupplierId()) &&
                        rentDocumentSellEntity.getSchemeName().equals(rentDocumentSchemeEntity.getSchemeName())){
                    rentDocumentSellEntity.setSchemeId(rentDocumentSchemeEntity.getId());
                }

            }
        }
        rentDocumentSellService.saveBatch(sellList);
    }
}
