package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.rent.vo.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.mapper.RentWinnoticeMapper;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.List;

/**
 * 中标公告表
 * 
 * @author generator
 * 
 */
@Service("rentWinnoticeService")
public class RentWinnoticeServiceImpl extends BaseServiceImpl<RentWinnoticeMapper, RentWinnoticeEntity> implements IRentWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRentNoticeService rentNoticeService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentBidDetailService rentBidDetailService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentBidSupplierService rentBidSupplierService;
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value("${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentPicketageSupplierService rentPicketageSupplierService;
    @Transactional
    @Override
    public RentWinnoticeVO saveWinnotice(Long picketageId) {
        RentWinnoticeEntity entity = new RentWinnoticeEntity();
        entity.setPicketageId(picketageId);
        RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(picketageId);
        RentInviteEntity inviteEntity = rentInviteService.selectById(rentPicketageEntity.getInviteId());
        entity.setInviteId(rentPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName()+"中标公告");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());

        //采购方式(0-项目采购,1-单位采购)
        if (inviteEntity.getPurchaseType().equals(0)){
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)){
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }

        RentDocumentEntity rentDocumentEntity = rentDocumentService.selectById(rentPicketageEntity.getDocumentId());
        entity.setEmployeeId(rentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setLineTypeName(CommonUtils.getTypeName(3));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate(entity, false);

        //回写定标数据
        rentPicketageEntity.setWinnoticeStatus(1);
        rentPicketageEntity.setWinnoticeId(entity.getId());
        rentPicketageService.updateById(rentPicketageEntity);

        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        rentInviteService.updateById(inviteEntity);
        //回写定标子表数据
        List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
        for (RentPicketageSupplierEntity rentPicketageSupplierEntity : picketageSupplierList){
            rentPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        rentPicketageSupplierService.updateBatchById(picketageSupplierList);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/winnotice");
        processService.saveOrUpdate(processEntity);
        RentWinnoticeVO rentWinnoticeVO = BeanMapper.map(entity, RentWinnoticeVO.class);
        return rentWinnoticeVO;
    }

    @Override
    public RentWinnoticeVO queryDetail(Long id) {
        RentWinnoticeEntity rentWinnoticeEntity = super.selectById(id);
        RentWinnoticeVO rentWinnoticeVO = BeanMapper.map(rentWinnoticeEntity, RentWinnoticeVO.class);
        RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(rentWinnoticeEntity.getPicketageId());
        List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
        List<RentPicketageSupplierVO> rentPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, RentPicketageSupplierVO.class);
        rentWinnoticeVO.setPicketageSupplierList(rentPicketageSupplierList);
        return rentWinnoticeVO;
    }

    @Override
    public RentWinnoticeVO publishWinnotice(Long id) {
        
        //更新发布状态
        RentWinnoticeEntity rentWinnoticeEntity = super.selectById(id);
        rentWinnoticeEntity.setPublishFlag(0);
        super.updateById(rentWinnoticeEntity);

        //回写定标数据
        RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(rentWinnoticeEntity.getPicketageId());
        rentPicketageEntity.setWinnoticeStatus(2);
        rentPicketageService.updateById(rentPicketageEntity);

        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentPicketageEntity.getInviteId());

        //调用供方接口
        //调用第三方报名接口
        //推送供应商
        RentWinVO winVO = new RentWinVO();
        winVO.setSourceType("云南建投中标公告");
        winVO.setSourceId(Long.toString(rentWinnoticeEntity.getInviteId()));
        winVO.setBillCode(rentInviteEntity.getBillCode());
        //采购方式(0-项目采购,1-单位采购)
        if (rentInviteEntity.getPurchaseType() == 0){
            winVO.setSourceProjectId(Long.toString(rentInviteEntity.getProjectId()));
            winVO.setProjectName(rentInviteEntity.getProjectName());
            winVO.setProjectCode(rentInviteEntity.getProjectCode());
        }

        if (rentInviteEntity.getPurchaseType() == 1){
            winVO.setOrgName(rentInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(rentInviteEntity.getOrgId()));
        }
        winVO.setSourceUnitId(Long.toString(rentInviteEntity.getUnitId()));
        winVO.setUnitName(rentInviteEntity.getUnitName());
        winVO.setType("RENT");
        winVO.setTenderName(rentInviteEntity.getTenderName());
        winVO.setTenderType(rentInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(rentWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(rentWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(rentWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(rentInviteEntity.getPurchaseType());
        winVO.setWinDate(rentWinnoticeEntity.getWinDate());
        winVO.setStopDate(rentWinnoticeEntity.getStopDate());
        winVO.setWinTitle(rentWinnoticeEntity.getTitleName());
        winVO.setMemo(rentWinnoticeEntity.getMemo());
        winVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        //明细设置
        List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
        ArrayList<RentWinDetailVO> winDetailVOS = new ArrayList<>();
        for (RentPicketageSupplierEntity rentPicketageSupplierEntity : picketageSupplierList){
            RentWinDetailVO winDetailVO = new RentWinDetailVO();
            winDetailVO.setWinId(rentWinnoticeEntity.getId());
            winDetailVO.setSupplierName(rentPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(rentPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = shareSupplierApi.queryById(rentPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(rentPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString(winVO);
        logger.info("中标公告发布" + stringFb);
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winSaveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标公告同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public RentWinnoticeVO saveOrUpdates(RentWinnoticeEntity entity) {
        super.saveOrUpdate(entity,false);
        return queryDetail(entity.getId());
    }
}
