package com.ejianc.business.tender.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 材料定标立项定标情况表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_rmat_invite_detail_bidder")
public class RmatInviteDetailBidderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 主表主键
    @TableField(value="invite_detail_id")
    private Long inviteDetailId; // 材料子表主键
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商主键
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="brand")
    private String brand; // 供货品牌
    @TableField(value="price")
    private java.math.BigDecimal price; // 单价(无税)
    @TableField(value="tax_price")
    private java.math.BigDecimal taxPrice; // 单价(含税)
    @TableField(value="tax_bidder_rate")
    private java.math.BigDecimal taxBidderRate; // 税率
    @TableField(value="num")
    private java.math.BigDecimal num; // 中标数量
    @TableField(value="tax_money")
    private java.math.BigDecimal taxMoney; // 中标金额(含税)
    @TableField(value="score")
    private java.math.BigDecimal score; // 评分
    @TableField(value="money")
    private java.math.BigDecimal money; // 中标金额(无税)
    @TableField(value="tax_bidder")
    private java.math.BigDecimal taxBidder; // 税额

    // add by sunyj  20231101 周转材租赁招标改造

    @TableField(value = "lack_month_day_unit_price")
    private BigDecimal lackMonthDayUnitPrice; // 不足月日单价(无税)
    @TableField(value = "lack_month_day_unit_tax_price")
    private BigDecimal lackMonthDayUnitTaxPrice; // 不足月日单价
    @TableField(value = "rent_days")
    private Integer rentDays; // 租赁天数-- 月租使用

    @TableField(value="rent_num")
    private BigDecimal rentNum; // 租赁数量

    @TableField(value="history_price_area")
    private String historyPriceArea;//历史价格区间（无税）
    @TableField(value="history_tax_price_area")
    private String historyTaxPriceArea;//历史价格区间（含税）
    @TableField(value="guide_price_area")
    private String guidePriceArea; // 公司指导价区间（无税）
    @TableField(value="guide_tax_price_area")
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }


    public BigDecimal getLackMonthDayUnitPrice() {
        return lackMonthDayUnitPrice;
    }

    public void setLackMonthDayUnitPrice(BigDecimal lackMonthDayUnitPrice) {
        this.lackMonthDayUnitPrice = lackMonthDayUnitPrice;
    }

    public BigDecimal getLackMonthDayUnitTaxPrice() {
        return lackMonthDayUnitTaxPrice;
    }

    public void setLackMonthDayUnitTaxPrice(BigDecimal lackMonthDayUnitTaxPrice) {
        this.lackMonthDayUnitTaxPrice = lackMonthDayUnitTaxPrice;
    }

    public Integer getRentDays() {
        return rentDays;
    }

    public void setRentDays(Integer rentDays) {
        this.rentDays = rentDays;
    }

    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }

    /**
     * 主表主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 主表主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 材料子表主键
     */
    public Long getInviteDetailId() {
        return inviteDetailId;
    }

    /**
     * 材料子表主键
     */
    public void setInviteDetailId(Long inviteDetailId) {
        this.inviteDetailId = inviteDetailId;
    }
    /**
     * 供应商主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供货品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 供货品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 单价(无税)
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价(无税)
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价(含税)
     */
    public java.math.BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setTaxPrice(java.math.BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxBidderRate() {
        return taxBidderRate;
    }

    /**
     * 税率
     */
    public void setTaxBidderRate(java.math.BigDecimal taxBidderRate) {
        this.taxBidderRate = taxBidderRate;
    }
    /**
     * 中标数量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 中标数量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 中标金额(含税)
     */
    public java.math.BigDecimal getTaxMoney() {
        return taxMoney;
    }

    /**
     * 中标金额(含税)
     */
    public void setTaxMoney(java.math.BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }
    /**
     * 评分
     */
    public java.math.BigDecimal getScore() {
        return score;
    }

    /**
     * 评分
     */
    public void setScore(java.math.BigDecimal score) {
        this.score = score;
    }
    /**
     * 中标金额(无税)
     */
    public java.math.BigDecimal getMoney() {
        return money;
    }

    /**
     * 中标金额(无税)
     */
    public void setMoney(java.math.BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTaxBidder() {
        return taxBidder;
    }

    public void setTaxBidder(BigDecimal taxBidder) {
        this.taxBidder = taxBidder;
    }
}
