package com.ejianc.business.tender.rmat.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.api.IBatchPlanApi;
import com.ejianc.business.pro.rmat.api.IPrormatContractApi;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.promaterial.contract.api.IPromaterialContractApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.enums.DraftTypeEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.vo.RentInviteDetailRecordVO;
import com.ejianc.business.tender.rent.vo.RentInviteVO;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailBidderVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailRecordVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteVO;
import com.ejianc.business.tender.rmat.vo.TenderStageEnum;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageRefsupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailRecordVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubDocumentSupplierService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 *
 * @author generator
 */
@Controller
@RequestMapping("rmatInvite")
public class RmatInviteController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TENDER_RMAT";//此处需要根据实际修改
    
    /** 参照查询：项目ID */
    private static final String CONDITION_PROJECT_ID = "projectId";
    /** 参照查询：组织ID */
    private static final String CONDITION_ORG_ID = "orgId";

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IRmatInviteService service;

    @Autowired
    private IRmatInviteDetailRecordService detailRecordService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private IBatchPlanApi batPlanApi;

    @Autowired
    private IRmatPicketageService picketageService;

    @Autowired
    private IRmatPicketageRefsupplierService refsupplierService;

    @Autowired
    private IPrormatContractApi contractApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IStuffInviteService stuffInviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IRmatDocumentService documentService;

    @Autowired
    private IRmatDocumentSupplierService documentSupplierService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatInviteVO> saveOrUpdate(@RequestBody RmatInviteVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        //处理子表供应商中标信息
        List<RmatInviteDetailRecordVO> rmatInviteDetailList = saveorUpdateVO.getRmatDetailRecord();
        List<RmatInviteDetailBidderEntity> biddermatityList = new ArrayList<RmatInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty(rmatInviteDetailList)) {
            for (RmatInviteDetailRecordVO rmatInviteDetailVO : rmatInviteDetailList) {
                if (rmatInviteDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    rmatInviteDetailVO.setId(id);
                }
                List<RmatInviteDetailBidderVO> bidderList = rmatInviteDetailVO.getRmatDetailBidder();
                if (CollectionUtils.isNotEmpty(bidderList)) {
                    for (RmatInviteDetailBidderVO bidderVO : bidderList) {
                        bidderVO.setInviteDetailId(rmatInviteDetailVO.getId());
                        RmatInviteDetailBidderEntity biddermatity = BeanMapper.map(bidderVO, RmatInviteDetailBidderEntity.class);
                        biddermatityList.add(biddermatity);
                    }
                }
            }
            logger.info("开始校验----"+JSONObject.toJSONString(saveorUpdateVO));
            if(null!=saveorUpdateVO.getEstablishType()&&0==saveorUpdateVO.getEstablishType()){
                logger.info("进入校验----");
                //同一维度 招标控制单价（无税）,招标控制单价' 这些字段必须相同 否则提示
                Map<String, List<RmatInviteDetailRecordVO>> map = rmatInviteDetailList.stream().filter(s->"del"!=s.getRowState()).collect(
                        Collectors.groupingBy(
                                s->s.getMaterialTypeId()+'-'+(s.getMaterialId()==null?"":s.getMaterialId().toString())+'-'+s.getRate()+'-'+s.getPlanEnterDate()+'-'+s.getCalculateType()+'-'+s.getPlanLeaveDate()
                        ));
                logger.info("map结果----"+JSONObject.toJSONString(map));
                map.forEach((key,value) ->{
                    long price = value.stream().map(RmatInviteDetailRecordVO::getPrice).distinct().count();
                    logger.info("重复数量----"+price);
                    //判断（如果全部相等：count应该等于1）
                    if (price != 1) {
                        throw new BusinessException("同一维度招标控制单价（无税）必须相同!");
                    }
                    long taxPrice = value.stream().map(RmatInviteDetailRecordVO::getPriceTax).distinct().count();
                    //判断（如果全部相等：count应该等于1）
                    if (taxPrice != 1) {
                        throw new BusinessException("同一维度招标控制单价必须相同!");
                    }
                });
            }
        }

        RmatInviteEntity entity = BeanMapper.map(saveorUpdateVO, RmatInviteEntity.class);
        if (CollectionUtils.isNotEmpty(biddermatityList)) {
            entity.setRmatDetailBidder(biddermatityList);
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        List<String> oldPlanIdList = detailRecordService.list(new LambdaQueryWrapper<RmatInviteDetailRecordEntity>()
//                .eq(RmatInviteDetailRecordEntity::getInviteId, saveorUpdateVO.getId()))
//                .stream().map(RmatInviteDetailRecordEntity::getPlanId)
//                .map(String::valueOf).distinct().collect(Collectors.toList());
//    	if (CollectionUtils.isNotEmpty(oldPlanIdList)){
//            CommonResponse<String> response1 = batPlanApi.updateBatPlanQuote(oldPlanIdList, BatchPlanEnum.PLAN_STATE_WAIT.getPlanState());
//            if (!response1.isSuccess()){
//                throw new BusinessException("修改计划状态失败"+response1.getMsg());
//            }
//        }
        RmatInviteEntity rmatInviteEntity = service.selectById(saveorUpdateVO.getId());
        if (null != rmatInviteEntity) {
            service.updateApiState(rmatInviteEntity, BatchPlanEnum.PLAN_STATE_WAIT.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_WAIT.getPlanState());
        }
        entity.setSignStatus(TenderSignStatusEnum.未签订.getCode());


//处理合同附件
        if (entity.getId() != null){
            RmatInviteEntity rmatInviteOldEntity = service.getById(entity.getId());
            if(0==rmatInviteOldEntity.getEstablishType()){
                if (rmatInviteOldEntity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                    //如果招标文件生成方式没变,前后都是线上起草,模版变了则删除附件,
                    if(entity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                        if (!rmatInviteOldEntity.getContractCategoryId().equals(entity.getContractCategoryId())){
                            if (rmatInviteOldEntity.getContractFileId() != null){
                                attachmentApi.deleteFileByParam(rmatInviteOldEntity.getId(),"BT220210000000008","contractFile");
                                CommonResponse<String> delete = attachmentApi.delete(rmatInviteOldEntity.getContractFileId().toString());
                            }
                            entity.setContractFileId(null);
                            entity.setContractFilePath(null);
                            entity.setContractTemplateId(null);
                            entity.setContractTemplateName(null);
                            entity.setContractFileHighlightId(null);
                            entity.setContractFileHighlightPath(null);
                        }
                    }
                    //如果招标文件生成方式改变,则
                    if(entity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                        if (rmatInviteOldEntity.getContractFileId() != null){
                            CommonResponse<String> delete = attachmentApi.deleteFileByParam(rmatInviteOldEntity.getId(),"BT220210000000008","contractFile");
                            attachmentApi.delete(rmatInviteOldEntity.getContractFileId().toString());
                        }
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                        entity.setContractCategoryId(null);
                        entity.setContractCategoryName(null);
                    }
                }
                //
                if (rmatInviteOldEntity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                    //如果招标文件生成方式没变,前后都是线上起草,模版变了则删除附件,
                    if(entity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                    }
                    //如果招标文件生成方式改变,则
                    if(entity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                        if (rmatInviteOldEntity.getContractFileId() != null){
                            CommonResponse<String> delete = attachmentApi.delete(rmatInviteOldEntity.getContractFileId().toString());
                        }
                        entity.setContractFileId(null);
                        entity.setContractFilePath(null);
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                        entity.setContractFileHighlightId(null);
                        entity.setContractFileHighlightPath(null);
                    }
                }
            }
        }

        service.saveOrUpdate(entity, false);
        RmatInviteVO vo = BeanMapper.map(entity, RmatInviteVO.class);

        //处理供应商子表信息
        List<RmatInviteDetailRecordVO> rmatInviteDetailVOList = vo.getRmatDetailRecord();
        List<RmatInviteDetailBidderVO> rmatInviteDetailBidderVOList = vo.getRmatDetailBidder();
        if (CollectionUtils.isNotEmpty(rmatInviteDetailBidderVOList)) {
            Map<Long, List<RmatInviteDetailBidderVO>> bidderMap = rmatInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(RmatInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(rmatInviteDetailVOList)) {
                for (RmatInviteDetailRecordVO rmatInviteDetailVO : rmatInviteDetailVOList) {
                    List<RmatInviteDetailBidderVO> rmatInviteDetailBidderVOS = bidderMap.get(rmatInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(rmatInviteDetailBidderVOS)) {
                        rmatInviteDetailVO.setRmatDetailBidder(rmatInviteDetailBidderVOS);
                    }
                }
            }
        }
        //修改计划状态
        service.updateApiState(entity, BatchPlanEnum.PLAN_STATE_EXEC.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_EXEC.getPlanState());

        if (entity.getEstablishType()==1){
            //修改招标状态
            List<Long> inviteIdList = entity.getRmatDetailRecord().stream().map(RmatInviteDetailRecordEntity::getPlanId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(inviteIdList)) {
                UpdateWrapper<RmatInviteEntity> wrapper = new UpdateWrapper<>();
                wrapper.set("occupy_state",1).in("id", inviteIdList);
                service.update(wrapper);
            }
        }

        //保存招标过程记录表
        if (!processService.selectByBillId(entity.getId())) {
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType() == 1) {
                processEntity.setBillName("定标立项");
            }
            else {
                processEntity.setBillName("招标立项");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(4);
            processEntity.setFrontendUrl("rmat/invite/card");
            processService.saveOrUpdate(processEntity);
        }

        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatInviteVO> queryDetail(Long id) {
        RmatInviteEntity entity = service.selectById(id);
        RmatInviteVO vo = BeanMapper.map(entity, RmatInviteVO.class);
        //处理供应商子表信息
        List<RmatInviteDetailRecordVO> rmatInviteDetailVOList = vo.getRmatDetailRecord();
        List<RmatInviteDetailBidderVO> rmatInviteDetailBidderVOList = vo.getRmatDetailBidder();
        if (CollectionUtils.isNotEmpty(rmatInviteDetailBidderVOList)) {
            Map<Long, List<RmatInviteDetailBidderVO>> bidderMap = rmatInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(RmatInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(rmatInviteDetailVOList)) {
                for (RmatInviteDetailRecordVO rmatInviteDetailVO : rmatInviteDetailVOList) {
                    List<RmatInviteDetailBidderVO> rmatInviteDetailBidderVOS = bidderMap.get(rmatInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(rmatInviteDetailBidderVOS)) {
                        rmatInviteDetailVO.setRmatDetailBidder(rmatInviteDetailBidderVOS);
                    }
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RmatInviteVO> vos) {
        List<Long> idList = vos.stream().map(RmatInviteVO::getId).collect(Collectors.toList());
        for (Long inviteId : idList) {
            service.updateApiState(service.selectById(inviteId), BatchPlanEnum.PLAN_STATE_WAIT.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_WAIT.getPlanState());
//            List<String> planIdList = detailRecordService.list(new LambdaQueryWrapper<RmatInviteDetailRecordEntity>()
//                    .eq(RmatInviteDetailRecordEntity::getInviteId, inviteId))
//                    .stream().map(RmatInviteDetailRecordEntity::getPlanId)
//                    .map(String::valueOf).distinct().collect(Collectors.toList());
//            batPlanApi.updateBatPlanQuote(planIdList, BatchPlanEnum.PLAN_STATE_WAIT.getPlanState());

            //修改招标状态
            RmatInviteEntity inviteEntity = service.selectById(inviteId);
            if (inviteEntity.getEstablishType()==1){
                List<String> inviteIdList = detailRecordService.list(new LambdaQueryWrapper<RmatInviteDetailRecordEntity>()
                        .eq(RmatInviteDetailRecordEntity::getInviteId, inviteId))
                        .stream().map(RmatInviteDetailRecordEntity::getPlanId)
                        .map(String::valueOf).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(inviteIdList)) {
                    UpdateWrapper<RmatInviteEntity> wrapper = new UpdateWrapper<>();
                    wrapper.set("occupy_state",0).in("id", inviteIdList);
                    service.update(wrapper);
                }
            }
        }
        service.removeByIds(vos.stream().map(RmatInviteVO::getId).collect(Collectors.toList()), true);
        processService.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId, vos.stream().map(RmatInviteVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RmatInviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseTypeName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("employeeId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().put("employeeId", new Parameter(QueryParam.NE, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");

        Parameter purchaseId = param.getParams().get("purchaseId");
        if(null!=purchaseId){
            List<String> purchaseIdList = Arrays.asList(param.getParams().get("purchaseId").getValue().toString().split(","));
            logger.info("purchaseId-------{}", param.getParams().get("purchaseId").getValue().toString());
            if (purchaseIdList.size() > 1){

                String sqlStr = "";
                for (String s : purchaseIdList) {
                    sqlStr += " purchase_id like \"%" + s + "%\" or";
                }
                sqlStr = sqlStr.substring(0, sqlStr.length() - 2);
                logger.info("sqlStr----{}", sqlStr);
                param.getParams().put("", new Parameter(QueryParam.SQL, "(" + sqlStr + ")"));
            }else {
                param.getParams().put("", new Parameter(QueryParam.SQL, " ( purchase_id like \"%" + param.getParams().get("purchaseId").getValue().toString() + "%\" )"));
            }
        }
        logger.info("param------{}", JSONObject.toJSONString(param.getParams()));
        param.getParams().remove("purchaseId");



        Parameter tenderState = param.getParams().get("tenderState");
        Boolean enrollFinishFlag = false;//报名截止
        Boolean quoteFinishFlag = false;//报价截止
        if(null!=tenderState){
            if (tenderState.getValue().toString().equals("1") || tenderState.getValue().toString().equals("2")){//报名中、报价中
                param.getParams().put("stopTime", new Parameter(QueryParam.GT, new Date()));
            }else if (tenderState.getValue().toString().equals("11")){
                enrollFinishFlag = true;
                param.getParams().put("stopTime", new Parameter(QueryParam.LT, new Date()));
                param.getParams().put("tenderState", new Parameter(QueryParam.EQ, 1));
            }else if (tenderState.getValue().toString().equals("21")){
                quoteFinishFlag = true;
                param.getParams().put("stopTime", new Parameter(QueryParam.LT, new Date()));
                param.getParams().put("tenderState", new Parameter(QueryParam.EQ, 2));
            }
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<RmatInviteEntity> page = service.queryPage(param, false);
        IPage<RmatInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RmatInviteVO.class));
        Date newData = new Date();
        for (RmatInviteVO record : pageData.getRecords()) {
            switch (record.getTenderType()) {
                case 0:
                    record.setTenderTypeName("平台公开招标");
                    break;
                case 1:
                    record.setTenderTypeName("邀请招标");
                    break;
                case 2:
                    record.setTenderTypeName("询价");
                    break;
                case 3:
                    record.setTenderTypeName("竞争性谈判");
                    break;
                case 4:
                    record.setTenderTypeName("单一来源");
                    break;
                case 5:
                    record.setTenderTypeName("紧急招标");
                    break;
            }
            switch (record.getSignStatus()){
                case 0:
                    record.setSignStatusName("未签订");
                    break;
                case 1:
                    record.setSignStatusName("部分签订");
                    break;
                case 2:
                    record.setSignStatusName("全部已签");
                    break;
                case 3:
                    record.setSignStatusName("已关闭");
                    break;
            }
            if (null != record.getTenderState()){
                if (enrollFinishFlag){
                    record.setTenderStateName("报名截止");
                }else if (quoteFinishFlag){
                    record.setTenderStateName("报价截止");
                }else {
                    switch (record.getTenderState()) {
                        case 1:
                            if (null != record.getStopTime() && record.getStopTime().compareTo(newData) > 0){
                                record.setTenderStateName("报名中");
                            }else {
                                record.setTenderStateName("报名截止");
                            }
                            break;
                        case 2:
                            if (null != record.getStopTime() && record.getStopTime().compareTo(newData) > 0){
                                record.setTenderStateName("报价中");
                            }else {
                                record.setTenderStateName("报价截止");
                            }
                            break;
                        case 3:
                            record.setTenderStateName("专家评标中");
                            break;
                        case 4:
                            record.setTenderStateName("专家评标结束");
                            break;
                    }
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "招标立项" : "定标立项");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("purchaseName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RmatInviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<RmatInviteVO> voList = JSON.parseArray(JSON.toJSONString(list), RmatInviteVO.class);
        for (RmatInviteVO rmatInviteVO : voList) {
            switch (rmatInviteVO.getTenderType()) {
                case 0:
                    rmatInviteVO.setTenderTypeName("平台公开招标");
                    break;
                case 1:
                    rmatInviteVO.setTenderTypeName("邀请招标");
                    break;
                case 2:
                    rmatInviteVO.setTenderTypeName("询价");
                    break;
                case 3:
                    rmatInviteVO.setTenderTypeName("竞争性谈判");
                    break;
                case 4:
                    rmatInviteVO.setTenderTypeName("单一来源");
                    break;
                case 5:
                    rmatInviteVO.setTenderTypeName("紧急招标");
                    break;
            }
            rmatInviteVO.setEstablishTypeName(rmatInviteVO.getEstablishType() == 0 ? "招标立项" : "定标立项");
            rmatInviteVO.setPurchaseTypeName(rmatInviteVO.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            rmatInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode(rmatInviteVO.getBillState()).getDescription());
            rmatInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(rmatInviteVO.getTenderStage()).getDescription());

            //处理报价供应商导出问题
            List<RmatDocumentEntity> documentEntityList = documentService.list(new LambdaQueryWrapper<RmatDocumentEntity>().eq(RmatDocumentEntity::getInviteId, rmatInviteVO.getId()));
            if(CollectionUtils.isNotEmpty(documentEntityList)){
                List<RmatDocumentSupplierEntity> documentSupplierEntityList = documentSupplierService.list(new LambdaQueryWrapper<RmatDocumentSupplierEntity>().eq(RmatDocumentSupplierEntity::getDocumentId, documentEntityList.get(0).getId()).groupBy(RmatDocumentSupplierEntity::getSupplierId));
                if(CollectionUtils.isNotEmpty(documentSupplierEntityList)){
                    StringBuffer sb = new StringBuffer();
                    for(int j=0;j<documentSupplierEntityList.size();j++){
                        if(j==(documentSupplierEntityList.size()-1)){
                            sb.append(documentSupplierEntityList.get(j).getSupplierName());
                        }else{
                            sb.append(documentSupplierEntityList.get(j).getSupplierName()+",");
                        }
                    }
                    rmatInviteVO.setSupplierTenderName(sb.toString());
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("材料立项.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRmatInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RmatInviteVO>> refRmatInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("tenderPlatform", new Parameter(QueryParam.EQ, 2));
        param.getParams().put("occupyState", new Parameter(QueryParam.EQ, 0));

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 项目id
            if (_con.containsKey(CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get(CONDITION_PROJECT_ID).toString());
                CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("查询项目信息失败！");
                }
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
            }
            // 组织id
            if (_con.containsKey(CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get(CONDITION_ORG_ID).toString());
                CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
                OrgVO orgVO = orgResp.getData();
                /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                }
                else {
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                            .findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId)
                            .collect(Collectors.toList())));
                }
            }
            if(_con.containsKey("purchaseType")){
                Integer purchaseType = _con.getInteger("purchaseType");
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ,purchaseType));
            }
        }
        IPage<RmatInviteEntity> page = service.queryPage(param, false);
        IPage<RmatInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RmatInviteVO.class));

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<RmatInviteVO> rmatInviteVOList = pageData.getRecords();
            List<String> idList = rmatInviteVOList.stream().map(RmatInviteVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("inviteId", new Parameter(QueryParam.IN, idList));
            List<RmatInviteDetailRecordEntity> detailEntityList = detailRecordService.queryList(detailParam);
            List<RmatInviteDetailRecordVO> detailVOList = BeanMapper.mapList(detailEntityList, RmatInviteDetailRecordVO.class);
            Map<Long, List<RmatInviteDetailRecordVO>> detailMap = new HashMap<>();
            List<RmatInviteDetailRecordVO> mapList;
            // 按照planID对子表结果分组
            for (RmatInviteDetailRecordVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getInviteId())) {
                    detailMap.get(vo.getInviteId()).add(vo);
                }
                else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getInviteId(), mapList);
                }
            }
            // 将清单添加到主表中
            rmatInviteVOList.forEach(t -> {
                t.setRmatDetailRecord(detailMap.get(t.getId()));
            });
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description saveOrUpdate 获取流/废标状态
     */
    @RequestMapping(value = "/getAType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = service.getAbolishType(tenderId);
        return CommonResponse.success("查询流/废标状态成功！", map);
    }

    /**
     * @param
     * @Description 子表导出
     * @Return void
     */
    @RequestMapping(value = "/detailExcelExport", method = RequestMethod.GET)
    @ResponseBody
    public void detailExcelExport(Long id, HttpServletResponse response) {
        RmatInviteVO equipmentInviteVO = queryDetail(id).getData();
        List<RmatInviteDetailRecordVO> detailList = equipmentInviteVO.getRmatDetailRecord();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("rmatInviteDetail.xlsx", beans, response);
    }
    @RequestMapping(value = "/queryContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContract(@RequestBody RmatInviteVO inviteVO) {
        Long refId;
        //招标立项
        if (inviteVO.getEstablishType()==0){
            RmatPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<RmatPicketageEntity>().eq("invite_id", inviteVO.getId())).get(0);
            refId=picketageEntity.getId();
        }else {
            refId = inviteVO.getId();
        }
        logger.info("定标ID"+refId);
        List<RmatPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<RmatPicketageRefsupplierEntity>().eq("picketage_id", refId));
        List<String> idList = refsupplierList.stream().map(RmatPicketageRefsupplierEntity::getId).map(String::valueOf).collect(Collectors.toList());
        logger.info("定标参照ID"+JSONObject.toJSONString(idList));
        CommonResponse<List<SignContractVo>> response = contractApi.queryContractByTargetResultId(idList);
        if (!response.isSuccess()){
            throw new BusinessException("查询合同失败"+response.getMsg());
        }
        response.getData().forEach(t->t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        return CommonResponse.success(response.getData());
    }
    @RequestMapping(value = "/closeSignStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        RmatInviteEntity entity = service.selectById(id);
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            //处于未签订、部分签订
            if (entity.getSignStatus() == 0 || entity.getSignStatus() == 1) {
                //招标立项
                if (establishType == 0) {
                    if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                        RmatPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<RmatPicketageEntity>().eq("invite_id", id)).get(0);
                        refId = picketageEntity.getId();
                    }
                }
                //定标立项
                else {
                    if (entity.getBillState() == 1 || entity.getBillState() == 3) {
                        refId = id;
                    }
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
            if (refId != null) {
                logger.info("定标ID" + refId);
                List<RmatPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<RmatPicketageRefsupplierEntity>().eq("picketage_id", refId));
                if (CollectionUtils.isNotEmpty(refsupplierList)){
                    refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.已关闭.getCode()));
                    refsupplierService.saveOrUpdateBatch(refsupplierList);
                    entity.setSignStatus(TenderSignStatusEnum.已关闭.getCode());
                    service.saveOrUpdate(entity);
                }else {
                    throw new BusinessException("不符合关闭条件");
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
        }
        else {
            throw new BusinessException("只有招标经办人才能关闭");
        }
        return CommonResponse.success("关闭成功！");
    }
    /**
     * @Description  判断当前登录人和招标经办人是否相同
     */
    @RequestMapping(value = "/judgeEmployee", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee (Long inviteId) {
        boolean flag = false;
        RmatInviteEntity entity = service.selectById(inviteId);
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            flag = true;
        }
        return CommonResponse.success("查询数据成功！", flag);
    }



    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody RmatInviteVO inviteVO) {
        return CommonResponse.success("参数校验成功！", paramCheck(inviteVO));
    }


    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {

        return CommonResponse.success("参数校验成功！", paramCheck(BeanMapper.map(service.selectById(id), RmatInviteVO.class)));
    }


    /**
     *
     */
    private ParamsCheckVO paramCheck(RmatInviteVO rmatInviteVO) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/

        ParamsCheckVO priceParam = service.priceCheckParams(rmatInviteVO);
        if(priceParam!=null){//价格库控制
            paramsCheckVOS.add(priceParam);
        }

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
}
