package com.ejianc.business.tender.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.rmat.vo.RmatPicketageRefsupplierVO;
import com.ejianc.business.tender.rmat.bean.RmatPicketageRefsupplierEntity;
import com.ejianc.business.tender.rmat.service.impl.RmatPicketageBpmServiceImpl;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rmatPicketageRefsupplier")
@Api(value = "定标供应商参照表(下游单据使用)", tags = {"定标供应商参照表(下游单据使用)"})
public class RmatPicketageRefsupplierController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private RmatPicketageBpmServiceImpl rmatPicketageBpmService;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRmatPicketageRefsupplierService service;
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatInviteDetailBidderService rmatInviteDetailBidderService;
    @Autowired
    private IRmatInviteDetailRecordService rmatInviteDetailRecordService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareSupplierApi supplierApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatPicketageRefsupplierVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody RmatPicketageRefsupplierVO saveOrUpdateVO) {
    	RmatPicketageRefsupplierEntity entity = BeanMapper.map(saveOrUpdateVO, RmatPicketageRefsupplierEntity.class);
    	service.saveOrUpdate(entity, false);
    	RmatPicketageRefsupplierVO vo = BeanMapper.map(entity, RmatPicketageRefsupplierVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatPicketageRefsupplierVO> queryDetail(@RequestParam Long id) {
    	RmatPicketageRefsupplierEntity entity = service.selectById(id);
    	RmatPicketageRefsupplierVO vo = BeanMapper.map(entity, RmatPicketageRefsupplierVO.class);
        if(0==entity.getPicketageFlag()) {
            RmatPicketageEntity picketageEntity = rmatPicketageService.selectById(entity.getPicketageId());
            vo.setInviteId(picketageEntity.getInviteId());
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }



    @ApiOperation("参照")
    @RequestMapping(value = "/refRmatsupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RmatPicketageRefsupplierVO>> refRmatsupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("picketageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //未占用状态
//        param.getParams().put("occupyFlag", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("picketageDate",QueryParam.DESC);
        //查询本下范围内日的合同
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        if(CollectionUtils.isNotEmpty(orgVOList)) {
            List<Long> ids = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, ids));
        }
        if (StringUtils.isNotBlank(condition)) {//辅料中心参照定标添加过滤条件
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("purchaseType")) {
                Integer purchaseType = Integer.valueOf(conditionMap.get("purchaseType").toString());
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ, purchaseType));
            }
        }
        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(TenderSignStatusEnum.未签订.getCode());
        listStatus.add(TenderSignStatusEnum.部分签订.getCode());
        param.getParams().put("signStatus", new Parameter(QueryParam.IN, listStatus));

        IPage<RmatPicketageRefsupplierEntity> page = service.queryPage(param,false);
        IPage<RmatPicketageRefsupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<RmatPicketageRefsupplierEntity> records = page.getRecords();
        if (CollectionUtils.isNotEmpty(records)){
            List<Long> supplierIdList = records.stream().distinct().map(RmatPicketageRefsupplierEntity::getSupplierId).collect(Collectors.toList());
            logger.info("supplierIdList:{}", JSONObject.toJSONString(supplierIdList));
            CommonResponse<List<SupplierDTO>> listCommonResponse = supplierApi.querySupplierDTOByIds(supplierIdList);
            Map<Long, String> supplierMap = new HashMap<>();
            if (listCommonResponse.isSuccess()){
                List<SupplierDTO> supplierVOList = listCommonResponse.getData();
                logger.info("supplierVOList:{}", JSONObject.toJSONString(supplierVOList));
                supplierMap = supplierVOList.stream().collect(Collectors.toMap(SupplierDTO::getId, SupplierDTO::getName));
            }else {
                throw new BusinessException("获取项目信息失败，失败原因：" + listCommonResponse.getMsg());
            }
            for (RmatPicketageRefsupplierEntity rmatPicketageRefsupplierEntity : records) {
                if (supplierMap.containsKey(rmatPicketageRefsupplierEntity.getSupplierId())){
                    rmatPicketageRefsupplierEntity.setSupplierName(supplierMap.get(rmatPicketageRefsupplierEntity.getSupplierId()));
                }
                if (rmatPicketageRefsupplierEntity.getPurchaseType() == 0) {
//                    (0-项目采购,1-单位采购)
                    rmatPicketageRefsupplierEntity.setPurchaseTypeName("项目采购");
                }
                if (rmatPicketageRefsupplierEntity.getPurchaseType() == 1) {
//                    (0-项目采购,1-单位采购)
                    rmatPicketageRefsupplierEntity.setPurchaseTypeName("公司采购");
                }

            }
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RmatPicketageRefsupplierVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @ApiOperation("定标子表参照")
    @RequestMapping(value = "/refRmatDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RmatDocumentSellVO>> refRmatDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long id = null;

        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("id")) {
                id = Long.valueOf(conditionMap.get("id").toString());
            }
        }
        RmatPicketageRefsupplierEntity rmatPicketageRefsupplierEntity = service.selectById(id);
        Integer picketageFlag = rmatPicketageRefsupplierEntity.getPicketageFlag();
        //定标类型0-流程定标,1-直接定标  区分数据源
        if (picketageFlag == 0) {
            RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(rmatPicketageRefsupplierEntity.getPicketageId());
            param.getParams().put("documentId", new Parameter(QueryParam.EQ, rmatPicketageEntity.getDocumentId()));
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, rmatPicketageRefsupplierEntity.getSupplierId()));
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, rmatPicketageRefsupplierEntity.getProjectId()));
            param.getParams().put("tenderFlag", new Parameter(QueryParam.EQ, 1));
            IPage<RmatDocumentSellEntity> page = rmatDocumentSellService.queryPage(param, false);
            IPage<RmatDocumentSellVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<RmatDocumentSellVO> rmatDocumentSellVOList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(page.getRecords())) {
                rmatDocumentSellVOList = BeanMapper.mapList(page.getRecords(), RmatDocumentSellVO.class);
            }
            pageData.setRecords(rmatDocumentSellVOList);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }

        if (picketageFlag == 1) {
            List<RmatDocumentSellVO> rmatDocumentSellVOS = new ArrayList<>();
            List<RmatInviteDetailBidderEntity> bidderEntityList1 = rmatInviteDetailBidderService.list(new QueryWrapper<RmatInviteDetailBidderEntity>()
                    .eq("invite_id", rmatPicketageRefsupplierEntity.getPicketageId())
                    .eq("supplier_id", rmatPicketageRefsupplierEntity.getSupplierId())
                    .eq("dr", 0));
            for (RmatInviteDetailBidderEntity bidderEntity : bidderEntityList1) {
                RmatDocumentSellVO rmatDocumentSellVO = new RmatDocumentSellVO();
                RmatInviteDetailRecordEntity recordEntity = rmatInviteDetailRecordService.selectById(bidderEntity.getInviteDetailId());
                rmatDocumentSellVO.setId(bidderEntity.getId());
                rmatDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                rmatDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                rmatDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                rmatDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                rmatDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                rmatDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                rmatDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                rmatDocumentSellVO.setUnit(recordEntity.getUnit());
                rmatDocumentSellVO.setSpec(recordEntity.getSpec());
                rmatDocumentSellVO.setDetailId(bidderEntity.getId());
                rmatDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                rmatDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                rmatDocumentSellVO.setBrand(bidderEntity.getBrand());
                rmatDocumentSellVO.setPrice(bidderEntity.getPrice());
                rmatDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                rmatDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                rmatDocumentSellVO.setTenderNum(bidderEntity.getNum());
                rmatDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                rmatDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                rmatDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                rmatDocumentSellVOS.add(rmatDocumentSellVO);
            }
            IPage<RmatDocumentSellVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), rmatDocumentSellVOS.size());
            // 进行分页处理
            pageDate.setRecords(rmatDocumentSellVOS.stream().skip((long) (param.getPageIndex() - 1) * param.getPageSize())
                    .limit(param.getPageSize()).collect(Collectors.toList()));
            return CommonResponse.success("查询参照数据成功！", pageDate);
        }
        return null;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
