package com.ejianc.business.tender.rmat.mapper;

import com.ejianc.business.tender.rmat.vo.RmatInviteDetailBidderVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface RmatInviteMapper extends BaseCrudMapper<RmatInviteEntity> {
    @Update("UPDATE ejc_tender_rmat_invite SET tender_stage = #{tenderStage} WHERE id = #{id} ")
    void updateTenderStage(String id, int tenderStage);
    @Update("UPDATE ejc_tender_rmat_invite SET abolish_type = #{abolishType} WHERE id = #{id} ")
    void updateAbolishType(String id, int abolishType);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money  FROM `ejc_tender_rmat_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr = 0 GROUP BY material_id ,material_type_id,rate,detail_project_id,calculate_type")
    List<RmatInviteDetailVO> selectSumDetail(Long inviteId);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money  FROM `ejc_tender_rmat_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr = 0 GROUP BY material_id ,material_type_id,rate,detail_org_id,calculate_type")
    List<RmatInviteDetailVO> selectOrgSumDetail(Long inviteId);
    @Select("SELECT c.*,sum( c.tax_money ) sum_tax_money,sum( c.money ) sum_money,sum( c.num ) sum_num FROM  (SELECT a.*,b.detail_project_id,b.detail_project_name,b.detail_org_id,b.detail_org_name FROM  `ejc_tender_rmat_invite_detail_bidder` a LEFT join ejc_tender_rmat_invite_detail_record b on a.invite_detail_id = b.id WHERE a.invite_id = #{inviteId}) c  GROUP BY c.supplier_id,c.detail_project_id")
    List<RmatInviteDetailBidderVO> selectDetailBidder(Long inviteId);
}
