package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.rmat.vo.RmatNoticeSupplierVO;
import com.ejianc.business.tender.rmat.vo.*;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.mapper.RmatNoticeDetailMapper;
import com.ejianc.business.tender.rmat.mapper.RmatNoticeMapper;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeSupplierDetailService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeSupplierService;
import com.ejianc.business.tender.stuff.vo.StuffNoticeDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
@Service("rmatNoticeService")
public class RmatNoticeServiceImpl extends BaseServiceImpl<RmatNoticeMapper, RmatNoticeEntity> implements IRmatNoticeService {

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IRmatNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private RmatNoticeDetailMapper rmatNoticeDetailMapper;

    @Autowired
    private IRmatNoticeSupplierService supplierService;

    @Autowired
    private IRmatInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        baseMapper.updateEndTime(noticeId,newTime);
    }

    @Transactional
    @Override
    public CommonResponse publish(RmatNoticeVO rmatNoticeVO) throws InvocationTargetException, IllegalAccessException {
        //插入主表数据
        RmatNoticeEntity rmatNoticeEntity = baseMapper.selectById(rmatNoticeVO.getId());
        RmatInviteEntity inviteEntity = inviteService.selectById(rmatNoticeEntity.getInviteId());
        rmatNoticeEntity.setPublishFlag(0);
        baseMapper.updateById(rmatNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        RmatNoticeSupplierTbVO rmatNoticeSupplierTbVO = new RmatNoticeSupplierTbVO();
        BeanUtils.copyProperties(rmatNoticeSupplierTbVO, rmatNoticeEntity);
        rmatNoticeSupplierTbVO.setNoticeStartTime(sdf.format(rmatNoticeEntity.getNoticeStartTime()));
        rmatNoticeSupplierTbVO.setNoticeEndTime(sdf.format(rmatNoticeEntity.getNoticeEndTime()));
        rmatNoticeSupplierTbVO.setNoticeType(0);
        if (rmatNoticeEntity.getPurchaseType()==1){
            rmatNoticeSupplierTbVO.setSourceProjectId(null);
        }else {
            rmatNoticeSupplierTbVO.setSourceProjectId(rmatNoticeEntity.getProjectId().toString());
        }
        rmatNoticeSupplierTbVO.setSourceId(rmatNoticeEntity.getInviteId().toString());
        rmatNoticeSupplierTbVO.setSourceType("云南建投招标公告");
        rmatNoticeSupplierTbVO.setSourceOrgId(rmatNoticeEntity.getOrgId().toString());
        rmatNoticeSupplierTbVO.setSourceUnitId(rmatNoticeEntity.getUnitId().toString());
        rmatNoticeSupplierTbVO.setType("RMAT");
        rmatNoticeSupplierTbVO.setTenderName(rmatNoticeEntity.getNoticeName());
        rmatNoticeSupplierTbVO.setSourceEmployeeId(rmatNoticeEntity.getEmployeeId().toString());
        rmatNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        rmatNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        rmatNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        rmatNoticeSupplierTbVO.setId(null);
        rmatNoticeSupplierTbVO.setCreateTime(null);
        rmatNoticeSupplierTbVO.setUpdateTime(null);
        rmatNoticeSupplierTbVO.setCreateUserCode(null);
        rmatNoticeSupplierTbVO.setUpdateUserCode(null);
        rmatNoticeSupplierTbVO.setSyncEsFlag(null);
        rmatNoticeSupplierTbVO.setVersion(null);
        rmatNoticeSupplierTbVO.setTenantId(null);
        rmatNoticeSupplierTbVO.setDr(null);
        rmatNoticeSupplierTbVO.setRentalType(inviteEntity.getRentalType());
        rmatNoticeSupplierTbVO.setBackType(inviteEntity.getBackType());
        rmatNoticeSupplierTbVO.setRentalStacking(inviteEntity.getRentalStacking());
        rmatNoticeSupplierTbVO.setBackStacking(inviteEntity.getBackStacking());

        //插入物资
        List<RmatNoticeDetailVO> noticeDetailEntityList =  rmatNoticeDetailMapper.selectSumDetail(rmatNoticeVO.getId());
        List<RmatNoticeDetailTbVO> rmatNoticeDetailVOS = new ArrayList<>();
        for (RmatNoticeDetailVO rmatNoticeDetailEntity : noticeDetailEntityList) {
            RmatNoticeDetailTbVO rmatNoticeDetailTbVO = new RmatNoticeDetailTbVO();
            BeanUtils.copyProperties(rmatNoticeDetailTbVO, rmatNoticeDetailEntity);
            rmatNoticeDetailTbVO.setNum(rmatNoticeDetailEntity.getSumNum());
            rmatNoticeDetailTbVO.setLackMonthDayUnitPriceTender(rmatNoticeDetailEntity.getLackMonthDayUnitPrice());
            rmatNoticeDetailTbVO.setLackMonthDayUnitTaxPriceTender(rmatNoticeDetailEntity.getLackMonthDayUnitTaxPrice());
            rmatNoticeDetailTbVO.setMoney(rmatNoticeDetailEntity.getSumMoney());
            rmatNoticeDetailTbVO.setMoneyTax(rmatNoticeDetailEntity.getSumMoneyTax());
            rmatNoticeDetailTbVO.setSourceId(rmatNoticeEntity.getInviteId().toString());
            rmatNoticeDetailTbVO.setSourceMaterialId(rmatNoticeDetailEntity.getMaterialId()==null?null: rmatNoticeDetailEntity.getMaterialId().toString());
            rmatNoticeDetailTbVO.setSourceMaterialTypeId(rmatNoticeDetailEntity.getMaterialTypeId()==null?null: rmatNoticeDetailEntity.getMaterialTypeId().toString());
            rmatNoticeDetailTbVO.setPriceTender(rmatNoticeDetailEntity.getPrice());
            rmatNoticeDetailTbVO.setTaxPriceTender(rmatNoticeDetailEntity.getPriceTax());
            rmatNoticeDetailVOS.add(rmatNoticeDetailTbVO);
        }
        rmatNoticeSupplierTbVO.setRmatDetailList(rmatNoticeDetailVOS);

        //是否是邀请招标
        if (rmatNoticeVO.getTenderType()==1){
            List<RmatNoticeSupplierDetailEntity> detailEntityList = noticeSupplierDetailService.list(new LambdaQueryWrapper<RmatNoticeSupplierDetailEntity>().eq(RmatNoticeSupplierDetailEntity::getInviteId, rmatNoticeEntity.getInviteId()).eq(RmatNoticeSupplierDetailEntity::getDr, 0));
            List<RmatNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (RmatNoticeSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                RmatNoticeSupplierDetailTbVO rmatNoticeSupplierDetailTbVO = new RmatNoticeSupplierDetailTbVO();
                rmatNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                rmatNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                rmatNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(rmatNoticeSupplierDetailTbVO);
            }
            rmatNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }

        //维修标准
        List<RmatInviteRepairEntity> rmatDetailRepair = inviteEntity.getRmatDetailRepair();
        List<RmatRepairVO> rmatRepairList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(rmatDetailRepair)){
            for (RmatInviteRepairEntity rmatInviteRepairEntity : rmatDetailRepair){
                RmatRepairVO rmatRepairVO = BeanMapper.map(rmatInviteRepairEntity, RmatRepairVO.class);
                rmatRepairVO.setSourceId(inviteEntity.getId().toString());
                rmatRepairVO.setSourceMaterialId(rmatInviteRepairEntity.getMaterialId().toString());
                rmatRepairVO.setSourceMaterialTypeId(rmatInviteRepairEntity.getMaterialTypeId().toString());
                rmatRepairList.add(rmatRepairVO);
            }
            rmatNoticeSupplierTbVO.setRmatRepairList(rmatRepairList);
        }

        //报废标准
        List<RmatScrapVO> rmatScrapList = new ArrayList<>();
        List<RmatInviteScrapEntity> rmatDetailScrap = inviteEntity.getRmatDetailScrap();
        if (CollectionUtils.isNotEmpty(rmatDetailScrap)){
            for (RmatInviteScrapEntity rmatInviteRepairEntity : rmatDetailScrap){
                RmatScrapVO rmatRepairVO = BeanMapper.map(rmatInviteRepairEntity, RmatScrapVO.class);
                rmatRepairVO.setSourceId(inviteEntity.getId().toString());
                rmatRepairVO.setSourceMaterialId(rmatInviteRepairEntity.getMaterialId().toString());
                rmatRepairVO.setSourceMaterialTypeId(rmatInviteRepairEntity.getMaterialTypeId().toString());
                rmatScrapList.add(rmatRepairVO);
            }
            rmatNoticeSupplierTbVO.setRmatScrapList(rmatScrapList);
        }

        logger.info("rmat发布公告:",JSON.toJSONString(rmatNoticeSupplierTbVO));

        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(rmatNoticeSupplierTbVO), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        //招标公告发布成功后 改招标状态 为报名中
        inviteEntity.setTenderState(TenderStateEnum.报名中.getCode());
        inviteEntity.setStopTime(rmatNoticeEntity.getNoticeEndTime());
        inviteService.saveOrUpdate(inviteEntity);
        return CommonResponse.success("公告信息推送成功");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<RmatNoticeEntity>().eq(RmatNoticeEntity::getInviteId,sourceId)).getId();
    }

    @Override
    public boolean selectFile(RmatNoticeVO vo) {
        List<RmatNoticeSupplierEntity> noticeSuppliermatityList = supplierService.list(new QueryWrapper<RmatNoticeSupplierEntity>().eq("notice_id", vo.getId()).eq("dr", 0));
        List<RmatNoticeSupplierVO> rmatNoticeSupplierVOS = BeanMapper.mapList(noticeSuppliermatityList, RmatNoticeSupplierVO.class);
        //处理供应商附件信息
        if (CollectionUtils.isNotEmpty(rmatNoticeSupplierVOS)){
            List<Long> attachIds = rmatNoticeSupplierVOS.stream().map(RmatNoticeSupplierVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds",attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId),Function.identity());
                    Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                    for (RmatNoticeSupplierVO rmatNoticeSupplierVO : rmatNoticeSupplierVOS){
                        List<AttachmentVO> attachmentVOList = attacMap.get(rmatNoticeSupplierVO.getId());
                        if (attachmentVOList!=null){
                            ArrayList<Map<String, Object>> list = new ArrayList<>();
                            for (AttachmentVO attachmentVO : attachmentVOList) {
                                HashMap<String, Object> hashMap = new HashMap<>();
                                hashMap.put("attachId",attachmentVO.getId());
                                hashMap.put("name",attachmentVO.getFileName());
                                list.add(hashMap);
                            }
                            rmatNoticeSupplierVO.setFile(list);
                        }else {
                            rmatNoticeSupplierVO.setAttachId(null);
                            rmatNoticeSupplierVO.setFileName(null);
                        }
                    }
                }
            }
            vo.setNoticeSupplierDetail(rmatNoticeSupplierVOS);
        }
        return true;
    }
}
