package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.api.IBatchPlanApi;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.vo.RmatBidVO;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("rmatPicketage")
public class RmatPicketageBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IRmatPicketageService rmatPicketageService;
	@Autowired
	private IRmatBidService rmatBidService;
	@Autowired
	private IRmatWinnoticeService rmatWinnoticeService;
	@Autowired
	private IRmatAdviceService rmatAdviceService;
	@Autowired
	private IRmatInviteService rmatInviteService;
	@Autowired
	private IRmatBidDetailService rmatBidDetailService;
	@Autowired
	private IRmatDocumentSellService rmatDocumentSellService;
	@Autowired
	private IRmatDocumentScrapService rmatDocumentScrapService;
	@Autowired
	private IRmatDocumentRepairService rmatDocumentRepairService;
	@Autowired
	private IRmatBidSupplierService rmatBidSupplierService;
	@Autowired
	private IRmatDocumentSupplierService rmatDocumentSupplierService;
	@Autowired
	private IProcessService processService;
	@Autowired
	private IShareSupplierApi shareSupplierApi;
	@Autowired
	private IRmatPicketageRefsupplierService rmatPicketageRefsupplierService;
	@Autowired
	private IRmatPicketageSupplierService rmatPicketageSupplierService;
	@Autowired
	private IRmatInviteDetailRecordService rmatInviteDetailRecordService;
	@Autowired
	private IBatchPlanApi batPlanApi;

	@Value("${gysUrl.updateTimeUrl}")
	private String updateTimeUrl;

	@Value("${gysUrl.winbidSavesUrl}")
	private String winbidSavesUrl;
	private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
	@Autowired
	private IProjectPoolApi projectPoolApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RmatBidVO rmatBidVO = rmatBidService.saveBid(billId);
		rmatBidService.publishBid(rmatBidVO);

		//处理参照表,只处理项目线的数据
		//查询出所有定标的数据

		RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(billId);
		RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatPicketageEntity.getInviteId());

		// 完成采购计划
//		QueryParam rmatInviteDetailQueryParam = new QueryParam();
//		rmatInviteDetailQueryParam.getParams()
//				.put("invite_id", new Parameter(QueryParam.EQ, rmatInviteEntity.getId()));
//		List<RmatInviteDetailRecordEntity> rmatInviteDetailEntityList = rmatInviteDetailRecordService
//				.queryList(rmatInviteDetailQueryParam);
		// 获取采购计划ID
		rmatInviteService.updateApiState(rmatInviteEntity,BatchPlanEnum.PLAN_STATE_OVER.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_OVER.getPlanState());
//		if (CollectionUtils.isNotEmpty(rmatInviteDetailEntityList)) {
//			List<String> planIdList = rmatInviteDetailEntityList.stream()
//					.map(RmatInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
//					.collect(Collectors.toList());
//			// 释放采购计划
//			batPlanApi.updateBatPlanQuote(planIdList, BatchPlanEnum.PLAN_STATE_OVER.getPlanState());
//		}

//		if (rmatInviteEntity.getPurchaseType().equals(0)) {
		LambdaQueryWrapper<RmatDocumentSellEntity> sellWrapper = Wrappers.lambdaQuery();
		sellWrapper.eq(RmatDocumentSellEntity::getDocumentId, rmatPicketageEntity.getDocumentId());
		sellWrapper.eq(RmatDocumentSellEntity::getTenderFlag, 1);
		List<RmatDocumentSellEntity> rmatDocumentSellList = rmatDocumentSellService.list(sellWrapper);
		//项目招标
		//改造-0905
		Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
		if (rmatInviteEntity.getPurchaseType().equals(0)){
			List<Long> projectPks = rmatDocumentSellList.stream().map(RmatDocumentSellEntity::getProjectId).collect(Collectors.toList());
			CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(projectPks);

			if (jsonArrayCommonResponse.isSuccess()){
				JSONArray data = jsonArrayCommonResponse.getData();
				List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
				proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
			}
		}
		Map<String, List<RmatDocumentSellEntity>> dataMap = new HashMap<>();
		for (RmatDocumentSellEntity rmatDocumentSellEntity : rmatDocumentSellList) {
			//改造-0905
			if (rmatInviteEntity.getPurchaseType().equals(0)){
				ProjectPoolSetVO projectPoolSetVO = proMap.get(rmatDocumentSellEntity.getProjectId());
				if (projectPoolSetVO != null){
					rmatDocumentSellEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
					rmatDocumentSellEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
				}
			}
			String s = null;
			if (rmatInviteEntity.getPurchaseType().equals(0)){
				s = rmatDocumentSellEntity.getProjectId().toString() + rmatDocumentSellEntity.getSupplierId()
						.toString();
			}
			if (rmatInviteEntity.getPurchaseType().equals(1)){
				s = rmatDocumentSellEntity.getSupplierId()
						.toString();
			}
			if (dataMap.containsKey(s)) {
				List<RmatDocumentSellEntity> rmatDocumentSellEntityList = dataMap.get(s);
				rmatDocumentSellEntityList.add(rmatDocumentSellEntity);
				dataMap.put(s,rmatDocumentSellEntityList);
			}else {
				List<RmatDocumentSellEntity> rmatDocumentSellEntities = new ArrayList<>();
				rmatDocumentSellEntities.add(rmatDocumentSellEntity);
				dataMap.put(s,rmatDocumentSellEntities);
			}
		}
		List<RmatPicketageRefsupplierEntity> rmatPicketageRefsuppliermatities = new ArrayList<>();
		dataMap.forEach((key,value) -> {
			RmatPicketageRefsupplierEntity rmatPicketageRefsupplierEntity = new RmatPicketageRefsupplierEntity();
			RmatDocumentSellEntity rmatSellEntity = value.stream().findFirst().get();
			rmatPicketageRefsupplierEntity.setSupplierId(rmatSellEntity.getSupplierId());
			rmatPicketageRefsupplierEntity.setSupplierName(rmatSellEntity.getSupplierName());
			rmatPicketageRefsupplierEntity.setProjectId(rmatSellEntity.getProjectId());
			rmatPicketageRefsupplierEntity.setProjectName(rmatSellEntity.getProjectName());
			rmatPicketageRefsupplierEntity.setProjectCode(rmatInviteEntity.getProjectCode());
			rmatPicketageRefsupplierEntity.setPicketageId(billId);
			rmatPicketageRefsupplierEntity.setOccupyFlag(0);
			SupplierDTO supplierVO = shareSupplierApi.queryById(rmatSellEntity.getSupplierId()).getData();
			rmatPicketageRefsupplierEntity.setSupplierTenantId(supplierVO.getTenant());
			rmatPicketageRefsupplierEntity.setPicketageName(rmatPicketageEntity.getPicketageName());
			rmatPicketageRefsupplierEntity.setPicketageDate(new Date());
			//改造-0905
			if (rmatInviteEntity.getPurchaseType().equals(0)){
				rmatPicketageRefsupplierEntity.setOrgId(rmatSellEntity.getOrgId());
				rmatPicketageRefsupplierEntity.setOrgName(rmatSellEntity.getOrgName());
			}
			if (rmatInviteEntity.getPurchaseType().equals(1)){
				rmatPicketageRefsupplierEntity.setOrgId(rmatInviteEntity.getOrgId());
				rmatPicketageRefsupplierEntity.setOrgName(rmatInviteEntity.getOrgName());
			}
			rmatPicketageRefsupplierEntity.setParentOrgId(rmatInviteEntity.getParentOrgId());
			rmatPicketageRefsupplierEntity.setParentOrgName(rmatInviteEntity.getParentOrgName());
			rmatPicketageRefsupplierEntity.setRentType(rmatInviteEntity.getRentType());
			rmatPicketageRefsupplierEntity.setPicketageFlag(0);
			rmatPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
			rmatPicketageRefsupplierEntity.setPurchaseType(rmatInviteEntity.getPurchaseType());
			BigDecimal tenderMoney = BigDecimal.ZERO;
			BigDecimal tenderMoneyTax = BigDecimal.ZERO;
			for (RmatDocumentSellEntity rmatDocumentSellEntity : value){
				tenderMoney = tenderMoney.add(ComputeUtil.nullToZero(rmatDocumentSellEntity.getTenderMoney()));
				tenderMoneyTax = tenderMoneyTax.add(ComputeUtil.nullToZero(rmatDocumentSellEntity.getTenderMoneyTax()));
			}
			rmatPicketageRefsupplierEntity.setMoney(tenderMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
			rmatPicketageRefsupplierEntity.setMoneyTax(tenderMoneyTax.setScale(2, BigDecimal.ROUND_HALF_UP));
			rmatPicketageRefsuppliermatities.add(rmatPicketageRefsupplierEntity);
		});
		rmatPicketageRefsupplierService.saveBatch(rmatPicketageRefsuppliermatities);


//		}

		//生成中标通知书类表数据
		List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
		List<RmatAdviceEntity> rmatAdviceList = BeanMapper.mapList(picketageSupplierList, RmatAdviceEntity.class);
		for (RmatAdviceEntity rmatAdviceEntity : rmatAdviceList){
			rmatAdviceEntity.setTitleName(rmatInviteEntity.getTenderName());
			rmatAdviceEntity.setUnitId(rmatInviteEntity.getUnitId());
			rmatAdviceEntity.setUnitName(rmatInviteEntity.getUnitName());
			rmatAdviceEntity.setProjectId(rmatInviteEntity.getProjectId());
			rmatAdviceEntity.setProjectName(rmatInviteEntity.getProjectName());
			rmatAdviceEntity.setOrgId(rmatInviteEntity.getOrgId());
			rmatAdviceEntity.setOrgName(rmatInviteEntity.getOrgName());
			rmatAdviceEntity.setParentOrgId(rmatInviteEntity.getParentOrgId());
			rmatAdviceEntity.setParentOrgName(rmatInviteEntity.getParentOrgName());
			rmatAdviceEntity.setParentOrgName(rmatInviteEntity.getParentOrgName());
			rmatAdviceEntity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(rmatInviteEntity.getTenderType()).getDescription());
			rmatAdviceEntity.setLineTypeName(CommonUtils.getTypeName(4));
			rmatAdviceEntity.setPurchaseType(rmatInviteEntity.getPurchaseType());
			rmatAdviceEntity.setScFlag(1);
			rmatAdviceEntity.setSendFlag(1);
			rmatAdviceEntity.setSignFlag(0);
			rmatAdviceEntity.setId(null);
			rmatAdviceEntity.setInviteId(rmatInviteEntity.getId());
		}


		rmatAdviceService.saveBatch(rmatAdviceList);

		//更新维修中标状态
		//更新中标维修标准和报废标准
		List<Long> supplierIds = picketageSupplierList.stream().map(RmatPicketageSupplierEntity::getSupplierId).collect(Collectors.toList());
		LambdaQueryWrapper<RmatDocumentRepairEntity> lambdaRepair = Wrappers.<RmatDocumentRepairEntity>lambdaQuery();
		lambdaRepair.eq(RmatDocumentRepairEntity::getInviteId,rmatPicketageEntity.getInviteId());
		List<RmatDocumentRepairEntity> rmatDocumentRepairEntities = rmatDocumentRepairService.list(lambdaRepair);
		if (CollectionUtils.isNotEmpty(rmatDocumentRepairEntities)){
			List<Integer> talkNumList = rmatDocumentRepairEntities.stream().map(RmatDocumentRepairEntity::getTalkNum).collect(Collectors.toList());
			Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();
			for (RmatDocumentRepairEntity rmatDocumentRepairEntity : rmatDocumentRepairEntities){
				if (rmatDocumentRepairEntity.getTalkNum().equals(talkNumMax) && supplierIds.contains(rmatDocumentRepairEntity.getSupplierId())){
					rmatDocumentRepairEntity.setTenderFlag(0);
				}else{
					rmatDocumentRepairEntity.setTenderFlag(1);
				}
			}
			rmatDocumentRepairService.updateBatchById(rmatDocumentRepairEntities);
		}

		//更新报废标准中标信息
		LambdaQueryWrapper<RmatDocumentScrapEntity> lambdaScrap = Wrappers.<RmatDocumentScrapEntity>lambdaQuery();
		lambdaScrap.eq(RmatDocumentScrapEntity::getInviteId,rmatPicketageEntity.getInviteId());
		List<RmatDocumentScrapEntity> rmatDocumentScrapEntities = rmatDocumentScrapService.list(lambdaScrap);
		if (CollectionUtils.isNotEmpty(rmatDocumentScrapEntities)){
			List<Integer> talkNumList = rmatDocumentScrapEntities.stream().map(RmatDocumentScrapEntity::getTalkNum).collect(Collectors.toList());
			Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();
			for (RmatDocumentScrapEntity rmatDocumentScrapEntity : rmatDocumentScrapEntities){
				if (rmatDocumentScrapEntity.getTalkNum().equals(talkNumMax) && supplierIds.contains(rmatDocumentScrapEntity.getSupplierId())){
					rmatDocumentScrapEntity.setTenderFlag(0);
				}else{
					rmatDocumentScrapEntity.setTenderFlag(1);
				}
			}
			rmatDocumentScrapService.updateBatchById(rmatDocumentScrapEntities);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
