package com.ejianc.business.tender.stuff.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料立项主表
 *
 * @author generator
 *
 */
@TableName("ejc_tender_stuff_invite")
public class StuffInviteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目ID
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 编制人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 编制人名称
    @TableField(value="unit_id")
    private java.lang.Long unitId; // 招标单位ID
    @TableField(value="unit_name")
    private java.lang.String unitName; // 招标单位名称
    @TableField(value="memo")
    private java.lang.String memo; // 备注
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="tender_name")
    private java.lang.String tenderName; // 招标名称
    @TableField(value="tender_type")
    private java.lang.Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标，6-洽商谈判)
    @TableField(value="tender_stage")
    private java.lang.Integer tenderStage; // 招标阶段
    @TableField(value="tender_unit_num")
    private java.lang.String tenderUnitNum; // 中标单位及数量
    @TableField(value="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date createDate; // 编制日期
    @TableField(value="value_type")
    private java.lang.Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    @TableField(value="purchase_id")
    private java.lang.String purchaseId; // 采购方式ID
    @TableField(value="purchase_name")
    private java.lang.String purchaseName; // 采购方式名称
    @TableField(value="project_code")
    private java.lang.String projectCode; // 项目编号
    @TableField(value="tender_money")
    private java.math.BigDecimal tenderMoney; // 招标金额
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private java.lang.Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private java.lang.String parentOrgName; // 父级组织名称
    @TableField(value="establish_type")
    private java.lang.Integer establishType; // 立项类型(0-招标立项，1-定标立项)
    @TableField(value="purchase_type")
    private java.lang.Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    @TableField(value="abolish_type")
    private java.lang.Integer abolishType;//流/废标（0-正常，1-流标，2-废标）
    @TableField(value="contract_type")
    private java.lang.String contractType;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    @TableField(value="contract_type_name")
    private java.lang.String contractTypeName;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    @TableField(value="purchase_type_name")
    private java.lang.String purchaseTypeName; // 采购方式名称
    @TableField(value="tender_platform")
    private java.lang.Integer tenderPlatform; // 招标平台(1-招采平台，2-云上营家)
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商ID
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称


    @TableField(value="money")
    private java.math.BigDecimal money; // 定标金额(无税)
    @TableField(value="tax_money")
    private java.math.BigDecimal taxMoney; // 定标金额(含税)
    @TableField(value="occupy_state")
    private Integer occupyState; //占用状态:0-未占用,1-已占用
    @TableField(value="tender_state")
    private Integer tenderState; // 招标状态:1-报名中,2-报价中,3-专家评标中,4-专家评标结束
    @TableField(value="stop_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date stopTime; //报名或报价截止时间
    @TableField(value="draft_type")
    private Integer draftType; //招标文件生成方式  线上起草-1、手动上传-2
    @TableField(value="contract_file_path")
    private String contractFilePath; // 合同附件路径
    @TableField(value="contract_file_id")
    private Long contractFileId; // 合同附件Id
    @TableField(value="contract_template_id")
    private Long contractTemplateId; // 合同模板Id
    @TableField(value="contract_template_name")
    private String contractTemplateName; // 合同模板名称
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 招标文件模版(分类)Id--实际存储的是供货内容id
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 招标文件模版(分类)名称--实际存储的是供货内容name
    @TableField(value="contract_file_highlight_path")
    private String contractFileHighlightPath; // 合同高亮附件路径
    @TableField(value="contract_file_highlight_id")
    private Long contractFileHighlightId; // 合同高亮附件Id
    /**
     * 线上起草合同，审批中修改的合同是否已重新进行合同编辑
     */
    @TableField(value = "contract_file_sync_flag")
    private Boolean contractFileSyncFlag = true;

    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Integer getDraftType() {
        return draftType;
    }

    public void setDraftType(Integer draftType) {
        this.draftType = draftType;
    }

    public Integer getOccupyState() {
        return occupyState;
    }

    public void setOccupyState(Integer occupyState) {
        this.occupyState = occupyState;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="stuffInviteDetailService", pidName= "inviteId")
    private List<StuffInviteDetailEntity> stuffDetail = new ArrayList<>(); // 材料招标立项采购清单表
    @TableField(exist=false)
    @SubEntity(serviceName="stuffInviteDetailRecordService", pidName= "inviteId")
    private List<StuffInviteDetailRecordEntity> stuffDetailRecord = new ArrayList<>(); // 材料招标立项采购清单表不合并
    @TableField(exist=false)
    @SubEntity(serviceName="stuffInviteSupplierService", pidName= "inviteId")
    private List<StuffInviteSupplierEntity> supplierDetail = new ArrayList<>(); // 材料招标立项供应商表
//    @TableField(exist=false)
//    @SubEntity(serviceName="stuffInviteExpertService", pidName= "inviteId")
//    private List<StuffInviteExpertEntity> expertDetail = new ArrayList<>(); // 材料招标立项专家表
    @TableField(exist=false)
    @SubEntity(serviceName="stuffInviteDetailBidderService", pidName= "inviteId")
    private List<StuffInviteDetailBidderEntity> stuffDetailBidder = new ArrayList<>(); // 材料定标立项定标情况表
    @TableField(value="sign_status")
    private Integer signStatus; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public Integer getTenderPlatform() {
        return tenderPlatform;
    }

    public void setTenderPlatform(Integer tenderPlatform) {
        this.tenderPlatform = tenderPlatform;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public List<StuffInviteDetailRecordEntity> getStuffDetailRecord() {
        return stuffDetailRecord;
    }

    public void setStuffDetailRecord(List<StuffInviteDetailRecordEntity> stuffDetailRecord) {
        this.stuffDetailRecord = stuffDetailRecord;
    }

    /**
     * 流/废标状态
     */
    public Integer getAbolishType() {
        return abolishType;
    }

    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目ID
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 编制人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标单位ID
     */
    public java.lang.Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    public void setUnitId(java.lang.Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public java.lang.String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(java.lang.String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 招标名称
     */
    public java.lang.String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(java.lang.String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public java.lang.Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(java.lang.Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标阶段
     */
    public java.lang.Integer getTenderStage() {
        return tenderStage;
    }

    /**
     * 招标阶段
     */
    public void setTenderStage(java.lang.Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    /**
     * 中标单位及数量
     */
    public java.lang.String getTenderUnitNum() {
        return tenderUnitNum;
    }

    /**
     * 中标单位及数量
     */
    public void setTenderUnitNum(java.lang.String tenderUnitNum) {
        this.tenderUnitNum = tenderUnitNum;
    }
    /**
     * 编制日期
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public java.lang.Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(java.lang.Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 采购方式ID
     */
    public java.lang.String getPurchaseId() {
        return purchaseId;
    }

    /**
     * 采购方式ID
     */
    public void setPurchaseId(java.lang.String purchaseId) {
        this.purchaseId = purchaseId;
    }
    /**
     * 采购方式名称
     */
    public java.lang.String getPurchaseName() {
        return purchaseName;
    }

    /**
     * 采购方式名称
     */
    public void setPurchaseName(java.lang.String purchaseName) {
        this.purchaseName = purchaseName;
    }
    /**
     * 项目编号
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 招标金额
     */
    public java.math.BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 招标金额
     */
    public void setTenderMoney(java.math.BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 组织
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public java.lang.Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(java.lang.Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public java.lang.String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(java.lang.String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public java.lang.Integer getEstablishType() {
        return establishType;
    }

    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public void setEstablishType(java.lang.Integer establishType) {
        this.establishType = establishType;
    }

    public List<StuffInviteDetailEntity> getStuffDetail() {
        return stuffDetail;
    }

    public void setStuffDetail(List<StuffInviteDetailEntity> stuffDetail) {
        this.stuffDetail = stuffDetail;
    }

    public List<StuffInviteSupplierEntity> getSupplierDetail() {
        return supplierDetail;
    }

    public void setSupplierDetail(List<StuffInviteSupplierEntity> supplierDetail) {
        this.supplierDetail = supplierDetail;
    }

    public List<StuffInviteDetailBidderEntity> getStuffDetailBidder() {
        return stuffDetailBidder;
    }

    public void setStuffDetailBidder(List<StuffInviteDetailBidderEntity> stuffDetailBidder) {
        this.stuffDetailBidder = stuffDetailBidder;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public Integer getTenderState() {
        return tenderState;
    }

    public void setTenderState(Integer tenderState) {
        this.tenderState = tenderState;
    }

    public Date getStopTime() {
        return stopTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }
}
