package com.ejianc.business.tender.stuff.controller;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.material.api.IMaterialBatchPlanApi;
import com.ejianc.business.promaterial.contract.api.IPromaterialContractApi;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.enums.DraftTypeEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailBidderVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailRecordVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubDocumentSupplierService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 *
 * @author generator
 */
@Controller
@RequestMapping("stuffInvite")
public class StuffInviteController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${common.env.base-host}")
    private String BaseHost;

    private static final String BILL_CODE = "TENDER_STUFF";//此处需要根据实际修改

    /** 参照查询：项目ID */
    private static final String CONDITION_PROJECT_ID = "projectId";
    /** 参照查询：组织ID */
    private static final String CONDITION_ORG_ID = "orgId";

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IStuffInviteService service;

    @Autowired
    private IStuffInviteDetailRecordService detailRecordService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private IBatPlanApi batPlanApi;

    @Autowired
    private IStuffPicketageService picketageService;

    @Autowired
    private IStuffPicketageRefsupplierService refsupplierService;

    @Autowired
    private IPromaterialContractApi contractApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialBatchPlanApi materialBatchPlanApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IStuffDocumentService documentService;

    @Autowired
    private IStuffDocumentSupplierService documentSupplierService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffInviteVO> saveOrUpdate(@RequestBody StuffInviteVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");

        //处理子表供应商中标信息
        List<StuffInviteDetailRecordVO> stuffInviteDetailList = saveorUpdateVO.getStuffDetailRecord();
        List<StuffInviteDetailBidderEntity> bidderEntityList = new ArrayList<StuffInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty(stuffInviteDetailList)) {
            for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailList) {
                if (stuffInviteDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    stuffInviteDetailVO.setId(id);
                }
                List<StuffInviteDetailBidderVO> bidderList = stuffInviteDetailVO.getStuffDetailBidder();
                if (CollectionUtils.isNotEmpty(bidderList)) {
                    for (StuffInviteDetailBidderVO bidderVO : bidderList) {
                        bidderVO.setInviteDetailId(stuffInviteDetailVO.getId());
                        StuffInviteDetailBidderEntity bidderEntity = BeanMapper.map(bidderVO, StuffInviteDetailBidderEntity.class);
                        bidderEntityList.add(bidderEntity);
                    }
                }
            }
        }

        StuffInviteEntity entity = BeanMapper.map(saveorUpdateVO, StuffInviteEntity.class);
        if (CollectionUtils.isNotEmpty(bidderEntityList)) {
            entity.setStuffDetailBidder(bidderEntityList);
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<String> oldPlanIdList = detailRecordService.list(new LambdaQueryWrapper<StuffInviteDetailRecordEntity>()
                .eq(StuffInviteDetailRecordEntity::getInviteId, saveorUpdateVO.getId()))
                .stream().map(StuffInviteDetailRecordEntity::getPlanId)
                .map(String::valueOf).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(oldPlanIdList)){
            if (entity.getPurchaseType() == 0) {
                CommonResponse<String> response = batPlanApi.updateBatPlanQuote(oldPlanIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
                if (!response.isSuccess()) {
                    throw new BusinessException("修改批次计划状态失败" + response.getMsg());
                }
            }else {
                CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(oldPlanIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
                if (!response.isSuccess()) {
                    throw new BusinessException("修改采购申请状态失败" + response.getMsg());
                }
            }
            }
        entity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
        if (entity.getEstablishType()==0){
            entity.setTenderMoney(entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getMoneyTax).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        }

        //处理合同附件
        if (entity.getId() != null){
            StuffInviteEntity stuffInviteOldEntity = service.getById(entity.getId());
            if(0==stuffInviteOldEntity.getEstablishType()){
                if (stuffInviteOldEntity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                    //如果招标文件生成方式没变,前后都是线上起草,模版变了则删除附件,
                    if(entity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                        if (!stuffInviteOldEntity.getContractCategoryId().equals(entity.getContractCategoryId())){
                            if (stuffInviteOldEntity.getContractFileId() != null){
                                logger.info("1111111");
                                attachmentApi.deleteFileByParam(stuffInviteOldEntity.getId(),"BT211110000000002","contractFile");
                                CommonResponse<String> delete = attachmentApi.delete(stuffInviteOldEntity.getContractFileId().toString());
                                logger.info(JSONObject.toJSONString(delete));
                            }
                            entity.setContractFileId(null);
                            entity.setContractFilePath(null);
                            entity.setContractTemplateId(null);
                            entity.setContractTemplateName(null);
                            entity.setContractFileHighlightId(null);
                            entity.setContractFileHighlightPath(null);
                        }
                    }
                    //如果招标文件生成方式改变,则
                    if(entity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                        if (stuffInviteOldEntity.getContractFileId() != null){
                            logger.info("222");
                            CommonResponse<String> delete = attachmentApi.deleteFileByParam(stuffInviteOldEntity.getId(),"BT211110000000002","contractFile");
                            attachmentApi.delete(stuffInviteOldEntity.getContractFileId().toString());
                            logger.info(JSONObject.toJSONString(delete));
                        }
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                        entity.setContractCategoryId(null);
                        entity.setContractCategoryName(null);
                    }
                }
                //
                if (stuffInviteOldEntity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                    //如果招标文件生成方式没变,前后都是线上起草,模版变了则删除附件,
                    if(entity.getDraftType().equals(DraftTypeEnum.手动上传.getCode())){
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                    }
                    //如果招标文件生成方式改变,则
                    if(entity.getDraftType().equals(DraftTypeEnum.线上起草.getCode())){
                        if (stuffInviteOldEntity.getContractFileId() != null){
                            attachmentApi.delete(stuffInviteOldEntity.getContractFileId().toString());
                        }
                        entity.setContractFileId(null);
                        entity.setContractFilePath(null);
                        entity.setContractTemplateId(null);
                        entity.setContractTemplateName(null);
                        entity.setContractFileHighlightId(null);
                        entity.setContractFileHighlightPath(null);
                    }
                }
            }
        }

        service.saveOrUpdate(entity, false);
        StuffInviteVO vo = BeanMapper.map(entity, StuffInviteVO.class);

        //处理供应商子表信息
        List<StuffInviteDetailRecordVO> stuffInviteDetailVOList = vo.getStuffDetailRecord();
        List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOList = vo.getStuffDetailBidder();
        if (CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOList)) {
            Map<Long, List<StuffInviteDetailBidderVO>> bidderMap = stuffInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(StuffInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(stuffInviteDetailVOList)) {
                for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailVOList) {
                    List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOS = bidderMap.get(stuffInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOS)) {
                        stuffInviteDetailVO.setStuffDetailBidder(stuffInviteDetailBidderVOS);
                    }
                }
            }
        }
        //修改计划状态
        List<String> planIdList = entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
        if (entity.getPurchaseType() == 0 ){
            CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState());
            if (!response.isSuccess()) {
                throw new BusinessException("修改批次计划状态失败" + response.getMsg());
            }
        }else {
            CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState());
            if (!response.isSuccess()) {
                throw new BusinessException("修改采购申请状态失败" + response.getMsg());
            }
        }
        if (entity.getEstablishType()==1){
            //修改招标状态
            List<Long> inviteIdList = entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getPlanId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(inviteIdList)) {
                UpdateWrapper<StuffInviteEntity> wrapper = new UpdateWrapper<>();
                wrapper.set("occupy_state",1).in("id", inviteIdList);
                service.update(wrapper);
            }
        }


        //保存招标过程记录表
        if (!processService.selectByBillId(entity.getId())) {
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType() == 1) {
                processEntity.setBillName("定标立项");
            }
            else {
                processEntity.setBillName("招标立项");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(0);
            processEntity.setFrontendUrl("stuff/invite/card");
            processService.saveOrUpdate(processEntity);
        }

        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffInviteVO> queryDetail(Long id) {
        StuffInviteEntity entity = service.selectById(id);
        StuffInviteVO vo = BeanMapper.map(entity, StuffInviteVO.class);
        //处理供应商子表信息
        List<StuffInviteDetailRecordVO> stuffInviteDetailVOList = vo.getStuffDetailRecord();
        List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOList = vo.getStuffDetailBidder();
        if (CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOList)) {
            Map<Long, List<StuffInviteDetailBidderVO>> bidderMap = stuffInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(StuffInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(stuffInviteDetailVOList)) {
                for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailVOList) {
                    List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOS = bidderMap.get(stuffInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOS)) {
                        stuffInviteDetailVO.setStuffDetailBidder(stuffInviteDetailBidderVOS);
                    }
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StuffInviteVO> vos) {
        List<Long> idList = vos.stream().map(StuffInviteVO::getId).collect(Collectors.toList());
        for (Long inviteId : idList) {
            StuffInviteEntity inviteEntity = service.selectById(inviteId);
            List<String> planIdList = detailRecordService.list(new LambdaQueryWrapper<StuffInviteDetailRecordEntity>()
                    .eq(StuffInviteDetailRecordEntity::getInviteId, inviteId))
                    .stream().map(StuffInviteDetailRecordEntity::getPlanId)
                    .map(String::valueOf).distinct().collect(Collectors.toList());
            if (inviteEntity.getPurchaseType() == 0 ){
                CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
                if (!response.isSuccess()) {
                    throw new BusinessException("修改批次计划状态失败" + response.getMsg());
                }
            }else {
                CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
                if (!response.isSuccess()) {
                    throw new BusinessException("修改采购申请状态失败" + response.getMsg());
                }
            }

            //修改招标状态
            if (inviteEntity.getEstablishType()==1){
                List<String> inviteIdList = detailRecordService.list(new LambdaQueryWrapper<StuffInviteDetailRecordEntity>()
                        .eq(StuffInviteDetailRecordEntity::getInviteId, inviteId))
                        .stream().map(StuffInviteDetailRecordEntity::getPlanId)
                        .map(String::valueOf).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(inviteIdList)) {
                    UpdateWrapper<StuffInviteEntity> wrapper = new UpdateWrapper<>();
                    wrapper.set("occupy_state",0).in("id", inviteIdList);
                    service.update(wrapper);
                }
            }
        }
        service.removeByIds(vos.stream().map(StuffInviteVO::getId).collect(Collectors.toList()), true);
        processService.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId, vos.stream().map(StuffInviteVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StuffInviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseTypeName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("employeeId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().put("employeeId", new Parameter(QueryParam.NE, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");

        Parameter purchaseId = param.getParams().get("purchaseId");
        if(null!=purchaseId){
            List<String> purchaseIdList = Arrays.asList(param.getParams().get("purchaseId").getValue().toString().split(","));
            logger.info("purchaseId-------{}", param.getParams().get("purchaseId").getValue().toString());
            if (purchaseIdList.size() > 1){

                String sqlStr = "";
                for (String s : purchaseIdList) {
                    sqlStr += " purchase_id like \"%" + s + "%\" or";
                }
                sqlStr = sqlStr.substring(0, sqlStr.length() - 2);
                logger.info("sqlStr----{}", sqlStr);
                param.getParams().put("", new Parameter(QueryParam.SQL, "(" + sqlStr + ")"));
            }else {
                param.getParams().put("", new Parameter(QueryParam.SQL, " ( purchase_id like \"%" + param.getParams().get("purchaseId").getValue().toString() + "%\" )"));
            }
        }
        logger.info("param------{}", JSONObject.toJSONString(param.getParams()));
        param.getParams().remove("purchaseId");



        Parameter tenderState = param.getParams().get("tenderState");
        Boolean enrollFinishFlag = false;//报名截止
        Boolean quoteFinishFlag = false;//报价截止
        if(null!=tenderState){
            if (tenderState.getValue().toString().equals("1") || tenderState.getValue().toString().equals("2")){//报名中、报价中
                param.getParams().put("stopTime", new Parameter(QueryParam.GT, new Date()));
            }else if (tenderState.getValue().toString().equals("11")){
                enrollFinishFlag = true;
                param.getParams().put("stopTime", new Parameter(QueryParam.LT, new Date()));
                param.getParams().put("tenderState", new Parameter(QueryParam.EQ, 1));
            }else if (tenderState.getValue().toString().equals("21")){
                quoteFinishFlag = true;
                param.getParams().put("stopTime", new Parameter(QueryParam.LT, new Date()));
                param.getParams().put("tenderState", new Parameter(QueryParam.EQ, 2));
            }
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<StuffInviteEntity> page = service.queryPage(param, false);
        IPage<StuffInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffInviteVO.class));
        Date newData = new Date();
        for (StuffInviteVO record : pageData.getRecords()) {
            switch (record.getTenderType()) {
                case 0:
                    record.setTenderTypeName("平台公开招标");
                    break;
                case 1:
                    record.setTenderTypeName("邀请招标");
                    break;
                case 2:
                    record.setTenderTypeName("询价");
                    break;
                case 3:
                    record.setTenderTypeName("竞争性谈判");
                    break;
                case 4:
                    record.setTenderTypeName("单一来源");
                    break;
                case 5:
                    record.setTenderTypeName("紧急招标");
                    break;
            }
            switch (record.getSignStatus()) {
                case 0:
                    record.setSignStatusName("未签订");
                    break;
                case 1:
                    record.setSignStatusName("部分签订");
                    break;
                case 2:
                    record.setSignStatusName("全部已签");
                    break;
                case 3:
                    record.setSignStatusName("已关闭");
                    break;
            }
            if (null != record.getTenderState()){
                if (enrollFinishFlag){
                    record.setTenderStateName("报名截止");
                }else if (quoteFinishFlag){
                    record.setTenderStateName("报价截止");
                }else {
                    switch (record.getTenderState()) {
                        case 1:
                            if (null != record.getStopTime() && record.getStopTime().compareTo(newData) > 0){
                                record.setTenderStateName("报名中");
                            }else {
                                record.setTenderStateName("报名截止");
                            }
                            break;
                        case 2:
                            if (null != record.getStopTime() && record.getStopTime().compareTo(newData) > 0){
                                record.setTenderStateName("报价中");
                            }else {
                                record.setTenderStateName("报价截止");
                            }
                            break;
                        case 3:
                            record.setTenderStateName("专家评标中");
                            break;
                        case 4:
                            record.setTenderStateName("专家评标结束");
                            break;
                    }
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "招标立项" : "定标立项");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("purchaseName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StuffInviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<StuffInviteVO> voList = JSON.parseArray(JSON.toJSONString(list), StuffInviteVO.class);
        for (StuffInviteVO stuffInviteVO : voList) {
            switch (stuffInviteVO.getTenderType()) {
                case 0:
                    stuffInviteVO.setTenderTypeName("平台公开招标");
                    break;
                case 1:
                    stuffInviteVO.setTenderTypeName("邀请招标");
                    break;
                case 2:
                    stuffInviteVO.setTenderTypeName("询价");
                    break;
                case 3:
                    stuffInviteVO.setTenderTypeName("竞争性谈判");
                    break;
                case 4:
                    stuffInviteVO.setTenderTypeName("单一来源");
                    break;
                case 5:
                    stuffInviteVO.setTenderTypeName("紧急招标");
                    break;
            }
            stuffInviteVO.setEstablishTypeName(stuffInviteVO.getEstablishType() == 0 ? "招标立项" : "定标立项");
            stuffInviteVO.setPurchaseTypeName(stuffInviteVO.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            stuffInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode(stuffInviteVO.getBillState()).getDescription());
            stuffInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(stuffInviteVO.getTenderStage()).getDescription());


            //处理报价供应商导出问题
            List<StuffDocumentEntity> documentEntityList = documentService.list(new LambdaQueryWrapper<StuffDocumentEntity>().eq(StuffDocumentEntity::getInviteId, stuffInviteVO.getId()));
            if(CollectionUtils.isNotEmpty(documentEntityList)){
                List<StuffDocumentSupplierEntity> documentSupplierEntityList = documentSupplierService.list(new LambdaQueryWrapper<StuffDocumentSupplierEntity>().eq(StuffDocumentSupplierEntity::getDocumentId, documentEntityList.get(0).getId()).groupBy(StuffDocumentSupplierEntity::getSupplierId));
                if(CollectionUtils.isNotEmpty(documentSupplierEntityList)){
                    StringBuffer sb = new StringBuffer();
                    for(int j=0;j<documentSupplierEntityList.size();j++){
                        if(j==(documentSupplierEntityList.size()-1)){
                            sb.append(documentSupplierEntityList.get(j).getSupplierName());
                        }else{
                            sb.append(documentSupplierEntityList.get(j).getSupplierName()+",");
                        }
                    }
                    stuffInviteVO.setSupplierTenderName(sb.toString());
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("材料立项.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refStuffInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StuffInviteVO>> refStuffInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("tenderPlatform", new Parameter(QueryParam.EQ, 2));
        param.getParams().put("occupyState", new Parameter(QueryParam.EQ, 0));

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 项目id
            if (_con.containsKey(CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get(CONDITION_PROJECT_ID).toString());
                CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("查询项目信息失败！");
                }
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
            }
            // 组织id
            if (_con.containsKey(CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get(CONDITION_ORG_ID).toString());
                CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
                OrgVO orgVO = orgResp.getData();
                /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                }
                else {
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                            .findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId)
                            .collect(Collectors.toList())));
                }
            }
            if(_con.containsKey("purchaseType")){
                Integer purchaseType = _con.getInteger("purchaseType");
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ,purchaseType));
            }
        }
        IPage<StuffInviteEntity> page = service.queryPage(param, false);
        IPage<StuffInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffInviteVO.class));

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<StuffInviteVO> stuffInviteVOList = pageData.getRecords();
            List<String> idList = stuffInviteVOList.stream().map(StuffInviteVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("inviteId", new Parameter(QueryParam.IN, idList));
            List<StuffInviteDetailRecordEntity> detailEntityList = detailRecordService.queryList(detailParam);
            List<StuffInviteDetailRecordVO> detailVOList = BeanMapper.mapList(detailEntityList, StuffInviteDetailRecordVO.class);
            Map<Long, List<StuffInviteDetailRecordVO>> detailMap = new HashMap<>();
            List<StuffInviteDetailRecordVO> mapList;
            // 按照planID对子表结果分组
            for (StuffInviteDetailRecordVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getInviteId())) {
                    detailMap.get(vo.getInviteId()).add(vo);
                }
                else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getInviteId(), mapList);
                }
            }
            // 将清单添加到主表中
            stuffInviteVOList.forEach(t -> {
                t.setStuffDetailRecord(detailMap.get(t.getId()));
            });
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description saveOrUpdate 获取流/废标状态
     */
    @RequestMapping(value = "/getAType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = service.getAbolishType(tenderId);
        return CommonResponse.success("查询流/废标状态成功！", map);
    }

    /**
     * @param
     * @Description 子表导出
     * @Return void
     */
    @RequestMapping(value = "/detailExcelExport", method = RequestMethod.GET)
    @ResponseBody
    public void detailExcelExport(Long id, HttpServletResponse response) {
        StuffInviteVO stuffInviteVO = queryDetail(id).getData();
        List<StuffInviteDetailRecordVO> detailList = stuffInviteVO.getStuffDetailRecord();
        for (StuffInviteDetailRecordVO recordVO : detailList) {
            switch (recordVO.getCalculateType()) {
                case 0:
                    recordVO.setCalculateTypeName("理计");
                    break;
                case 1:
                    recordVO.setCalculateTypeName("过磅");
                    break;
                case 2:
                    recordVO.setCalculateTypeName("点数");
                    break;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("stuffInviteDetail.xlsx", beans, response);
    }

    @RequestMapping(value = "/queryContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContract(@RequestBody StuffInviteVO inviteVO) {
        Long refId;
        //招标立项
        if (inviteVO.getEstablishType() == 0) {
            StuffPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<StuffPicketageEntity>().eq("invite_id", inviteVO.getId())).get(0);
            refId = picketageEntity.getId();
        }
        else {
            refId = inviteVO.getId();
        }
        logger.info("定标ID" + refId);
        List<StuffPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<StuffPicketageRefsupplierEntity>().eq("picketage_id", refId));
        List<String> idList = refsupplierList.stream().map(StuffPicketageRefsupplierEntity::getId).map(String::valueOf).collect(Collectors.toList());
        logger.info("定标参照ID" + JSONObject.toJSONString(idList));
        CommonResponse<List<SignContractVo>> response = contractApi.queryContractByTargetResultId(idList);
        if (!response.isSuccess()) {
            throw new BusinessException("查询合同失败" + response.getMsg());
        }
        response.getData().forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        return CommonResponse.success(response.getData());
    }

    @RequestMapping(value = "/closeSignStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        StuffInviteEntity entity = service.selectById(id);
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            //处于未签订、部分签订
            if (entity.getSignStatus() == 0 || entity.getSignStatus() == 1) {
                //招标立项
                if (establishType == 0) {
                    if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                        StuffPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<StuffPicketageEntity>().eq("invite_id", id)).get(0);
                        refId = picketageEntity.getId();
                    }
                }
                //定标立项
                else {
                    if (entity.getBillState() == 1 || entity.getBillState() == 3) {
                        refId = id;
                    }
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
            if (refId != null) {
                logger.info("定标ID" + refId);
                List<StuffPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<StuffPicketageRefsupplierEntity>().eq("picketage_id", refId));
                if (CollectionUtils.isNotEmpty(refsupplierList)){
                    refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.已关闭.getCode()));
                    refsupplierService.saveOrUpdateBatch(refsupplierList);
                    entity.setSignStatus(TenderSignStatusEnum.已关闭.getCode());
                    service.saveOrUpdate(entity);
                }else {
                    throw new BusinessException("不符合关闭条件");
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
        }
        else {
            throw new BusinessException("只有招标经办人才能关闭");
        }
        return CommonResponse.success("关闭成功！");
    }
    /**
     * @Description  判断当前登录人和招标经办人是否相同
     */
    @RequestMapping(value = "/judgeEmployee", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee (Long inviteId) {
        boolean flag = false;
        StuffInviteEntity entity = service.selectById(inviteId);
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
           flag = true;
        }
        return CommonResponse.success("查询数据成功！", flag);
    }

//    public Boolean delContractFile(Long fileId, String authority) {
//        Map<String, Object> params = new HashMap<>();
//        Map<String, String> header = new HashMap<>();
//        params.put("ids", fileId.toString());
//        header.put("authority", authority);
//        String delRespStr = null;
//        try {
//            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
//        }
//        catch (Exception e) {
//            e.printStackTrace();
//        }
//        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
//        if (delResp != null) {
//            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
//        }
//        return true;
//    }


    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody StuffInviteVO inviteVO) {
        return CommonResponse.success("参数校验成功！", paramCheck(inviteVO));
    }


    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {

        return CommonResponse.success("参数校验成功！", paramCheck(BeanMapper.map(service.selectById(id), StuffInviteVO.class)));
    }


    /**
     *
     */
    private ParamsCheckVO paramCheck(StuffInviteVO StuffInviteVO) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/

        ParamsCheckVO priceParam = service.priceCheckParams(StuffInviteVO);
        if(priceParam!=null){//价格库控制
            paramsCheckVOS.add(priceParam);
        }

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    
}
