package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import static org.apache.commons.jexl2.parser.ParserConstants.eq;

/**
 * 招标公告主表
 *
 * @author generator
 */
@Controller
@RequestMapping("stuffNotice")
@Api(value = "招标公告主表", tags = {"招标公告主表"})
public class StuffNoticeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-notice-code";
    ;//此处需要根据实际修改

    @Autowired
    private IStuffNoticeService service;

    @Autowired
    private IStuffInviteService inviteService;

    @Autowired
    private IStuffInviteDetailService inviteDetailService;

    @Autowired
    private IStuffNoticeDetailService noticeDetailService;

    @Autowired
    private IProcessService processSerice;

    @Autowired
    private IStuffNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private IStuffInviteSupplierService inviteSupplierService;

    @Autowired
    private IStuffNoticeSupplierService noticeSupplierService;

    @Autowired
    private IStuffNoticeChangeService changeService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IAttachmentApi attachmentApi;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffNoticeVO> saveOrUpdate(@ApiParam(name = "saveorUpdateVO", required = true) @RequestBody StuffNoticeVO saveorUpdateVO) {
        StuffNoticeEntity entity = BeanMapper.map(saveorUpdateVO, StuffNoticeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        StuffNoticeVO vo = BeanMapper.map(entity, StuffNoticeVO.class);

        //保存招标过程记录表
//        ProcessEntity processEntity = new ProcessEntity();
//        processEntity.setBillId(entity.getId());
//        processEntity.setBillName(entity.getNoticeName());
//        processEntity.setTenderId(entity.getId());
//        processEntity.setType(0);
//        processEntity.setFrontendUrl("stuff/invite/card");
//        processSerice.saveOrUpdate(processEntity);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffNoticeVO> queryDetail(@RequestParam Long id) {
        StuffNoticeEntity entity = service.selectById(id);
        StuffNoticeVO vo = BeanMapper.map(entity, StuffNoticeVO.class);
        //处理供应商附件信息
        if (!service.selectFile(vo)) {
            CommonResponse.success("供应商附件查询失败！");
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StuffNoticeVO> vos) {
        service.removeByIds(vos.stream().map(StuffNoticeVO::getId).collect(Collectors.toList()), true);
        processSerice.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId, vos.stream().map(StuffNoticeVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StuffNoticeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<StuffNoticeEntity> page = service.queryPage(param, false);
        IPage<StuffNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffNoticeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！", mobilePhone);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StuffNoticeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StuffNotice-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refStuffNoticeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StuffNoticeVO>> refStuffNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StuffNoticeEntity> page = service.queryPage(param, false);
        IPage<StuffNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffNoticeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("点击下一步进行下个页面数据初始化")
    @RequestMapping(value = "/nextStep", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffNoticeEntity> nextStep(String id) throws InvocationTargetException, IllegalAccessException {
        //主表赋值
        StuffInviteEntity stuffInviteEntity = inviteService.selectById(id);
        StuffNoticeEntity stuffNoticeEntity = new StuffNoticeEntity();
        BeanUtils.copyProperties(stuffNoticeEntity, stuffInviteEntity);
        stuffNoticeEntity.setNoticeName(stuffInviteEntity.getTenderName());
        stuffNoticeEntity.setInviteId(stuffInviteEntity.getId());
        stuffNoticeEntity.setId(null);
        stuffNoticeEntity.setCreateTime(null);
        stuffNoticeEntity.setUpdateTime(null);
        stuffNoticeEntity.setBillCode(null);
        stuffNoticeEntity.setBillState(null);
        stuffNoticeEntity.setCreateUserCode(null);
        stuffNoticeEntity.setUpdateUserCode(null);
        stuffNoticeEntity.setSyncEsFlag(null);
        stuffNoticeEntity.setVersion(null);
        stuffNoticeEntity.setTenantId(null);
        stuffNoticeEntity.setMemo(null);
        stuffNoticeEntity.setEmployeeId(null);
        stuffNoticeEntity.setEmployeeName(null);
        service.saveOrUpdate(stuffNoticeEntity);
        //子表赋值
        List<StuffInviteDetailEntity> stuffInviteDetailList = inviteDetailService.list(new LambdaQueryWrapper<StuffInviteDetailEntity>().eq(StuffInviteDetailEntity::getInviteId, id).eq(StuffInviteDetailEntity::getDr, 0));
        StuffNoticeDetailEntity stuffNoticeDetailEntity = new StuffNoticeDetailEntity();
        if (CollectionUtil.isNotEmpty(stuffInviteDetailList)) {
            for (StuffInviteDetailEntity stuffInviteDetailEntity : stuffInviteDetailList) {
                BeanUtils.copyProperties(stuffNoticeDetailEntity, stuffInviteDetailEntity);
                stuffNoticeDetailEntity.setNoticeId(stuffNoticeEntity.getId());
                stuffNoticeDetailEntity.setId(null);
                stuffNoticeDetailEntity.setCreateTime(null);
                stuffNoticeDetailEntity.setUpdateTime(null);
                stuffNoticeDetailEntity.setCreateUserCode(null);
                stuffNoticeDetailEntity.setUpdateUserCode(null);
                stuffNoticeDetailEntity.setSyncEsFlag(null);
                stuffNoticeDetailEntity.setVersion(null);
                stuffNoticeDetailEntity.setTenantId(null);
                noticeDetailService.saveOrUpdate(stuffNoticeDetailEntity);
            }
        }
        //供应商
        List<StuffInviteSupplierEntity> stuffInviteSupplierList = inviteSupplierService.list(new LambdaQueryWrapper<StuffInviteSupplierEntity>().eq(StuffInviteSupplierEntity::getInviteId, id).eq(StuffInviteSupplierEntity::getDr, 0));
        StuffNoticeSupplierDetailEntity stuffNoticeSupplierDetailEntity = new StuffNoticeSupplierDetailEntity();
        if (CollectionUtil.isNotEmpty(stuffInviteSupplierList)) {
            for (StuffInviteSupplierEntity stuffInviteSupplierEntity : stuffInviteSupplierList) {
                BeanUtils.copyProperties(stuffNoticeSupplierDetailEntity, stuffInviteSupplierEntity);
                stuffNoticeSupplierDetailEntity.setInviteId(stuffNoticeEntity.getInviteId());
                stuffNoticeSupplierDetailEntity.setId(null);
                stuffNoticeSupplierDetailEntity.setCreateTime(null);
                stuffNoticeSupplierDetailEntity.setUpdateTime(null);
                stuffNoticeSupplierDetailEntity.setCreateUserCode(null);
                stuffNoticeSupplierDetailEntity.setUpdateUserCode(null);
                stuffNoticeSupplierDetailEntity.setSyncEsFlag(null);
                stuffNoticeSupplierDetailEntity.setVersion(null);
                stuffNoticeSupplierDetailEntity.setTenantId(null);
                noticeSupplierDetailService.saveOrUpdate(stuffNoticeSupplierDetailEntity);
            }
        }
        //回写招标阶段
        Integer tenderStage = 2;
        inviteService.updateTenderStage(id, tenderStage);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(stuffNoticeEntity.getId());
        processEntity.setBillName("招标公告");
        processEntity.setTenderId(stuffNoticeEntity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/notice");
        processSerice.saveOrUpdate(processEntity);
        return CommonResponse.success("初始化数据成功", stuffNoticeEntity);
    }

    @ApiOperation("延长截止时间")
    @RequestMapping(value = "/extend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse extend(@RequestBody StuffNoticeChangeEntity stuffNoticeChangeEntity) {
        service.updateEndTime(stuffNoticeChangeEntity.getNoticeId(), stuffNoticeChangeEntity.getNewTime());
        StuffNoticeEntity stuffNoticeEntity = service.selectById(stuffNoticeChangeEntity.getNoticeId());
        //调用第三方报名接口
        Map<String, Object> map = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("sourceId", stuffNoticeEntity.getInviteId());
        map.put("noticeEndTime", sdf.format(stuffNoticeChangeEntity.getNewTime()));
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, JSON.toJSONString(map), appId, appSecret, appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        changeService.saveOrUpdate(stuffNoticeChangeEntity);

        //更新招标截止时间
        StuffInviteEntity inviteEntity = inviteService.selectById(stuffNoticeEntity.getInviteId());
        inviteEntity.setStopTime(stuffNoticeChangeEntity.getNewTime());
        inviteService.saveOrUpdate(inviteEntity);
        return CommonResponse.success("延长截止时间成功！");
    }

    @ApiOperation("发布公告")
    @RequestMapping(value = "/publish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse publish(@RequestBody StuffNoticeVO stuffNoticeVO) throws InvocationTargetException, IllegalAccessException {
        return service.publish(stuffNoticeVO);
    }

    @ApiOperation("报名情况")
    @RequestMapping(value = "/signUp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> signUp(HttpServletRequest request) {
        logger.info("进入报名接口request-{}", JSONObject.toJSONString(request.getHeaderNames()));
        String notice = request.getParameter("bmNoticeVO");
        logger.info("报名实体信息-{}", notice);
        StuffNoticeSupplierVO stuffNoticeSupplierVO = JSON.parseObject(notice, new TypeReference<StuffNoticeSupplierVO>() {
        });

        StuffNoticeSupplierEntity stuffNoticeSupplierEntity = BeanMapper.map(stuffNoticeSupplierVO, StuffNoticeSupplierEntity.class);
        stuffNoticeSupplierEntity.setNoticeId(service.selectNotice(stuffNoticeSupplierVO.getSourceId()));
        stuffNoticeSupplierEntity.setSourceSupplierTenantId(stuffNoticeSupplierVO.getTenantId().toString());
        stuffNoticeSupplierEntity.setSupplierId(Long.valueOf(stuffNoticeSupplierVO.getSourceSupplierId()));
        SupplierDTO supplierVO = shareSupplierApi.queryById(Long.valueOf(stuffNoticeSupplierVO.getSourceSupplierId())).getData();
        stuffNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        stuffNoticeSupplierEntity.setSupplierEmployeeId(stuffNoticeSupplierVO.getEmployeeId());
        stuffNoticeSupplierEntity.setSupplierEmployeeName(stuffNoticeSupplierVO.getEmployeeName());
        stuffNoticeSupplierEntity.setSupplierEmployeeMobile(stuffNoticeSupplierVO.getEmployeeMobile());
        stuffNoticeSupplierEntity.setId(null);
        stuffNoticeSupplierEntity.setState(0);
        //查询是否已经报名
        LambdaQueryWrapper<StuffNoticeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(StuffNoticeEntity::getInviteId, stuffNoticeSupplierVO.getSourceId());
        List<StuffNoticeEntity> noticeEntityList = service.list(queryWrapper);
        LambdaQueryWrapper<StuffNoticeSupplierEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(StuffNoticeSupplierEntity::getSourceSupplierId, stuffNoticeSupplierVO.getSourceSupplierId())
                .eq(StuffNoticeSupplierEntity::getNoticeId, noticeEntityList.get(0).getId())
                .eq(StuffNoticeSupplierEntity::getDr, 0);
        List<StuffNoticeSupplierEntity> supplierEntityList = noticeSupplierService.list(lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty(supplierEntityList)) {
            noticeSupplierService.removeById(supplierEntityList.get(0).getId());
        }
        boolean b = noticeSupplierService.saveOrUpdate(stuffNoticeSupplierEntity);
        //处理附件
        List<SupplyFileVo> pzList = stuffNoticeSupplierVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            pzList.forEach(e->{
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(stuffNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            });
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
//        //删除之前附件
//        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
//                .queryListBySourceId(stuffNoticeSupplierEntity.getId(), BILL_SUPPLIER_TYPE, "BmSupplierFileType", null);
//        // 查询成功并有相应的文件
//        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
//            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
//            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
//                    .collect(Collectors.joining(","));
//            attachmentApi.delete(ids);
//        }
////        logger.info(request + "报名文件名称- {}" + file.getOriginalFilename());
////        Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"BmSupplierFileType",Long.toString(stuffNoticeSupplierEntity.getId()),BILL_SUPPLIER_TYPE,file,request);
////        logger.info(request+"报名文件上传结果-{}",upFlag);
//        String authority = request.getHeader("authority");
//        String nameSourceTypeMapping = request.getParameter("fileSourceType");
//        Map mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
//        FileUtil.getInstance()
//                .handleReqFile((MultipartHttpServletRequest) request, mp, BILL_SUPPLIER_TYPE, authority, Long.toString(stuffNoticeSupplierEntity.getId()));

        return CommonResponse.success("报名情况接口掉用成功", b);
    }

    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/deleteSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse deleteSupplier(@RequestBody StuffNoticeSupplierVO stuffNoticeSupplierVO) {
        List<StuffNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
        StuffNoticeEntity stuffNoticeEntity = service.selectById(stuffNoticeSupplierVO.getNoticeId());
        StuffNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new StuffNoticeSupplierDetailTbVO();
        stuffNoticeSupplierDetailTbVO.setSourceId(stuffNoticeEntity.getInviteId().toString());
        stuffNoticeSupplierDetailTbVO.setTenantId(stuffNoticeSupplierVO.getTenantId());
        stuffNoticeSupplierDetailTbVO.setSourceSupplierId(stuffNoticeSupplierVO.getSupplierId().toString());
        stuffNoticeSupplierDetailTbVO.setOutReason(stuffNoticeSupplierVO.getOutReason() == null ? "超时未报名" : stuffNoticeSupplierVO.getOutReason());
        supplierDetailTbVOList.add(stuffNoticeSupplierDetailTbVO);

        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateSupStatusUrl, RequestMethod.POST, JSON.toJSONString(supplierDetailTbVOList), appId, appSecret, appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        //更新供应商状态
        noticeSupplierService.updateState(stuffNoticeSupplierVO.getId());
        return CommonResponse.success("剔除供应商成功");
    }

}
