package com.ejianc.business.tender.stuff.service;

import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
public interface IStuffDocumentService extends IBaseService<StuffDocumentEntity> {

    StuffDocumentVO publishDocument(Long id) throws Exception;

    StuffDocumentVO bidDocument(Long id);

    StuffDocumentVO queryDetail(Long id);

    StuffDocumentVO queryDocDetail(Long id,Integer talkNum);


    List<StuffDocumentSellVO> getSchemeDetail(StuffDocumentSellVO stuffDocumentSellVO);

    StuffDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId);

    StuffDocumentVO extendDocument(StuffDocumentRecordVO stuffDocumentRecordVO);

    StuffDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId);

    StuffDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException;

    CommonResponse delSupplier(Long id);

    StuffDocumentVO saveManyDocument(Long id);

    StuffDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId);

    StuffDocumentVO saveDocument(Long noticeId);

    StuffDocumentVO queryDetailNum(Long documentId);

    Boolean supplierPushSell(HttpServletRequest request, MultipartFile file);

    String uploadById(Long attachId,Long inviteId);

    String deleteFileById(Long sourceId, List<String> fileNames);

    StuffDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId);

    StuffDocumentVO queryDetail1(Long documentId, Integer num);
}
