package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.equipment.vo.TenderStageEnum;
import com.ejianc.business.tender.stuff.bean.StuffBidEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffBidService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.vo.StuffAdviceSupplierPushVO;
import com.ejianc.business.tender.stuff.vo.StuffAdviceVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSupplierVO;
import com.ejianc.business.tender.sub.bean.SubAdviceEntity;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.foundation.share.utils.FileUtil;

import com.ejianc.business.tender.stuff.mapper.StuffAdviceMapper;
import com.ejianc.business.tender.stuff.bean.StuffAdviceEntity;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料-中标通知书表
 * 
 * @author generator
 * 
 */
@Service("stuffAdviceService")
public class StuffAdviceServiceImpl extends BaseServiceImpl<StuffAdviceMapper, StuffAdviceEntity> implements IStuffAdviceService{
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;

    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffBidService stuffBidService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    private final String OPERATE = "STUFF_ADVICE_SYNC";
    private static final String BILL_TYPE = "BT220316000000001";//此处需要根据实际修改

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
        StuffAdviceEntity stuffAdviceEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            stuffAdviceEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            stuffAdviceEntity.setSignFlag(1);
        }
        if(status == 4){
            stuffAdviceEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(stuffAdviceEntity.getId());
            cv.setContractName(stuffAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(stuffAdviceEntity);

        return CommonResponse.success("更新成功!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        StuffAdviceEntity stuffAdviceEntity = super.selectById(id);
        stuffAdviceEntity.setSendFlag(0);
        super.updateById(stuffAdviceEntity);
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffAdviceEntity.getInviteId());
        StuffAdviceSupplierPushVO stuffAdviceSupplierPushVO = BeanMapper.map(stuffAdviceEntity, StuffAdviceSupplierPushVO.class);

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        stuffAdviceSupplierPushVO.setSystemId(ejcCloudSystemCode.getData());
        stuffAdviceSupplierPushVO.setSourceType("云南建投材料中标通知书");
        stuffAdviceSupplierPushVO.setSourceId(stuffAdviceEntity.getId().toString());
        stuffAdviceSupplierPushVO.setBidTitle(stuffAdviceEntity.getTitleName());
        stuffAdviceSupplierPushVO.setSourceProjectId(stuffAdviceEntity.getProjectId() != null ? stuffAdviceEntity.getProjectId().toString() : null);
        stuffAdviceSupplierPushVO.setSourceOrgId(stuffAdviceEntity.getOrgId().toString());
        stuffAdviceSupplierPushVO.setSourceUnitId(stuffAdviceEntity.getUnitId().toString());
//        stuffAdviceSupplierPushVO.setType("TYPE_MATERIAL");
        stuffAdviceSupplierPushVO.setType(CommonUtils.getGysType(CommonUtils.TYPE_MATERIAL));
        stuffAdviceSupplierPushVO.setTenderType(stuffInviteEntity.getTenderType());
        stuffAdviceSupplierPushVO.setBidDate(stuffAdviceEntity.getNoticeDate());
        stuffAdviceSupplierPushVO.setMoney(stuffAdviceEntity.getMoney());
        stuffAdviceSupplierPushVO.setMoneyTax(stuffAdviceEntity.getMoneyTax());

        String dataInfo = JSONObject.toJSONString(stuffAdviceSupplierPushVO);

        boolean b = pushBillToSupCenter(dataInfo, stuffAdviceEntity.getSupplierId(), stuffAdviceEntity.getId(),
                BILL_TYPE, PUSH_ADVICE_SERVER_URL,stuffAdviceEntity.getTitleName());
        if (!b){
            throw new BusinessException("推送供方失败!");
        }
        return null;
    }

    @Override
    public List<StuffAdviceVO> queryAdviceList(Long id) {
        StuffBidEntity stuffBidEntity = stuffBidService.selectById(id);
        LambdaQueryWrapper<StuffAdviceEntity> lambdaAdvice = Wrappers.<StuffAdviceEntity>lambdaQuery();
        lambdaAdvice.eq(StuffAdviceEntity::getInviteId, stuffBidEntity.getInviteId());
        List<StuffAdviceEntity> list = super.list(lambdaAdvice);
        List<StuffAdviceVO> stuffAdviceVOS = BeanMapper.mapList(list, StuffAdviceVO.class);
        //处理签章附件信息
        if (CollectionUtils.isNotEmpty(stuffAdviceVOS)) {
            List<Long> attachIds = stuffAdviceVOS.stream().map(StuffAdviceVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    for (StuffAdviceVO stuffAdviceVO : stuffAdviceVOS) {
                        AttachmentVO attachmentVO = attacMap.get(stuffAdviceVO.getId());
                        if (attachmentVO != null) {
                            stuffAdviceVO.setAttachId(attachmentVO.getId());
                            stuffAdviceVO.setFileName(attachmentVO.getFileName());
                            stuffAdviceVO.setFilePath(attachmentVO.getFilePath());
                        }
                    }
                }
            }
        }
        return stuffAdviceVOS;
    }
    /**
     * 中标通知书推送供方
     *
     * @param datInfo      推送数据
     * @param supplierId   供应商id
     * @param sourceId     单据id
     * @param billTypeCode 单据类型编码
     * @param url          推送URL
     * @param sourceName   该条单据名称
     * @return 推送结果
     */
    @Override
    public boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, String url,String sourceName) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }
//            // 先同步最新合同
//            StuffAdviceEntity stuffAdviceEntity = super.selectById(sourceId);
//            Assert.notNull(entity, "查询不到合同详情");
//            ContractVO cv = new ContractVO();
//            cv.setContractId(sourceId);
//            cv.setContractName(sourceName);
////            cv.setBillType("BT220316000000001");
//            cv.setBillType(billTypeCode);
//            cv.setSourceType("tenderAdvice");
//            ArrayList<ContractVO> cvs = new ArrayList<>();
//            cvs.add(cv);
//
//            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);


            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", datInfo);

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(sourceId, null, "tenderAdvice", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }

                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));

                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送计量单据参数-{}", supplierId, JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url,
                        paramMap,
                        supplierId.toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送验收单据id-{}失败, {}", supplierId, sourceId, billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送验收单据id-{}给供方id-{}失败, {}", sourceId, supplierId, syncReqResp.getMsg());
                }
            } else {
                logger.error("获取验收单据id-{}对应附件信息失败, {}", sourceId, fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送验收单据id-{}给供方id-{} 异常，", sourceId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
}
