package com.ejianc.business.tender.stuff.service.impl;

import bsh.Primitive;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.expert.bean.ExpertRepetitionSupplierEntity;
import com.ejianc.business.tender.expert.service.IExpertRepetitionSupplierService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.mapper.StuffDocumentMapper;
import com.ejianc.business.tender.stuff.mapper.StuffDocumentSellMapper;
import com.ejianc.business.tender.stuff.mapper.StuffDocumentSupplierDetailMapper;
import com.ejianc.business.tender.stuff.mapper.StuffDocumentSupplierMapper;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标文件主表
 *
 * @author generator
 */
@Service("stuffDocumentService")
public class StuffDocumentServiceImpl extends BaseServiceImpl<StuffDocumentMapper, StuffDocumentEntity> implements IStuffDocumentService {
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private StuffDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private StuffDocumentSupplierMapper supplierMapper;
    @Autowired
    private IStuffDocumentSchemeService stuffDocumentSchemeService;
    @Autowired
    private IExpertRepetitionSupplierService expertRepetitionSupplierService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private StuffDocumentSellMapper stuffDocumentSellMapper;
    @Autowired
    private IStuffDocumentRecordService stuffDocumentRecordService;
    @Autowired
    private IStuffDocumentDetailService stuffDocumentDetailService;
    @Autowired
    private IStuffTalkService stuffTalkService;
    @Autowired
    private IStuffTalkRecordService stuffTalkRecordService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffDocumentExpertService documentExpertService;
    @Autowired
    private IStuffDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IStuffDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IStuffDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IStuffNoticeService stuffNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Value("${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000004";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IStuffNoticeSupplierService stuffNoticeSupplierService;


    @Transactional
    @Override
    public StuffDocumentVO publishDocument(Long id) {
        //更新发布状态
        StuffDocumentEntity stuffDocumentEntity = super.selectById(id);
        stuffDocumentEntity.setPublishFlag(0);
        super.updateById(stuffDocumentEntity);
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());

        //推送供应商
        StuffDocumentSupplierTbVO stuffDocumentSupplierTbVO = new StuffDocumentSupplierTbVO();
        stuffDocumentSupplierTbVO.setSourceId(stuffDocumentEntity.getInviteId().toString());
        stuffDocumentSupplierTbVO.setSourceType("云南建投招标文件");
        stuffDocumentSupplierTbVO.setNoticeType(1);
        stuffDocumentSupplierTbVO.setProjectLinkName(stuffDocumentEntity.getProjectLinkName());
        stuffDocumentSupplierTbVO.setProjectLinkPhone(stuffDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(stuffDocumentEntity.getOfferStartTime());
        stuffDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(stuffDocumentEntity.getOfferEndTime());
        stuffDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        stuffDocumentSupplierTbVO.setContent(stuffDocumentEntity.getDocumentContent());
        stuffDocumentSupplierTbVO.setBrandFlag(stuffDocumentEntity.getBrandFlag());
        stuffDocumentSupplierTbVO.setMemo(stuffDocumentEntity.getMemo());
        stuffDocumentSupplierTbVO.setTenderName(stuffDocumentEntity.getDocumentName());
        CommonResponse<String> stringCommonResponse = proSupplierApi.getEjcCloudSystemCode();
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件获取systemId失败" + stringCommonResponse.getMsg());
        }
        stuffDocumentSupplierTbVO.setSystemId(stringCommonResponse.getData());

        //处理附件
        //查询招标文件
        CommonResponse<List<AttachmentVO>> zbwjFile = attachmentApi.queryListBySourceId(stuffDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Long> zbwjAttachIdList = new ArrayList<>();
        if (zbwjFile.isSuccess()) {
            List<AttachmentVO> data = zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }

        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds", zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //招标文件stream处理
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonZbwj.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        String dataZbwj = zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject(dataZbwj);
        Map<String, byte[]> zbwjMap = JSONObject.parseObject(zbwListJson.toJSONString(), new TypeReference<Map<String, byte[]>>() {
        });
        Map<String, InputStream> streamMap = new HashMap<>();
        zbwjMap.forEach((key, value) -> {
            streamMap.put(key, new ByteArrayInputStream(value));
        });

        String stringFb = JSONObject.toJSONString(stuffDocumentSupplierTbVO);
        Map<String, String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;
        if (!streamMap.isEmpty()) {
            files = new HashMap<>();
            files.put("file", streamMap);
        }

        //推送供方
        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl, params, files, appId, appSecret, appHost);
        if (!stringCommonResponses.isSuccess()) {
            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
        }
//        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataWithUniversal(saveWjUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
//        if(!stringCommonResponses.isSuccess()) {
//            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
//        }
//                try {
//
//            String s = new ThirdSystemUtils().postFile(tokenUrl, saveWjUrl, params, headers,zbwjMap,cacheManager);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }


        //招标文件发布成功后 改招标状态 为报价中
        stuffInviteEntity.setTenderState(TenderStateEnum.报价中.getCode());
        stuffInviteEntity.setStopTime(stuffDocumentEntity.getOfferEndTime());
        stuffInviteService.saveOrUpdate(stuffInviteEntity);

        StuffDocumentVO stuffDocumentVO = queryDetail(id);
        return stuffDocumentVO;
    }


    @Override
    public StuffDocumentVO bidDocument(Long id) {
        //
        //更新开标状态
        StuffDocumentEntity stuffDocumentEntity = super.selectById(id);
        stuffDocumentEntity.setBidFlag(0);
        stuffDocumentEntity.setBidTime(new Date());
        super.updateById(stuffDocumentEntity);
        StuffDocumentVO stuffDocumentVO = queryDetail(id);
//        开标之后给专家发送微信+内部消息通知：xx专家您好，XXX（项目名称）已开标，后续的评标开始时间我们会以短信+消息
        List<StuffDocumentExpertEntity> entityList = documentExpertService.list(new QueryWrapper<StuffDocumentExpertEntity>().eq("document_id", stuffDocumentVO.getId()).eq("dr", 0));
        for (StuffDocumentExpertEntity entity : entityList) {
            //审批通过给专家发内部消息
            List<String> messageType = new ArrayList<>();
            //系统消息
            messageType.add("sys");
            //微信消息
            //messageType.add("weChat");
            List<String> sender = new ArrayList<>();
            sender.add(entity.getExpertId() + "");
            String name = stuffDocumentVO.getPurchaseType() == 0 ? stuffDocumentVO.getProjectName() : stuffDocumentVO.getOrgName();
            logger.info("发送信息给专家:>----------" + sender);
            String subject = entity.getExpertName() + "专家您好，" + name + "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            String content = entity.getExpertName() + "专家您好，" + name + "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);
        }
        return stuffDocumentVO;
    }

    @Override
    public StuffDocumentVO queryDetail(Long id) {
        return queryDocDetail(id, 0);
    }

    @Override
    public StuffDocumentVO queryDetail1(Long id, Integer num) {
        return queryDocDetail(id, num);
    }

    @Override
    public StuffDocumentVO queryDetailNum(Long id) {
        StuffDocumentSchemeEntity stuffDocumentSchemeEntity = stuffDocumentSchemeService.list(new QueryWrapper<StuffDocumentSchemeEntity>().eq("document_id", id).orderByDesc("talk_num")).get(0);
        return queryDocDetail(id, stuffDocumentSchemeEntity.getTalkNum());
    }

    @Transactional
    @Override
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {

        logger.info("进入报价接口request-{},file-{}", request, file);
        String notice = request.getParameter("bjNoticeVO");
        logger.info("实体信息-{}", notice);
        SupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<SupplierSellVO>() {
        });

        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = stuffInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            //查询轮数
            LambdaQueryWrapper<StuffTalkEntity> lambdaTalk = Wrappers.<StuffTalkEntity>lambdaQuery();
            lambdaTalk.eq(StuffTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            StuffTalkEntity stuffTalkEntity = stuffTalkService.getOne(lambdaTalk);
            talkNum = stuffTalkEntity.getTalkNum();
        }
        //报价轮数查询-区分是否二次报价
        if(null!=pushVO.getTenderType()&&(0==pushVO.getTenderType()||1==pushVO.getTenderType()) && pushVO.getTalkNum() != null && pushVO.getTalkNum() > 0){
            talkNum = pushVO.getTalkNum();
        }

        //转换
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();

        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<StuffDocumentEntity> lambdaDocument = Wrappers.<StuffDocumentEntity>lambdaQuery();
        lambdaDocument.eq(StuffDocumentEntity::getInviteId, inviteId);
        StuffDocumentEntity stuffDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplier = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, stuffDocumentEntity.getId());
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, talkNum);
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.getOne(lambdaSupplier);

        //更新二次报价的供应商报价状态
        LambdaQueryWrapper<ExpertRepetitionSupplierEntity> lambdaRepetitionSupplier = Wrappers.<ExpertRepetitionSupplierEntity>lambdaQuery();
        lambdaRepetitionSupplier.eq(ExpertRepetitionSupplierEntity::getSupplierId, sourceSupplierId);
        lambdaRepetitionSupplier.eq(ExpertRepetitionSupplierEntity::getTalkNum, talkNum);
        lambdaRepetitionSupplier.eq(ExpertRepetitionSupplierEntity::getDocumentId, stuffDocumentEntity.getId());
        ExpertRepetitionSupplierEntity expertRepetitionSupplierEntity = expertRepetitionSupplierService.getOne(lambdaRepetitionSupplier);
        if (expertRepetitionSupplierEntity != null){
            expertRepetitionSupplierEntity.setSellStatus(2);
        }
        expertRepetitionSupplierService.updateById(expertRepetitionSupplierEntity);

        Long documentSupplierId = null;
        if (stuffDocumentSupplierEntity != null) {
            //更新供应商信息
            stuffDocumentSupplierEntity.setOfferTime(new Date());
            stuffDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            stuffDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            stuffDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            stuffDocumentSupplierService.updateById(stuffDocumentSupplierEntity);
            documentSupplierId = stuffDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, stuffDocumentSupplierEntity.getId());
            stuffDocumentSchemeService.remove(lambdaScheme);
        }
        if (stuffDocumentSupplierEntity == null) {
            //新增供应商信息
            StuffDocumentSupplierEntity stuffDocumentSupplierEntityAdd = new StuffDocumentSupplierEntity();
            stuffDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            stuffDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            stuffDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            stuffDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            stuffDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            stuffDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            stuffDocumentSupplierEntityAdd.setOfferTime(new Date());
            stuffDocumentSupplierEntityAdd.setDocumentId(stuffDocumentEntity.getId());
            stuffDocumentSupplierEntityAdd.setTalkNum(talkNum);
            stuffDocumentSupplierService.save(stuffDocumentSupplierEntityAdd);
            documentSupplierId = stuffDocumentSupplierEntityAdd.getId();
        }

        //处理方案信息
        List<SupplierSellSchemeVO> schemeList = pushVO.getSchemeList();
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<StuffDocumentSellVO> stuffDocumentSellVOList = new ArrayList<>();
        for (SupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            StuffDocumentSchemeEntity stuffDocumentSchemeEntity = new StuffDocumentSchemeEntity();
            stuffDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            stuffDocumentSchemeEntity.setDocumentId(stuffDocumentEntity.getId());
            stuffDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            stuffDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            stuffDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            stuffDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            stuffDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            stuffDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            stuffDocumentSchemeEntity.setTalkNum(talkNum);
            stuffDocumentSchemeEntity.setId(IdWorker.getId());
            stuffDocumentSchemeEntity.setPassFlag(1);

            stuffDocumentSchemeEntityArrayList.add(stuffDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<SupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getSchemeDetailList();
            for (SupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                StuffDocumentSellVO stuffDocumentSellVO = new StuffDocumentSellVO();
//                stuffDocumentSellVO.setProjectId(stuffDocumentEntity.getProjectId());
//                stuffDocumentSellVO.setProjectName(stuffDocumentEntity.getProjectName());
                stuffDocumentSellVO.setSchemeId(stuffDocumentSchemeEntity.getId());
                stuffDocumentSellVO.setDocumentId(stuffDocumentEntity.getId());
                stuffDocumentSellVO.setSupplierId(sourceSupplierId);
                stuffDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                stuffDocumentSellVO.setSupplierName(supplierVO.getName());
                stuffDocumentSellVO.setMaterialId(supplierSellSchemeDetailVO.getSourceMaterialId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId()) : null);
                stuffDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                stuffDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                stuffDocumentSellVO.setMaterialTypeId(supplierSellSchemeDetailVO.getSourceMaterialTypeId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()) : null);
                stuffDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                stuffDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                stuffDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
//                stuffDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                stuffDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                stuffDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                stuffDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                stuffDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
//                stuffDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
//                stuffDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
//                stuffDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                stuffDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                stuffDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                stuffDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                stuffDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                stuffDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                stuffDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                stuffDocumentSellVO.setReferFlag(2);
                stuffDocumentSellVO.setPassFlag(1);
                stuffDocumentSellVO.setTalkNum(talkNum);

                stuffDocumentSellVOList.add(stuffDocumentSellVO);

            }

        }
        //新增方案
        stuffDocumentSchemeService.saveBatch(stuffDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getSupplierId, sourceSupplierId);
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum);
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentEntity.getId());
        stuffDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<StuffDocumentDetailEntity> lambdaDetail = Wrappers.<StuffDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(StuffDocumentDetailEntity::getDocumentId, stuffDocumentEntity.getId());
        List<StuffDocumentDetailEntity> stuffDocumentDetailList = stuffDocumentDetailService.list(lambdaDetail);

        List<StuffDocumentSellEntity> stuffDocumentSellEntityArrayList = new ArrayList<>();
        for (StuffDocumentDetailEntity stuffDocumentDetailEntity : stuffDocumentDetailList) {
            for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOList) {
                //判断是否只有分类
                if (stuffDocumentDetailEntity.getMaterialId() != null) {
                    if (stuffInviteEntity.getPurchaseType()==1){
                        if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                                stuffDocumentDetailEntity.getMaterialId().equals(stuffDocumentSellVO.getMaterialId()) &&
                                stuffDocumentDetailEntity.getRate().equals(stuffDocumentSellVO.getDetailRate())) {
                            StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                            stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                            stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                            stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                            stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                            stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                            stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                            stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                            // 备注拆分
                            stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());

                            stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                        }
                    }else {
                        if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                                stuffDocumentDetailEntity.getMaterialId().equals(stuffDocumentSellVO.getMaterialId()) &&
                                stuffDocumentDetailEntity.getCalculateType().equals(stuffDocumentSellVO.getCalculateType()) &&
                                stuffDocumentDetailEntity.getRate().equals(stuffDocumentSellVO.getDetailRate())) {
                            StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                            stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                            stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                            stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                            stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                            stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                            stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                            stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                            // 备注拆分
                            stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                            stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                        }
                    }
                }
                if (stuffDocumentDetailEntity.getMaterialId() == null) {
                    if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                            (stuffDocumentDetailEntity.getCalculateType() == null || stuffDocumentDetailEntity.getCalculateType().equals(stuffDocumentSellVO.getCalculateType())) &&
                            stuffDocumentDetailEntity.getRate().equals(stuffDocumentSellVO.getDetailRate())) {
                        StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                        stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                        stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                        stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                        stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                        stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                        stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                        stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                        // 备注拆分
                        stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                        stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                    }
                }

            }

        }
        //新增报价信息
        stuffDocumentSellService.saveBatch(stuffDocumentSellEntityArrayList);

        //先删除附件
        if (documentSupplierId != null) {
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]", documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)) {
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}", deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if (CollectionUtils.isNotEmpty(pzList)) {
            List<AttachmentVO> list = new ArrayList<>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            }
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request + "报名文件上传结果-{}", JSONObject.toJSONString(stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId, Long inviteId) {
        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds", Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //文件stream处理
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonwj.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        String datawj = zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject(datawj);
        Map<String, byte[]> wjMap = JSONObject.parseObject(wListJson.toJSONString(), new TypeReference<Map<String, byte[]>>() {
        });
        Map<String, InputStream> streamMap = new HashMap<>();
        wjMap.forEach((key, value) -> {
            streamMap.put(key, new ByteArrayInputStream(value));
        });


        Map<String, String> params = new HashMap<>();
        params.put("sourceId", Long.toString(inviteId));
        Map<String, String> headers = new HashMap<>();
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        files.put("file", streamMap);

        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataAndFilesWithUniversal(addFileUrl, params, files, appId, appSecret, appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附件批量修改同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        Map<String, Object> map = new HashMap<>();
        map.put("sourceId", sourceId);
        map.put("fileNames", fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(delFileUrl, RequestMethod.POST, stringInfo, appId, appSecret, appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
        }
        return "同步成功";
    }

    @Override
    public StuffDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {

        StuffDocumentEntity stuffDocumentEntity = super.selectById(documentId);
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = new StuffDocumentSupplierSellVO();
        StuffDocumentSchemeEntity stuffDocumentSchemeEntity = stuffDocumentSchemeService.selectById(schemeId);
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.selectById(stuffDocumentSchemeEntity.getDocumentSupplierId());
        Long supplierDetailId = stuffDocumentSupplierEntity.getId();
        stuffDocumentSupplierSellVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
        stuffDocumentSupplierSellVO.setSupplierName(stuffDocumentSupplierEntity.getSupplierName());
        stuffDocumentSupplierSellVO.setLinkMobile(stuffDocumentSupplierEntity.getLinkMobile());
        stuffDocumentSupplierSellVO.setOfferTime(stuffDocumentSupplierEntity.getOfferTime());
        stuffDocumentSupplierSellVO.setTaxMemo(stuffDocumentSupplierEntity.getTaxMemo());
        stuffDocumentSupplierSellVO.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, supplierDetailId);
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityList = stuffDocumentSchemeService.list(lambdaScheme);
        List<StuffDocumentSchemeVO> stuffDocumentSchemeVOList = BeanMapper.mapList(stuffDocumentSchemeEntityList, StuffDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentSupplierEntity.getDocumentId());
        List<StuffDocumentSellEntity> stuffDocumentSellEntityList = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(stuffDocumentSellEntityList, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOList.stream().
                collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeId));
        for (StuffDocumentSchemeVO stuffDocumentSchemeVO : stuffDocumentSchemeVOList) {
            List<StuffDocumentSellVO> stuffDocumentSellVOS = sellMap.get(stuffDocumentSchemeVO.getId());
            stuffDocumentSchemeVO.setStuffDocumentSellList(stuffDocumentSellVOS);
        }
        stuffDocumentSupplierSellVO.setStuffDocumentSchemeList(stuffDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                stuffDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                stuffDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return stuffDocumentSupplierSellVO;
    }


    @Override
    public StuffDocumentVO queryDocDetail(Long id, Integer talkNum) {

        StuffDocumentEntity entity = super.selectById(id);
        StuffDocumentVO stuffDocumentVO = BeanMapper.map(entity, StuffDocumentVO.class);

        stuffDocumentVO.setStuffDocumentSchemeList(null);
        stuffDocumentVO.setStuffDocumentSellList(null);
        //处理报名供应商信息
        if (stuffDocumentVO.getNoticeId() != null) {
            LambdaQueryWrapper<StuffNoticeSupplierEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(StuffNoticeSupplierEntity::getNoticeId, entity.getNoticeId());
            wrapper.ne(StuffNoticeSupplierEntity::getState, 1);
            List<StuffNoticeSupplierEntity> list = stuffNoticeSupplierService.list(wrapper);//未剔除的报名供应商
            if (CollectionUtils.isNotEmpty(list)) {
                List<StuffNoticeSupplierVO> noticeSupplierVOS = BeanMapper.mapList(list, StuffNoticeSupplierVO.class);//报名供应商
                Map<Long, StuffDocumentSupplierVO> documentSupplierVOMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(stuffDocumentVO.getStuffDocumentSupplierList())) {//报价供应商
                    documentSupplierVOMap = stuffDocumentVO.getStuffDocumentSupplierList().stream().filter(t -> t.getSupplierId() != null).collect(Collectors.toMap(StuffDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (StuffNoticeSupplierVO noticeSupplier : noticeSupplierVOS) {
                    if (documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())) {
                        noticeSupplier.setDocumentType(0);//已报价
                    }
                    else {
                        noticeSupplier.setDocumentType(1);//未报价
                    }
                }
                stuffDocumentVO.setStuffDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        //处理报价信息,开标之前不能显示
        //按供应商查看报价()
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambda = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambda.eq(StuffDocumentSupplierEntity::getDocumentId, id);
        lambda.eq(StuffDocumentSupplierEntity::getTalkNum, talkNum);
        List<StuffDocumentSupplierEntity> supplierList = stuffDocumentSupplierService.list(lambda);

        if (CollectionUtils.isNotEmpty(supplierList)) {
            List<StuffDocumentSupplierVO> stuffDocumentSupplierVOS = BeanMapper.mapList(supplierList, StuffDocumentSupplierVO.class);
            LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentId, id);
            lambdaScheme.eq(StuffDocumentSchemeEntity::getTalkNum, talkNum);
            lambdaScheme.orderByAsc(StuffDocumentSchemeEntity::getSchemeName);
            List<StuffDocumentSchemeEntity> schemeList = stuffDocumentSchemeService.list(lambdaScheme);
            Map<Long, List<StuffDocumentSchemeEntity>> schemeMap = schemeList.stream().
                    collect(Collectors.groupingBy(StuffDocumentSchemeEntity::getDocumentSupplierId));
            //是否开标,0-是,1-否
            if (entity.getBidFlag() == 0) {
                for (StuffDocumentSupplierVO stuffDocumentSupplierEntity : stuffDocumentSupplierVOS) {
                    List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntities = schemeMap.get(stuffDocumentSupplierEntity.getId());
                    String schemeMoney = "";
                    for (StuffDocumentSchemeEntity stuffDocumentSchemeEntity : stuffDocumentSchemeEntities) {
                        schemeMoney = schemeMoney + stuffDocumentSchemeEntity.getSchemeName() + ":" + stuffDocumentSchemeEntity.getMoneyTax().setScale(2, BigDecimal.ROUND_HALF_DOWN) + "元" + ";";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    stuffDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }

                //处理供应商附件信息
                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierVOS)) {
                    List<Long> attachIds = stuffDocumentSupplierVOS.stream().map(StuffDocumentSupplierVO::getId).collect(Collectors.toList());
                    Map<String, List<Long>> map = new HashMap<>();
                    map.put("sourceIds", attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess()) {
                        List<AttachmentVO> data = listCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(data)) {
                            Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                            for (StuffDocumentSupplierVO stuffDocumentSupplierVO : stuffDocumentSupplierVOS) {
                                AttachmentVO attachmentVO = attacMap.get(stuffDocumentSupplierVO.getId());
                                if (attachmentVO != null) {
                                    stuffDocumentSupplierVO.setAttachId(attachmentVO.getId());
                                    stuffDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                                }
                            }
                        }
                    }
                }
            }

            //是否开标,0-是,1-否
//            if (entity.getBidFlag() == 1){
//                for (StuffDocumentSupplierVO stuffDocumentSupplierVO : stuffDocumentSupplierVOS){
//                    stuffDocumentSupplierVO.setRegisterDate(null);
//                }
//            }
            //按供应商查看报价
            stuffDocumentVO.setStuffDocumentSupplierList(stuffDocumentSupplierVOS);
            //前端键值重复设计
            stuffDocumentVO.setStuffDocumentSupplierSchemeList(stuffDocumentSupplierVOS);
            //按材料查看报价
            List<StuffDocumentDetailVO> stuffDocumentDetailList = stuffDocumentVO.getStuffDocumentDetailList();
            //获取材料明细报价
            LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
            lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, id);
            lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum);
            lambdaSell.orderByAsc(StuffDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(StuffDocumentSellEntity::getSchemeName);
            List<StuffDocumentSellEntity> sellList = stuffDocumentSellService.list(lambdaSell);
            if (CollectionUtils.isNotEmpty(sellList)) {
                List<StuffDocumentSellVO> stuffDocumentSellVOS = BeanMapper.mapList(sellList, StuffDocumentSellVO.class);
                for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOS) {
                    //是否开标,0-是,1-否
                    if (entity.getBidFlag() == 1) {
                        stuffDocumentSellVO.setPrice(null);
                        stuffDocumentSellVO.setPriceTax(null);
                        stuffDocumentSellVO.setMoney(null);
                        stuffDocumentSellVO.setMoneyTax(null);
                        stuffDocumentSellVO.setSellTax(null);
                        stuffDocumentSellVO.setTenderNum(null);
                        stuffDocumentSellVO.setTenderMoney(null);
                        stuffDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() == 0) {
                        stuffDocumentSellVO.setTenderNum(null);
                        stuffDocumentSellVO.setTenderMoney(null);
                        stuffDocumentSellVO.setTenderFlag(null);
                    }
                }
                Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOS.stream().
                        collect(Collectors.groupingBy(StuffDocumentSellVO::getDetailId));
                for (StuffDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList) {
                    List<StuffDocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
                    List<StuffDocumentSellVO> stuffDocumentSellEntities = sellMap.get(stuffDocumentDetailVO.getId());
                    Map<Long, List<StuffDocumentSellVO>> sellDetailMap = stuffDocumentSellEntities.stream().
                            collect(Collectors.groupingBy(StuffDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key, value) -> {
                        StuffDocumentSupplierVO stuffDocumentSupplierVO = new StuffDocumentSupplierVO();
                        stuffDocumentSupplierVO.setSupplierId(key);
                        StuffDocumentSellVO stuffDocumentSellVO = value.stream().findFirst().get();
                        stuffDocumentSupplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
                        stuffDocumentSupplierVO.setStuffDocumentSellVOList(value);
                        documentSupplierVOS.add(stuffDocumentSupplierVO);
                    });
                    stuffDocumentDetailVO.setStuffDocumentSupplierVOList(documentSupplierVOS);
                }
                //区分报价详情信息
                List<StuffDocumentDetailVO> stuffDocumentDetailSellList = stuffDocumentVO.getStuffDocumentDetailList();
                stuffDocumentVO.setStuffDocumentDetailSellList(stuffDocumentDetailSellList);
            }
        }

        return stuffDocumentVO;
    }


    @Override
    public List<StuffDocumentSellVO> getSchemeDetail(StuffDocumentSellVO stuffDocumentSellVO) {
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getSupplierId, stuffDocumentSellVO.getSupplierId());
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentSellVO.getDocumentId());
        lambdaSell.eq(StuffDocumentSellEntity::getSchemeId, stuffDocumentSellVO.getSchemeId());
        List<StuffDocumentSellEntity> list = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(list, StuffDocumentSellVO.class);
        return stuffDocumentSellVOList;
    }

    @Override
    public StuffDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        StuffDocumentEntity stuffDocumentEntity = super.selectById(documentId);
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = new StuffDocumentSupplierSellVO();
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.selectById(supplierDetailId);
        stuffDocumentSupplierSellVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
        stuffDocumentSupplierSellVO.setSupplierId(stuffDocumentSupplierEntity.getSupplierId());
        stuffDocumentSupplierSellVO.setSupplierName(stuffDocumentSupplierEntity.getSupplierName());
        stuffDocumentSupplierSellVO.setLinkMobile(stuffDocumentSupplierEntity.getLinkMobile());
        stuffDocumentSupplierSellVO.setOfferTime(stuffDocumentSupplierEntity.getOfferTime());
        stuffDocumentSupplierSellVO.setTaxMemo(stuffDocumentSupplierEntity.getTaxMemo());
        stuffDocumentSupplierSellVO.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, supplierDetailId);
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityList = stuffDocumentSchemeService.list(lambdaScheme);
        List<StuffDocumentSchemeVO> stuffDocumentSchemeVOList = BeanMapper.mapList(stuffDocumentSchemeEntityList, StuffDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentSupplierEntity.getDocumentId());
        List<StuffDocumentSellEntity> stuffDocumentSellEntityList = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(stuffDocumentSellEntityList, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOList.stream().
                collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeId));
        for (StuffDocumentSchemeVO stuffDocumentSchemeVO : stuffDocumentSchemeVOList) {
            List<StuffDocumentSellVO> stuffDocumentSellVOS = sellMap.get(stuffDocumentSchemeVO.getId());
            if(CollectionUtils.isNotEmpty(stuffDocumentSellVOS)){
                for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOS) {
                    StuffDocumentDetailEntity subDocumentDetailEntity = stuffDocumentDetailService.selectById(stuffDocumentSellVO.getDetailId());
                    stuffDocumentSellVO.setInvitePrice(subDocumentDetailEntity.getPrice());
                    stuffDocumentSellVO.setInvitePriceTax(subDocumentDetailEntity.getTaxPrice());
                }
            }
            stuffDocumentSchemeVO.setStuffDocumentSellList(stuffDocumentSellVOS);
        }
        stuffDocumentSupplierSellVO.setStuffDocumentSchemeList(stuffDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                stuffDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                stuffDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return stuffDocumentSupplierSellVO;
    }

    @Transactional
    @Override
    public StuffDocumentVO extendDocument(StuffDocumentRecordVO stuffDocumentRecordVO) {
        StuffDocumentRecordEntity stuffDocumentRecordEntity = BeanMapper.map(stuffDocumentRecordVO, StuffDocumentRecordEntity.class);
        stuffDocumentRecordService.save(stuffDocumentRecordEntity);
        StuffDocumentEntity stuffDocumentEntity = super.selectById(stuffDocumentRecordVO.getDocumentId());
        stuffDocumentEntity.setOfferEndTime(stuffDocumentRecordVO.getNewTime());
        boolean b = super.updateById(stuffDocumentEntity);

        //推送供方
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(stuffDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(stuffDocumentRecordVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件同步供方接口报错" + stringCommonResponse.getMsg());
        }

        //更新招标截止时间
        StuffInviteEntity inviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        inviteEntity.setStopTime(stuffDocumentEntity.getOfferEndTime());
        stuffInviteService.saveOrUpdate(inviteEntity);

        StuffDocumentVO stuffDocumentVO = queryDetail(stuffDocumentRecordVO.getDocumentId());
        return stuffDocumentVO;
    }

    @Override
    public StuffDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {

        StuffTalkEntity stuffTalkEntity = stuffTalkService.selectById(talkId);
        Integer talkNum = stuffTalkEntity.getTalkNum();
        if (stuffTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        List<StuffTalkVO> talkVOArrayList = new ArrayList<>();
        String name = null;
        for (int a = 0; a <= talkNum; a++) {
            StuffTalkVO stuffTalkVO = new StuffTalkVO();
            stuffTalkVO.setTalkNum(a);
            if (a == 0) {
                name = "首次报价";
            }
            else {
                name = "第" + a + "轮报价";
            }
            stuffTalkVO.setTalkNumName(name);
            talkVOArrayList.add(stuffTalkVO);
        }

        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = new StuffDocumentSupplierSellVO();
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.selectById(supplierDetailId);
        stuffDocumentSupplierSellVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
        stuffDocumentSupplierSellVO.setLinkMobile(stuffDocumentSupplierEntity.getLinkMobile());
        stuffDocumentSupplierSellVO.setOfferTime(stuffDocumentSupplierEntity.getOfferTime());
        stuffDocumentSupplierSellVO.setTaxMemo(stuffDocumentSupplierEntity.getTaxMemo());
        stuffDocumentSupplierSellVO.setSupplierName(stuffDocumentSupplierEntity.getSupplierName());

        for (StuffTalkVO stuffTalkVO : talkVOArrayList) {
            LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentId, stuffDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(StuffDocumentSchemeEntity::getSupplierId, stuffDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(StuffDocumentSchemeEntity::getTalkNum, stuffTalkVO.getTalkNum());
            List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityList = stuffDocumentSchemeService.list(lambdaScheme);
            if (CollectionUtils.isEmpty(stuffDocumentSchemeEntityList)) {
                continue;
            }
            List<StuffDocumentSchemeVO> stuffDocumentSchemeVOList = BeanMapper.mapList(stuffDocumentSchemeEntityList, StuffDocumentSchemeVO.class);

            //获取报价方案详情
            List<Long> schemePkList = stuffDocumentSchemeVOList.stream().map(StuffDocumentSchemeVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
            lambdaSell.in(StuffDocumentSellEntity::getSchemeId, schemePkList);
            List<StuffDocumentSellEntity> stuffDocumentSellEntityList = stuffDocumentSellService.list(lambdaSell);
            List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(stuffDocumentSellEntityList, StuffDocumentSellVO.class);
            Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOList.stream().
                    collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeId));
            for (StuffDocumentSchemeVO stuffDocumentSchemeVO : stuffDocumentSchemeVOList) {
                List<StuffDocumentSellVO> stuffDocumentSellVOS = sellMap.get(stuffDocumentSchemeVO.getId());
                stuffDocumentSchemeVO.setStuffDocumentSellList(stuffDocumentSellVOS);
            }
            stuffTalkVO.setStuffDocumentSchemeList(stuffDocumentSchemeVOList);
        }
        stuffDocumentSupplierSellVO.setStuffTalkVOList(talkVOArrayList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                stuffDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                stuffDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return stuffDocumentSupplierSellVO;
    }

    private Map<String, Object> getFileInfo(Long sourceId) {
        Map<String, Object> map = new HashMap<>();
        //查询附件
        CommonResponse<List<AttachmentVO>> attachResponse = attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess()) {
            List<AttachmentVO> data = attachResponse.getData();
            if (CollectionUtils.isNotEmpty(data)) {
                AttachmentVO attachmentVO = data.stream().findFirst().get();
                if (attachmentVO != null) {
                    map.put("fileName", attachmentVO.getFileName());
                    map.put("attachId", attachmentVO.getId());
                }


            }
        }
        return map;
    }

    @Override
    public StuffDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        //更新发布状态
        StuffDocumentEntity stuffDocumentEntity = super.selectById(id);
        stuffDocumentEntity.setPublishFlag(0);
        super.updateById(stuffDocumentEntity);


        StuffNoticeSupplierTbVO stuffNoticeSupplierTbVO = new StuffNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        stuffNoticeSupplierTbVO.setSourceType("云南建投招标文件");
        stuffNoticeSupplierTbVO.setSourceId(stuffDocumentEntity.getInviteId().toString());
        StuffInviteEntity inviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        if (stuffDocumentEntity.getTenderType() == 2) {
            stuffNoticeSupplierTbVO.setNoticeType(2);
        }
        else {
            stuffNoticeSupplierTbVO.setNoticeType(3);
        }
        if (stuffDocumentEntity.getPurchaseType() == 1) {
            stuffNoticeSupplierTbVO.setSourceProjectId(null);
            stuffNoticeSupplierTbVO.setProjectName(null);
            stuffNoticeSupplierTbVO.setProjectCode(null);
        }
        else {
            stuffNoticeSupplierTbVO.setSourceProjectId(stuffDocumentEntity.getProjectId().toString());
            stuffNoticeSupplierTbVO.setProjectName(stuffDocumentEntity.getProjectName());
            stuffNoticeSupplierTbVO.setProjectCode(stuffDocumentEntity.getProjectCode());
        }

        stuffNoticeSupplierTbVO.setSourceOrgId(stuffDocumentEntity.getOrgId().toString());
        stuffNoticeSupplierTbVO.setOrgName(stuffDocumentEntity.getOrgName());
        stuffNoticeSupplierTbVO.setSourceUnitId(stuffDocumentEntity.getUnitId().toString());
        stuffNoticeSupplierTbVO.setUnitName(stuffDocumentEntity.getUnitName());
        stuffNoticeSupplierTbVO.setMemo(stuffDocumentEntity.getMemo());
        stuffNoticeSupplierTbVO.setType("MATERIAL");
        stuffNoticeSupplierTbVO.setTenderName(stuffDocumentEntity.getDocumentName());
        stuffNoticeSupplierTbVO.setTenderType(stuffDocumentEntity.getTenderType());
        stuffNoticeSupplierTbVO.setPurchaseType(stuffDocumentEntity.getPurchaseType().toString());
        stuffNoticeSupplierTbVO.setPurchaseName(stuffDocumentEntity.getPurchaseName());
        stuffNoticeSupplierTbVO.setSourceEmployeeId(stuffDocumentEntity.getEmployeeId().toString());
        stuffNoticeSupplierTbVO.setEmployeeName(stuffDocumentEntity.getEmployeeName());
        stuffNoticeSupplierTbVO.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
        stuffNoticeSupplierTbVO.setValueType(stuffDocumentEntity.getValueType());
        stuffNoticeSupplierTbVO.setContent(stuffDocumentEntity.getDocumentContent());
        stuffNoticeSupplierTbVO.setOfferStartTime(sdf.format(stuffDocumentEntity.getOfferStartTime()));
        stuffNoticeSupplierTbVO.setOfferEndTime(sdf.format(stuffDocumentEntity.getOfferEndTime()));
        stuffNoticeSupplierTbVO.setBrandFlag(stuffDocumentEntity.getBrandFlag());
        stuffNoticeSupplierTbVO.setProjectLinkName(stuffDocumentEntity.getProjectLinkName());
        stuffNoticeSupplierTbVO.setProjectLinkPhone(stuffDocumentEntity.getProjectLinkPhone());
        stuffNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        stuffNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        stuffNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        //插入物资
        List<StuffNoticeDetailTbVO> stuffNoticeDetailVOS = new ArrayList<>();
        List<StuffDocumentDetailVO> documentDetailEntityList =  baseMapper.selectSumDetail(stuffDocumentEntity.getId());
        for (StuffDocumentDetailVO stuffDocumentDetailEntity : documentDetailEntityList) {
            StuffNoticeDetailTbVO stuffNoticeDetailTbVO = new StuffNoticeDetailTbVO();
            BeanUtils.copyProperties(stuffNoticeDetailTbVO, stuffDocumentDetailEntity);
            stuffNoticeDetailTbVO.setMemo(stuffDocumentDetailEntity.getSumMemo());
            stuffNoticeDetailTbVO.setNum(stuffDocumentDetailEntity.getSumNum());
            stuffNoticeDetailTbVO.setMoney(stuffDocumentDetailEntity.getSumMoney());
            stuffNoticeDetailTbVO.setMoneyTax(stuffDocumentDetailEntity.getSumMoneyTax());
            stuffNoticeDetailTbVO.setPriceTender(stuffDocumentDetailEntity.getPrice());
            stuffNoticeDetailTbVO.setTaxPriceTender(stuffDocumentDetailEntity.getTaxPrice());
            stuffNoticeDetailTbVO.setSourceId(stuffDocumentEntity.getInviteId().toString());
            stuffNoticeDetailTbVO.setSourceMaterialId(stuffDocumentDetailEntity.getMaterialId() == null ? null : stuffDocumentDetailEntity.getMaterialId().toString());
            stuffNoticeDetailTbVO.setSourceMaterialTypeId(stuffDocumentDetailEntity.getMaterialTypeId().toString());
            stuffNoticeDetailVOS.add(stuffNoticeDetailTbVO);
        }
        stuffNoticeSupplierTbVO.setDetailList(stuffNoticeDetailVOS);
        //是否是邀请招标
        if (stuffDocumentEntity.getTenderType() != 2) {
            List<StuffDocumentSupplierDetailEntity> detailEntityList = supplierDetailService.list(new LambdaQueryWrapper<StuffDocumentSupplierDetailEntity>().eq(StuffDocumentSupplierDetailEntity::getInviteId, stuffDocumentEntity.getInviteId()).eq(StuffDocumentSupplierDetailEntity::getDr, 0));
            List<StuffNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (StuffDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                StuffNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new StuffNoticeSupplierDetailTbVO();
                stuffNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                stuffNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                stuffNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

                supplierDetailTbVOList.add(stuffNoticeSupplierDetailTbVO);
            }
            stuffNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }

        //调用第三方报名接口
//        CommonResponse<JSONObject> response = null;
//        logger.info("发布内容"+stringFb);
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, stringFb,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
//        }

        //处理附件
        //查询招标文件
        CommonResponse<List<AttachmentVO>> zbwjFile = attachmentApi.queryListBySourceId(stuffDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Long> zbwjAttachIdList = new ArrayList<>();
        if(zbwjFile.isSuccess()){
            List<AttachmentVO> data = zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }

        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //招标文件stream处理
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonZbwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String dataZbwj = zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject(dataZbwj);
        Map<String, byte[]> zbwjMap = JSONObject.parseObject(zbwListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        zbwjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });

        String stringFb = JSONObject.toJSONString(stuffNoticeSupplierTbVO);
        Map<String,String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;
        if (!streamMap.isEmpty()){
            files = new HashMap<>();
            files.put("file",streamMap);
        }



        //调用第三方接口
        CommonResponse<String> response = null;
        try {
//            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
            response = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl,params,files, appId, appSecret, appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
        }
        //招标文件发布成功后 改招标状态 为报价中
        inviteEntity.setTenderState(TenderStateEnum.报价中.getCode());
        inviteEntity.setStopTime(stuffDocumentEntity.getOfferEndTime());
        stuffInviteService.saveOrUpdate(inviteEntity);
        return queryDetail(id);
    }

    @Override
    public CommonResponse delSupplier(Long id) {
        StuffDocumentEntity stuffDocumentEntity = baseMapper.selectById(id);
        List<StuffDocumentSupplierEntity> stuffDocumentSupplierList = supplierMapper.selectList(new QueryWrapper<StuffDocumentSupplierEntity>().eq("document_id", stuffDocumentEntity.getId()).eq("dr", 0));
        List<StuffDocumentSupplierDetailEntity> supplierDetailList = supplierDetailMapper.selectList(new QueryWrapper<StuffDocumentSupplierDetailEntity>().eq("invite_id", stuffDocumentEntity.getInviteId()).eq("dr", 0));
        List<Long> oldIds = new ArrayList<>();
        List<Long> newIds = new ArrayList<>();
        stuffDocumentSupplierList.stream().forEach(it -> oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it -> newIds.add(it.getSupplierId()));
        List<Long> newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List<StuffDocumentSupplierDetailEntity> newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        //装填数据
        List<StuffNoticeSupplierDetailTbVO> signVOList = new ArrayList<>();
        for (StuffDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            StuffNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new StuffNoticeSupplierDetailTbVO();
            stuffNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            stuffNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            //todo
//            HashMap<Long, Long> hashMap = new HashMap<>();
//            hashMap.put(1406947724700246112L,1471726626618441730L);
//            hashMap.put(1406947724700246113L,1471729176256151553L);
//            hashMap.put(1406947724700246114L,1471731643794554881L);
//            hashMap.put(527888337260777477L,1472852233918054402L);
//
//            //云南建设总承包公司测试用户
//            hashMap.put(528220972239556690L,1473189202070044674L);
//            hashMap.put(528222266413027386L,1473189172567310338L);
//            hashMap.put(528222429273657395L,1473189113180160002L);stuffEvaluation/queryGatherList
//            hashMap.put(528222690796900362L,1473190529172996098L);
            stuffNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

            stuffNoticeSupplierDetailTbVO.setOutReason("超时未报价");
            signVOList.add(stuffNoticeSupplierDetailTbVO);
        }
        logger.info("剔除的供应商" + JSON.toJSONString(signVOList));
        //调用第三方接口
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), appId, appSecret, appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("剔除供应商成功");
    }

    @Override
    public StuffDocumentVO saveManyDocument(Long id) {
        StuffDocumentEntity stuffDocumentEntity = new StuffDocumentEntity();
        //查询招标主表信息
        StuffInviteEntity inviteEntity = stuffInviteService.selectById(id);
        //复制主表
        stuffDocumentEntity.setInviteId(inviteEntity.getId());
        stuffDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType() == 0) {
            stuffDocumentEntity.setProjectId(inviteEntity.getProjectId());
            stuffDocumentEntity.setProjectName(inviteEntity.getProjectName());
            stuffDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        stuffDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        stuffDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        stuffDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        stuffDocumentEntity.setOrgId(inviteEntity.getOrgId());
        stuffDocumentEntity.setOrgName(inviteEntity.getOrgName());
        stuffDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        stuffDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        stuffDocumentEntity.setValueType(inviteEntity.getValueType());
        stuffDocumentEntity.setUnitId(inviteEntity.getUnitId());
        stuffDocumentEntity.setUnitName(inviteEntity.getUnitName());
        stuffDocumentEntity.setTenderType(inviteEntity.getTenderType());

        //设置计价方式
        stuffDocumentEntity.setBidFlag(1);
        stuffDocumentEntity.setPublishFlag(1);
        stuffDocumentEntity.setNextFlag(1);


        //复制物资详情
        List<StuffInviteDetailEntity> stuffNoticeDetailList = inviteEntity.getStuffDetail();
        List<StuffDocumentDetailEntity> stuffDocumentDetailList = BeanMapper.mapList(stuffNoticeDetailList, StuffDocumentDetailEntity.class);
        for (StuffDocumentDetailEntity stuffDocumentDetailEntity : stuffDocumentDetailList) {
            stuffDocumentDetailEntity.setId(null);
        }
        stuffDocumentEntity.setStuffDocumentDetailList(stuffDocumentDetailList);

        //复制供应商
        List<StuffInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List<StuffDocumentSupplierDetailEntity> stuffDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, StuffDocumentSupplierDetailEntity.class);
        for (StuffDocumentSupplierDetailEntity stuffDocumentSupplierDetailVO : stuffDocumentSupplierDetailVOS) {
            stuffDocumentSupplierDetailVO.setId(null);
            documentSupplierDetailService.saveOrUpdate(stuffDocumentSupplierDetailVO);
        }


        stuffDocumentEntity.setId(IdWorker.getId());
        service.saveOrUpdate(stuffDocumentEntity, false);

        //招标立项向招标文件附件复制
        String sourceBillSourceType = null;
        if (inviteEntity.getDraftType() == 1){
            sourceBillSourceType = "contractFile";
        }
        if (inviteEntity.getDraftType() == 2){
            sourceBillSourceType = "stuffInviteFile";
        }
        CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                inviteEntity.getId().toString(),
                "BT211110000000002",
                sourceBillSourceType,
                stuffDocumentEntity.getId().toString(),
                "BT211119000000003",
                "documentBill02"
        );
        if (!responseCopy.isSuccess()) {
            throw new BusinessException("招标立项向招标文件附件复制失败:" + responseCopy.getMsg());
        }


        ProcessEntity processEntity = new ProcessEntity();
        //回写招标阶段
        switch (inviteEntity.getTenderType()) {
            case 3:
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("竞争性谈判");
                break;
            case 4:
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("单一来源");
                break;
            case 5:
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("紧急招标");
                break;
            case 2:
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("询价公告");
                break;
        }
        stuffInviteService.updateById(inviteEntity);
        //回写进展表
        processEntity.setBillId(stuffDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/fourJzDyJjXj");
        processService.saveOrUpdate(processEntity);
        StuffDocumentVO vo = BeanMapper.map(stuffDocumentEntity, StuffDocumentVO.class);
        return vo;
    }

    @Override
    public StuffDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        //获取轮数
        StuffTalkRecordEntity stuffTalkRecordEntity = stuffTalkRecordService.selectById(talkId);
        Integer talkNum = stuffTalkRecordEntity.getTalkNum();
        if (stuffTalkRecordEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }

        //
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = new StuffDocumentSupplierSellVO();
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.selectById(supplierDetailId);
        stuffDocumentSupplierSellVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
        stuffDocumentSupplierSellVO.setLinkMobile(stuffDocumentSupplierEntity.getLinkMobile());
        stuffDocumentSupplierSellVO.setOfferTime(stuffDocumentSupplierEntity.getOfferTime());
        stuffDocumentSupplierSellVO.setTaxMemo(stuffDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, supplierDetailId);
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityList = stuffDocumentSchemeService.list(lambdaScheme);
        List<StuffDocumentSchemeVO> stuffDocumentSchemeVOList = BeanMapper.mapList(stuffDocumentSchemeEntityList, StuffDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum);
        List<StuffDocumentSellEntity> stuffDocumentSellEntityList = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(stuffDocumentSellEntityList, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOList.stream().
                collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeId));
        for (StuffDocumentSchemeVO stuffDocumentSchemeVO : stuffDocumentSchemeVOList) {
            List<StuffDocumentSellVO> stuffDocumentSellVOS = sellMap.get(stuffDocumentSchemeVO.getId());
            stuffDocumentSchemeVO.setStuffDocumentSellList(stuffDocumentSellVOS);
        }
        stuffDocumentSupplierSellVO.setStuffDocumentSchemeList(stuffDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                stuffDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                stuffDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return stuffDocumentSupplierSellVO;
    }

    @Override
    public StuffDocumentVO saveDocument(Long noticeId) {
        StuffDocumentEntity entity = new StuffDocumentEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询公告主表信息
        StuffNoticeEntity stuffNoticeEntity = stuffNoticeService.selectById(noticeId);
        //复制物资详情
        List<StuffNoticeDetailEntity> stuffNoticeDetailList = stuffNoticeEntity.getNoticeDetail();
        List<StuffDocumentDetailEntity> stuffDocumentDetailList = BeanMapper.mapList(stuffNoticeDetailList, StuffDocumentDetailEntity.class);
        for (StuffDocumentDetailEntity stuffDocumentDetailEntity : stuffDocumentDetailList) {
            stuffDocumentDetailEntity.setId(null);
        }
        entity.setStuffDocumentDetailList(stuffDocumentDetailList);

        //复制主表信息
        entity.setProjectId(stuffNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(stuffNoticeEntity.getProjectName());
        entity.setOrgId(stuffNoticeEntity.getOrgId());
        entity.setOrgName(stuffNoticeEntity.getOrgName());
        entity.setParentOrgId(stuffNoticeEntity.getParentOrgId());
        entity.setParentOrgName(stuffNoticeEntity.getParentOrgName());
        entity.setProjectCode(stuffNoticeEntity.getProjectCode());
        entity.setDocumentName(stuffNoticeEntity.getNoticeName());
        entity.setEmployeeId(stuffNoticeEntity.getEmployeeId());
        entity.setEmployeeName(stuffNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(stuffNoticeEntity.getEmployeeMobile());
        entity.setInviteId(stuffNoticeEntity.getInviteId());
        entity.setPurchaseId(stuffNoticeEntity.getPurchaseId());
        entity.setPurchaseName(stuffNoticeEntity.getPurchaseName());
        entity.setPurchaseType(stuffNoticeEntity.getPurchaseType());
        entity.setTenderType(stuffNoticeEntity.getTenderType());
        //设置计价方式
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffNoticeEntity.getInviteId());
        entity.setValueType(stuffInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setId(IdWorker.getId());

        service.saveOrUpdate(entity, false);

        //招标立项向招标文件附件复制
        String sourceBillSourceType = null;
        if (stuffInviteEntity.getDraftType() == 1){
            sourceBillSourceType = "contractFile";
        }
        if (stuffInviteEntity.getDraftType() == 2){
            sourceBillSourceType = "stuffInviteFile";
        }
        CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                stuffInviteEntity.getId().toString(),
                "BT211110000000002",
                sourceBillSourceType,
                entity.getId().toString(),
                "BT211119000000003",
                "documentBill02"
        );
        if (!responseCopy.isSuccess()) {
            throw new BusinessException("招标立项向招标文件附件复制失败:" + responseCopy.getMsg());
        }

        //回写招标阶段
        stuffInviteEntity.setTenderStage(3);
        stuffInviteService.updateById(stuffInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("招标文件");
        processEntity.setTenderId(stuffNoticeEntity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/document");
        processService.saveOrUpdate(processEntity);
        StuffDocumentVO vo = BeanMapper.map(entity, StuffDocumentVO.class);
        return vo;
    }

}
