package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.mapper.StuffNoticeDetailMapper;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeSupplierDetailService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeSupplierService;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.stuff.mapper.StuffNoticeMapper;
import com.ejianc.business.tender.stuff.service.IStuffNoticeService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
@Service("stuffNoticeService")
public class StuffNoticeServiceImpl extends BaseServiceImpl<StuffNoticeMapper, StuffNoticeEntity> implements IStuffNoticeService{

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IStuffNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private StuffNoticeDetailMapper stuffNoticeDetailMapper;

    @Autowired
    private IStuffNoticeSupplierService supplierService;

    @Autowired
    private IStuffInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        baseMapper.updateEndTime(noticeId,newTime);
    }

    @Transactional
    @Override
    public CommonResponse publish(StuffNoticeVO stuffNoticeVO) throws InvocationTargetException, IllegalAccessException {
        //插入主表数据
        StuffNoticeEntity stuffNoticeEntity = baseMapper.selectById(stuffNoticeVO.getId());
        StuffInviteEntity inviteEntity = inviteService.selectById(stuffNoticeEntity.getInviteId());

        stuffNoticeEntity.setPublishFlag(0);
        baseMapper.updateById(stuffNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StuffNoticeSupplierTbVO stuffNoticeSupplierTbVO = new StuffNoticeSupplierTbVO();
        BeanUtils.copyProperties(stuffNoticeSupplierTbVO,stuffNoticeEntity);
        stuffNoticeSupplierTbVO.setNoticeStartTime(sdf.format(stuffNoticeEntity.getNoticeStartTime()));
        stuffNoticeSupplierTbVO.setNoticeEndTime(sdf.format(stuffNoticeEntity.getNoticeEndTime()));
        stuffNoticeSupplierTbVO.setNoticeType(0);
        if (stuffNoticeEntity.getPurchaseType()==1){
            stuffNoticeSupplierTbVO.setSourceProjectId(null);
        }else {
            stuffNoticeSupplierTbVO.setSourceProjectId(stuffNoticeEntity.getProjectId().toString());
        }
        stuffNoticeSupplierTbVO.setSourceId(stuffNoticeEntity.getInviteId().toString());
        stuffNoticeSupplierTbVO.setSourceType("云南建投招标公告");
        stuffNoticeSupplierTbVO.setSourceOrgId(stuffNoticeEntity.getOrgId().toString());
        stuffNoticeSupplierTbVO.setSourceUnitId(stuffNoticeEntity.getUnitId().toString());
        stuffNoticeSupplierTbVO.setType("MATERIAL");
        stuffNoticeSupplierTbVO.setTenderName(stuffNoticeEntity.getNoticeName());
        stuffNoticeSupplierTbVO.setSourceEmployeeId(stuffNoticeEntity.getEmployeeId().toString());
        stuffNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        stuffNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        stuffNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        stuffNoticeSupplierTbVO.setId(null);
        stuffNoticeSupplierTbVO.setCreateTime(null);
        stuffNoticeSupplierTbVO.setUpdateTime(null);
        stuffNoticeSupplierTbVO.setCreateUserCode(null);
        stuffNoticeSupplierTbVO.setUpdateUserCode(null);
        stuffNoticeSupplierTbVO.setSyncEsFlag(null);
        stuffNoticeSupplierTbVO.setVersion(null);
        stuffNoticeSupplierTbVO.setTenantId(null);
        stuffNoticeSupplierTbVO.setDr(null);
        //插入物资
//        List<StuffNoticeDetailEntity> noticeDetailEntityList = stuffNoticeDetailMapper.selectList(new LambdaQueryWrapper<StuffNoticeDetailEntity>().eq(StuffNoticeDetailEntity::getNoticeId, stuffNoticeVO.getId()));
        List<StuffNoticeDetailVO> noticeDetailEntityList =  stuffNoticeDetailMapper.selectSumDetail(stuffNoticeVO.getId());
        List<StuffNoticeDetailTbVO> stuffNoticeDetailVOS = new ArrayList<>();
        for (StuffNoticeDetailVO stuffNoticeDetailEntity : noticeDetailEntityList) {
            StuffNoticeDetailTbVO stuffNoticeDetailTbVO = new StuffNoticeDetailTbVO();
            BeanUtils.copyProperties(stuffNoticeDetailTbVO,stuffNoticeDetailEntity);
            stuffNoticeDetailTbVO.setMemo(stuffNoticeDetailEntity.getSumMemo());
            stuffNoticeDetailTbVO.setNum(stuffNoticeDetailEntity.getSumNum());
            stuffNoticeDetailTbVO.setMoney(stuffNoticeDetailEntity.getSumMoney());
            stuffNoticeDetailTbVO.setMoneyTax(stuffNoticeDetailEntity.getSumMoneyTax());
            stuffNoticeDetailTbVO.setPriceTender(stuffNoticeDetailEntity.getPrice());
            stuffNoticeDetailTbVO.setTaxPriceTender(stuffNoticeDetailEntity.getTaxPrice());
            stuffNoticeDetailTbVO.setSourceId(stuffNoticeEntity.getInviteId().toString());
            stuffNoticeDetailTbVO.setSourceMaterialId(stuffNoticeDetailEntity.getMaterialId()==null?null:stuffNoticeDetailEntity.getMaterialId().toString());
            stuffNoticeDetailTbVO.setSourceMaterialTypeId(stuffNoticeDetailEntity.getMaterialTypeId()==null?null:stuffNoticeDetailEntity.getMaterialTypeId().toString());
            stuffNoticeDetailVOS.add(stuffNoticeDetailTbVO);

        }
        stuffNoticeSupplierTbVO.setDetailList(stuffNoticeDetailVOS);
        //是否是邀请招标
        if (stuffNoticeVO.getTenderType()==1){
            List<StuffNoticeSupplierDetailEntity> detailEntityList = noticeSupplierDetailService.list(new LambdaQueryWrapper<StuffNoticeSupplierDetailEntity>().eq(StuffNoticeSupplierDetailEntity::getInviteId, stuffNoticeEntity.getInviteId()).eq(StuffNoticeSupplierDetailEntity::getDr, 0));
            List<StuffNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (StuffNoticeSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                StuffNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new StuffNoticeSupplierDetailTbVO();
                stuffNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                stuffNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo 暂时写死
                stuffNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(stuffNoticeSupplierDetailTbVO);
            }
            stuffNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        //调用第三方接口
//        CommonResponse<JSONObject> response = null;
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, JSON.toJSONString(stuffNoticeSupplierTbVO),cacheManager);
//            if(!response.isSuccess()) {
//                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            return CommonResponse.error("调用平台报名接口失败");
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(stuffNoticeSupplierTbVO), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }

        //招标公告发布成功后 改招标状态 为报名中
        inviteEntity.setTenderState(TenderStateEnum.报名中.getCode());
        inviteEntity.setStopTime(stuffNoticeEntity.getNoticeEndTime());
        inviteService.saveOrUpdate(inviteEntity);
        return CommonResponse.success("公告信息推送成功");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<StuffNoticeEntity>().eq(StuffNoticeEntity::getInviteId,sourceId)).getId();
    }

    @Override
    public boolean selectFile(StuffNoticeVO vo) {
        List<StuffNoticeSupplierEntity> noticeSupplierEntityList = supplierService.list(new QueryWrapper<StuffNoticeSupplierEntity>().eq("notice_id", vo.getId()).eq("dr", 0));
        List<StuffNoticeSupplierVO> stuffNoticeSupplierVOS = BeanMapper.mapList(noticeSupplierEntityList, StuffNoticeSupplierVO.class);
        //处理供应商附件信息
        if (CollectionUtils.isNotEmpty(stuffNoticeSupplierVOS)){
            List<Long> attachIds = stuffNoticeSupplierVOS.stream().map(StuffNoticeSupplierVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds",attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId),Function.identity());
                    Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                    for (StuffNoticeSupplierVO stuffNoticeSupplierVO : stuffNoticeSupplierVOS){
                        List<AttachmentVO> attachmentVOList = attacMap.get(stuffNoticeSupplierVO.getId());
                        logger.info("查询文件详情"+JSONObject.toJSONString(attachmentVOList));
                        if (attachmentVOList!=null){
                            ArrayList<Map<String, Object>> list = new ArrayList<>();
                            for (AttachmentVO attachmentVO : attachmentVOList) {
                                HashMap<String, Object> hashMap = new HashMap<>();
                                hashMap.put("attachId",attachmentVO.getId());
                                hashMap.put("name",attachmentVO.getFileName());
                                list.add(hashMap);
                            }
                            stuffNoticeSupplierVO.setFile(list);
                        }else {
                            stuffNoticeSupplierVO.setAttachId(null);
                            stuffNoticeSupplierVO.setFileName(null);
                        }
                    }
                }
            }
            vo.setNoticeSupplierDetail(stuffNoticeSupplierVOS);
        }
        return true;
    }
}
