package com.ejianc.business.tender.stuff.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatPicketageSupplierEntity;
import com.ejianc.business.tender.rmat.vo.TenderStageEnum;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.mapper.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 定标主表
 * 
 * @author generator
 * 
 */
@Service("stuffPicketageService")
public class StuffPicketageServiceImpl extends BaseServiceImpl<StuffPicketageMapper, StuffPicketageEntity> implements IStuffPicketageService{
    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private IStuffDocumentSchemeService stuffDocumentSchemeService;
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private StuffDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IStuffTalkService stuffTalkService;
    @Autowired
    private IStuffPicketageSupplierService stuffPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public StuffPicketageVO savePicketage(Long evaluationId) {

        StuffPicketageEntity entity = new StuffPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            entity.setPicketageTime(new Date());
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //转换数据
        ExpertEvaluatingEntity stuffEvaluationEntity = IExpertEvaluatingService.selectById(evaluationId);
        StuffInviteEntity inviteEntity = stuffInviteService.selectById(stuffEvaluationEntity.getInviteId());
        StuffDocumentEntity stuffDocumentEntity = stuffDocumentService.selectById(stuffEvaluationEntity.getDocumentId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(stuffDocumentEntity.getEmployeeId());
        entity.setEmployeeName(stuffDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
        entity.setValueType(stuffDocumentEntity.getValueType());
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        entity.setPurchaseId(stuffInviteEntity.getPurchaseId());
        entity.setPurchaseName(stuffInviteEntity.getPurchaseName());
        entity.setDocumentId(stuffEvaluationEntity.getDocumentId());
        entity.setEvaluationId(stuffEvaluationEntity.getId());
        entity.setInviteId(stuffEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
        //材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        StuffPicketageVO vo = BeanMapper.map(entity, StuffPicketageVO.class);

        //回写招标阶段
        stuffInviteEntity.setTenderStage(5);
        stuffInviteService.updateById(stuffInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/picketage");
        processService.saveOrUpdate(processEntity);

        //回写方案得分
        List<StuffDocumentSchemeEntity> schemeList = schemeMapper.selectSupplier(stuffDocumentEntity.getId());
        for (StuffDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score  = recordMapper.selectScore(schemeEntity.getId(),schemeEntity.getSupplierId(),stuffDocumentEntity.getId());
            Boolean scoreBoolean = schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), stuffDocumentEntity.getId(), score);
            if (!scoreBoolean){
                throw new BusinessException("回写方案得分失败!");
            }
        }
        return vo;
    }
    @Transactional
    @Override
    public StuffPicketageVO queryDetail(Long id) {
        StuffPicketageEntity stuffPicketageEntity = super.selectById(id);
        //查询最大轮数
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplier = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, stuffPicketageEntity.getDocumentId());
        List<StuffDocumentSupplierEntity> supplierEntityList = stuffDocumentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplierEntityList.stream().map(StuffDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();


        StuffDocumentEntity entity = stuffDocumentService.selectById(stuffPicketageEntity.getDocumentId());
        StuffDocumentVO stuffDocumentVO = BeanMapper.map(entity, StuffDocumentVO.class);
        //按材料查看报价
        List<StuffDocumentDetailVO> stuffDocumentDetailList = stuffDocumentVO.getStuffDocumentDetailList();
        //获取材料明细报价
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffPicketageEntity.getDocumentId());
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNumMax);
        lambdaSell.eq(StuffDocumentSellEntity::getPassFlag, 1);
        lambdaSell.orderByAsc(StuffDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(StuffDocumentSellEntity::getSchemeName);
        List<StuffDocumentSellEntity> sellList = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOS = BeanMapper.mapList(sellList, StuffDocumentSellVO.class);
        //查询所有方案
        LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentId, stuffPicketageEntity.getDocumentId());
        lambdaScheme.eq(StuffDocumentSchemeEntity::getTalkNum, talkNumMax);
        lambdaScheme.orderByAsc(StuffDocumentSchemeEntity::getSchemeName);
        List<StuffDocumentSchemeEntity> schemeList = stuffDocumentSchemeService.list(lambdaScheme);
        for (StuffDocumentSchemeEntity stuffDocumentSchemeEntity : schemeList){
            for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOS){
                if (stuffDocumentSellVO.getSchemeId().equals(stuffDocumentSchemeEntity.getId())){
                    stuffDocumentSellVO.setScore(stuffDocumentSchemeEntity.getScore());
                }

            }

        }

        //排序
        StuffDocumentSellVO stuffDocumentSellFirst = stuffDocumentSellVOS.stream().findFirst().get();
        if (stuffDocumentSellFirst.getScore() == null){
            stuffDocumentSellVOS.sort(Comparator.comparing(StuffDocumentSellVO::getCreateTime).reversed());
        }
        if (stuffDocumentSellFirst.getScore() != null){
            stuffDocumentSellVOS.sort(Comparator.comparing(StuffDocumentSellVO::getScore).reversed());
        }
        //根据物料详情主键分组
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOS.stream().
                collect(Collectors.groupingBy(StuffDocumentSellVO::getDetailId));
        for (StuffDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList){
            List<StuffDocumentSellVO> stuffDocumentSellEntities = sellMap.get(stuffDocumentDetailVO.getId());
            stuffDocumentDetailVO.setStuffDocumentSellVOList(stuffDocumentSellEntities);
        }

        StuffPicketageVO stuffPicketageVO = BeanMapper.map(stuffPicketageEntity, StuffPicketageVO.class);
        stuffPicketageVO.setStuffDocumentDetailList(stuffDocumentDetailList);
        if (stuffDocumentSellFirst.getScore() == null) {
            stuffPicketageVO.setScoreStatus(1);
        }
        if (stuffDocumentSellFirst.getScore() != null) {
            stuffPicketageVO.setScoreStatus(0);
        }
        
        return stuffPicketageVO;

    }

    @Override
    public StuffPicketageVO saveOrUpdates(StuffPicketageVO saveorUpdateVO) {
        StuffPicketageEntity entity = BeanMapper.map(saveorUpdateVO, StuffPicketageEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            entity.setPicketageTime(new Date());
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity,false);

        //先删后增供应商定标数据
        LambdaQueryWrapper<StuffPicketageSupplierEntity> lambdaSupplier = Wrappers.<StuffPicketageSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(StuffPicketageSupplierEntity::getPicketageId,entity.getId());
        stuffPicketageSupplierService.remove(lambdaSupplier);
        List<StuffPicketageSupplierVO> picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for(StuffPicketageSupplierVO stuffPicketageSupplierVO : picketageSupplierList){
            stuffPicketageSupplierVO.setTenderFlag(0);
        }
        List<StuffPicketageSupplierEntity> stuffPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, StuffPicketageSupplierEntity.class);
        stuffPicketageSupplierService.saveBatch(stuffPicketageSupplierList);

        //更新中标信息
        List<StuffDocumentDetailVO> stuffDocumentDetailList = saveorUpdateVO.getStuffDocumentDetailList();
        ArrayList<StuffDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (StuffDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList){
            documentSellVOArrayList.addAll(stuffDocumentDetailVO.getStuffDocumentSellVOList());
        }
        List<StuffDocumentSellEntity> stuffDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList,StuffDocumentSellEntity.class);
        stuffDocumentSellService.saveOrUpdateBatch(stuffDocumentSellEntityList);
        StuffPicketageVO stuffPicketageVO = queryDetail(saveorUpdateVO.getId());
        return stuffPicketageVO;
    }

    @Override
    public StuffPicketageVO saveManyPicketage(Long documentId) {
        StuffPicketageEntity entity = new StuffPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            entity.setPicketageTime(new Date());
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //更新状态
        StuffDocumentEntity documentEntity = stuffDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        stuffDocumentService.saveOrUpdate(documentEntity);

        //更新洽商谈判状态
        LambdaQueryWrapper<StuffTalkEntity> lambdaTalk = Wrappers.<StuffTalkEntity>lambdaQuery();
        lambdaTalk.eq(StuffTalkEntity::getBillId, documentId);
        StuffTalkEntity stuffTalkEntity = stuffTalkService.getOne(lambdaTalk);
        if (stuffTalkEntity != null){
            stuffTalkEntity.setNextFlag(0);
            stuffTalkService.updateById(stuffTalkEntity);
        }

        //转换数据
        StuffDocumentEntity stuffDocumentEntity = stuffDocumentService.selectById(documentId);
        StuffInviteEntity inviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setEmployeeId(stuffDocumentEntity.getEmployeeId());
        entity.setEmployeeName(stuffDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
        entity.setValueType(stuffDocumentEntity.getValueType());
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        entity.setPurchaseId(stuffInviteEntity.getPurchaseId());
        entity.setPurchaseName(stuffInviteEntity.getPurchaseName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(stuffDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        //材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        StuffPicketageVO vo = BeanMapper.map(entity, StuffPicketageVO.class);


        //回写招标阶段
        stuffInviteEntity.setTenderStage(5);
        stuffInviteService.updateById(stuffInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/picketage");
        processService.saveOrUpdate(processEntity);
        return vo;
    }

    @Override
    public List<StuffPicketageSupplierVO> querySupplierList(Long picketageId) {
        StuffPicketageEntity stuffPicketageEntity = super.selectById(picketageId);
        List<StuffPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        List<StuffPicketageSupplierVO> list = BeanMapper.mapList(picketageSupplierList, StuffPicketageSupplierVO.class);

        return list;
    }

    @Override
    public StuffPicketageVO saveSupplierBatch(StuffPicketageVO saveorUpdateVO) {
        StuffPicketageEntity stuffPicketageEntity = super.selectById(saveorUpdateVO.getId());
        List<StuffPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)){
            return queryDetail(saveorUpdateVO.getId());
        }
        //
        List<StuffPicketageSupplierEntity> stuffPicketageSupplierEntities = BeanMapper.mapList(saveorUpdateVO.getPicketageSupplierList(), StuffPicketageSupplierEntity.class);
        for (StuffPicketageSupplierEntity stuffPicketageSupplierEntity : stuffPicketageSupplierEntities){
            stuffPicketageSupplierEntity.setTenderFlag(0);

        }
        stuffPicketageSupplierService.saveBatch(stuffPicketageSupplierEntities);

        //更新中标信息
        List<StuffDocumentDetailVO> stuffDocumentDetailList = saveorUpdateVO.getStuffDocumentDetailList();
        ArrayList<StuffDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (StuffDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList){
            documentSellVOArrayList.addAll(stuffDocumentDetailVO.getStuffDocumentSellVOList());
        }
        List<StuffDocumentSellEntity> stuffDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList,StuffDocumentSellEntity.class);
        stuffDocumentSellService.saveOrUpdateBatch(stuffDocumentSellEntityList);
        return queryDetail(saveorUpdateVO.getId());
    }

}
