package com.ejianc.business.tender.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.service.IExpertRepetitionSupplierService;
import com.ejianc.business.tender.sub.vo.SubDocumentRecordVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSupplierSellVO;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubTalkEntity;
import com.ejianc.business.tender.sub.service.ISubDocumentSupplierService;
import com.ejianc.business.tender.sub.service.ISubTalkService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 招标文件主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subDocument")
@Api(value = "招标文件主表", tags = {"招标文件主表"})
public class SubDocumentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改
    @Autowired
    private ISubDocumentService service;
    @Autowired
    private ISubTalkService talkService;
    @Autowired
    private ISubDocumentSupplierService documentSupplierService;
    @Autowired
    private IExpertRepetitionSupplierService expertRepetitionSupplierService;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubDocumentVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SubDocumentVO saveorUpdateVO) {
        SubDocumentVO subDocumentVO = service.saveOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",subDocumentVO);
    }
    @ApiOperation("供方推送报价信息接口")
    @RequestMapping(value = "/supplierPushSell", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> supplierPushSell(HttpServletRequest request,  @RequestParam(value = "file",required = false) MultipartFile file){
        Boolean b = service.supplierPushSell(request,file);
        return CommonResponse.success("推送报价信息成功！",b);
    }


    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentVO> publishDocument(@RequestParam Long id) throws Exception {
    	return CommonResponse.success("发布成功！",service.publishDocument(id));
    }
    @ApiOperation("答疑附件上传同步供方新增接口")
    @RequestMapping(value = "/uploadById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> uploadById(@RequestParam Long attachId,@RequestParam Long inviteId) throws Exception {
    	return CommonResponse.success("同步成功！",service.uploadById(attachId,inviteId));
    }
    @ApiOperation("答疑附件删除同步供方接口")
    @RequestMapping(value = "/deleteFileById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteFileById(@RequestBody SubDocumentVO subDocumentVO) throws Exception {
    	return CommonResponse.success("删除成功！",service.deleteFileById(subDocumentVO.getSourceId(),subDocumentVO.getFileNames()));
    }
    @ApiOperation("竞争性谈判等发布接口")
    @RequestMapping(value = "/publishManyDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentVO> publish4Document(@RequestParam Long id) throws InvocationTargetException, IllegalAccessException {
        return CommonResponse.success("发布成功！",service.publishManyDocument(id));
    }
    @ApiOperation("根据供应商主键和方案主键查询详情接口")
    @RequestMapping(value = "/getSchemeDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SubDocumentSellVO>> getSchemeDetail(@RequestBody SubDocumentSellVO subDocumentSellVO) {
        List<SubDocumentSellVO> list = service.getSchemeDetail(subDocumentSellVO);
    	return CommonResponse.success("查询成功！",list);
    }
    @ApiOperation("开标接口")
    @RequestMapping(value = "/bidDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentVO> bidDocument(@RequestParam Long id) {
        SubDocumentVO s = service.bidDocument(id);
    	return CommonResponse.success("开标成功！",s);
    }
    @ApiOperation("延长截止时间接口")
    @RequestMapping(value = "/extendDocument", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubDocumentVO> extendDocument(@RequestBody SubDocumentRecordVO subDocumentRecordVO) {
    	return CommonResponse.success("延长截止时间！",service.extendDocument(subDocumentRecordVO));
    }
    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/delSupplier", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse delSupplier(@RequestParam Long id) {
        return service.delSupplier(id);
    }
    @ApiOperation("查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentSupplierSellVO> getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        SubDocumentSupplierSellVO subDocumentSupplierSellVO = service.getSupplierSchemeDetail(supplierDetailId,documentId);
    	return CommonResponse.success("开标成功！",subDocumentSupplierSellVO);
    }
    @ApiOperation("定标中查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetailDb", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentSupplierSellVO> getSupplierSchemeDetailDb(Long schemeId,Long documentId) {
        SubDocumentSupplierSellVO subDocumentSupplierSellVO = service.getSupplierSchemeDetailDb(schemeId,documentId);
    	return CommonResponse.success("开标成功！",subDocumentSupplierSellVO);
    }
    @ApiOperation("洽商谈判查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetailTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentSupplierSellVO> getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        SubDocumentSupplierSellVO subDocumentSupplierSellVO = service.getSupplierSchemeDetailTalk(supplierDetailId,talkId);
    	return CommonResponse.success("开标成功！",subDocumentSupplierSellVO);
    }
    @ApiOperation("洽商谈判供应商方案详情接口(多轮显示)")
    @RequestMapping(value = "/getSupplierSchemeTalkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentSupplierSellVO> getSupplierSchemeTalkDetail(Long supplierDetailId,Long talkId) {
        SubDocumentSupplierSellVO subDocumentSupplierSellVO = service.getSupplierSchemeTalkDetail(supplierDetailId,talkId);
    	return CommonResponse.success("开标成功！",subDocumentSupplierSellVO);
    }
    @ApiOperation("招标公告下一步接口")
    @RequestMapping(value = "/saveDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentVO> saveDocument(@RequestParam Long noticeId) {
        SubDocumentVO subDocumentVO = service.saveDocument(noticeId);
    	return CommonResponse.success("保存或修改单据成功！",subDocumentVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentVO> queryDetail(@RequestParam Long id) {
        SubDocumentVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubDocumentVO> vos) {
        service.removeByIds(vos.stream().map(SubDocumentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubDocumentVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubDocumentEntity> page = service.queryPage(param,false);
        IPage<SubDocumentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubDocumentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubDocumentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubDocument-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSubDocumentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubDocumentVO>> refSubDocumentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubDocumentEntity> page = service.queryPage(param,false);
        IPage<SubDocumentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubDocumentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("竞争性谈判等下一步接口")
    @RequestMapping(value = "/saveManyDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentVO> saveManyDocument(@RequestParam Long id) {
        SubDocumentEntity subDocumentEntity = new SubDocumentEntity();
        if(subDocumentEntity.getId() == null || subDocumentEntity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                subDocumentEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        SubDocumentVO vo = service.saveManyDocument(id);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("查询供应商主键ID")
    @RequestMapping(value = "/querySupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDocumentSupplierEntity> querySupplierId(@RequestParam Long supplierId, @RequestParam Long talkId) {
        SubTalkEntity subTalkEntity = talkService.selectById(talkId);
        List<SubDocumentSupplierEntity> list = documentSupplierService.list(new QueryWrapper<SubDocumentSupplierEntity>().eq("supplier_id", supplierId).eq("document_id", subTalkEntity.getBillId()));
        return CommonResponse.success("保存或修改单据成功！",list.get(0));
    }
}
