package com.ejianc.business.tender.sub.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.sub.bean.SubNoticeEntity;
import com.ejianc.business.tender.sub.bean.SubNoticeSupplierEntity;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sub/subNotice")
@Api(value = "招标公告主表", tags = {"招标公告主表"})
public class SubNoticeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-notice-code";;//此处需要根据实际修改

    @Autowired
    private ISubNoticeService service;

    @Autowired
    private ISubInviteService inviteService;

    @Autowired
    private ISubInviteDetailService inviteDetailService;

    @Autowired
    private ISubInviteDetailRecordService inviteDetailRecordService;

    @Autowired
    private ISubNoticeDetailService noticeDetailService;

    @Autowired
    private IProcessService processSerice;

    @Autowired
    private ISubNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private ISubInviteSupplierService inviteSupplierService;

    @Autowired
    private ISubNoticeSupplierService noticeSupplierService;

    @Autowired
    private ISubNoticeChangeService changeService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IAttachmentApi attachmentApi;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubNoticeVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SubNoticeVO saveorUpdateVO) {
    	SubNoticeEntity entity = BeanMapper.map(saveorUpdateVO, SubNoticeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        //保存前清空主键和父主键，重新生成
//        List<SubNoticeDetailEntity> detailList = entity.getNoticeDetail();
//        if(CollectionUtils.isNotEmpty(detailList)){
//            Map<String,Long> idMap=new HashMap<>();
//            for(SubNoticeDetailEntity cdEntity : detailList){
//                if (cdEntity.getId() == null){
//                    cdEntity.setId(com.baomidou.mybatisplus.core.toolkit.IdWorker.getId());
//                }
//                idMap.put(cdEntity.getTid(),cdEntity.getId());
//                cdEntity.setParentId(null);
//            }
//            for(SubNoticeDetailEntity cdEntity : detailList){
//                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
//                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
//                }
//            }
//        }

    	service.saveOrUpdate(entity, false);
    	SubNoticeVO vo = BeanMapper.map(entity, SubNoticeVO.class);

//        //保存招标过程记录表
//        ProcessEntity processEntity = new ProcessEntity();
//        processEntity.setBillId(entity.getId());
//        processEntity.setBillName(entity.getNoticeName());
//        processEntity.setTenderId(entity.getId());
//        processEntity.setType(1);
//        processEntity.setFrontendUrl("sub/invite/card");
//        processSerice.saveOrUpdate(processEntity);
    	return CommonResponse.success("保存或修改单据成功！",queryDetail(vo.getId()).getData());
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubNoticeVO> queryDetail(@RequestParam Long id) {
        SubNoticeEntity subNoticeEntity = service.selectById(id);
        SubNoticeVO vo = BeanMapper.map(subNoticeEntity, SubNoticeVO.class);
        SubInviteVO subInviteVO = inviteService.queryDetailTree(vo.getInviteId());
        List<SubNoticeDetailVO> noticeDetailEntityList = BeanMapper.mapList(subInviteVO.getSubDetailRecord(), SubNoticeDetailVO.class);
        vo.setNoticeDetail(noticeDetailEntityList);
        //处理供应商附件信息
        if (!service.selectFile(vo)){
            CommonResponse.success("供应商附件查询失败！");
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubNoticeVO> vos) {
        service.removeByIds(vos.stream().map(SubNoticeVO::getId).collect(Collectors.toList()),true);
        processSerice.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId,vos.stream().map(SubNoticeVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubNoticeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubNoticeEntity> page = service.queryPage(param,false);
        IPage<SubNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubNoticeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubNoticeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubNotice-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSubNoticeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubNoticeVO>> refSubNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubNoticeEntity> page = service.queryPage(param,false);
        IPage<SubNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubNoticeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("点击下一步进行下个页面数据初始化")
    @RequestMapping(value = "/nextStep", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubNoticeEntity> nextStep(String id) throws InvocationTargetException, IllegalAccessException {
        //主表赋值
        SubInviteEntity subInviteEntity = inviteService.selectById(id);
        SubNoticeEntity subNoticeEntity = new SubNoticeEntity();
        BeanUtils.copyProperties(subNoticeEntity, subInviteEntity);
        subNoticeEntity.setNoticeName(subInviteEntity.getTenderName());
        subNoticeEntity.setInviteId(subInviteEntity.getId());
        subNoticeEntity.setId(null);
        subNoticeEntity.setCreateTime(null);
        subNoticeEntity.setUpdateTime(null);
        subNoticeEntity.setBillCode(null);
        subNoticeEntity.setBillState(null);
        subNoticeEntity.setCreateUserCode(null);
        subNoticeEntity.setUpdateUserCode(null);
        subNoticeEntity.setSyncEsFlag(null);
        subNoticeEntity.setVersion(null);
        subNoticeEntity.setTenantId(null);
        subNoticeEntity.setMemo(null);
        subNoticeEntity.setEmployeeId(null);
        subNoticeEntity.setEmployeeName(null);
        subNoticeEntity.setNoticeName(subInviteEntity.getTenderName());
        service.saveOrUpdate(subNoticeEntity);
        //子表赋值
        List<SubInviteDetailRecordEntity> subInviteDetailList = inviteDetailRecordService.list(new LambdaQueryWrapper<SubInviteDetailRecordEntity>().eq(SubInviteDetailRecordEntity::getInviteId,id).eq(SubInviteDetailRecordEntity::getDr,0));
        SubNoticeDetailEntity subNoticeDetailEntity = new SubNoticeDetailEntity();
        if (CollectionUtil.isNotEmpty(subInviteDetailList)){
//            //保存前清空主键和父主键，重新生成
//            Map<String,Long> idMap=new HashMap<>();
//            for(SubInviteDetailRecordEntity cdEntity : subInviteDetailList){
//                if (cdEntity.getId() == null){
//                    cdEntity.setId(com.baomidou.mybatisplus.core.toolkit.IdWorker.getId());
//                }
//                idMap.put(cdEntity.getTid(),cdEntity.getId());
//                cdEntity.setParentId(null);
//            }
//            for(SubInviteDetailRecordEntity cdEntity : subInviteDetailList){
//                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
//                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
//                }
//            }
            for (SubInviteDetailRecordEntity subInviteDetailEntity : subInviteDetailList) {
                BeanUtils.copyProperties(subNoticeDetailEntity, subInviteDetailEntity);
                subNoticeDetailEntity.setNoticeId(subNoticeEntity.getId());
//                subNoticeDetailEntity.setId(null);
                subNoticeDetailEntity.setCreateTime(null);
                subNoticeDetailEntity.setUpdateTime(null);
                subNoticeDetailEntity.setCreateUserCode(null);
                subNoticeDetailEntity.setUpdateUserCode(null);
                subNoticeDetailEntity.setSyncEsFlag(null);
                subNoticeDetailEntity.setVersion(null);
                subNoticeDetailEntity.setTenantId(null);
                noticeDetailService.saveOrUpdate(subNoticeDetailEntity);
            }
        }
        //供应商
        List<SubInviteSupplierEntity> subInviteSupplierList = inviteSupplierService.list(new LambdaQueryWrapper<SubInviteSupplierEntity>().eq(SubInviteSupplierEntity::getInviteId, id).eq(SubInviteSupplierEntity::getDr, 0));
        SubNoticeSupplierDetailEntity subNoticeSupplierDetailEntity = new SubNoticeSupplierDetailEntity();
        if (CollectionUtil.isNotEmpty(subInviteSupplierList)){
            for (SubInviteSupplierEntity subInviteSupplierEntity : subInviteSupplierList) {
                BeanUtils.copyProperties(subNoticeSupplierDetailEntity, subInviteSupplierEntity);
                subNoticeSupplierDetailEntity.setInviteId(subNoticeEntity.getInviteId());
                subNoticeSupplierDetailEntity.setCreateTime(null);
                subNoticeSupplierDetailEntity.setUpdateTime(null);
                subNoticeSupplierDetailEntity.setCreateUserCode(null);
                subNoticeSupplierDetailEntity.setUpdateUserCode(null);
                subNoticeSupplierDetailEntity.setSyncEsFlag(null);
                subNoticeSupplierDetailEntity.setVersion(null);
                subNoticeSupplierDetailEntity.setTenantId(null);
                noticeSupplierDetailService.saveOrUpdate(subNoticeSupplierDetailEntity);
            }
        }
        //回写招标阶段
        Integer tenderStage = 2;
        inviteService.updateTenderStage(id,tenderStage);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(subNoticeEntity.getId());
        processEntity.setBillName("招标公告");
        processEntity.setTenderId(subNoticeEntity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/notice");
        processSerice.saveOrUpdate(processEntity);
        return CommonResponse.success("初始化数据成功", subNoticeEntity);
    }
    @ApiOperation("延长截止时间")
    @RequestMapping(value = "/extend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse extend(@RequestBody SubNoticeChangeEntity subNoticeChangeEntity) {
        service.updateEndTime(subNoticeChangeEntity.getNoticeId(), subNoticeChangeEntity.getNewTime());
        SubNoticeEntity subNoticeEntity = service.selectById(subNoticeChangeEntity.getNoticeId());
        //调用第三方报名接口
        Map<String, Object> map = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("sourceId", subNoticeEntity.getInviteId());
        map.put("noticeEndTime",sdf.format(subNoticeChangeEntity.getNewTime()));
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, JSON.toJSONString(map), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        changeService.saveOrUpdate(subNoticeChangeEntity);

        //更新招标截止时间
        SubInviteEntity inviteEntity = inviteService.selectById(subNoticeEntity.getInviteId());
        inviteEntity.setStopTime(subNoticeChangeEntity.getNewTime());
        inviteService.saveOrUpdate(inviteEntity);
        return CommonResponse.success("延长截止时间成功！");
    }

    @ApiOperation("发布公告")
    @RequestMapping(value = "/publish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse publish(@RequestBody SubNoticeVO subNoticeVO) throws InvocationTargetException, IllegalAccessException {
        return service.publish(subNoticeVO);
    }
    @ApiOperation("报名情况")
    @RequestMapping(value = "/signUp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> signUp(HttpServletRequest request) {
        logger.info("进入报名接口request-{},file-{}", request);
        String notice = request.getParameter("bmNoticeVO");
        logger.info("报名实体信息-{}",notice);
        SubNoticeSupplierVO subNoticeSupplierVO = JSON.parseObject(notice, new TypeReference<SubNoticeSupplierVO>() { });

        SubNoticeSupplierEntity subNoticeSupplierEntity = BeanMapper.map(subNoticeSupplierVO, SubNoticeSupplierEntity.class);
        subNoticeSupplierEntity.setNoticeId(service.selectNotice(subNoticeSupplierVO.getSourceId()));
        subNoticeSupplierEntity.setSourceSupplierTenantId(subNoticeSupplierVO.getTenantId().toString());
        subNoticeSupplierEntity.setSupplierId(Long.valueOf(subNoticeSupplierVO.getSourceSupplierId()));
        SupplierDTO supplierVO = shareSupplierApi.queryById(Long.valueOf(subNoticeSupplierVO.getSourceSupplierId())).getData();
        logger.info("供应商Id-{}",subNoticeSupplierVO.getSourceSupplierId());
        logger.info("供应商信息-{}",JSONObject.toJSONString(supplierVO));
        subNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        subNoticeSupplierEntity.setSupplierEmployeeId(subNoticeSupplierVO.getEmployeeId());
        subNoticeSupplierEntity.setSupplierEmployeeName(subNoticeSupplierVO.getEmployeeName());
        subNoticeSupplierEntity.setSupplierEmployeeMobile(subNoticeSupplierVO.getEmployeeMobile());
        subNoticeSupplierEntity.setId(null);
        subNoticeSupplierEntity.setState(0);
        //查询是否已经报名
        LambdaQueryWrapper<SubNoticeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SubNoticeEntity::getInviteId, subNoticeSupplierVO.getSourceId());
        List<SubNoticeEntity> noticeEntityList = service.list(queryWrapper);
        LambdaQueryWrapper<SubNoticeSupplierEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SubNoticeSupplierEntity::getSourceSupplierId, subNoticeSupplierVO.getSourceSupplierId())
                .eq(SubNoticeSupplierEntity::getNoticeId, noticeEntityList.get(0).getId())
                .eq(SubNoticeSupplierEntity::getDr, 0);
        List<SubNoticeSupplierEntity> supplierEntityList = noticeSupplierService.list(lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty(supplierEntityList)) {
            noticeSupplierService.removeById(supplierEntityList.get(0).getId());
        }
        boolean b = noticeSupplierService.saveOrUpdate(subNoticeSupplierEntity);
        //处理附件
        List<SupplyFileVo> pzList = subNoticeSupplierVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            pzList.forEach(e->{
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(subNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            });
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
//        //删除之前附件
//        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
//                .queryListBySourceId(subNoticeSupplierEntity.getId(), BILL_SUPPLIER_TYPE, "BmSupplierFileType", null);
//        // 查询成功并有相应的文件
//        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
//            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
//            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
//                    .collect(Collectors.joining(","));
//            attachmentApi.delete(ids);
//        }
////        logger.info(request + "报名文件名称- {}" + file.getOriginalFilename());
////        Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"BmSupplierFileType",Long.toString(subNoticeSupplierEntity.getId()),BILL_SUPPLIER_TYPE,file,request);
////        logger.info(request+"报名文件上传结果-{}",upFlag);
//        String authority = request.getHeader("authority");
//        String nameSourceTypeMapping = request.getParameter("fileSourceType");
//        Map mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
//        FileUtil.getInstance()
//                .handleReqFile((MultipartHttpServletRequest) request, mp, BILL_SUPPLIER_TYPE, authority, Long.toString(subNoticeSupplierEntity.getId()));

        return CommonResponse.success("报名情况接口掉用成功",b);
    }

    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/deleteSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse deleteSupplier(@RequestBody SubNoticeSupplierVO subNoticeSupplierVO) {
        List<SubNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
        SubNoticeEntity subNoticeEntity = service.selectById(subNoticeSupplierVO.getNoticeId());
        SubNoticeSupplierDetailTbVO SubNoticeSupplierDetailTbVO = new SubNoticeSupplierDetailTbVO();
        SubNoticeSupplierDetailTbVO.setSourceId(subNoticeEntity.getInviteId().toString());
        SubNoticeSupplierDetailTbVO.setTenantId(subNoticeSupplierVO.getTenantId());
        SubNoticeSupplierDetailTbVO.setSourceSupplierId(subNoticeSupplierVO.getSupplierId().toString());
        SubNoticeSupplierDetailTbVO.setOutReason(subNoticeSupplierVO.getOutReason()==null?"超时未报名":subNoticeSupplierVO.getOutReason());
        supplierDetailTbVOList.add(SubNoticeSupplierDetailTbVO);

        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateSupStatusUrl, RequestMethod.POST, JSON.toJSONString(supplierDetailTbVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        //更新供应商状态
        noticeSupplierService.updateState(subNoticeSupplierVO.getId());
        return CommonResponse.success("剔除供应商成功");
    }

}
