package com.ejianc.business.tender.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.ISubDocumentSellService;
import com.ejianc.business.tender.sub.service.ISubInviteDetailBidderService;
import com.ejianc.business.tender.sub.service.ISubPicketageService;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageEntity;
import com.ejianc.business.tender.sub.service.ISubPicketageRefsupplierService;
import com.ejianc.business.tender.sub.bean.SubPicketageRefsupplierEntity;
import com.ejianc.business.tender.sub.service.impl.SubInviteServiceImpl;
import com.ejianc.business.tender.sub.service.impl.SubPicketageBpmServiceImpl;
import com.ejianc.business.tender.sub.service.impl.SubPicketageServiceImpl;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubPicketageRefsupplierVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 *
 * @author generator
 */
@Controller
@RequestMapping("subPicketageRefsupplier")
@Api(value = "定标供应商参照表(下游单据使用)", tags = {"定标供应商参照表(下游单据使用)"})
public class SubPicketageRefsupplierController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SubPicketageBpmServiceImpl subPicketageBpmService;
    @Autowired
    private SubInviteServiceImpl inviteService;
    @Autowired
    private SubPicketageServiceImpl picketageService;
    @Autowired
    private ISubPicketageService subPicketageService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISubInviteDetailBidderService subInviteDetailBidderService;

    @Autowired
    private IShareSupplierApi supplierApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubPicketageRefsupplierService service;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubPicketageRefsupplierVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody SubPicketageRefsupplierVO saveOrUpdateVO) {
        SubPicketageRefsupplierEntity entity = BeanMapper.map(saveOrUpdateVO, SubPicketageRefsupplierEntity.class);
        service.saveOrUpdate(entity, false);
        SubPicketageRefsupplierVO vo = BeanMapper.map(entity, SubPicketageRefsupplierVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubPicketageRefsupplierVO> queryDetail(@RequestParam Long id) {
        SubPicketageRefsupplierEntity entity = service.selectById(id);
        SubPicketageRefsupplierVO vo = BeanMapper.map(entity, SubPicketageRefsupplierVO.class);
        if(0==entity.getPicketageFlag()){
            SubPicketageEntity subPicketageEntity = subPicketageService.selectById(entity.getPicketageId());
            vo.setInviteId(subPicketageEntity.getInviteId());
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSubsupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubPicketageRefsupplierVO>> refSubsupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("picketageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //未占用状态
//        param.getParams().put("occupyFlag", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("picketageDate",QueryParam.DESC);
        //查询本下范围内日的合同
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        if(CollectionUtils.isNotEmpty(orgVOList)) {
            List<Long> ids = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, ids));
        }
        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(TenderSignStatusEnum.未签订.getCode());
        listStatus.add(TenderSignStatusEnum.部分签订.getCode());

        param.getParams().put("signStatus", new Parameter(QueryParam.IN, listStatus));
        IPage<SubPicketageRefsupplierEntity> page = service.queryPage(param, false);
        List<SubPicketageRefsupplierEntity> records = page.getRecords();
        if (StringUtils.isNotEmpty(condition)) {
            List<SubPicketageRefsupplierEntity> newRecord = new ArrayList<>(records);
            records.clear();
            /** 处理condition */
            JSONObject conditionJson = JSONObject.parseObject(condition);
            Integer type = conditionJson.getInteger("subType");
            Long subType = null;
            SubInviteEntity sub = null;
            if (type == 0) {
                subType = 1471313836879101953L;

                for (SubPicketageRefsupplierEntity record : newRecord) {
                    if (record.getPicketageFlag() == 0) {
                        SubPicketageEntity subPicketageEntity = picketageService.selectById(record.getPicketageId());
                        sub= inviteService.selectById(subPicketageEntity.getInviteId());
                        if (subType.equals(sub.getSubType())) {
                            record.setSubType(sub.getSubType());
                            records.add(record);
                        }
                    }
                    else {
                        sub = inviteService.selectById(record.getPicketageId());
                        if (subType.equals(sub.getSubType())) {
                            record.setSubType(sub.getSubType());
                            records.add(record);
                        }
                    }
                }
            }
            else {
                subType = 1471313685275983873L;
                Long subt = 3L;
                for (SubPicketageRefsupplierEntity record : newRecord) {
                    if (record.getPicketageFlag() == 0) {
                        SubPicketageEntity subPicketageEntity = picketageService.selectById(record.getPicketageId());
                        Long stype = inviteService.selectById(subPicketageEntity.getInviteId()).getSubType();
                        // edit by sunyj 20230208  分包类型增加 "机械承揽" 同"劳务分包"功能一样
                        if (subType.equals(stype)|| subt.equals(stype)) {
                            record.setSubType(stype);
                            records.add(record);
                        }
                    }
                    else {
                        SubInviteEntity subInviteEntity = inviteService.selectById(record.getPicketageId());
                        if (subType.equals(subInviteEntity.getSubType())|| subt.equals(subInviteEntity.getSubType())) {
                            record.setSubType(subInviteEntity.getSubType());
                            records.add(record);
                        }
                    }
                }
            }
        }

        if (CollectionUtils.isNotEmpty(records)) {
            List<Long> supplierIdList = records.stream().distinct().map(SubPicketageRefsupplierEntity::getSupplierId).collect(Collectors.toList());
            logger.info("supplierIdList:{}", JSONObject.toJSONString(supplierIdList));
            CommonResponse<List<SupplierDTO>> listCommonResponse = supplierApi.querySupplierDTOByIds(supplierIdList);
            Map<Long, String> supplierMap = new HashMap<>();
            if (listCommonResponse.isSuccess()){
                List<SupplierDTO> supplierVOList = listCommonResponse.getData();
                logger.info("supplierVOList:{}", JSONObject.toJSONString(supplierVOList));
                supplierMap = supplierVOList.stream().collect(Collectors.toMap(SupplierDTO::getId, SupplierDTO::getName));
            }else {
                throw new BusinessException("获取项目信息失败，失败原因：" + listCommonResponse.getMsg());
            }

            for (SubPicketageRefsupplierEntity subPicketageRefsupplierEntity : records) {
                if (supplierMap.containsKey(subPicketageRefsupplierEntity.getSupplierId())){
                    subPicketageRefsupplierEntity.setSupplierName(supplierMap.get(subPicketageRefsupplierEntity.getSupplierId()));
                }
                if (subPicketageRefsupplierEntity.getPurchaseType() == 0) {
//                    (0-项目采购,1-单位采购)
                    subPicketageRefsupplierEntity.setPurchaseTypeName("项目采购");
                }
                if (subPicketageRefsupplierEntity.getPurchaseType() == 1) {
//                    (0-项目采购,1-单位采购)
                    subPicketageRefsupplierEntity.setPurchaseTypeName("公司采购");
                }

            }

        }
        page.setRecords(records);
        page.setTotal(records.size());
        IPage<SubPicketageRefsupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubPicketageRefsupplierVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("定标子表参照")
    @RequestMapping(value = "/refSubDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubDocumentSellVO>> refSubDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long id = null;

        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("id")) {
                id = Long.valueOf(conditionMap.get("id").toString());
            }
        }
        SubPicketageRefsupplierEntity subPicketageRefsupplierEntity = service.selectById(id);
        Integer picketageFlag = subPicketageRefsupplierEntity.getPicketageFlag();
        //定标类型0-流程定标,1-直接定标  区分数据源
        if (picketageFlag == 0) {
            SubPicketageEntity subPicketageEntity = subPicketageService.selectById(subPicketageRefsupplierEntity.getPicketageId());
            param.getParams().put("documentId", new Parameter(QueryParam.EQ, subPicketageEntity.getDocumentId()));
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, subPicketageRefsupplierEntity.getSupplierId()));
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, subPicketageRefsupplierEntity.getProjectId()));
            param.getParams().put("tenderFlag", new Parameter(QueryParam.EQ, 1));
            param.getParams().put("nums", new Parameter(QueryParam.SQL, "ifnull(sign_num,0) < tender_num"));
            IPage<SubDocumentSellEntity> page = subDocumentSellService.queryPage(param, false);
            IPage<SubDocumentSellVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<SubDocumentSellVO> subDocumentSellVOList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(page.getRecords())) {
                subDocumentSellVOList = BeanMapper.mapList(page.getRecords(), SubDocumentSellVO.class);
                for (SubDocumentSellVO subDocumentSellVO : subDocumentSellVOList) {
                    BigDecimal tenderNum = subDocumentSellVO.getTenderNum();
                    BigDecimal signNum = subDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : subDocumentSellVO.getSignNum();
                    subDocumentSellVO.setSurplusNum(tenderNum.subtract(signNum));
                }

            }
            pageData.setRecords(subDocumentSellVOList);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }

        if (picketageFlag == 1) {
            List<SubDocumentSellVO> subDocumentSellVOS = new ArrayList<>();
            List<SubInviteDetailBidderEntity> bidderEntityList1 = inviteService.selectById(subPicketageRefsupplierEntity.getPicketageId()).getSubDetailBidder();
            List<SubInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t->t.getNum()!=null).filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            for (SubInviteDetailBidderEntity bidderEntity : bidderEntityList1) {
                if (bidderEntity.getNum()==null){
                    bidderEntityList.add(bidderEntity);
                }
            }
            List<SubInviteDetailBidderVO> subDetailBidder = BeanMapper.mapList(bidderEntityList, SubInviteDetailBidderVO.class);
            for (SubInviteDetailBidderVO bidderEntity : subDetailBidder) {
                SubDocumentSellVO subDocumentSellVO = new SubDocumentSellVO();
                subDocumentSellVO.setTreeIndex(bidderEntity.getTreeIndex());
                subDocumentSellVO.setParentId(bidderEntity.getParentId());
                subDocumentSellVO.setChildren(bidderEntity.getChildren());
                subDocumentSellVO.setContent(bidderEntity.getContent());
                subDocumentSellVO.setRule(bidderEntity.getRule());
                subDocumentSellVO.setMaterialId(bidderEntity.getDocId());
                subDocumentSellVO.setMaterialTypeId(bidderEntity.getDocCategoryId());
                subDocumentSellVO.setMaterialCode(bidderEntity.getDetailCode());
                subDocumentSellVO.setMaterialName(bidderEntity.getDetailName());
                subDocumentSellVO.setUnit(bidderEntity.getUnit());
                subDocumentSellVO.setTenderNum(bidderEntity.getNum());
                subDocumentSellVO.setRate(bidderEntity.getTaxRate());
                subDocumentSellVO.setMemo(bidderEntity.getMemo());
                subDocumentSellVO.setPrice(bidderEntity.getPrice());
                subDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                subDocumentSellVO.setTenderMoney(bidderEntity.getMny());
                subDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMny());
                subDocumentSellVO.setSellTax(bidderEntity.getTax());
                if (bidderEntity.getNum()!=null){
                    subDocumentSellVO.setSignNum(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum());
                    subDocumentSellVO.setSurplusNum(bidderEntity.getNum().subtract(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum()));
                }
                subDocumentSellVOS.add(subDocumentSellVO);
            }
            IPage<SubDocumentSellVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), subDocumentSellVOS.size());
            // 进行分页处理
            pageDate.setRecords(subDocumentSellVOS.stream().skip((long) (param.getPageIndex() - 1) * param.getPageSize())
                    .limit(param.getPageSize()).collect(Collectors.toList()));
            return CommonResponse.success("查询参照数据成功！", pageDate);
        }
        return null;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
