package com.ejianc.business.tender.sub.mapper;

import com.ejianc.business.tender.sub.bean.SubInviteDetailEntity;
import com.ejianc.business.tender.sub.bean.SubInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface SubInviteMapper extends BaseCrudMapper<SubInviteEntity> {
    @Update("UPDATE ejc_tender_sub_invite SET tender_stage = #{tenderStage} WHERE id = #{id} ")
    void updateTenderStage(String id, int tenderStage);
    @Update("UPDATE ejc_tender_sub_invite SET abolish_type = #{abolishType} WHERE id = #{id} ")
    void updateAbolishType(String id, int abolishType);
    @Select("SELECT * FROM `ejc_tender_sub_invite_detail_record` where invite_id = #{inviteId} and dr = 0 and id not in " +
            "(SELECT parent_id FROM `ejc_tender_sub_invite_detail_record`  where  invite_id = #{inviteId} and  parent_id is not null)")
    List<SubInviteDetailEntity> selectSumDetail(Long inviteId);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money  FROM `ejc_tender_sub_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr =0 GROUP BY material_id ,material_type_id,rate,calculate_type")
    List<SubInviteDetailVO> selectOrgSumDetail(Long inviteId);
    @Select("SELECT sum(mny) sum_money ,sum(tax_mny) sum_tax_money ,sum(num) sum_num FROM `ejc_tender_sub_invite_detail_bidder` where invite_id = #{inviteId} and dr = 0 and id not in " +
            "(SELECT parent_id FROM `ejc_tender_sub_invite_detail_bidder`  where  invite_id = #{inviteId} and  parent_id is not null)")
    List<SubInviteDetailBidderVO> selectDetailBidder(Long inviteId);
    @Select("SELECT * FROM `ejc_tender_sub_invite_detail_record` where invite_id = #{inviteId} and dr = 0 and id not in " +
            "(SELECT parent_id FROM `ejc_tender_sub_invite_detail_record` where  invite_id = #{inviteId} and  parent_id is not null) ORDER BY tree_index ")
    List<SubInviteDetailBidderVO> querySonDetail(Long inviteId);

    List<SubInviteDetailRecordEntity> selectDetailByProjectId(@Param(value = "projectId") Long projectId,
                                                              @Param(value = "docIdList") List<Long> docIdList,
                                                              @Param(value = "subType") Integer subType);

}
