package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.bean.StuffAdviceEntity;
import com.ejianc.business.tender.stuff.bean.StuffBidEntity;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.stuff.service.IStuffBidService;
import com.ejianc.business.tender.stuff.vo.StuffAdviceVO;
import com.ejianc.business.tender.sub.bean.SubAdviceEntity;
import com.ejianc.business.tender.sub.bean.SubBidEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubBidService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubAdviceSupplierPushVO;
import com.ejianc.business.tender.sub.vo.SubAdviceVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.sub.mapper.SubAdviceMapper;
import com.ejianc.business.tender.sub.bean.SubAdviceEntity;
import com.ejianc.business.tender.sub.service.ISubAdviceService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包-中标通知书
 * 
 * @author generator
 * 
 */
@Service("subAdviceService")
public class SubAdviceServiceImpl extends BaseServiceImpl<SubAdviceMapper, SubAdviceEntity> implements ISubAdviceService{
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000006";//此处需要根据实际修改
    @Autowired
    private ISubBidService subBidService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
//        1,5678, -0, 23 - 1, 4 -2
        SubAdviceEntity subAdviceEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            subAdviceEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            subAdviceEntity.setSignFlag(1);
        }
        if(status == 4){
            subAdviceEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(subAdviceEntity.getId());
            cv.setContractName(subAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(subAdviceEntity);

        return CommonResponse.success("更新成功!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        SubAdviceEntity subAdviceEntity = super.selectById(id);
        subAdviceEntity.setSendFlag(0);
        super.updateById(subAdviceEntity);
        SubInviteEntity subInviteEntity = subInviteService.selectById(subAdviceEntity.getInviteId());
        SubAdviceSupplierPushVO subAdviceSupplierPushVO = BeanMapper.map(subAdviceEntity, SubAdviceSupplierPushVO.class);

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        subAdviceSupplierPushVO.setSystemId(ejcCloudSystemCode.getData());
        subAdviceSupplierPushVO.setSourceType("云南建投分包中标通知书");
        subAdviceSupplierPushVO.setSourceId(subAdviceEntity.getId().toString());
        subAdviceSupplierPushVO.setBidTitle(subAdviceEntity.getTitleName());
        subAdviceSupplierPushVO.setSourceProjectId(subAdviceEntity.getProjectId() != null ? subAdviceEntity.getProjectId().toString() : null);
        subAdviceSupplierPushVO.setSourceOrgId(subAdviceEntity.getOrgId().toString());
        subAdviceSupplierPushVO.setSourceUnitId(subAdviceEntity.getUnitId().toString());
//        subAdviceSupplierPushVO.setType("TYPE_SUB");
        subAdviceSupplierPushVO.setType(CommonUtils.getGysType(CommonUtils.TYPE_SUB));
        subAdviceSupplierPushVO.setTenderType(subInviteEntity.getTenderType());
        subAdviceSupplierPushVO.setBidDate(subAdviceEntity.getNoticeDate());
        subAdviceSupplierPushVO.setMoney(subAdviceEntity.getMoney());
        subAdviceSupplierPushVO.setMoneyTax(subAdviceEntity.getMoneyTax());

        String dataInfo = JSONObject.toJSONString(subAdviceSupplierPushVO);

        boolean b = stuffAdviceService.pushBillToSupCenter(dataInfo, subAdviceEntity.getSupplierId(), subAdviceEntity.getId(),
                BILL_TYPE, PUSH_ADVICE_SERVER_URL,subAdviceEntity.getTitleName());
        if (!b){
            throw new BusinessException("推送供方失败!");
        }
        return null;
    }

    @Override
    public List<SubAdviceVO> queryAdviceList(Long id) {
        SubBidEntity subBidEntity = subBidService.selectById(id);
        LambdaQueryWrapper<SubAdviceEntity> lambdaAdvice = Wrappers.<SubAdviceEntity>lambdaQuery();
        lambdaAdvice.eq(SubAdviceEntity::getInviteId, subBidEntity.getInviteId());
        List<SubAdviceEntity> list = super.list(lambdaAdvice);
        List<SubAdviceVO> subAdviceVOS = BeanMapper.mapList(list, SubAdviceVO.class);
        //处理签章附件信息
        if (CollectionUtils.isNotEmpty(subAdviceVOS)) {
            List<Long> attachIds = subAdviceVOS.stream().map(SubAdviceVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    for (SubAdviceVO subAdviceVO : subAdviceVOS) {
                        AttachmentVO attachmentVO = attacMap.get(subAdviceVO.getId());
                        if (attachmentVO != null) {
                            subAdviceVO.setAttachId(attachmentVO.getId());
                            subAdviceVO.setFileName(attachmentVO.getFileName());
                            subAdviceVO.setFilePath(attachmentVO.getFilePath());
                        }
                    }
                }
            }
        }
        return subAdviceVOS;
    }
}
