package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.enums.DraftTypeEnum;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.bean.SubInviteDetailEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageRefsupplierEntity;
import com.ejianc.business.tender.sub.service.ISubInviteDetailService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.service.ISubPicketageRefsupplierService;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Service("subInvite") 
public class SubInviteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private ISubInviteService service;

	@Autowired
	private ISubInviteDetailService detailService;

	@Autowired
	private ISubPicketageRefsupplierService picketageRefsupplierService;
	

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SubInviteEntity subInviteEntity = service.selectById(billId);
		if(0==subInviteEntity.getEstablishType()){
			if(DraftTypeEnum.线上起草.getCode().toString().equals(subInviteEntity.getDraftType().toString())) {
				if(null == subInviteEntity.getContractFileId()) {
					//确保线上起草方式时，用户已编辑合同文件
					return CommonResponse.error("请编辑招标文件并保存后再执行此操作！");
				}
				if(!subInviteEntity.getContractFileSyncFlag()) {
					return CommonResponse.error("请重新进行招标文件编辑，同步单据信息到招标文件！");
				}
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SubInviteEntity subInviteEntity = service.selectById(billId);
		if(0==subInviteEntity.getEstablishType()){
			if(DraftTypeEnum.线上起草.getCode().toString().equals(subInviteEntity.getDraftType().toString())) {
				if(null == subInviteEntity.getContractFileId()) {
					//确保线上起草方式时，用户已编辑合同文件
					return CommonResponse.error("请编辑招标文件并保存后再执行此操作！");
				}
				if(!subInviteEntity.getContractFileSyncFlag()) {
					return CommonResponse.error("请重新进行招标文件编辑，同步单据信息到招标文件！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state || BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
			List<SubInviteDetailEntity> detailVOList = service.selectSumDetail(billId);
			if(CollectionUtils.isNotEmpty(detailVOList)){
				detailService.saveOrUpdateBatch(detailVOList);
			}
			SubInviteEntity inviteEntity = service.selectById(billId);
			if (CollectionUtils.isNotEmpty(inviteEntity.getSubDetailBidder())){
				List<SubInviteDetailBidderVO> detailBidderList =  service.selectDetailBidder(billId);
				String tenderUnitNum = "";
				for (SubInviteDetailBidderVO detailBidderVO : detailBidderList) {
					SubPicketageRefsupplierEntity subPicketageRefsupplierEntity = new SubPicketageRefsupplierEntity();
					subPicketageRefsupplierEntity.setPicketageId(billId);
					subPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName()+"定标");
					subPicketageRefsupplierEntity.setPicketageDate(new Date());
					subPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
					subPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
					subPicketageRefsupplierEntity.setSupplierId(inviteEntity.getSupplierId());
					subPicketageRefsupplierEntity.setSupplierName(inviteEntity.getSupplierName());
					//暂时使用主表
					subPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
					subPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
					subPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
					subPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
					subPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
					subPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
					subPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
					subPicketageRefsupplierEntity.setOccupyFlag(0);
					subPicketageRefsupplierEntity.setPicketageFlag(1);
					subPicketageRefsupplierEntity.setSignStatus(0);
					subPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
					picketageRefsupplierService.saveOrUpdate(subPicketageRefsupplierEntity);
					BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4,BigDecimal.ROUND_HALF_UP);
					tenderUnitNum+=inviteEntity.getSupplierName()+"("+sumNum+"),";
				}
				if (tenderUnitNum.length() > 1) {
					tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
				}
				inviteEntity.setTenderUnitNum(tenderUnitNum);
				service.saveOrUpdate(inviteEntity);
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SubInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getOccupyState()!= null && inviteEntity.getOccupyState()==1){
			return CommonResponse.error("招标已被占用,不能撤回!");
		}
		if (inviteEntity.getTenderStage()>1){
			return CommonResponse.error("招标处于"+ TenderStageEnum.getEnumByStateCode(inviteEntity.getTenderStage()).getDescription()+",不能撤回!");
		}
		if (inviteEntity.getEstablishType()==1){
			QueryWrapper<SubPicketageRefsupplierEntity> refWrapper = new QueryWrapper<>();
			refWrapper.eq("picketage_id",inviteEntity.getId());
			List<SubPicketageRefsupplierEntity> refsupplierEntityList = picketageRefsupplierService.list(refWrapper);
			for (SubPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
				if (refsupplierEntity.getSignStatus()!=0){
					return CommonResponse.error("存在已签订合同,不能撤回!");
				}
			}
			picketageRefsupplierService.remove(refWrapper);
		}
		detailService.delByInviteId(inviteEntity.getId());
//		QueryWrapper<SubInviteDetailEntity> detailWrapper = new QueryWrapper<>();
//		detailWrapper.eq("invite_id",inviteEntity.getId());
//		detailService.remove(detailWrapper);
		return CommonResponse.success();
//        return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	@Override
	public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
		SubInviteEntity e = service.selectById(billId);
		List<ParamsCheckVO> list = service.historyPriceCtrlContractPrice(BeanMapper.map(e,SubInviteVO.class));
		JSONObject object = new JSONObject();
		if(CollectionUtils.isNotEmpty(list)){
			object.put("priceFlag","是");//是单价异常
			logger.info("单价异常-----"+JSONObject.toJSONString(list));
		}else{
			object.put("priceFlag","否");//否 单价异常
			logger.info("单价正常-----");
		}
		return CommonResponse.success(object);
	}

}
