package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.assist.rmat.enums.ChangeTypeEnum;
import com.ejianc.business.plan.api.IProsubPlanApi;
import com.ejianc.business.plan.vo.PlanDetailVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.sub.bean.SubInviteDetailBidderEntity;
import com.ejianc.business.tender.sub.bean.SubInviteDetailEntity;
import com.ejianc.business.tender.sub.bean.SubInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.mapper.SubInviteMapper;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Service("subInviteService")
public class SubInviteServiceImpl extends BaseServiceImpl<SubInviteMapper, SubInviteEntity> implements ISubInviteService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IDutyApi dutyApi;


    @Autowired
    private IProsubPlanApi prosubPlanApi;

    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    // 【目标成本劳务分包价格】控【劳务分包招标立项】
    private final String LAB_TARGET_COST_PRICE_CTRL_INVITE_PRICE = "P-0mo3850224";
    // 【目标成本劳务分包价格】控【劳务分包招标立项】
    private final String PRO_TARGET_COST_PRICE_CTRL_INVITE_PRICE = "P-N21jvu0222";
    // 【劳务分包总计划金额】控【招标立项】+【定标立项】
    private final String LAB_PLAN_MNY_CTRL_INVITE_MNY = "P-98T57z0238";
    // 【劳务分包总计划量】控【招标立项】/【定标立项】
    private final String LAB_PLAN_NUM_CTRL_INVITE_NUM = "P-VqX2360237";

    // 【专业分包总计划金额】控【招标立项】+【定标立项】
    private final String PRO_PLAN_MNY_CTRL_INVITE_MNY = "P-q5q8Sq0240";
    // 【专业分包总计划量】控【招标立项】/【定标立项】
    private final String PRO_PLAN_NUM_CTRL_INVITE_NUM = "P-NZ494c0239";

    // 劳务招标 【劳务分包历史最高价】控【劳务分包招标】
    private final String LAB_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-hHi3zu0248";
    // 专业招标 【专业分包历史最高价】控【专业分包招标】
    private final String PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-z867t10250";
    // 劳务招标 【劳务分包历史最低价】控【劳务分包招标】
    private final String LAB_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-Q00U300247";
    // 专业招标 【专业分包历史最低价】控【专业分包招标】
    private final String PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-7ny20q0249";

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id, tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id, abolishType);
    }

    @Override
    public List<SubInviteDetailEntity> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<SubInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public SubInviteVO queryDetailTree(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("subDetailRecord", orderParams);


        SubInviteEntity subInviteEntity = super.selectById(id, orderMap);
        SubInviteVO subInviteVO = BeanMapper.map(subInviteEntity, SubInviteVO.class);

        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(subInviteVO.getSubDetailRecord())) {
            for (SubInviteDetailRecordVO detail : subInviteVO.getSubDetailRecord()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            subInviteVO.setSubDetailRecord(TreeNodeBUtil.buildTree(subInviteVO.getSubDetailRecord()));
        }
        if (CollectionUtils.isNotEmpty(subInviteVO.getSubDetailBidder())) {
            for (SubInviteDetailBidderVO detail1 : subInviteVO.getSubDetailBidder()) {
                detail1.setTid(detail1.getId().toString());
                detail1.setTpid(detail1.getParentId() != null ? detail1.getParentId().toString() : null);
            }
            subInviteVO.setSubDetailBidder(TreeNodeBUtil.buildTree(subInviteVO.getSubDetailBidder()));
        }
        subInviteVO.setSubDetailBidder(subInviteVO.getSubDetailBidder());
        return subInviteVO;
    }

    @Override
    public List<SubInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }

    @Override
    public List<SubInviteDetailBidderVO> querySonDetail(Long inviteId) {
        return baseMapper.querySonDetail(inviteId);
    }

    @Override
    public List<ParamsCheckVO> targetCostPriceCtrlSubInvitePrice(SubInviteVO subInviteVO) {
        logger.info("tender---SubInviteServiceImpl---targetCostPriceCtrlSubInvitePrice()--- 目标成本价控招标价入参：{}", JSONObject.toJSONString(subInviteVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        List<SubInviteDetailRecordVO> detailList = (0 == subInviteVO.getEstablishType()) ? subInviteVO.getSubDetailRecord() : BeanMapper.mapList(subInviteVO.getSubDetailBidder(), SubInviteDetailRecordVO.class);
        // 专业
        if (subInviteVO.getSubType()==1471313836879101953L) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_TARGET_COST_PRICE_CTRL_INVITE_PRICE, subInviteVO.getOrgId());
        }else {// 劳务
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_TARGET_COST_PRICE_CTRL_INVITE_PRICE, subInviteVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询目标成本价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数目标成本价查询结果：{}", JSONObject.toJSONString(maxParamByCode));
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果

        List<Long> docIds = detailList.stream().filter(item -> null != item.getNum()).map(SubInviteDetailRecordVO::getDocId).collect(Collectors.toList());
        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByDocIds(subInviteVO.getProjectId(), subInviteVO.getSubType()==1471313836879101953L ? DocTypeEnum.专业分包档案.getCode() : DocTypeEnum.劳务分包档案.getCode() , docIds);
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVOList;
        }
        Map<Long, BigDecimal> dutyMap = dutyRes.getData();

        logger.info("目标成本价参数控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        if (null == dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVOList;
        }
        logger.info("目标成本价map信息返回："+JSONObject.toJSONString(dutyMap));
        if(CollectionUtils.isNotEmpty(maxParamVOS)){
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (SubInviteDetailRecordVO detailVO: detailList) {//遍历明细
                    if (null != detailVO.getNum() && !"del".equals(detailVO.getRowState())){
                        BigDecimal maxPrice = !dutyMap.containsKey(detailVO.getDocId()) || null == dutyMap.get(detailVO.getDocId()) ? BigDecimal.ZERO : dutyMap.get(detailVO.getDocId()).setScale(4, BigDecimal.ROUND_HALF_UP);//获取目标成本价格
                        BigDecimal price = null == detailVO.getPrice() ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//档案单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        logger.info("marpriceparam:{},price:{},maxprice:{}", maxPriceParam,price,maxPrice);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName() + (detailVO.getContent() == null ? "" : "+" + detailVO.getContent()));
                            paramsCheckDsVO.setWarnName("招标单价大于目标成本单价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("招标单价：").append(price)
                                    .append("元，目标成本单价：(").append(maxPrice)
                                    .append("元),目标成本单价*").append(roleValueMax).append("%：").append(maxPriceParam)
                                    .append("元，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4, BigDecimal.ROUND_HALF_UP)).append("元");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        return paramsCheckVOList;
    }


    @Override
    public List<ParamsCheckVO> checkParamsByPlanMny(SubInviteVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        // subType 1: 专业 0：劳务
        Integer subType = 1471313836879101953L == vo.getSubType() ? 1 : 0;
        BigDecimal temporaryMoney = vo.getTenderMoney();//本次招标金额
        BigDecimal planTaxMny;//总计划金额
        BigDecimal totalMoney = temporaryMoney;//累计招标金额  默认赋值本次
        //查询总计划
        CommonResponse<List<PlanVO>> response = prosubPlanApi.queryPlanByProjectId(vo.getProjectId(), subType);
        if (!response.isSuccess()){
            throw new BusinessException("查询总计划失败"+response.getMsg());
        }
        List<PlanVO> planList = response.getData();
        if (CollectionUtils.isNotEmpty(planList) && response.getData().size() > 0) {
            logger.info("查的总计划数据：{}", JSONObject.toJSONString(planList));
            planTaxMny = planList.stream().filter(e -> e.getTotalPlanMny() != null).map(PlanVO::getTotalPlanMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            return paramsCheckVOS;
        }
        /*
            查询招标
            招标阶段   不包含：废标、流标
            招标平台   选择招采平台的才计入占用金额
            分包类型   专业分包 和 劳务分包/机械承揽
         */
        LambdaQueryWrapper<SubInviteEntity> Lambda = new LambdaQueryWrapper<>();
        Lambda.eq(SubInviteEntity::getProjectId, vo.getProjectId());
        Lambda.in(SubInviteEntity::getBillState, 1, 3);
        //不含废标、流标
        Lambda.notIn(SubInviteEntity::getTenderStage, TenderStageEnum.FLOW_STATE.getTenderTypeCode(), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
        Lambda.and(l -> l.eq(SubInviteEntity::getTenderPlatform, 1)//招采平台
                .or(c -> c.isNull(SubInviteEntity::getTenderPlatform)));//或者定标
        if (1471313836879101953L == vo.getSubType()){//专业
            Lambda.eq(SubInviteEntity::getSubType, vo.getSubType());
        }else {//劳务
            Lambda.ne(SubInviteEntity::getSubType, 1471313836879101953L);
        }
        List<SubInviteEntity> list = super.list(Lambda);//查询项目下所有招标
        logger.info("所有招标集合list-{}：", JSONObject.toJSONString(list));
        if (CollectionUtils.isNotEmpty(list)) {
            totalMoney = list.stream().filter(e -> null != e.getTenderMoney()).map(SubInviteEntity::getTenderMoney).reduce(totalMoney, BigDecimal::add);
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(1471313836879101953L == vo.getSubType() ? PRO_PLAN_MNY_CTRL_INVITE_MNY : LAB_PLAN_MNY_CTRL_INVITE_MNY, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划金额控制招标金额信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(planTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    logger.info("planTaxMny-{}， comMny-{}，temporaryMoney-{},totalMoney-{}", planTaxMny, comMny, temporaryMoney, totalMoney);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("招标金额超总计划金额");
                        paramsCheckDsVO.setWarnName("累计招标金额大于总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次招标金额：").append(temporaryMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计招标金额：").append(totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，总计划金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsByPlanNum(SubInviteVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        // subType 1: 专业 0：劳务
        Integer subType = 1471313836879101953L == vo.getSubType() ? 1 : 0;
        //查询总计划
        CommonResponse<List<PlanVO>> response = prosubPlanApi.queryPlanByProjectId(vo.getProjectId(), subType);
        if (!response.isSuccess()){
            throw new BusinessException("查询总计划失败"+response.getMsg());
        }
        List<PlanDetailVO> planDetailList = new ArrayList<>();
        if (null != response.getData() && response.getData().size() > 0) {
            planDetailList = response.getData().get(0).getPlanDetailList().stream().filter(e -> null != e.getPlanNum() && !ChangeTypeEnum.中止.toString().equals(e.getChangeType())).collect(Collectors.toList());
        } else {
            return paramsCheckVOS;
        }
        List<Long> docIdList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(planDetailList)){
            docIdList = planDetailList.stream().filter(e -> null != e.getPlanNum() && null != e.getDocId()).map(PlanDetailVO::getDocId).distinct().collect(Collectors.toList());
        }


        //当前vo子表
        List<SubInviteDetailRecordVO> detailVOList = (0 == vo.getEstablishType()) ? vo.getSubDetailRecord() : BeanMapper.mapList(vo.getSubDetailBidder(), SubInviteDetailRecordVO.class);
        //当前vo子表档案累加数量
        Map<Long, BigDecimal> inviteDetailDocNumMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(detailVOList)){
            inviteDetailDocNumMap = detailVOList.stream().filter(e -> null != e.getNum() && null != e.getDocId()).collect(Collectors.toMap(SubInviteDetailRecordVO::getDocId, SubInviteDetailRecordVO::getNum, (key1, key2) -> key2));
        }
        //查招标累计子表
        //累计招标档案累加数量
        Map<Long, BigDecimal> tenderSumDocNumMap = new HashMap<>();
        List<SubInviteDetailRecordEntity> detailEntityList = baseMapper.selectDetailByProjectId(vo.getProjectId(), docIdList, subType);
        if (CollectionUtils.isNotEmpty(detailEntityList)){
            tenderSumDocNumMap = detailEntityList.stream().collect(Collectors.toMap(SubInviteDetailRecordEntity::getDocId, SubInviteDetailRecordEntity::getNum, (key1, key2) -> key2));
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(1471313836879101953L == vo.getSubType() ? PRO_PLAN_NUM_CTRL_INVITE_NUM : LAB_PLAN_NUM_CTRL_INVITE_NUM, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划清单量控制招标清单量信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if(CollectionUtils.isNotEmpty(planDetailList)){
                        //先遍历总计划子表，判断招标tenderDocMap是否包含总计划子表的档案id，若有则把本单据该档案数量 和 招标累计档案数量 相加 判断是否大于总计划子表量
                        //遍历明细
                        for (PlanDetailVO detailVO : planDetailList) {
                            if (!inviteDetailDocNumMap.containsKey(detailVO.getDocId())){
                                continue;
                            }
                            //总计划清单数量
                            BigDecimal comNum = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(detailVO.getPlanNum(), roleValue), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                            //累计招标 数量  明细
                            BigDecimal totalNum = ComputeUtil.safeAdd(tenderSumDocNumMap.containsKey(detailVO.getDocId()) ? tenderSumDocNumMap.get(detailVO.getDocId()) : BigDecimal.ZERO, inviteDetailDocNumMap.get(detailVO.getDocId()));

                            logger.info("docName-{}，comNum-{},totalNum-{}", detailVO.getDetailName(), comNum, totalNum);
                            if (totalNum.compareTo(comNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(detailVO.getDetailName()+" - "+detailVO.getDetailCode());
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnName("招标清单数量大于总计划清单数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(detailVO.getDetailName()+" - "+detailVO.getDetailCode()).append(" ").append("本次招标数量：").append(inviteDetailDocNumMap.get(detailVO.getDocId()).setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("，含本次累计招标数量：").append(totalNum.setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划招标数量*").append(roleValue).append("%:").append(comNum.setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(ComputeUtil.safeSub(totalNum, comNum).setScale(4, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                            logger.info("checkDsVOS-{}", JSONObject.toJSONString(checkDsVOS));
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(SubInviteVO subInviteVO) {
        logger.info("tender---SubInviteServiceImpl---historyPriceCtrlContractPrice()--- 历史价控招标控制单价入参：{}", JSONObject.toJSONString(subInviteVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();

        //当前vo子表
        List<SubInviteDetailRecordVO> detailList = (0 == subInviteVO.getEstablishType()) ? subInviteVO.getSubDetailRecord() : BeanMapper.mapList(subInviteVO.getSubDetailBidder(), SubInviteDetailRecordVO.class);

        if (subInviteVO.getSubType()==1471313836879101953L) {
            // 专业
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE, subInviteVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE, subInviteVO.getOrgId());
        }else {
            //劳务
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MAX_PRICE_CTRL_CON_PRICE, subInviteVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MIN_PRICE_CTRL_CON_PRICE, subInviteVO.getOrgId());
        }


        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("分包招标历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("分包招标历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));

        //todo 取优先级
        boolean flag = true;
        int priceCode = subInviteVO.getSubType()==1471313836879101953L ? PrinceDepotEnum.专业分包价格库.getCode() : PrinceDepotEnum.劳务分包价格库.getCode();
        logger.info("传入参数--{}", priceCode);
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(priceCode);
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null != priorityFlag && 2==priorityFlag){
            //指导价优先
            flag = false;
        }


        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (SubInviteDetailRecordVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }

                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包招标清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("招标单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("招标单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                for (SubInviteDetailRecordVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }

                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包招标清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("招标单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("招标单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }
}
