package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.sub.vo.SubNoticeSupplierVO;
import com.ejianc.business.tender.sub.mapper.SubInviteDetailMapper;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubNoticeDetailMapper;
import com.ejianc.business.tender.sub.mapper.SubNoticeMapper;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
@Service("subNoticeService")
public class SubNoticeServiceImpl extends BaseServiceImpl<SubNoticeMapper, SubNoticeEntity> implements ISubNoticeService {

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private ISubNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private ISubInviteSupplierService inviteSupplierService;

    @Autowired
    private SubInviteDetailMapper subInviteDetailMapper;

    @Autowired
    private ISubNoticeSupplierService supplierService;

    @Autowired
    private ISubInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        baseMapper.updateEndTime(noticeId,newTime);
    }

    @Transactional
    @Override
    public CommonResponse publish(SubNoticeVO subNoticeVO) throws InvocationTargetException, IllegalAccessException {
        //插入主表数据
        SubNoticeEntity subNoticeEntity = baseMapper.selectById(subNoticeVO.getId());
        SubInviteEntity inviteEntity = inviteService.selectById(subNoticeEntity.getInviteId());
        subNoticeEntity.setPublishFlag(0);
        baseMapper.updateById(subNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SubNoticeSupplierTbVO subNoticeSupplierTbVO = new SubNoticeSupplierTbVO();
        BeanUtils.copyProperties(subNoticeSupplierTbVO, subNoticeEntity);
        subNoticeSupplierTbVO.setNoticeStartTime(sdf.format(subNoticeEntity.getNoticeStartTime()));
        subNoticeSupplierTbVO.setNoticeEndTime(sdf.format(subNoticeEntity.getNoticeEndTime()));
        subNoticeSupplierTbVO.setNoticeType(0);
        if (subNoticeEntity.getPurchaseType()==1){
            subNoticeSupplierTbVO.setSourceProjectId(null);
        }else {
            subNoticeSupplierTbVO.setSourceProjectId(subNoticeEntity.getProjectId().toString());
        }
        subNoticeSupplierTbVO.setSourceId(subNoticeEntity.getInviteId().toString());
        subNoticeSupplierTbVO.setSourceType("云南建投招标公告");
        subNoticeSupplierTbVO.setSourceOrgId(subNoticeEntity.getOrgId().toString());
        subNoticeSupplierTbVO.setSourceUnitId(subNoticeEntity.getUnitId().toString());
        subNoticeSupplierTbVO.setType("SUB");
        subNoticeSupplierTbVO.setTenderName(subNoticeEntity.getNoticeName());
        subNoticeSupplierTbVO.setSourceEmployeeId(subNoticeEntity.getEmployeeId().toString());
        subNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        subNoticeSupplierTbVO.setId(null);
        subNoticeSupplierTbVO.setCreateTime(null);
        subNoticeSupplierTbVO.setUpdateTime(null);
        subNoticeSupplierTbVO.setCreateUserCode(null);
        subNoticeSupplierTbVO.setUpdateUserCode(null);
        subNoticeSupplierTbVO.setSyncEsFlag(null);
        subNoticeSupplierTbVO.setVersion(null);
        subNoticeSupplierTbVO.setTenantId(null);
        subNoticeSupplierTbVO.setDr(null);
        subNoticeSupplierTbVO.setSubType(inviteEntity.getSubType());
        subNoticeSupplierTbVO.setProjectQualification(inviteEntity.getProjectQualification());
        subNoticeSupplierTbVO.setPaymentId(inviteEntity.getPaymentId());
        subNoticeSupplierTbVO.setPaymentName(inviteEntity.getPaymentName());
        subNoticeSupplierTbVO.setPayScale(inviteEntity.getPayScale());
        subNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        subNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        //插入物资
        List<SubInviteDetailEntity> inviteDetailEntityList = subInviteDetailMapper.selectList(new LambdaQueryWrapper<SubInviteDetailEntity>().eq(SubInviteDetailEntity::getInviteId, inviteEntity.getId()));
        List<SubNoticeDetailEntity> noticeDetailEntityList = BeanMapper.mapList(inviteDetailEntityList, SubNoticeDetailEntity.class);
//        List<SubNoticeDetailEntity> noticeDetailEntityList = subNoticeDetailMapper.selectList(new LambdaQueryWrapper<SubNoticeDetailEntity>().eq(SubNoticeDetailEntity::getNoticeId, subNoticeVO.getId()));
        List<SubNoticeDetailTbVO> subNoticeDetailVOS = new ArrayList<>();
        for (SubNoticeDetailEntity subNoticeDetailEntity : noticeDetailEntityList) {
            SubNoticeDetailTbVO subNoticeDetailTbVO = new SubNoticeDetailTbVO();
            BeanUtils.copyProperties(subNoticeDetailTbVO, subNoticeDetailEntity);
            subNoticeDetailTbVO.setSourceId(subNoticeEntity.getInviteId().toString());
            subNoticeDetailTbVO.setSourceDetailId(String.valueOf(subNoticeDetailEntity.getId()));
            subNoticeDetailTbVO.setRate(subNoticeDetailEntity.getTaxRate());
            subNoticeDetailVOS.add(subNoticeDetailTbVO);

        }
        subNoticeSupplierTbVO.setSubDetailList(subNoticeDetailVOS);
        //是否是邀请招标
        if (subNoticeVO.getTenderType()==1){
            List<SubInviteSupplierEntity> detailEntityList = inviteSupplierService.list(new LambdaQueryWrapper<SubInviteSupplierEntity>().eq(SubInviteSupplierEntity::getInviteId, subNoticeEntity.getInviteId()).eq(SubInviteSupplierEntity::getDr, 0));
            List<SubNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (SubInviteSupplierEntity supplierDetailEntity : detailEntityList) {
                SubNoticeSupplierDetailTbVO subNoticeSupplierDetailTbVO = new SubNoticeSupplierDetailTbVO();
                subNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                subNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo 暂时写死
                subNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(subNoticeSupplierDetailTbVO);
            }
            subNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        //调用第三方接口
//        CommonResponse<JSONObject> response = null;
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, JSON.toJSONString(subNoticeSupplierTbVO),cacheManager);
//            if(!response.isSuccess()) {
//                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            return CommonResponse.error("调用平台报名接口失败");
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(subNoticeSupplierTbVO), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }

        //招标公告发布成功后 改招标状态 为报名中
        inviteEntity.setTenderState(TenderStateEnum.报名中.getCode());
        inviteEntity.setStopTime(subNoticeEntity.getNoticeEndTime());
        inviteService.saveOrUpdate(inviteEntity);
        return CommonResponse.success("公告信息推送成功");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<SubNoticeEntity>().eq(SubNoticeEntity::getInviteId,sourceId)).getId();
    }

    @Override
    public boolean selectFile(SubNoticeVO vo) {
        List<SubNoticeSupplierEntity> noticeSupplierEntityList = supplierService.list(new QueryWrapper<SubNoticeSupplierEntity>().eq("notice_id", vo.getId()).eq("dr", 0));
        List<SubNoticeSupplierVO> subNoticeSupplierVOS = BeanMapper.mapList(noticeSupplierEntityList, SubNoticeSupplierVO.class);
        //处理供应商附件信息
        if (CollectionUtils.isNotEmpty(subNoticeSupplierVOS)){
            List<Long> attachIds = subNoticeSupplierVOS.stream().map(SubNoticeSupplierVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds",attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId),Function.identity());
                    Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                    for (SubNoticeSupplierVO subNoticeSupplierVO : subNoticeSupplierVOS){
                        List<AttachmentVO> attachmentVOList = attacMap.get(subNoticeSupplierVO.getId());
                        if (attachmentVOList!=null){
                            ArrayList<Map<String, Object>> list = new ArrayList<>();
                            for (AttachmentVO attachmentVO : attachmentVOList) {
                                HashMap<String, Object> hashMap = new HashMap<>();
                                hashMap.put("attachId",attachmentVO.getId());
                                hashMap.put("name",attachmentVO.getFileName());
                                list.add(hashMap);
                            }
                            subNoticeSupplierVO.setFile(list);
                        }else {
                            subNoticeSupplierVO.setAttachId(null);
                            subNoticeSupplierVO.setFileName(null);
                        }
                    }
                }
            }
            vo.setNoticeSupplierDetail(subNoticeSupplierVOS);
        }
        return true;
    }
}
